%------------------------------------------------------------------------------
% File     : SWW485_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 78
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_78 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.5.0, 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  171 (  37 unt;  30 typ;   0 def)
%            Number of atoms       :  384 (  57 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  293 (  50   ~;  14   |;  17   &)
%                                         (  27 <=>; 185  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   14 (   9   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   1 prp; 0-3 aty)
%            Number of functors    :   11 (  11 usr;   4 con; 0-4 aty)
%            Number of variables   :  333 ( 311   !;   3   ?; 333   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:45
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Polynomial_Opoly,type,
    poly1: $tType > $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (24)
tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Polynomial_Oorder,type,
    order1: 
      !>[A: $tType] : ( ( A * poly1(A) ) > nat ) ).

tff(sy_c_Polynomial_Opoly,type,
    poly: 
      !>[A: $tType] : ( poly1(A) > fun(A,A) ) ).

tff(sy_c_RealVector_Onorm__class_Onorm,type,
    norm_norm: 
      !>[A: $tType] : ( A > real ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_cs____,type,
    cs: poly1(complex) ).

tff(sy_v_r,type,
    r: real ).

tff(sy_v_thesis____,type,
    thesis: $o ).

%----Relevant facts (99)
tff(fact_0_pCons,axiom,
    ? [M3: real] :
      ( ord_less(real,zero_zero(real),M3)
      & ! [Z2: complex] :
          ( ord_less_eq(real,norm_norm(complex,Z2),r)
         => ord_less_eq(real,norm_norm(complex,aa(complex,complex,poly(complex,cs),Z2)),M3) ) ) ).

tff(fact_1_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_2_poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0(A)
        & idom(A) )
     => ! [Q: poly1(A),Pa: poly1(A)] :
          ( ( poly(A,Pa) = poly(A,Q) )
        <=> ( Pa = Q ) ) ) ).

tff(fact_3_norm__ge__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] : ord_less_eq(real,zero_zero(real),norm_norm(A,X)) ) ).

tff(fact_4_norm__le__zero__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X2: A] :
          ( ord_less_eq(real,norm_norm(A,X2),zero_zero(real))
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_5_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X3: A] : ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_6_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_7_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 = Y2 )
        <=> ( ord_less_eq(A,X2,Y2)
            & ord_less_eq(A,Y2,X2) ) ) ) ).

tff(fact_8_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_9_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_10_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X2: A,Y2: A] :
          ( ord_less_eq(A,Y2,X2)
         => ( ord_less_eq(A,X2,Y2)
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_11_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less_eq(A,B2,C)
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_12_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( B2 = C )
           => ord_less_eq(A,A2,C) ) ) ) ).

tff(fact_13_poly__0,axiom,
    ! [A: $tType] :
      ( comm_semiring_0(A)
     => ! [X: A] : ( aa(A,A,poly(A,zero_zero(poly1(A))),X) = zero_zero(A) ) ) ).

tff(fact_14_norm__eq__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X2: A] :
          ( ( norm_norm(A,X2) = zero_zero(real) )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_15_norm__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( norm_norm(A,zero_zero(A)) = zero_zero(real) ) ) ).

tff(fact_16_zero__less__norm__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X2: A] :
          ( ord_less(real,zero_zero(real),norm_norm(A,X2))
        <=> ( X2 != zero_zero(A) ) ) ) ).

tff(fact_17_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_18_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ( X2 != Y2 )
        <=> ( ord_less(A,X2,Y2)
            | ord_less(A,Y2,X2) ) ) ) ).

tff(fact_19_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
        <=> ( ord_less(A,Y2,X2)
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_20_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_21_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X2: A,Y2: A] :
          ( ~ ord_less(A,Y2,X2)
         => ( ~ ord_less(A,X2,Y2)
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_22_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_23_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_24_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_25_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_26_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_27_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_28_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
         => ( ord_less(A,Y2,X2)
           => pp(P) ) ) ) ).

tff(fact_29_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_30_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C)
           => ord_less(A,A2,C) ) ) ) ).

tff(fact_31_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C )
           => ord_less(A,A2,C) ) ) ) ).

tff(fact_32_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z1)
           => ord_less(A,X,Z1) ) ) ) ).

tff(fact_33_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_34_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_35_poly__zero,axiom,
    ! [A: $tType] :
      ( ( ring_char_0(A)
        & idom(A) )
     => ! [Pa: poly1(A)] :
          ( ( poly(A,Pa) = poly(A,zero_zero(poly1(A))) )
        <=> ( Pa = zero_zero(poly1(A)) ) ) ) ).

tff(fact_36_norm__not__less__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X: A] : ~ ord_less(real,norm_norm(A,X),zero_zero(real)) ) ).

tff(fact_37_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less(A,Y,Z1)
           => ord_less(A,X,Z1) ) ) ) ).

tff(fact_38_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less_eq(A,Y,Z1)
           => ord_less(A,X,Z1) ) ) ) ).

tff(fact_39_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( A2 != B2 )
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_40_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less(A,X,Y)
            | ( X = Y ) ) ) ) ).

tff(fact_41_linorder__antisym__conv2,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
         => ( ~ ord_less(A,X2,Y2)
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_42_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_43_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ~ ord_less(A,X,Y) ) ) ).

tff(fact_44_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( ord_less_eq(A,A2,B2)
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_45_linorder__antisym__conv1,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
         => ( ord_less_eq(A,X2,Y2)
          <=> ( X2 = Y2 ) ) ) ) ).

tff(fact_46_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ~ ord_less_eq(A,Y,X)
         => ord_less(A,X,Y) ) ) ).

tff(fact_47_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_48_order__le__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,X2,Y2)
        <=> ( ord_less(A,X2,Y2)
            | ( X2 = Y2 ) ) ) ) ).

tff(fact_49_less__le__not__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
        <=> ( ord_less_eq(A,X2,Y2)
            & ~ ord_less_eq(A,Y2,X2) ) ) ) ).

tff(fact_50_order__less__le,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y2: A,X2: A] :
          ( ord_less(A,X2,Y2)
        <=> ( ord_less_eq(A,X2,Y2)
            & ( X2 != Y2 ) ) ) ) ).

tff(fact_51_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less(A,Y,X) ) ) ).

tff(fact_52_linorder__not__le,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less_eq(A,X2,Y2)
        <=> ord_less(A,Y2,X2) ) ) ).

tff(fact_53_linorder__not__less,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X2: A] :
          ( ~ ord_less(A,X2,Y2)
        <=> ord_less_eq(A,Y2,X2) ) ) ).

tff(fact_54_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_55_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_56_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z1)
           => ord_less_eq(A,X,Z1) ) ) ) ).

tff(fact_57_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_58_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X1: A] : ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_59_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [Ca: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less_eq(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,Ca)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,A1,aa(B,A,F,Ca)) ) ) ) ) ).

tff(fact_60_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [Ca: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,Ca)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less_eq(B,X1,Y1)
                 => ord_less_eq(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,A1,aa(B,A,F,Ca)) ) ) ) ) ).

tff(fact_61_order__le__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [Ca: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less(B,aa(A,B,F,B1),Ca)
           => ( ! [X1: A,Y1: A] :
                  ( ord_less_eq(A,X1,Y1)
                 => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,A1),Ca) ) ) ) ) ).

tff(fact_62_order__less__le__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [Ca: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),Ca)
           => ( ! [X1: A,Y1: A] :
                  ( ord_less(A,X1,Y1)
                 => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,A1),Ca) ) ) ) ) ).

tff(fact_63_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z1: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ! [W: A] :
                ( ord_less(A,X,W)
               => ( ord_less(A,W,Y)
                 => ord_less_eq(A,W,Z1) ) )
           => ord_less_eq(A,Y,Z1) ) ) ) ).

tff(fact_64_dense__le,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Z1: A,Y: A] :
          ( ! [X1: A] :
              ( ord_less(A,X1,Y)
             => ord_less_eq(A,X1,Z1) )
         => ord_less_eq(A,Y,Z1) ) ) ).

tff(fact_65_less__eq__real__def,axiom,
    ! [Y2: real,X2: real] :
      ( ord_less_eq(real,X2,Y2)
    <=> ( ord_less(real,X2,Y2)
        | ( X2 = Y2 ) ) ) ).

tff(fact_66_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less(fun(A,B),F,G)
        <=> ( ord_less_eq(fun(A,B),F,G)
            & ~ ord_less_eq(fun(A,B),G,F) ) ) ) ).

tff(fact_67_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_68_real__lbound__gt__zero,axiom,
    ! [D2: real,D1: real] :
      ( ord_less(real,zero_zero(real),D1)
     => ( ord_less(real,zero_zero(real),D2)
       => ? [E: real] :
            ( ord_less(real,zero_zero(real),E)
            & ord_less(real,E,D1)
            & ord_less(real,E,D2) ) ) ) ).

tff(fact_69_order__root,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [A1: A,Pa: poly1(A)] :
          ( ( aa(A,A,poly(A,Pa),A1) = zero_zero(A) )
        <=> ( ( Pa = zero_zero(poly1(A)) )
            | ( order1(A,A1,Pa) != zero_zero(nat) ) ) ) ) ).

tff(fact_70_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [Ca: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,Ca)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,A1,aa(B,A,F,Ca)) ) ) ) ) ).

tff(fact_71_le0,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_72_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_73_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_76_le__0__eq,axiom,
    ! [N: nat] :
      ( ord_less_eq(nat,N,zero_zero(nat))
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_77_less__eq__nat_Osimps_I1_J,axiom,
    ! [N1: nat] : ord_less_eq(nat,zero_zero(nat),N1) ).

tff(fact_78_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_79_nat__neq__iff,axiom,
    ! [N: nat,M2: nat] :
      ( ( M2 != N )
    <=> ( ord_less(nat,M2,N)
        | ord_less(nat,N,M2) ) ) ).

tff(fact_80_nat__less__le,axiom,
    ! [N: nat,M2: nat] :
      ( ord_less(nat,M2,N)
    <=> ( ord_less_eq(nat,M2,N)
        & ( M2 != N ) ) ) ).

tff(fact_81_le__eq__less__or__eq,axiom,
    ! [N: nat,M2: nat] :
      ( ord_less_eq(nat,M2,N)
    <=> ( ord_less(nat,M2,N)
        | ( M2 = N ) ) ) ).

tff(fact_82_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_83_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_84_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( ord_less(nat,N1,M1)
     => ( M1 != N1 ) ) ).

tff(fact_85_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_86_less__imp__le__nat,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_87_le__neq__implies__less,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ( M1 != N1 )
       => ord_less(nat,M1,N1) ) ) ).

tff(fact_88_less__or__eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_89_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N: nat,M2: nat] :
      ( ( ord_less(nat,M2,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M2)) )
     => ( ( ( M2 = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M2)) )
       => ( ( ord_less(nat,N,M2)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M2)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M2)) ) ) ) ).

tff(fact_90_le__refl,axiom,
    ! [N1: nat] : ord_less_eq(nat,N1,N1) ).

tff(fact_91_nat__le__linear,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
      | ord_less_eq(nat,N1,M1) ) ).

tff(fact_92_eq__imp__le,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 = N1 )
     => ord_less_eq(nat,M1,N1) ) ).

tff(fact_93_le__trans,axiom,
    ! [K1: nat,J: nat,I1: nat] :
      ( ord_less_eq(nat,I1,J)
     => ( ord_less_eq(nat,J,K1)
       => ord_less_eq(nat,I1,K1) ) ) ).

tff(fact_94_le__antisym,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N1)
     => ( ord_less_eq(nat,N1,M1)
       => ( M1 = N1 ) ) ) ).

tff(fact_95_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_96_gr__implies__not0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_97_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_98_ex__least__nat__le,axiom,
    ! [N: nat,P: fun(nat,bool)] :
      ( ~ pp(aa(nat,bool,P,zero_zero(nat)))
     => ( pp(aa(nat,bool,P,N))
       => ? [K: nat] :
            ( ord_less_eq(nat,K,N)
            & ! [I: nat] :
                ( ord_less(nat,I,K)
               => ~ pp(aa(nat,bool,P,I)) )
            & pp(aa(nat,bool,P,K)) ) ) ) ).

%----Arities (38)
tff(arity_Polynomial_Opoly___Rings_Olinordered__idom,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linordered_idom(poly1(T_1)) ) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(real) ).

tff(arity_RealDef_Oreal___Orderings_Odense__linorder,axiom,
    dense_linorder(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(real) ).

tff(arity_RealDef_Oreal___Orderings_Opreorder,axiom,
    preorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Olinorder,axiom,
    linorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Oorder,axiom,
    order(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Orderings_Oord,axiom,
    ord(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Rings_Oidom,axiom,
    idom(real) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oidom,axiom,
    idom(complex) ).

tff(arity_Polynomial_Opoly___Rings_Ocomm__semiring__0,axiom,
    ! [T_1: $tType] :
      ( comm_semiring_0(T_1)
     => comm_semiring_0(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Orderings_Opreorder,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => preorder(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Orderings_Olinorder,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => linorder(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Orderings_Oorder,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => order(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Int_Oring__char__0,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ring_char_0(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Orderings_Oord,axiom,
    ! [T_1: $tType] :
      ( linordered_idom(T_1)
     => ord(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Groups_Ozero,axiom,
    ! [T_1: $tType] :
      ( zero(T_1)
     => zero(poly1(T_1)) ) ).

tff(arity_Polynomial_Opoly___Rings_Oidom,axiom,
    ! [T_1: $tType] :
      ( idom(T_1)
     => idom(poly1(T_1)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [M: real] :
      ( ! [Z: complex] :
          ( ord_less_eq(real,norm_norm(complex,Z),r)
         => ord_less_eq(real,norm_norm(complex,aa(complex,complex,poly(complex,cs),Z)),M) )
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
