%------------------------------------------------------------------------------
% File     : SWW483_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 50
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_50 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  188 (  85 unt;  42 typ;   0 def)
%            Number of atoms       :  253 ( 120 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  121 (  14   ~;   0   |;  22   &)
%                                         (  28 <=>;  57  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   24 (  15   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  17 usr;   1 prp; 0-3 aty)
%            Number of functors    :   20 (  20 usr;   6 con; 0-4 aty)
%            Number of variables   :  227 ( 201   !;   0   ?; 227   :)
%                                         (  26  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__field,type,
    real_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add__abs,type,
    ordere142940540dd_abs: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocomplex_OComplex,type,
    complex1: ( real * real ) > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_NthRoot_Osqrt,type,
    sqrt: real > real ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_x____,type,
    x: real ).

tff(sy_v_y____,type,
    y: real ).

tff(sy_v_z,type,
    z: complex ).

%----Relevant facts (97)
tff(fact_0_y0,axiom,
    y != zero_zero(real) ).

tff(fact_1_xy,axiom,
    z = complex1(x,y) ).

tff(fact_2_sqrt4,axiom,
    sqrt(number_number_of(real,bit0(bit0(bit1(pls))))) = number_number_of(real,bit0(bit1(pls))) ).

tff(fact_3__096_B_Bthesis_O_A_I_B_Bx_Ay_O_Az_A_061_AComplex_Ax_Ay_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [X1: real,Y1: real] : ( z != complex1(X1,Y1) ) ).

tff(fact_4_th1,axiom,
    minus_minus(real,sqrt(inverse_divide(real,times_times(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x)),number_number_of(real,bit0(bit0(bit1(pls)))))),sqrt(inverse_divide(real,times_times(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x)),number_number_of(real,bit0(bit0(bit1(pls))))))) = x ).

tff(fact_5_th2,axiom,
    inverse_divide(real,times_times(real,number_number_of(real,bit0(bit1(pls))),times_times(real,y,sqrt(inverse_divide(real,times_times(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x)),number_number_of(real,bit0(bit0(bit1(pls)))))))),abs_abs(real,y)) = y ).

tff(fact_6_real__average__minus__first,axiom,
    ! [B1: real,A2: real] : ( minus_minus(real,inverse_divide(real,plus_plus(real,A2,B1),number_number_of(real,bit0(bit1(pls)))),A2) = inverse_divide(real,minus_minus(real,B1,A2),number_number_of(real,bit0(bit1(pls)))) ) ).

tff(fact_7_real__average__minus__second,axiom,
    ! [A2: real,B1: real] : ( minus_minus(real,inverse_divide(real,plus_plus(real,B1,A2),number_number_of(real,bit0(bit1(pls)))),A2) = inverse_divide(real,minus_minus(real,B1,A2),number_number_of(real,bit0(bit1(pls)))) ) ).

tff(fact_8__0960_A_060_061_A_Isqrt_A_Ix_A_K_Ax_A_L_Ay_A_K_Ay_J_A_N_Ax_J_A_P_A2_096,axiom,
    ord_less_eq(real,zero_zero(real),inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))) ).

tff(fact_9_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,B: A,A1: A] :
          ( ( A1 = inverse_divide(A,B,number_number_of(A,W)) )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( times_times(A,A1,number_number_of(A,W)) = B ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A1 = zero_zero(A) ) ) ) ) ) ).

tff(fact_10_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [A1: A,W: int,B: A] :
          ( ( inverse_divide(A,B,number_number_of(A,W)) = A1 )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( B = times_times(A,A1,number_number_of(A,W)) ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A1 = zero_zero(A) ) ) ) ) ) ).

tff(fact_11__0960_A_060_061_A_Isqrt_A_Ix_A_K_Ax_A_L_Ay_A_K_Ay_J_A_L_Ax_J_A_P_A2_096,axiom,
    ord_less_eq(real,zero_zero(real),inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))) ).

tff(fact_12_real__sqrt__abs2,axiom,
    ! [X: real] : ( sqrt(times_times(real,X,X)) = abs_abs(real,X) ) ).

tff(fact_13_th_I2_J,axiom,
    ! [Ya: real,Xa: real] : ord_less_eq(real,zero_zero(real),inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,Xa,Xa),times_times(real,Ya,Ya))),Xa),number_number_of(real,bit0(bit1(pls))))) ).

tff(fact_14_real__two__squares__add__zero__iff,axiom,
    ! [Ya: real,Xa: real] :
      ( ( plus_plus(real,times_times(real,Xa,Xa),times_times(real,Ya,Ya)) = zero_zero(real) )
    <=> ( ( Xa = zero_zero(real) )
        & ( Ya = zero_zero(real) ) ) ) ).

tff(fact_15_right__diff__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & ring(B2) )
     => ! [C1: B2,B1: B2,V: int] : ( times_times(B2,number_number_of(B2,V),minus_minus(B2,B1,C1)) = minus_minus(B2,times_times(B2,number_number_of(B2,V),B1),times_times(B2,number_number_of(B2,V),C1)) ) ) ).

tff(fact_16_left__diff__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & ring(B2) )
     => ! [V: int,B1: B2,A2: B2] : ( times_times(B2,minus_minus(B2,A2,B1),number_number_of(B2,V)) = minus_minus(B2,times_times(B2,A2,number_number_of(B2,V)),times_times(B2,B1,number_number_of(B2,V))) ) ) ).

tff(fact_17_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_18_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_19_rel__simps_I51_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit1(K1) = bit1(L) )
    <=> ( K1 = L ) ) ).

tff(fact_20_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_21_diff__bin__simps_I7_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit0(K),bit0(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_22_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit0(K),L1) = bit0(times_times(int,K,L1)) ) ).

tff(fact_23_rel__simps_I48_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit0(K1) = bit0(L) )
    <=> ( K1 = L ) ) ).

tff(fact_24_real__sqrt__eq__iff,axiom,
    ! [Ya: real,Xa: real] :
      ( ( sqrt(Xa) = sqrt(Ya) )
    <=> ( Xa = Ya ) ) ).

tff(fact_25_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( plus_plus(A,A1,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_26_le__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int,Xa: int] :
          ( ord_less_eq(A,number_number_of(A,Xa),number_number_of(A,Ya))
        <=> ord_less_eq(int,Xa,Ya) ) ) ).

tff(fact_27_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z) ) ) ).

tff(fact_28_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_29_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W1),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W1)),Z) ) ) ).

tff(fact_30_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,plus_plus(int,V,W1)) ) ) ).

tff(fact_31_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_32_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_33_diff__bin__simps_I10_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit1(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_34_diff__bin__simps_I9_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit0(L1)) = bit1(minus_minus(int,K,L1)) ) ).

tff(fact_35_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_36_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_37_diff__bin__simps_I3_J,axiom,
    ! [L1: int] : ( minus_minus(int,pls,bit0(L1)) = bit0(minus_minus(int,pls,L1)) ) ).

tff(fact_38_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_39_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_40_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_41_real__divide__square__eq,axiom,
    ! [A2: real,R: real] : ( inverse_divide(real,times_times(real,R,A2),times_times(real,R,R)) = inverse_divide(real,A2,R) ) ).

tff(fact_42_real__sqrt__le__iff,axiom,
    ! [Ya: real,Xa: real] :
      ( ord_less_eq(real,sqrt(Xa),sqrt(Ya))
    <=> ord_less_eq(real,Xa,Ya) ) ).

tff(fact_43_real__sqrt__eq__0__iff,axiom,
    ! [Xa: real] :
      ( ( sqrt(Xa) = zero_zero(real) )
    <=> ( Xa = zero_zero(real) ) ) ).

tff(fact_44_real__sqrt__zero,axiom,
    sqrt(zero_zero(real)) = zero_zero(real) ).

tff(fact_45_th_I1_J,axiom,
    ! [Ya: real,Xa: real] : ord_less_eq(real,zero_zero(real),inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,Xa,Xa),times_times(real,Ya,Ya))),Xa),number_number_of(real,bit0(bit1(pls))))) ).

tff(fact_46_left__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [V: int,B1: B2,A2: B2] : ( times_times(B2,plus_plus(B2,A2,B1),number_number_of(B2,V)) = plus_plus(B2,times_times(B2,A2,number_number_of(B2,V)),times_times(B2,B1,number_number_of(B2,V))) ) ) ).

tff(fact_47_right__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [C1: B2,B1: B2,V: int] : ( times_times(B2,number_number_of(B2,V),plus_plus(B2,B1,C1)) = plus_plus(B2,times_times(B2,number_number_of(B2,V),B1),times_times(B2,number_number_of(B2,V),C1)) ) ) ).

tff(fact_48_real__sqrt__le__0__iff,axiom,
    ! [Xa: real] :
      ( ord_less_eq(real,sqrt(Xa),zero_zero(real))
    <=> ord_less_eq(real,Xa,zero_zero(real)) ) ).

tff(fact_49_real__sqrt__ge__0__iff,axiom,
    ! [Ya: real] :
      ( ord_less_eq(real,zero_zero(real),sqrt(Ya))
    <=> ord_less_eq(real,zero_zero(real),Ya) ) ).

tff(fact_50_le__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Xa: int] :
          ( ord_less_eq(A,number_number_of(A,Xa),zero_zero(A))
        <=> ord_less_eq(int,Xa,pls) ) ) ).

tff(fact_51_le__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Ya: int] :
          ( ord_less_eq(A,zero_zero(A),number_number_of(A,Ya))
        <=> ord_less_eq(int,pls,Ya) ) ) ).

tff(fact_52_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_53_diff__bin__simps_I1_J,axiom,
    ! [K: int] : ( minus_minus(int,K,pls) = K ) ).

tff(fact_54_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_55_real__sqrt__le__mono,axiom,
    ! [Y: real,X: real] :
      ( ord_less_eq(real,X,Y)
     => ord_less_eq(real,sqrt(X),sqrt(Y)) ) ).

tff(fact_56_real__sqrt__eq__zero__cancel,axiom,
    ! [X: real] :
      ( ord_less_eq(real,zero_zero(real),X)
     => ( ( sqrt(X) = zero_zero(real) )
       => ( X = zero_zero(real) ) ) ) ).

tff(fact_57_real__sqrt__ge__zero,axiom,
    ! [X: real] :
      ( ord_less_eq(real,zero_zero(real),X)
     => ord_less_eq(real,zero_zero(real),sqrt(X)) ) ).

tff(fact_58_le__real__sqrt__sumsq,axiom,
    ! [Y: real,X: real] : ord_less_eq(real,X,sqrt(plus_plus(real,times_times(real,X,X),times_times(real,Y,Y)))) ).

tff(fact_59_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W: int] :
          ( ( number_number_of(A,W) = Xa )
        <=> ( Xa = number_number_of(A,W) ) ) ) ).

tff(fact_60_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_61_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,plus_plus(int,V,W1)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_62_add__diff__add,axiom,
    ! [A: $tType] :
      ( ab_group_add(A)
     => ! [D: A,B1: A,C1: A,A2: A] : ( minus_minus(A,plus_plus(A,A2,C1),plus_plus(A,B1,D)) = plus_plus(A,minus_minus(A,A2,B1),minus_minus(A,C1,D)) ) ) ).

tff(fact_63_number__of__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,minus_minus(int,V,W1)) = minus_minus(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_64_real__mult__left__cancel,axiom,
    ! [B: real,A1: real,C: real] :
      ( ( C != zero_zero(real) )
     => ( ( times_times(real,C,A1) = times_times(real,C,B) )
      <=> ( A1 = B ) ) ) ).

tff(fact_65_real__mult__right__cancel,axiom,
    ! [B: real,A1: real,C: real] :
      ( ( C != zero_zero(real) )
     => ( ( times_times(real,A1,C) = times_times(real,B,C) )
      <=> ( A1 = B ) ) ) ).

tff(fact_66_real__sqrt__mult,axiom,
    ! [Y: real,X: real] : ( sqrt(times_times(real,X,Y)) = times_times(real,sqrt(X),sqrt(Y)) ) ).

tff(fact_67_real__sqrt__divide,axiom,
    ! [Y: real,X: real] : ( sqrt(inverse_divide(real,X,Y)) = inverse_divide(real,sqrt(X),sqrt(Y)) ) ).

tff(fact_68_mult__diff__mult,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [B1: A,A2: A,Y: A,X: A] : ( minus_minus(A,times_times(A,X,Y),times_times(A,A2,B1)) = plus_plus(A,times_times(A,X,minus_minus(A,Y,B1)),times_times(A,minus_minus(A,X,A2),B1)) ) ) ).

tff(fact_69_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_70_add__number__of__diff1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [C1: A,W1: int,V: int] : ( plus_plus(A,number_number_of(A,V),minus_minus(A,number_number_of(A,W1),C1)) = minus_minus(A,number_number_of(A,plus_plus(int,V,W1)),C1) ) ) ).

tff(fact_71_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( plus_plus(A,number_number_of(A,pls),A2) = A2 ) ) ).

tff(fact_72_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( plus_plus(A,A2,number_number_of(A,pls)) = A2 ) ) ).

tff(fact_73_lemma__MVT,axiom,
    ! [B: real,A1: real,F: fun(real,real)] : ( minus_minus(real,aa(real,real,F,A1),times_times(real,inverse_divide(real,minus_minus(real,aa(real,real,F,B),aa(real,real,F,A1)),minus_minus(real,B,A1)),A1)) = minus_minus(real,aa(real,real,F,B),times_times(real,inverse_divide(real,minus_minus(real,aa(real,real,F,B),aa(real,real,F,A1)),minus_minus(real,B,A1)),B)) ) ).

tff(fact_74_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int] : ( number_number_of(A,bit0(W1)) = plus_plus(A,plus_plus(A,zero_zero(A),number_number_of(A,W1)),number_number_of(A,W1)) ) ) ).

tff(fact_75_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,C: A,B: A] :
          ( ( inverse_divide(A,B,C) = number_number_of(A,W) )
        <=> ( ( ( C != zero_zero(A) )
             => ( B = times_times(A,number_number_of(A,W),C) ) )
            & ( ( C = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_76_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C: A,B: A,W: int] :
          ( ( number_number_of(A,W) = inverse_divide(A,B,C) )
        <=> ( ( ( C != zero_zero(A) )
             => ( times_times(A,number_number_of(A,W),C) = B ) )
            & ( ( C = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_77_DERIV__mult__lemma,axiom,
    ! [A: $tType] :
      ( real_field(A)
     => ! [H: A,D: A,C1: A,B1: A,A2: A] : ( inverse_divide(A,minus_minus(A,times_times(A,A2,B1),times_times(A,C1,D)),H) = plus_plus(A,times_times(A,A2,inverse_divide(A,minus_minus(A,B1,D),H)),times_times(A,inverse_divide(A,minus_minus(A,A2,C1),H),D)) ) ) ).

tff(fact_78_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_79_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( times_times(A,number_number_of(A,bit1(pls)),A2) = A2 ) ) ).

tff(fact_80_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( times_times(A,A2,number_number_of(A,bit1(pls))) = A2 ) ) ).

tff(fact_81_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,bit1(pls))) = X ) ) ).

tff(fact_82_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A2: A] : ( inverse_divide(A,A2,number_number_of(A,bit1(pls))) = A2 ) ) ).

tff(fact_83_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z) = plus_plus(A,Z,Z) ) ) ).

tff(fact_84_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( times_times(A,number_number_of(A,bit0(bit1(pls))),Z) = plus_plus(A,Z,Z) ) ) ).

tff(fact_85_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( times_times(A,Z,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z,Z) ) ) ).

tff(fact_86_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( times_times(A,Z,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z,Z) ) ) ).

tff(fact_87_eq__divide__2__times__iff,axiom,
    ! [Za: real,Ya: real,Xa: real] :
      ( ( Xa = inverse_divide(real,Ya,times_times(real,number_number_of(real,bit0(bit1(pls))),Za)) )
    <=> ( times_times(real,number_number_of(real,bit0(bit1(pls))),Xa) = inverse_divide(real,Ya,Za) ) ) ).

tff(fact_88_complex__mult,axiom,
    ! [D: real,C1: real,B1: real,A2: real] : ( times_times(complex,complex1(A2,B1),complex1(C1,D)) = complex1(minus_minus(real,times_times(real,A2,C1),times_times(real,B1,D)),plus_plus(real,times_times(real,A2,D),times_times(real,B1,C1))) ) ).

tff(fact_89_sq4_H_I2_J,axiom,
    sqrt(inverse_divide(real,power_power(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(nat,bit0(bit1(pls)))),number_number_of(real,bit0(bit0(bit1(pls)))))) = inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls)))) ).

tff(fact_90_sq4_H_I1_J,axiom,
    sqrt(inverse_divide(real,power_power(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(nat,bit0(bit1(pls)))),number_number_of(real,bit0(bit0(bit1(pls)))))) = inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls)))) ).

tff(fact_91_Complex__eq__number__of,axiom,
    ! [W: int,B: real,A1: real] :
      ( ( complex1(A1,B) = number_number_of(complex,W) )
    <=> ( ( A1 = number_number_of(real,W) )
        & ( B = zero_zero(real) ) ) ) ).

tff(fact_92_abs__le__zero__iff,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] :
          ( ord_less_eq(A,abs_abs(A,A1),zero_zero(A))
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_93_double__add__le__zero__iff__single__add__le__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less_eq(A,plus_plus(A,A1,A1),zero_zero(A))
        <=> ord_less_eq(A,A1,zero_zero(A)) ) ) ).

tff(fact_94_zero__le__double__add__iff__zero__le__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ord_less_eq(A,zero_zero(A),plus_plus(A,A1,A1))
        <=> ord_less_eq(A,zero_zero(A),A1) ) ) ).

tff(fact_95_real__sum__of__halves,axiom,
    ! [X: real] : ( plus_plus(real,inverse_divide(real,X,number_number_of(real,bit0(bit1(pls)))),inverse_divide(real,X,number_number_of(real,bit0(bit1(pls))))) = X ) ).

tff(fact_96_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
        <=> ( B = C ) ) ) ).

%----Arities (44)
tff(arity_Int_Oint___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Oab__group__add,axiom,
    ab_group_add(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs(real) ).

tff(arity_RealDef_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__field,axiom,
    real_field(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__group__add,axiom,
    ab_group_add(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring,axiom,
    semiring(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Rings_Oring,axiom,
    ring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__field,axiom,
    real_field(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__group__add,axiom,
    ab_group_add(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring,axiom,
    semiring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring,axiom,
    ring(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    $true ).

tff(conj_1,hypothesis,
    $true ).

tff(conj_2,conjecture,
    ( ( minus_minus(real,times_times(real,sqrt(inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))),sqrt(inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls)))))),times_times(real,sqrt(inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))),sqrt(inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))))) = x )
    & ( inverse_divide(real,times_times(real,number_number_of(real,bit0(bit1(pls))),times_times(real,y,times_times(real,sqrt(inverse_divide(real,minus_minus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls))))),sqrt(inverse_divide(real,plus_plus(real,sqrt(plus_plus(real,times_times(real,x,x),times_times(real,y,y))),x),number_number_of(real,bit0(bit1(pls)))))))),abs_abs(real,y)) = y ) ) ).

%------------------------------------------------------------------------------
