%------------------------------------------------------------------------------
% File     : SWW482_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fundamental Theorem of Algebra line 43
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fta_43 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.50 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  188 (  74 unt;  42 typ;   0 def)
%            Number of atoms       :  268 ( 133 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  142 (  20   ~;   2   |;  23   &)
%                                         (  19 <=>;  78  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   17 (  12   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   23 (  22 usr;   0 prp; 1-2 aty)
%            Number of functors    :   16 (  16 usr;   5 con; 0-4 aty)
%            Number of variables   :  252 ( 223   !;   0   ?; 252   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:13
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_NthRoot_Oroot,type,
    root: nat > fun(real,real) ).

tff(sy_c_NthRoot_Osqrt,type,
    sqrt: fun(real,real) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_y____,type,
    y: real ).

%----Relevant facts (98)
tff(fact_0_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_1_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_2_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_3_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_4_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_5_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_6_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_7_sq4,axiom,
    ! [X: real] : ( inverse_divide(real,power_power(real,X,number_number_of(nat,bit0(bit1(pls)))),number_number_of(real,bit0(bit0(bit1(pls))))) = power_power(real,inverse_divide(real,X,number_number_of(real,bit0(bit1(pls)))),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_8_real__sqrt__eq__iff,axiom,
    ! [Ya: real,Xa: real] :
      ( ( aa(real,real,sqrt,Xa) = aa(real,real,sqrt,Ya) )
    <=> ( Xa = Ya ) ) ).

tff(fact_9_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_10_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_11_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Ya: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Ya) )
        <=> ( Xa = Ya ) ) ) ).

tff(fact_12_real__sqrt__divide,axiom,
    ! [Y: real,X: real] : ( aa(real,real,sqrt,inverse_divide(real,X,Y)) = inverse_divide(real,aa(real,real,sqrt,X),aa(real,real,sqrt,Y)) ) ).

tff(fact_13_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,bit1(pls))) = X ) ) ).

tff(fact_14_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A1: A] : ( inverse_divide(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_15_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W1: int] :
          ( ( number_number_of(A,W1) = Xa )
        <=> ( Xa = number_number_of(A,W1) ) ) ) ).

tff(fact_16_real__sqrt__power,axiom,
    ! [K: nat,X: real] : ( aa(real,real,sqrt,power_power(real,X,K)) = power_power(real,aa(real,real,sqrt,X),K) ) ).

tff(fact_17_real__sqrt__abs,axiom,
    ! [X: real] : ( aa(real,real,sqrt,power_power(real,X,number_number_of(nat,bit0(bit1(pls))))) = abs_abs(real,X) ) ).

tff(fact_18_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_19_four__x__squared,axiom,
    ! [X: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_20_not__iszero__Numeral1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ~ iszero(A,number_number_of(A,bit1(pls))) ) ).

tff(fact_21_power2__eq__square__number__of,axiom,
    ! [B2: $tType] :
      ( ( monoid_mult(B2)
        & number(B2) )
     => ! [W: int] : ( power_power(B2,number_number_of(B2,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B2,number_number_of(B2,W),number_number_of(B2,W)) ) ) ).

tff(fact_22_iszero__number__of__Bit0,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [W1: int] :
          ( iszero(A,number_number_of(A,bit0(W1)))
        <=> iszero(A,number_number_of(A,W1)) ) ) ).

tff(fact_23_sqrt__def,axiom,
    sqrt = root(number_number_of(nat,bit0(bit1(pls)))) ).

tff(fact_24_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [A2: A] :
          ( ( power_power(A,A2,number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_25_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,zero_zero(A),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_26_y0,axiom,
    y != zero_zero(real) ).

tff(fact_27_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_28_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_29_real__sqrt__zero,axiom,
    aa(real,real,sqrt,zero_zero(real)) = zero_zero(real) ).

tff(fact_30_real__sqrt__eq__0__iff,axiom,
    ! [Xa: real] :
      ( ( aa(real,real,sqrt,Xa) = zero_zero(real) )
    <=> ( Xa = zero_zero(real) ) ) ).

tff(fact_31_real__root__zero,axiom,
    ! [N: nat] : ( aa(real,real,root(N),zero_zero(real)) = zero_zero(real) ) ).

tff(fact_32_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_33_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z) ) ) ).

tff(fact_34_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [N1: nat,A2: A] :
          ( ( power_power(A,A2,N1) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( N1 != zero_zero(nat) ) ) ) ) ).

tff(fact_35_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_36_real__divide__square__eq,axiom,
    ! [A1: real,R: real] : ( inverse_divide(real,times_times(real,R,A1),times_times(real,R,R)) = inverse_divide(real,A1,R) ) ).

tff(fact_37_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_38_real__sqrt__abs2,axiom,
    ! [X: real] : ( aa(real,real,sqrt,times_times(real,X,X)) = abs_abs(real,X) ) ).

tff(fact_39_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [A2: A,W1: int,B1: A] :
          ( ( inverse_divide(A,B1,number_number_of(A,W1)) = A2 )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( B1 = times_times(A,A2,number_number_of(A,W1)) ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_40_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,B1: A,A2: A] :
          ( ( A2 = inverse_divide(A,B1,number_number_of(A,W1)) )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( times_times(A,A2,number_number_of(A,W1)) = B1 ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_41_abs__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( abs_abs(A,power_power(A,A1,number_number_of(nat,bit0(bit1(pls))))) = power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_42_power2__abs,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( power_power(A,abs_abs(A,A1),number_number_of(nat,bit0(bit1(pls)))) = power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_43_iszero__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => iszero(A,zero_zero(A)) ) ).

tff(fact_44_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_45_iszero__def,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Za: A] :
          ( iszero(A,Za)
        <=> ( Za = zero_zero(A) ) ) ) ).

tff(fact_46_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,times_times(int,V,W)) = times_times(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_47_power__abs,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [N: nat,A1: A] : ( abs_abs(A,power_power(A,A1,N)) = power_power(A,abs_abs(A,A1),N) ) ) ).

tff(fact_48_power__commutes,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( times_times(A,power_power(A,A1,N),A1) = times_times(A,A1,power_power(A,A1,N)) ) ) ).

tff(fact_49_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,times_times(A,A1,B),N) = times_times(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_50_power__mult,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M: nat,A1: A] : ( power_power(A,A1,times_times(nat,M,N)) = power_power(A,power_power(A,A1,M),N) ) ) ).

tff(fact_51_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_52_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,C1: A,B1: A] :
          ( ( inverse_divide(A,B1,C1) = number_number_of(A,W1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( B1 = times_times(A,number_number_of(A,W1),C1) ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_53_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C1: A,B1: A,W1: int] :
          ( ( number_number_of(A,W1) = inverse_divide(A,B1,C1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( times_times(A,number_number_of(A,W1),C1) = B1 ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_54_real__sqrt__mult,axiom,
    ! [Y: real,X: real] : ( aa(real,real,sqrt,times_times(real,X,Y)) = times_times(real,aa(real,real,sqrt,X),aa(real,real,sqrt,Y)) ) ).

tff(fact_55_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_56_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_57_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ).

tff(fact_58_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_59_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_60_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_61_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_62_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_63_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_64_iszero__number__of__Bit1,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [W: int] : ~ iszero(A,number_number_of(A,bit1(W))) ) ).

tff(fact_65_iszero__Numeral0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => iszero(A,number_number_of(A,pls)) ) ).

tff(fact_66_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_67_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_68_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,A2: A] :
          ( ( power_power(A,A2,number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_69_eq__divide__2__times__iff,axiom,
    ! [Za: real,Ya: real,Xa: real] :
      ( ( Xa = inverse_divide(real,Ya,times_times(real,number_number_of(real,bit0(bit1(pls))),Za)) )
    <=> ( times_times(real,number_number_of(real,bit0(bit1(pls))),Xa) = inverse_divide(real,Ya,Za) ) ) ).

tff(fact_70_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X: A] : ( power_power(A,X,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X,N),power_power(A,X,N)) ) ) ).

tff(fact_71_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( times_times(A,X,X) = power_power(A,X,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_72_abs__divide,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,A1: A] : ( abs_abs(A,inverse_divide(A,A1,B)) = inverse_divide(A,abs_abs(A,A1),abs_abs(A,B)) ) ) ).

tff(fact_73_ext,axiom,
    ! [B2: $tType,A: $tType,G: fun(A,B2),F: fun(A,B2)] :
      ( ! [X1: A] : ( aa(A,B2,F,X1) = aa(A,B2,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_abs__mult__self,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( times_times(A,abs_abs(A,A1),abs_abs(A,A1)) = times_times(A,A1,A1) ) ) ).

tff(fact_75_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_76_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_77_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A2: A] :
          ( ( times_times(A,A2,B1) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_78_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_79_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( inverse_divide(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_80_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,A1,inverse_divide(A,B,C)) = inverse_divide(A,times_times(A,A1,B),C) ) ) ).

tff(fact_81_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_82_times__numeral__code_I5_J,axiom,
    ! [W: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W)) = number_number_of(int,times_times(int,V,W)) ) ).

tff(fact_83_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( power_power(int,power_power(int,X,Y),Z) = power_power(int,X,times_times(nat,Y,Z)) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_90_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X: A] : ( power_power(A,power_power(A,X,P),Q) = power_power(A,X,times_times(nat,P,Q)) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I9_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_94_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_95_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B != zero_zero(A) )
           => ( times_times(A,A1,B) != zero_zero(A) ) ) ) ) ).

tff(fact_96_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( times_times(A,A1,B) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B = zero_zero(A) ) ) ) ) ).

tff(fact_97_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y: A,X: A] : ( power_power(A,times_times(A,X,Y),Q) = times_times(A,power_power(A,X,Q),power_power(A,Y,Q)) ) ) ).

%----Arities (45)
tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field__inverse__zero,axiom,
    linord1117847801e_zero(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring,axiom,
    division_ring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__1,axiom,
    semiring_1(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(real,real,sqrt,number_number_of(real,bit0(bit0(bit1(pls))))) = aa(real,real,sqrt,power_power(real,number_number_of(real,bit0(bit1(pls))),number_number_of(nat,bit0(bit1(pls))))) ).

%------------------------------------------------------------------------------
