%------------------------------------------------------------------------------
% File     : SWW476_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Java type soundness line 197
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : jinja_197 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  33 unt;  58 typ;   0 def)
%            Number of atoms       :  262 (  82 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  186 (  31   ~;   2   |;   6   &)
%                                         (  15 <=>; 132  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   8 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   79 (  39   >;  40   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-5 aty)
%            Number of functors    :   41 (  41 usr;  10 con; 0-6 aty)
%            Number of variables   :  650 ( 590   !;  12   ?; 650   :)
%                                         (  48  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:58
%------------------------------------------------------------------------------
%----Should-be-implicit typings (10)
tff(ty_tc_Expr_Oexp,type,
    exp: $tType > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_Type_Oty,type,
    ty: $tType ).

tff(ty_tc_Value_Oval,type,
    val: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_c_BigStep_Oeval,type,
    eval: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) * exp(list(char)) * product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))) ) > $o ).

tff(sy_c_BigStep_Ofinal,type,
    final: 
      !>[A: $tType] : ( exp(A) > $o ) ).

tff(sy_c_Conform_Oconf,type,
    conf: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > fun(val,fun(ty,bool)) ) ).

tff(sy_c_Conform_Ohconf,type,
    hconf: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ) ).

tff(sy_c_Conform_Olconf,type,
    lconf: 
      !>[M: $tType] : ( ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(val)) * fun(list(char),option(ty)) ) > $o ) ).

tff(sy_c_Expr_Oexp_OVal,type,
    val1: 
      !>[A: $tType] : fun(val,exp(A)) ).

tff(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Fun_Ooverride__on,type,
    override_on: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,B) * fun(A,bool) ) > fun(A,B) ) ).

tff(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Olist__all2,type,
    list_all2: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,bool)) * list(A) * list(B) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > fun(list(A),list(B)) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Map_Omap__add,type,
    map_add: 
      !>[A: $tType,B: $tType] : ( ( fun(A,option(B)) * fun(A,option(B)) ) > fun(A,option(B)) ) ).

tff(sy_c_Map_Omap__upds,type,
    map_upds: 
      !>[A: $tType,B: $tType] : ( ( fun(A,option(B)) * list(A) * list(B) ) > fun(A,option(B)) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Objects_Ohext,type,
    hext: ( fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ) > $o ).

tff(sy_c_Objects_Otypeof__h,type,
    typeof_h: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) > fun(val,option(ty)) ).

tff(sy_c_Option_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( option(A) * fun(A,option(B)) ) > option(B) ) ).

tff(sy_c_Option_Ois__none,type,
    is_none: 
      !>[A: $tType] : ( option(A) > $o ) ).

tff(sy_c_Option_Ooption_OSome,type,
    some: 
      !>[A: $tType] : fun(A,option(A)) ).

tff(sy_c_Option_Ooption_Ooption__case,type,
    option_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,T4) * option(A) ) > T4 ) ).

tff(sy_c_Option_Ooption_Ooption__rec,type,
    option_rec: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,T4) * option(A) ) > T4 ) ).

tff(sy_c_Option_Oset,type,
    set1: 
      !>[A: $tType] : ( option(A) > fun(A,bool) ) ).

tff(sy_c_Option_Othe,type,
    the: 
      !>[A: $tType] : fun(option(A),A) ).

tff(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( ( A * B ) > product_prod(A,B) ) ).

tff(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(product_prod(A,B),C) * A * B ) > C ) ).

tff(sy_c_Product__Type_Ointernal__split,type,
    produc1605651328_split: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * product_prod(A,B) ) > C ) ).

tff(sy_c_Product__Type_Oprod_Oprod__rec,type,
    product_prod_rec: 
      !>[A: $tType,B: $tType,T4: $tType] : ( ( fun(A,fun(B,T4)) * product_prod(A,B) ) > T4 ) ).

tff(sy_c_SmallStep_Oblocks,type,
    blocks: product_prod(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char))))) > exp(list(char)) ).

tff(sy_c_SmallStep_Ored,type,
    red: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) > fun(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),bool) ).

tff(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( fun(product_prod(A,A),bool) > fun(product_prod(A,A),bool) ) ).

tff(sy_c_TypeRel_Owiden,type,
    widen: 
      !>[M: $tType] : ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M)))))))) > fun(ty,fun(ty,bool)) ) ).

tff(sy_c_WellTypeRT_OWTrt,type,
    wTrt: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * exp(list(char)) * ty ) > $o ).

tff(sy_c_WellTypeRT_OWTrts,type,
    wTrts: ( list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) * fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) * fun(list(char),option(ty)) * list(exp(list(char))) * list(ty) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_E,type,
    e1: fun(list(char),option(ty)) ).

tff(sy_v_P,type,
    p: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))) ).

tff(sy_v_T,type,
    t: ty ).

tff(sy_v_Ts,type,
    ts: list(ty) ).

tff(sy_v_Vs,type,
    vs1: list(list(char)) ).

tff(sy_v_e,type,
    e: exp(list(char)) ).

tff(sy_v_h,type,
    h: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))) ).

tff(sy_v_vs,type,
    vs: list(val) ).

%----Relevant facts (100)
tff(fact_0_widens__refl,axiom,
    ! [A: $tType,Xs: list(ty),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] : list_all2(ty,ty,widen(A,Pa),Xs,Xs) ).

tff(fact_1_length__map,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( size_size(list(A),aa(list(B),list(A),map(B,A,F),Xs)) = size_size(list(B),Xs) ) ).

tff(fact_2_widen__refl,axiom,
    ! [M: $tType,T3: ty,P4: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,M))))))))] : pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(M,P4),T3),T3)) ).

tff(fact_3_option_Oinject,axiom,
    ! [A: $tType,A7: A,A2: A] :
      ( ( aa(A,option(A),some(A),A2) = aa(A,option(A),some(A),A7) )
    <=> ( A2 = A7 ) ) ).

tff(fact_4_widens__trans,axiom,
    ! [A: $tType,Us: list(ty),Tsa: list(ty),Ss: list(ty),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(ty,ty,widen(A,Pa),Ss,Tsa)
     => ( list_all2(ty,ty,widen(A,Pa),Tsa,Us)
       => list_all2(ty,ty,widen(A,Pa),Ss,Us) ) ) ).

tff(fact_5_split__paired__All,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ! [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ! [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_6_Pair__eq,axiom,
    ! [A: $tType,B: $tType,B6: B,A7: A,B1: B,A2: A] :
      ( ( product_Pair(A,B,A2,B1) = product_Pair(A,B,A7,B6) )
    <=> ( ( A2 = A7 )
        & ( B1 = B6 ) ) ) ).

tff(fact_7_list__all2__lengthD,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,Xs,Ys)
     => ( size_size(list(A),Xs) = size_size(list(B),Ys) ) ) ).

tff(fact_8_map__eq__imp__length__eq,axiom,
    ! [A: $tType,B: $tType,C: $tType,Ys: list(C),G: fun(C,A),Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xs) = aa(list(C),list(A),map(C,A,G),Ys) )
     => ( size_size(list(B),Xs) = size_size(list(C),Ys) ) ) ).

tff(fact_9_prod__induct6,axiom,
    ! [F3: $tType,E2: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3))))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3))))),bool)] :
      ( ! [A1: A,B2: B,C5: C,D1: D,E3: E2,F4: F3] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3))))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E2,F3))),B2,product_Pair(C,product_prod(D,product_prod(E2,F3)),C5,product_Pair(D,product_prod(E2,F3),D1,product_Pair(E2,F3,E3,F4)))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3))))),bool,Pa,X2)) ) ).

tff(fact_10_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E2: $tType,F3: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3)))))] :
      ~ ! [A1: A,B2: B,C5: C,D1: D,E3: E2,F4: F3] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,product_prod(E2,F3)))),A1,product_Pair(B,product_prod(C,product_prod(D,product_prod(E2,F3))),B2,product_Pair(C,product_prod(D,product_prod(E2,F3)),C5,product_Pair(D,product_prod(E2,F3),D1,product_Pair(E2,F3,E3,F4))))) ) ).

tff(fact_11_prod__induct5,axiom,
    ! [E2: $tType,D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E2)))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E2)))),bool)] :
      ( ! [A1: A,B2: B,C5: C,D1: D,E3: E2] : pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E2)))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E2))),A1,product_Pair(B,product_prod(C,product_prod(D,E2)),B2,product_Pair(C,product_prod(D,E2),C5,product_Pair(D,E2,D1,E3))))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,product_prod(D,E2)))),bool,Pa,X2)) ) ).

tff(fact_12_Pair__inject,axiom,
    ! [A: $tType,B: $tType,B5: B,A6: A,B4: B,A5: A] :
      ( ( product_Pair(A,B,A5,B4) = product_Pair(A,B,A6,B5) )
     => ~ ( ( A5 = A6 )
         => ( B4 != B5 ) ) ) ).

tff(fact_13_neq__if__length__neq,axiom,
    ! [A: $tType,Ys2: list(A),Xs2: list(A)] :
      ( ( size_size(list(A),Xs2) != size_size(list(A),Ys2) )
     => ( Xs2 != Ys2 ) ) ).

tff(fact_14_list__all2__eq,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = Ys )
    <=> list_all2(A,A,fequal(A),Xs,Ys) ) ).

tff(fact_15_widen__trans,axiom,
    ! [A: $tType,T3: ty,U: ty,S2: ty,P4: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P4),S2),U))
     => ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P4),U),T3))
       => pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,P4),S2),T3)) ) ) ).

tff(fact_16_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,E2: $tType,Y: product_prod(A,product_prod(B,product_prod(C,product_prod(D,E2))))] :
      ~ ! [A1: A,B2: B,C5: C,D1: D,E3: E2] : ( Y != product_Pair(A,product_prod(B,product_prod(C,product_prod(D,E2))),A1,product_Pair(B,product_prod(C,product_prod(D,E2)),B2,product_Pair(C,product_prod(D,E2),C5,product_Pair(D,E2,D1,E3)))) ) ).

tff(fact_17_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D: $tType,Y: product_prod(A,product_prod(B,product_prod(C,D)))] :
      ~ ! [A1: A,B2: B,C5: C,D1: D] : ( Y != product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C5,D1))) ) ).

tff(fact_18_prod__induct4,axiom,
    ! [D: $tType,C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,product_prod(C,D))),Pa: fun(product_prod(A,product_prod(B,product_prod(C,D))),bool)] :
      ( ! [A1: A,B2: B,C5: C,D1: D] : pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,product_Pair(A,product_prod(B,product_prod(C,D)),A1,product_Pair(B,product_prod(C,D),B2,product_Pair(C,D,C5,D1)))))
     => pp(aa(product_prod(A,product_prod(B,product_prod(C,D))),bool,Pa,X2)) ) ).

tff(fact_19_split__paired__Ex,axiom,
    ! [A: $tType,B: $tType,Pa: fun(product_prod(A,B),bool)] :
      ( ? [X11: product_prod(A,B)] : pp(aa(product_prod(A,B),bool,Pa,X11))
    <=> ? [A4: A,B3: B] : pp(aa(product_prod(A,B),bool,Pa,product_Pair(A,B,A4,B3))) ) ).

tff(fact_20_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod(A,product_prod(B,C))] :
      ~ ! [A1: A,B2: B,C5: C] : ( Y != product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B2,C5)) ) ).

tff(fact_21_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,X2: product_prod(A,product_prod(B,C)),Pa: fun(product_prod(A,product_prod(B,C)),bool)] :
      ( ! [A1: A,B2: B,C5: C] : pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,product_Pair(A,product_prod(B,C),A1,product_Pair(B,C,B2,C5))))
     => pp(aa(product_prod(A,product_prod(B,C)),bool,Pa,X2)) ) ).

tff(fact_22_confs__conv__map,axiom,
    ! [A: $tType,Ts1: list(ty),Vsa1: list(val),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(val,ty,conf(A,Pa,Ha),Vsa1,Ts1)
    <=> ? [Ts2: list(ty)] :
          ( ( aa(list(val),list(option(ty)),map(val,option(ty),typeof_h(Ha)),Vsa1) = aa(list(ty),list(option(ty)),map(ty,option(ty),some(ty)),Ts2) )
          & list_all2(ty,ty,widen(A,Pa),Ts2,Ts1) ) ) ).

tff(fact_23_prod_Orecs,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A2: B,F1: fun(B,fun(C,A))] : ( product_prod_rec(B,C,A,F1,product_Pair(B,C,A2,B1)) = aa(C,A,aa(B,fun(C,A),F1,A2),B1) ) ).

tff(fact_24_list__all2__mono,axiom,
    ! [A: $tType,B: $tType,Q: fun(A,fun(B,bool)),Ys: list(B),Xs: list(A),Pa: fun(A,fun(B,bool))] :
      ( list_all2(A,B,Pa,Xs,Ys)
     => ( ! [Xs1: A,Ys1: B] :
            ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Xs1),Ys1))
           => pp(aa(B,bool,aa(A,fun(B,bool),Q,Xs1),Ys1)) )
       => list_all2(A,B,Q,Xs,Ys) ) ) ).

tff(fact_25_conf__widen,axiom,
    ! [A: $tType,T2: ty,Ta: ty,V2: val,Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V2),Ta))
     => ( pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,Pa),Ta),T2))
       => pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V2),T2)) ) ) ).

tff(fact_26_typeof__conf,axiom,
    ! [A: $tType,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),Ta: ty,V2: val,Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(val,option(ty),typeof_h(Ha),V2) = aa(ty,option(ty),some(ty),Ta) )
     => pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V2),Ta)) ) ).

tff(fact_27_confs__widens,axiom,
    ! [A: $tType,Ts1: list(ty),Tsa: list(ty),Vsa1: list(val),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(val,ty,conf(A,Pa,Ha),Vsa1,Tsa)
     => ( list_all2(ty,ty,widen(A,Pa),Tsa,Ts1)
       => list_all2(val,ty,conf(A,Pa,Ha),Vsa1,Ts1) ) ) ).

tff(fact_28_conf__def,axiom,
    ! [A: $tType,Ta: ty,V2: val,Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V2),Ta))
    <=> ? [T1: ty] :
          ( ( aa(val,option(ty),typeof_h(Ha),V2) = aa(ty,option(ty),some(ty),T1) )
          & pp(aa(ty,bool,aa(ty,fun(ty,bool),widen(A,Pa),T1),Ta)) ) ) ).

tff(fact_29_list__all2__trans,axiom,
    ! [B: $tType,A: $tType,C: $tType,Cs: list(C),Bs: list(B),As: list(A),P3: fun(A,fun(C,bool)),P2: fun(B,fun(C,bool)),P11: fun(A,fun(B,bool))] :
      ( ! [A1: A,B2: B,C5: C] :
          ( pp(aa(B,bool,aa(A,fun(B,bool),P11,A1),B2))
         => ( pp(aa(C,bool,aa(B,fun(C,bool),P2,B2),C5))
           => pp(aa(C,bool,aa(A,fun(C,bool),P3,A1),C5)) ) )
     => ( list_all2(A,B,P11,As,Bs)
       => ( list_all2(B,C,P2,Bs,Cs)
         => list_all2(A,C,P3,As,Cs) ) ) ) ).

tff(fact_30_list__all2__antisym,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),Q: fun(A,fun(A,bool)),Pa: fun(A,fun(A,bool))] :
      ( ! [X3: A,Y1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),Pa,X3),Y1))
         => ( pp(aa(A,bool,aa(A,fun(A,bool),Q,Y1),X3))
           => ( X3 = Y1 ) ) )
     => ( list_all2(A,A,Pa,Xs,Ys)
       => ( list_all2(A,A,Q,Ys,Xs)
         => ( Xs = Ys ) ) ) ) ).

tff(fact_31_list__all2__refl,axiom,
    ! [A: $tType,Xs: list(A),Pa: fun(A,fun(A,bool))] :
      ( ! [X3: A] : pp(aa(A,bool,aa(A,fun(A,bool),Pa,X3),X3))
     => list_all2(A,A,Pa,Xs,Xs) ) ).

tff(fact_32_elem__set,axiom,
    ! [A: $tType,Xo: option(A),X2: A] :
      ( member(A,X2,set1(A,Xo))
    <=> ( Xo = aa(A,option(A),some(A),X2) ) ) ).

tff(fact_33_option_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,A2: B,F2: fun(B,A),F1: A] : ( option_rec(A,B,F1,F2,aa(B,option(B),some(B),A2)) = aa(B,A,F2,A2) ) ).

tff(fact_34_Ex__list__of__length,axiom,
    ! [A: $tType,N: nat] :
    ? [Xs1: list(A)] : ( size_size(list(A),Xs1) = N ) ).

tff(fact_35_PairE,axiom,
    ! [A: $tType,B: $tType,P1: product_prod(A,B)] :
      ~ ! [X3: A,Y1: B] : ( P1 != product_Pair(A,B,X3,Y1) ) ).

tff(fact_36_ospec,axiom,
    ! [A: $tType,X2: A,Pa: fun(A,bool),A3: option(A)] :
      ( ! [X3: A] :
          ( member(A,X3,set1(A,A3))
         => pp(aa(A,bool,Pa,X3)) )
     => ( ( A3 = aa(A,option(A),some(A),X2) )
       => pp(aa(A,bool,Pa,X2)) ) ) ).

tff(fact_37_prod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod(A,B)] :
      ~ ! [A1: A,B2: B] : ( Y != product_Pair(A,B,A1,B2) ) ).

tff(fact_38_internal__split__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,B1: C,A2: B,C2: fun(B,fun(C,A))] : ( produc1605651328_split(B,C,A,C2,product_Pair(B,C,A2,B1)) = aa(C,A,aa(B,fun(C,A),C2,A2),B1) ) ).

tff(fact_39_curry__conv,axiom,
    ! [A: $tType,B: $tType,C: $tType,B1: C,A2: B,F: fun(product_prod(B,C),A)] : ( product_curry(B,C,A,F,A2,B1) = aa(product_prod(B,C),A,F,product_Pair(B,C,A2,B1)) ) ).

tff(fact_40_is__none__code_I2_J,axiom,
    ! [B: $tType,X: B] : ~ is_none(B,aa(B,option(B),some(B),X)) ).

tff(fact_41_curryI,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B1)))
     => pp(product_curry(A,B,bool,F,A2,B1)) ) ).

tff(fact_42_curryD,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A2,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B1))) ) ).

tff(fact_43_curryE,axiom,
    ! [A: $tType,B: $tType,B1: B,A2: A,F: fun(product_prod(A,B),bool)] :
      ( pp(product_curry(A,B,bool,F,A2,B1))
     => pp(aa(product_prod(A,B),bool,F,product_Pair(A,B,A2,B1))) ) ).

tff(fact_44_option_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,A2: B,F2: fun(B,A),F1: A] : ( option_case(A,B,F1,F2,aa(B,option(B),some(B),A2)) = aa(B,A,F2,A2) ) ).

tff(fact_45_confs__hext,axiom,
    ! [A: $tType,H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Tsa: list(ty),Vsa1: list(val),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( list_all2(val,ty,conf(A,Pa,Ha),Vsa1,Tsa)
     => ( hext(Ha,H)
       => list_all2(val,ty,conf(A,Pa,H),Vsa1,Tsa) ) ) ).

tff(fact_46_blocksEval,axiom,
    ! [L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Vsa1: list(val),Tsa: list(ty),Ps: list(list(char))] :
      ( ( size_size(list(list(char)),Ps) = size_size(list(ty),Tsa) )
     => ( ( size_size(list(list(char)),Ps) = size_size(list(val),Vsa1) )
       => ( eval(Pa,blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Ps,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),Vsa1,Ea)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))
         => ? [L3: fun(list(char),option(val))] : eval(Pa,Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_upds(list(char),val,L,Ps,Vsa1)),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L3)) ) ) ) ).

tff(fact_47_WTrts__Val,axiom,
    ! [Tsa: list(ty),Vsa1: list(val),E1: fun(list(char),option(ty)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrts(Pa,Ha,E1,aa(list(val),list(exp(list(char))),map(val,exp(list(char)),val1(list(char))),Vsa1),Tsa)
    <=> ( aa(list(val),list(option(ty)),map(val,option(ty),typeof_h(Ha)),Vsa1) = aa(list(ty),list(option(ty)),map(ty,option(ty),some(ty)),Tsa) ) ) ).

tff(fact_48_bind__lunit,axiom,
    ! [A: $tType,B: $tType,F: fun(B,option(A)),X2: B] : ( bind(B,A,aa(B,option(B),some(B),X2),F) = aa(B,option(A),F,X2) ) ).

tff(fact_49_WTrtVal,axiom,
    ! [E1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ta: ty,V2: val,Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ( aa(val,option(ty),typeof_h(Ha),V2) = aa(ty,option(ty),some(ty),Ta) )
     => wTrt(Pa,Ha,E1,aa(val,exp(list(char)),val1(list(char)),V2),Ta) ) ).

tff(fact_50_WTrt__hext__mono,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ta: ty,Ea: exp(list(char)),E1: fun(list(char),option(ty)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrt(Pa,Ha,E1,Ea,Ta)
     => ( hext(Ha,H)
       => wTrt(Pa,H,E1,Ea,Ta) ) ) ).

tff(fact_51_WTrts__hext__mono,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Tsa: list(ty),Es: list(exp(list(char))),E1: fun(list(char),option(ty)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrts(Pa,Ha,E1,Es,Tsa)
     => ( hext(Ha,H)
       => wTrts(Pa,H,E1,Es,Tsa) ) ) ).

tff(fact_52_WTrts__same__length,axiom,
    ! [Tsa: list(ty),Es: list(exp(list(char))),E1: fun(list(char),option(ty)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( wTrts(Pa,Ha,E1,Es,Tsa)
     => ( size_size(list(exp(list(char))),Es) = size_size(list(ty),Tsa) ) ) ).

tff(fact_53_conf__hext,axiom,
    ! [A: $tType,Ta: ty,V2: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A)))))))),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H)
     => ( pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V2),Ta))
       => pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,H),V2),Ta)) ) ) ).

tff(fact_54_bind__runit,axiom,
    ! [A: $tType,X2: option(A)] : ( bind(A,A,X2,some(A)) = X2 ) ).

tff(fact_55_hext__typeof__mono,axiom,
    ! [Ta: ty,V2: val,H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H)
     => ( ( aa(val,option(ty),typeof_h(Ha),V2) = aa(ty,option(ty),some(ty),Ta) )
       => ( aa(val,option(ty),typeof_h(H),V2) = aa(ty,option(ty),some(ty),Ta) ) ) ) ).

tff(fact_56_eval__hext,axiom,
    ! [L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))
     => hext(Ha,H) ) ).

tff(fact_57_hext__refl,axiom,
    ! [Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] : hext(Ha,Ha) ).

tff(fact_58_exp_Osimps_I3_J,axiom,
    ! [A: $tType,Val1: val,Val: val] :
      ( ( aa(val,exp(A),val1(A),Val) = aa(val,exp(A),val1(A),Val1) )
    <=> ( Val = Val1 ) ) ).

tff(fact_59_hext__trans,axiom,
    ! [H1: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H)
     => ( hext(H,H1)
       => hext(Ha,H1) ) ) ).

tff(fact_60_eval__cases_I2_J,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),V2: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,aa(val,exp(list(char)),val1(list(char)),V2),S,E,S1)
     => ~ ( ( E = aa(val,exp(list(char)),val1(list(char)),V2) )
         => ( S1 != S ) ) ) ).

tff(fact_61_Val,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),V2: val,Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] : eval(Pa,aa(val,exp(list(char)),val1(list(char)),V2),S,aa(val,exp(list(char)),val1(list(char)),V2),S) ).

tff(fact_62_hext__objD,axiom,
    ! [Fs4: fun(product_prod(list(char),list(char)),option(val)),C4: list(char),A2: nat,H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H)
     => ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A2) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs4)) )
       => ? [Fs5: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H,A2) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C4,Fs5)) ) ) ) ).

tff(fact_63_hext__def,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( hext(Ha,H)
    <=> ! [A4: nat,C3: list(char),Fs2: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A4) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs2)) )
         => ? [Fs3: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H,A4) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C3,Fs3)) ) ) ) ).

tff(fact_64_blocksFinal,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char)),Vsa1: list(val),Tsa: list(ty),Vsa: list(list(char))] :
      ( ( size_size(list(list(char)),Vsa) = size_size(list(ty),Tsa) )
     => ( ( size_size(list(val),Vsa1) = size_size(list(ty),Tsa) )
       => ( final(list(char),Ea)
         => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Vsa,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),Vsa1,Ea)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ) ).

tff(fact_65_eval__final,axiom,
    ! [S1: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E: exp(list(char)),S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea: exp(list(char)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char)))))))))))] :
      ( eval(Pa,Ea,S,E,S1)
     => final(list(char),E) ) ).

tff(fact_66_eval__finalId,axiom,
    ! [S: product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),Ea: exp(list(char))] :
      ( final(list(char),Ea)
     => eval(Pa,Ea,S,Ea,S) ) ).

tff(fact_67_red__hext__incr,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),red(Pa))
     => hext(Ha,H) ) ).

tff(fact_68_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),A2: A] : member(product_prod(A,A),product_Pair(A,A,A2,A2),transitive_rtrancl(A,R)) ).

tff(fact_69_rtrancl__idemp,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool)] : ( transitive_rtrancl(A,transitive_rtrancl(A,R)) = transitive_rtrancl(A,R) ) ).

tff(fact_70_r__into__rtrancl,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),P: product_prod(A,A)] :
      ( member(product_prod(A,A),P,R)
     => member(product_prod(A,A),P,transitive_rtrancl(A,R)) ) ).

tff(fact_71_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),R)
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C2),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_72_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C2),R)
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_73_rtrancl__trans,axiom,
    ! [A: $tType,C2: A,R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),transitive_rtrancl(A,R))
     => ( member(product_prod(A,A),product_Pair(A,A,B1,C2),transitive_rtrancl(A,R))
       => member(product_prod(A,A),product_Pair(A,A,A2,C2),transitive_rtrancl(A,R)) ) ) ).

tff(fact_74_rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay))
       => ( ! [A1: A,B2: B,Aa: A,Ba: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,A1,B2)),transitive_rtrancl(product_prod(A,B),R))
             => ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B2),product_Pair(A,B,Aa,Ba)),R)
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,A1),B2))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By)) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X2: A] :
      ( member(A,X2,A3)
    <=> pp(aa(A,bool,A3,X2)) ) ).

tff(fact_77_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Pa: fun(A,fun(B,bool)),R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),By: B,Bx: A,Ay: B,Ax: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Ax,Ay),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
     => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Bx),By))
       => ( ! [A1: A,B2: B,Aa: A,Ba: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B2),product_Pair(A,B,Aa,Ba)),R)
             => ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Aa,Ba),product_Pair(A,B,Bx,By)),transitive_rtrancl(product_prod(A,B),R))
               => ( pp(aa(B,bool,aa(A,fun(B,bool),Pa,Aa),Ba))
                 => pp(aa(B,bool,aa(A,fun(B,bool),Pa,A1),B2)) ) ) )
         => pp(aa(B,bool,aa(A,fun(B,bool),Pa,Ax),Ay)) ) ) ) ).

tff(fact_78_converse__rtranclE2,axiom,
    ! [B: $tType,A: $tType,R: fun(product_prod(product_prod(A,B),product_prod(A,B)),bool),Zb: B,Za: A,Xb: B,Xa: A] :
      ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,Za,Zb)),transitive_rtrancl(product_prod(A,B),R))
     => ( ( product_Pair(A,B,Xa,Xb) != product_Pair(A,B,Za,Zb) )
       => ~ ! [A1: A,B2: B] :
              ( member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,Xa,Xb),product_Pair(A,B,A1,B2)),R)
             => ~ member(product_prod(product_prod(A,B),product_prod(A,B)),product_Pair(product_prod(A,B),product_prod(A,B),product_Pair(A,B,A1,B2),product_Pair(A,B,Za,Zb)),transitive_rtrancl(product_prod(A,B),R)) ) ) ) ).

tff(fact_79_red__preserves__hconf,axiom,
    ! [Ta: ty,E1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),red(Pa))
     => ( wTrt(Pa,Ha,E1,Ea,Ta)
       => ( hconf(product_prod(list(list(char)),exp(list(char))),Pa,Ha)
         => hconf(product_prod(list(list(char)),exp(list(char))),Pa,H) ) ) ) ).

tff(fact_80_rtranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),transitive_rtrancl(A,R))
     => ( ( A2 != B1 )
       => ~ ! [Y1: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A2,Y1),transitive_rtrancl(A,R))
             => ~ member(product_prod(A,A),product_Pair(A,A,Y1,B1),R) ) ) ) ).

tff(fact_81_rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),transitive_rtrancl(A,R))
     => ( pp(aa(A,bool,Pa,A2))
       => ( ! [Y1: A,Z1: A] :
              ( member(product_prod(A,A),product_Pair(A,A,A2,Y1),transitive_rtrancl(A,R))
             => ( member(product_prod(A,A),product_Pair(A,A,Y1,Z1),R)
               => ( pp(aa(A,bool,Pa,Y1))
                 => pp(aa(A,bool,Pa,Z1)) ) ) )
         => pp(aa(A,bool,Pa,B1)) ) ) ) ).

tff(fact_82_converse__rtrancl__induct,axiom,
    ! [A: $tType,Pa: fun(A,bool),R: fun(product_prod(A,A),bool),B1: A,A2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,A2,B1),transitive_rtrancl(A,R))
     => ( pp(aa(A,bool,Pa,B1))
       => ( ! [Y1: A,Z1: A] :
              ( member(product_prod(A,A),product_Pair(A,A,Y1,Z1),R)
             => ( member(product_prod(A,A),product_Pair(A,A,Z1,B1),transitive_rtrancl(A,R))
               => ( pp(aa(A,bool,Pa,Z1))
                 => pp(aa(A,bool,Pa,Y1)) ) ) )
         => pp(aa(A,bool,Pa,A2)) ) ) ) ).

tff(fact_83_converse__rtranclE,axiom,
    ! [A: $tType,R: fun(product_prod(A,A),bool),Z: A,X2: A] :
      ( member(product_prod(A,A),product_Pair(A,A,X2,Z),transitive_rtrancl(A,R))
     => ( ( X2 != Z )
       => ~ ! [Y1: A] :
              ( member(product_prod(A,A),product_Pair(A,A,X2,Y1),R)
             => ~ member(product_prod(A,A),product_Pair(A,A,Y1,Z),transitive_rtrancl(A,R)) ) ) ) ).

tff(fact_84_red__preserves__lconf,axiom,
    ! [Ta: ty,E1: fun(list(char),option(ty)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),red(Pa))
     => ( wTrt(Pa,Ha,E1,Ea,Ta)
       => ( lconf(product_prod(list(list(char)),exp(list(char))),Pa,Ha,L,E1)
         => lconf(product_prod(list(list(char)),exp(list(char))),Pa,H,L1,E1) ) ) ) ).

tff(fact_85_lconf__hext,axiom,
    ! [A: $tType,H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E1: fun(list(char),option(ty)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Ha,L,E1)
     => ( hext(Ha,H)
       => lconf(A,Pa,H,L,E1) ) ) ).

tff(fact_86_lconf__def,axiom,
    ! [A: $tType,E1: fun(list(char),option(ty)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,A))))))))] :
      ( lconf(A,Pa,Ha,L,E1)
    <=> ! [V1: list(char),V: val] :
          ( ( aa(list(char),option(val),L,V1) = aa(val,option(val),some(val),V) )
         => ? [T: ty] :
              ( ( aa(list(char),option(ty),E1,V1) = aa(ty,option(ty),some(ty),T) )
              & pp(aa(ty,bool,aa(val,fun(ty,bool),conf(A,Pa,Ha),V),T)) ) ) ) ).

tff(fact_87_hextI,axiom,
    ! [H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))))] :
      ( ! [A1: nat,C1: list(char),Fs: fun(product_prod(list(char),list(char)),option(val))] :
          ( ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),Ha,A1) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C1,Fs)) )
         => ? [Fs1: fun(product_prod(list(char),list(char)),option(val))] : ( aa(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),H,A1) = aa(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))),option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),some(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val)))),product_Pair(list(char),fun(product_prod(list(char),list(char)),option(val)),C1,Fs1)) ) )
     => hext(Ha,H) ) ).

tff(fact_88_blocksRedsFinal,axiom,
    ! [L2: fun(list(char),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char)),Vsa1: list(val),Tsa: list(ty),Vsa: list(list(char))] :
      ( ( size_size(list(list(char)),Vsa) = size_size(list(ty),Tsa) )
     => ( ( size_size(list(val),Vsa1) = size_size(list(ty),Tsa) )
       => ( distinct(list(char),Vsa)
         => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_upds(list(char),val,L,Vsa,Vsa1))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
           => ( final(list(char),E)
             => ( ( L2 = override_on(list(char),option(val),L1,L,set(list(char),Vsa)) )
               => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Vsa,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),Vsa1,Ea)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L2))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ) ) ) ) ).

tff(fact_89_Red__lcl__add,axiom,
    ! [L_0: fun(list(char),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_add(list(char),val,L_0,L))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,map_add(list(char),val,L_0,L1)))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ).

tff(fact_90_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,G: fun(B,A),Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),map(B,A,F),Xs) = aa(list(B),list(A),map(B,A,G),Xs) )
    <=> ! [X1: B] :
          ( member(B,X1,set(B,Xs))
         => ( aa(B,A,F,X1) = aa(B,A,G,X1) ) ) ) ).

tff(fact_91_red__lcl__add,axiom,
    ! [L_0: fun(list(char),option(val)),Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char))] :
      ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),red(Pa))
     => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_add(list(char),val,L_0,L))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,map_add(list(char),val,L_0,L1)))),red(Pa)) ) ).

tff(fact_92_map__add__upds,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(A),M2: fun(A,option(B)),M1: fun(A,option(B))] : ( map_add(A,B,M1,map_upds(A,B,M2,Xs,Ys)) = map_upds(A,B,map_add(A,B,M1,M2),Xs,Ys) ) ).

tff(fact_93_blocksReds,axiom,
    ! [Pa: list(product_prod(list(char),product_prod(list(char),product_prod(list(product_prod(list(char),ty)),list(product_prod(list(char),product_prod(list(ty),product_prod(ty,product_prod(list(list(char)),exp(list(char))))))))))),L1: fun(list(char),option(val)),H: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),E: exp(list(char)),L: fun(list(char),option(val)),Ha: fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),Ea: exp(list(char)),Vsa1: list(val),Tsa: list(ty),Vsa: list(list(char))] :
      ( ( size_size(list(list(char)),Vsa) = size_size(list(ty),Tsa) )
     => ( ( size_size(list(val),Vsa1) = size_size(list(ty),Tsa) )
       => ( distinct(list(char),Vsa)
         => ( member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),Ea,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,map_upds(list(char),val,L,Vsa,Vsa1))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),E,product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,L1))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa)))
           => member(product_prod(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))))),product_Pair(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Vsa,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),Vsa1,Ea)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),Ha,L)),product_Pair(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val))),blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),Vsa,product_Pair(list(ty),product_prod(list(val),exp(list(char))),Tsa,product_Pair(list(val),exp(list(char)),aa(list(list(char)),list(val),map(list(char),val,comp(option(val),val,list(char),the(val),L1)),Vsa),E)))),product_Pair(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)),H,override_on(list(char),option(val),L1,L,set(list(char),Vsa))))),transitive_rtrancl(product_prod(exp(list(char)),product_prod(fun(nat,option(product_prod(list(char),fun(product_prod(list(char),list(char)),option(val))))),fun(list(char),option(val)))),red(Pa))) ) ) ) ) ).

tff(fact_94_map__add__assoc,axiom,
    ! [B: $tType,A: $tType,M3: fun(A,option(B)),M2: fun(A,option(B)),M1: fun(A,option(B))] : ( map_add(A,B,M1,map_add(A,B,M2,M3)) = map_add(A,B,map_add(A,B,M1,M2),M3) ) ).

tff(fact_95_map__map,axiom,
    ! [B: $tType,A: $tType,C: $tType,Xs: list(C),G: fun(C,B),F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),aa(list(C),list(B),map(C,B,G),Xs)) = aa(list(C),list(A),map(C,A,comp(B,A,C,F,G)),Xs) ) ).

tff(fact_96_map__comp__map,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(A,C),F: fun(C,B)] : ( comp(list(C),list(B),list(A),map(C,B,F),map(A,C,G)) = map(A,B,comp(C,B,A,F,G)) ) ).

tff(fact_97_List_Omap_Ocompositionality,axiom,
    ! [B: $tType,A: $tType,C: $tType,List: list(C),G: fun(C,B),F: fun(B,A)] : ( aa(list(B),list(A),map(B,A,F),aa(list(C),list(B),map(C,B,G),List)) = aa(list(C),list(A),map(C,A,comp(B,A,C,F,G)),List) ) ).

tff(fact_98_List_Omap_Ocomp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: fun(A,C),F: fun(C,B)] : ( comp(list(C),list(B),list(A),map(C,B,F),map(A,C,G)) = map(A,B,comp(C,B,A,F,G)) ) ).

tff(fact_99_the_Osimps,axiom,
    ! [A: $tType,X: A] : ( aa(option(A),A,the(A),aa(A,option(A),some(A),X)) = X ) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    size_size(list(list(char)),vs1) = size_size(list(ty),ts) ).

tff(conj_1,hypothesis,
    size_size(list(val),vs) = size_size(list(ty),ts) ).

tff(conj_2,conjecture,
    ( wTrt(p,h,e1,blocks(product_Pair(list(list(char)),product_prod(list(ty),product_prod(list(val),exp(list(char)))),vs1,product_Pair(list(ty),product_prod(list(val),exp(list(char))),ts,product_Pair(list(val),exp(list(char)),vs,e)))),t)
  <=> ( wTrt(p,h,map_upds(list(char),ty,e1,vs1,ts),e,t)
      & ? [Ts: list(ty)] :
          ( ( aa(list(val),list(option(ty)),map(val,option(ty),typeof_h(h)),vs) = aa(list(ty),list(option(ty)),map(ty,option(ty),some(ty)),Ts) )
          & list_all2(ty,ty,widen(product_prod(list(list(char)),exp(list(char))),p),Ts,ts) ) ) ) ).

%------------------------------------------------------------------------------
