%------------------------------------------------------------------------------
% File     : SWW471_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 269
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_269 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  184 (  47 unt;  51 typ;   0 def)
%            Number of atoms       :  277 ( 105 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  188 (  44   ~;  23   |;  18   &)
%                                         (  26 <=>;  77  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   37 (  21   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   35 (  35 usr;  13 con; 0-5 aty)
%            Number of variables   :  482 ( 438   !;   7   ?; 482   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:37
%------------------------------------------------------------------------------
%----Should-be-implicit typings (9)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Opname,type,
    pname: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Option_Ooption,type,
    option: $tType > $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Com_Obody,type,
    body1: fun(pname,option(com)) ).

tff(sy_c_Com_Ocom_OBODY,type,
    body: fun(pname,com) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__derivs,type,
    hoare_992312373derivs: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ohoare__valids,type,
    hoare_592965047valids: 
      !>[A: $tType] : ( ( fun(hoare_28830079triple(A),bool) * fun(hoare_28830079triple(A),bool) ) > $o ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),hoare_28830079triple(A)))) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T))) * hoare_28830079triple(A) ) > T ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T))) * hoare_28830079triple(A) ) > T ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple__valid,type,
    hoare_1633586161_valid: 
      !>[A: $tType] : ( ( nat * hoare_28830079triple(A) ) > $o ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Natural_Oevalc,type,
    evalc: ( com * state * state ) > $o ).

tff(sy_c_Option_Othe,type,
    the: 
      !>[A: $tType] : fun(option(A),A) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Predicate_OPowp,type,
    powp: 
      !>[A: $tType] : ( ( fun(A,bool) * fun(A,bool) ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_G,type,
    g: fun(hoare_28830079triple(a),bool) ).

tff(sy_v_P,type,
    p: fun(pname,fun(a,fun(state,bool))) ).

tff(sy_v_Procs,type,
    procs: fun(pname,bool) ).

tff(sy_v_Q,type,
    q: fun(pname,fun(a,fun(state,bool))) ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (99)
tff(fact_0_triple_Oinject,axiom,
    ! [B: $tType,Fun22: fun(B,fun(state,bool)),Com2: com,Fun12: fun(B,fun(state,bool)),Fun21: fun(B,fun(state,bool)),Com1: com,Fun11: fun(B,fun(state,bool))] :
      ( ( aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Fun11),Com1),Fun21) = aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Fun12),Com2),Fun22) )
    <=> ( ( Fun11 = Fun12 )
        & ( Com1 = Com2 )
        & ( Fun21 = Fun22 ) ) ) ).

tff(fact_1_com_Osimps_I6_J,axiom,
    ! [Pname1: pname,Pname: pname] :
      ( ( aa(pname,com,body,Pname) = aa(pname,com,body,Pname1) )
    <=> ( Pname = Pname1 ) ) ).

tff(fact_2_hoare__valids__def,axiom,
    ! [B: $tType,Ts: fun(hoare_28830079triple(B),bool),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_592965047valids(B,Ga,Ts)
    <=> ! [N3: nat] :
          ( ! [X4: hoare_28830079triple(B)] :
              ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X4),Ga))
             => hoare_1633586161_valid(B,N3,X4) )
         => ! [X4: hoare_28830079triple(B)] :
              ( pp(aa(fun(hoare_28830079triple(B),bool),bool,aa(hoare_28830079triple(B),fun(fun(hoare_28830079triple(B),bool),bool),member(hoare_28830079triple(B)),X4),Ts))
             => hoare_1633586161_valid(B,N3,X4) ) ) ) ).

tff(fact_3_hoare__derivs_OBody,axiom,
    ! [B: $tType,Procsa: fun(pname,bool),Qa: fun(pname,fun(B,fun(state,bool))),Pa: fun(pname,fun(B,fun(state,bool))),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,sup_sup(fun(hoare_28830079triple(B),bool),Ga,image(pname,hoare_28830079triple(B),combs(pname,fun(B,fun(state,bool)),hoare_28830079triple(B),combs(pname,com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),combb(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),pname,hoare_1841697145triple(B),Pa),body),Qa),Procsa)),image(pname,hoare_28830079triple(B),combs(pname,fun(B,fun(state,bool)),hoare_28830079triple(B),combs(pname,com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),combb(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),pname,hoare_1841697145triple(B),Pa),combb(option(com),com,pname,the(com),body1)),Qa),Procsa))
     => hoare_992312373derivs(B,Ga,image(pname,hoare_28830079triple(B),combs(pname,fun(B,fun(state,bool)),hoare_28830079triple(B),combs(pname,com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),combb(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),pname,hoare_1841697145triple(B),Pa),body),Qa),Procsa)) ) ).

tff(fact_4_Un__iff,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),sup_sup(fun(B,bool),A2,B2)))
    <=> ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),A2))
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),B2)) ) ) ).

tff(fact_5_UnE,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),sup_sup(fun(B,bool),A2,B2)))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),A2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),B2)) ) ) ).

tff(fact_6_sup1E,axiom,
    ! [B: $tType,X3: B,B2: fun(B,bool),A2: fun(B,bool)] :
      ( pp(aa(B,bool,sup_sup(fun(B,bool),A2,B2),X3))
     => ( ~ pp(aa(B,bool,A2,X3))
       => pp(aa(B,bool,B2,X3)) ) ) ).

tff(fact_7_sup1CI,axiom,
    ! [B: $tType,A2: fun(B,bool),X3: B,B2: fun(B,bool)] :
      ( ( ~ pp(aa(B,bool,B2,X3))
       => pp(aa(B,bool,A2,X3)) )
     => pp(aa(B,bool,sup_sup(fun(B,bool),A2,B2),X3)) ) ).

tff(fact_8_UnCI,axiom,
    ! [B: $tType,A2: fun(B,bool),B2: fun(B,bool),C2: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),B2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),A2)) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),sup_sup(fun(B,bool),A2,B2))) ) ).

tff(fact_9_image__eqI,axiom,
    ! [B: $tType,C: $tType,A2: fun(C,bool),X3: C,F: fun(C,B),B1: B] :
      ( ( B1 = aa(C,B,F,X3) )
     => ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X3),A2))
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),image(C,B,F,A2))) ) ) ).

tff(fact_10_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B3: A,A3: A] : ( sup_sup(A,A3,sup_sup(A,A3,B3)) = sup_sup(A,A3,B3) ) ) ).

tff(fact_11_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y)) = sup_sup(A,X2,Y) ) ) ).

tff(fact_12_triple_Orecs,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com1: com,Fun11: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_678420151le_rec(C,B,F1,aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Fun11),Com1),Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F1,Fun11),Com1),Fun21) ) ).

tff(fact_13_cut,axiom,
    ! [B: $tType,Ga: fun(hoare_28830079triple(B),bool),Ts: fun(hoare_28830079triple(B),bool),G1: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,G1,Ts)
     => ( hoare_992312373derivs(B,Ga,G1)
       => hoare_992312373derivs(B,Ga,Ts) ) ) ).

tff(fact_14_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z1: A,Y: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y),Z1) = sup_sup(A,X2,sup_sup(A,Y,Z1)) ) ) ).

tff(fact_15_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z1: A,Y: A,X2: A] : ( sup_sup(A,sup_sup(A,X2,Y),Z1) = sup_sup(A,X2,sup_sup(A,Y,Z1)) ) ) ).

tff(fact_16_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C4: A,B3: A,A3: A] : ( sup_sup(A,sup_sup(A,A3,B3),C4) = sup_sup(A,A3,sup_sup(A,B3,C4)) ) ) ).

tff(fact_17_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z1: A,Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y,Z1)) = sup_sup(A,Y,sup_sup(A,X2,Z1)) ) ) ).

tff(fact_18_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z1: A,Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,Y,Z1)) = sup_sup(A,Y,sup_sup(A,X2,Z1)) ) ) ).

tff(fact_19_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C4: A,A3: A,B3: A] : ( sup_sup(A,B3,sup_sup(A,A3,C4)) = sup_sup(A,A3,sup_sup(A,B3,C4)) ) ) ).

tff(fact_20_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,sup_sup(A,X2,Y)) = sup_sup(A,X2,Y) ) ) ).

tff(fact_21_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,Y) = sup_sup(A,Y,X2) ) ) ).

tff(fact_22_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X2: A] : ( sup_sup(A,X2,Y) = sup_sup(A,Y,X2) ) ) ).

tff(fact_23_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B3: A,A3: A] : ( sup_sup(A,A3,B3) = sup_sup(A,B3,A3) ) ) ).

tff(fact_24_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X2: A] : ( sup_sup(A,X2,X2) = X2 ) ) ).

tff(fact_25_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A3: A] : ( sup_sup(A,A3,A3) = A3 ) ) ).

tff(fact_26_rev__image__eqI,axiom,
    ! [C: $tType,B: $tType,F: fun(B,C),B1: C,A2: fun(B,bool),X3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A2))
     => ( ( B1 = aa(B,C,F,X3) )
       => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),B1),image(B,C,F,A2))) ) ) ).

tff(fact_27_imageI,axiom,
    ! [C: $tType,B: $tType,F: fun(B,C),A2: fun(B,bool),X3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A2))
     => pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),aa(B,C,F,X3)),image(B,C,F,A2))) ) ).

tff(fact_28_image__iff,axiom,
    ! [B: $tType,C: $tType,A2: fun(C,bool),F: fun(C,B),Z: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Z),image(C,B,F,A2)))
    <=> ? [X4: C] :
          ( pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X4),A2))
          & ( Z = aa(C,B,F,X4) ) ) ) ).

tff(fact_29_UnI2,axiom,
    ! [B: $tType,A2: fun(B,bool),B2: fun(B,bool),C2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),B2))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),sup_sup(fun(B,bool),A2,B2))) ) ).

tff(fact_30_UnI1,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),C2: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),A2))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),sup_sup(fun(B,bool),A2,B2))) ) ).

tff(fact_31_sup1I2,axiom,
    ! [B: $tType,A2: fun(B,bool),X3: B,B2: fun(B,bool)] :
      ( pp(aa(B,bool,B2,X3))
     => pp(aa(B,bool,sup_sup(fun(B,bool),A2,B2),X3)) ) ).

tff(fact_32_sup1I1,axiom,
    ! [B: $tType,B2: fun(B,bool),X3: B,A2: fun(B,bool)] :
      ( pp(aa(B,bool,A2,X3))
     => pp(aa(B,bool,sup_sup(fun(B,bool),A2,B2),X3)) ) ).

tff(fact_33_ball__Un,axiom,
    ! [B: $tType,Pa: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] :
      ( ! [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),sup_sup(fun(B,bool),A2,B2)))
         => pp(aa(B,bool,Pa,X4)) )
    <=> ( ! [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A2))
           => pp(aa(B,bool,Pa,X4)) )
        & ! [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),B2))
           => pp(aa(B,bool,Pa,X4)) ) ) ) ).

tff(fact_34_bex__Un,axiom,
    ! [B: $tType,Pa: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] :
      ( ? [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),sup_sup(fun(B,bool),A2,B2)))
          & pp(aa(B,bool,Pa,X4)) )
    <=> ( ? [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A2))
            & pp(aa(B,bool,Pa,X4)) )
        | ? [X4: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),B2))
            & pp(aa(B,bool,Pa,X4)) ) ) ) ).

tff(fact_35_Un__assoc,axiom,
    ! [B: $tType,C3: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] : ( sup_sup(fun(B,bool),sup_sup(fun(B,bool),A2,B2),C3) = sup_sup(fun(B,bool),A2,sup_sup(fun(B,bool),B2,C3)) ) ).

tff(fact_36_Un__left__commute,axiom,
    ! [B: $tType,C3: fun(B,bool),B2: fun(B,bool),A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,sup_sup(fun(B,bool),B2,C3)) = sup_sup(fun(B,bool),B2,sup_sup(fun(B,bool),A2,C3)) ) ).

tff(fact_37_Un__left__absorb,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,sup_sup(fun(B,bool),A2,B2)) = sup_sup(fun(B,bool),A2,B2) ) ).

tff(fact_38_Un__commute,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,B2) = sup_sup(fun(B,bool),B2,A2) ) ).

tff(fact_39_Un__def,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,B2) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,fun(B,bool),bool,member(B),A2)),combc(B,fun(B,bool),bool,member(B),B2))) ) ).

tff(fact_40_Un__absorb,axiom,
    ! [B: $tType,A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,A2) = A2 ) ).

tff(fact_41_image__ident,axiom,
    ! [B: $tType,Y2: fun(B,bool)] : ( image(B,B,combi(B),Y2) = Y2 ) ).

tff(fact_42_image__image,axiom,
    ! [C: $tType,B: $tType,D1: $tType,A2: fun(D1,bool),G: fun(D1,C),F: fun(C,B)] : ( image(C,B,F,image(D1,C,G,A2)) = image(D1,B,combb(C,B,D1,F,G),A2) ) ).

tff(fact_43_sup__Un__eq,axiom,
    ! [B: $tType,S2: fun(B,bool),R1: fun(B,bool),X1: B] :
      ( pp(aa(B,bool,sup_sup(fun(B,bool),combc(B,fun(B,bool),bool,member(B),R1),combc(B,fun(B,bool),bool,member(B),S2)),X1))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),sup_sup(fun(B,bool),R1,S2))) ) ).

tff(fact_44_Collect__disj__eq,axiom,
    ! [B: $tType,Qa: fun(B,bool),Pa: fun(B,bool)] : ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,Pa),Qa)) = sup_sup(fun(B,bool),collect(B,Pa),collect(B,Qa)) ) ).

tff(fact_45_sup__apply,axiom,
    ! [B: $tType,C: $tType] :
      ( lattice(B)
     => ! [X3: C,G: fun(C,B),F: fun(C,B)] : ( aa(C,B,sup_sup(fun(C,B),F,G),X3) = sup_sup(B,aa(C,B,F,X3),aa(C,B,G,X3)) ) ) ).

tff(fact_46_sup__fun__def,axiom,
    ! [C: $tType,B: $tType] :
      ( lattice(C)
     => ! [G: fun(B,C),F: fun(B,C),X1: B] : ( aa(B,C,sup_sup(fun(B,C),F,G),X1) = sup_sup(C,aa(B,C,F,X1),aa(B,C,G,X1)) ) ) ).

tff(fact_47_image__Un,axiom,
    ! [B: $tType,C: $tType,B2: fun(C,bool),A2: fun(C,bool),F: fun(C,B)] : ( image(C,B,F,sup_sup(fun(C,bool),A2,B2)) = sup_sup(fun(B,bool),image(C,B,F,A2),image(C,B,F,B2)) ) ).

tff(fact_48_imageE,axiom,
    ! [B: $tType,C: $tType,A2: fun(C,bool),F: fun(C,B),B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),image(C,B,F,A2)))
     => ~ ! [X: C] :
            ( ( B1 = aa(C,B,F,X) )
           => ~ pp(aa(fun(C,bool),bool,aa(C,fun(fun(C,bool),bool),member(C),X),A2)) ) ) ).

tff(fact_49_triple_Osimps_I2_J,axiom,
    ! [B: $tType,C: $tType,Fun21: fun(C,fun(state,bool)),Com1: com,Fun11: fun(C,fun(state,bool)),F1: fun(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)))] : ( hoare_376461865e_case(C,B,F1,aa(fun(C,fun(state,bool)),hoare_28830079triple(C),aa(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C)),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),hoare_28830079triple(C))),hoare_1841697145triple(C),Fun11),Com1),Fun21)) = aa(fun(C,fun(state,bool)),B,aa(com,fun(fun(C,fun(state,bool)),B),aa(fun(C,fun(state,bool)),fun(com,fun(fun(C,fun(state,bool)),B)),F1,Fun11),Com1),Fun21) ) ).

tff(fact_50_Body__triple__valid__Suc,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pn1: pname,Pa: fun(B,fun(state,bool)),N2: nat] :
      ( hoare_1633586161_valid(B,N2,aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Pa),aa(option(com),com,the(com),aa(pname,option(com),body1,Pn1))),Qa))
    <=> hoare_1633586161_valid(B,suc(N2),aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Pa),aa(pname,com,body,Pn1)),Qa)) ) ).

tff(fact_51_triple_Oexhaust,axiom,
    ! [B: $tType,Y1: hoare_28830079triple(B)] :
      ~ ! [Fun1: fun(B,fun(state,bool)),Com: com,Fun2: fun(B,fun(state,bool))] : ( Y1 != aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Fun1),Com),Fun2) ) ).

tff(fact_52_Body1,axiom,
    ! [B: $tType,Pn1: pname,Procsa: fun(pname,bool),Qa: fun(pname,fun(B,fun(state,bool))),Pa: fun(pname,fun(B,fun(state,bool))),Ga: fun(hoare_28830079triple(B),bool)] :
      ( hoare_992312373derivs(B,sup_sup(fun(hoare_28830079triple(B),bool),Ga,image(pname,hoare_28830079triple(B),combs(pname,fun(B,fun(state,bool)),hoare_28830079triple(B),combs(pname,com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),combb(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),pname,hoare_1841697145triple(B),Pa),body),Qa),Procsa)),image(pname,hoare_28830079triple(B),combs(pname,fun(B,fun(state,bool)),hoare_28830079triple(B),combs(pname,com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),combb(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),pname,hoare_1841697145triple(B),Pa),combb(option(com),com,pname,the(com),body1)),Qa),Procsa))
     => ( pp(aa(fun(pname,bool),bool,aa(pname,fun(fun(pname,bool),bool),member(pname),Pn1),Procsa))
       => hoare_992312373derivs(B,Ga,insert(hoare_28830079triple(B),aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),aa(pname,fun(B,fun(state,bool)),Pa,Pn1)),aa(pname,com,body,Pn1)),aa(pname,fun(B,fun(state,bool)),Qa,Pn1)),bot_bot(fun(hoare_28830079triple(B),bool)))) ) ) ).

tff(fact_53_image__cong,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C),N1: fun(B,bool),M: fun(B,bool)] :
      ( ( M = N1 )
     => ( ! [X: B] :
            ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X),N1))
           => ( aa(B,C,F,X) = aa(B,C,G,X) ) )
       => ( image(B,C,F,M) = image(B,C,G,N1) ) ) ) ).

tff(fact_54_Powp__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X1: fun(B,bool)] :
      ( powp(B,A2,X1)
    <=> ! [Xa1: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),Xa1),X1))
         => pp(aa(B,bool,A2,Xa1)) ) ) ).

tff(fact_55_Body__triple__valid__0,axiom,
    ! [B: $tType,Qa: fun(B,fun(state,bool)),Pn1: pname,Pa: fun(B,fun(state,bool))] : hoare_1633586161_valid(B,zero_zero(nat),aa(fun(B,fun(state,bool)),hoare_28830079triple(B),aa(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B)),aa(fun(B,fun(state,bool)),fun(com,fun(fun(B,fun(state,bool)),hoare_28830079triple(B))),hoare_1841697145triple(B),Pa),aa(pname,com,body,Pn1)),Qa)) ).

tff(fact_56_evalc_OBody,axiom,
    ! [S1: state,S0: state,Pn: pname] :
      ( evalc(aa(option(com),com,the(com),aa(pname,option(com),body1,Pn)),S0,S1)
     => evalc(aa(pname,com,body,Pn),S0,S1) ) ).

tff(fact_57_all__not__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ! [X4: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A2))
    <=> ( A2 = bot_bot(fun(B,bool)) ) ) ).

tff(fact_58_empty__Collect__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( bot_bot(fun(B,bool)) = collect(B,Pa) )
    <=> ! [X4: B] : ~ pp(aa(B,bool,Pa,X4)) ) ).

tff(fact_59_empty__iff,axiom,
    ! [B: $tType,C2: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),C2),bot_bot(fun(B,bool)))) ).

tff(fact_60_Collect__empty__eq,axiom,
    ! [B: $tType,Pa: fun(B,bool)] :
      ( ( collect(B,Pa) = bot_bot(fun(B,bool)) )
    <=> ! [X4: B] : ~ pp(aa(B,bool,Pa,X4)) ) ).

tff(fact_61_emptyE,axiom,
    ! [B: $tType,A1: B] : ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),bot_bot(fun(B,bool)))) ).

tff(fact_62_insert__absorb2,axiom,
    ! [B: $tType,A2: fun(B,bool),X3: B] : ( insert(B,X3,insert(B,X3,A2)) = insert(B,X3,A2) ) ).

tff(fact_63_insert__iff,axiom,
    ! [B: $tType,A2: fun(B,bool),B1: B,A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B1,A2)))
    <=> ( ( A1 = B1 )
        | pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A2)) ) ) ).

tff(fact_64_insertE,axiom,
    ! [B: $tType,A2: fun(B,bool),B1: B,A1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B1,A2)))
     => ( ( A1 != B1 )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A2)) ) ) ).

tff(fact_65_insertCI,axiom,
    ! [B: $tType,B1: B,B2: fun(B,bool),A1: B] :
      ( ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),B2))
       => ( A1 = B1 ) )
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,B1,B2))) ) ).

tff(fact_66_sup__eq__bot__iff,axiom,
    ! [B: $tType] :
      ( bounded_lattice_bot(B)
     => ! [Y1: B,X3: B] :
          ( ( sup_sup(B,X3,Y1) = bot_bot(B) )
        <=> ( ( X3 = bot_bot(B) )
            & ( Y1 = bot_bot(B) ) ) ) ) ).

tff(fact_67_empty__is__image,axiom,
    ! [B: $tType,C: $tType,A2: fun(C,bool),F: fun(C,B)] :
      ( ( bot_bot(fun(B,bool)) = image(C,B,F,A2) )
    <=> ( A2 = bot_bot(fun(C,bool)) ) ) ).

tff(fact_68_image__empty,axiom,
    ! [C: $tType,B: $tType,F: fun(C,B)] : ( image(C,B,F,bot_bot(fun(C,bool))) = bot_bot(fun(B,bool)) ) ).

tff(fact_69_image__is__empty,axiom,
    ! [B: $tType,C: $tType,A2: fun(C,bool),F: fun(C,B)] :
      ( ( image(C,B,F,A2) = bot_bot(fun(B,bool)) )
    <=> ( A2 = bot_bot(fun(C,bool)) ) ) ).

tff(fact_70_ball__empty,axiom,
    ! [B: $tType,Pa: fun(B,bool),X1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),bot_bot(fun(B,bool))))
     => pp(aa(B,bool,Pa,X1)) ) ).

tff(fact_71_Un__empty,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool)] :
      ( ( sup_sup(fun(B,bool),A2,B2) = bot_bot(fun(B,bool)) )
    <=> ( ( A2 = bot_bot(fun(B,bool)) )
        & ( B2 = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_72_image__insert,axiom,
    ! [B: $tType,C: $tType,B2: fun(C,bool),A1: C,F: fun(C,B)] : ( image(C,B,F,insert(C,A1,B2)) = insert(B,aa(C,B,F,A1),image(C,B,F,B2)) ) ).

tff(fact_73_Un__insert__right,axiom,
    ! [B: $tType,B2: fun(B,bool),A1: B,A2: fun(B,bool)] : ( sup_sup(fun(B,bool),A2,insert(B,A1,B2)) = insert(B,A1,sup_sup(fun(B,bool),A2,B2)) ) ).

tff(fact_74_ext,axiom,
    ! [C: $tType,B: $tType,G: fun(B,C),F: fun(B,C)] :
      ( ! [X: B] : ( aa(B,C,F,X) = aa(B,C,G,X) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [B: $tType,A2: fun(B,bool),X3: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A2))
    <=> pp(aa(B,bool,A2,X3)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [B: $tType,Pa: fun(B,bool)] : ( collect(B,Pa) = Pa ) ).

tff(fact_77_Un__insert__left,axiom,
    ! [B: $tType,C3: fun(B,bool),B2: fun(B,bool),A1: B] : ( sup_sup(fun(B,bool),insert(B,A1,B2),C3) = insert(B,A1,sup_sup(fun(B,bool),B2,C3)) ) ).

tff(fact_78_singleton__conv2,axiom,
    ! [B: $tType,A1: B] : ( collect(B,aa(B,fun(B,bool),fequal(B),A1)) = insert(B,A1,bot_bot(fun(B,bool))) ) ).

tff(fact_79_singleton__conv,axiom,
    ! [B: $tType,A1: B] : ( collect(B,combc(B,B,bool,fequal(B),A1)) = insert(B,A1,bot_bot(fun(B,bool))) ) ).

tff(fact_80_evalc__elim__cases_I6_J,axiom,
    ! [S1: state,S: state,P: pname] :
      ( evalc(aa(pname,com,body,P),S,S1)
     => evalc(aa(option(com),com,the(com),aa(pname,option(com),body1,P)),S,S1) ) ).

tff(fact_81_empty__not__insert,axiom,
    ! [B: $tType,A2: fun(B,bool),A1: B] : ( bot_bot(fun(B,bool)) != insert(B,A1,A2) ) ).

tff(fact_82_insert__not__empty,axiom,
    ! [B: $tType,A2: fun(B,bool),A1: B] : ( insert(B,A1,A2) != bot_bot(fun(B,bool)) ) ).

tff(fact_83_bot__empty__eq,axiom,
    ! [B: $tType,X1: B] :
      ( pp(aa(B,bool,bot_bot(fun(B,bool)),X1))
    <=> pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X1),bot_bot(fun(B,bool)))) ) ).

tff(fact_84_empty__def,axiom,
    ! [B: $tType] : ( bot_bot(fun(B,bool)) = collect(B,combk(bool,B,fFalse)) ) ).

tff(fact_85_insertI1,axiom,
    ! [B: $tType,B2: fun(B,bool),A1: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),insert(B,A1,B2))) ).

tff(fact_86_ex__in__conv,axiom,
    ! [B: $tType,A2: fun(B,bool)] :
      ( ? [X4: B] : pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A2))
    <=> ( A2 != bot_bot(fun(B,bool)) ) ) ).

tff(fact_87_Collect__conv__if2,axiom,
    ! [B: $tType,A1: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A1))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A1)),Pa)) = insert(B,A1,bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A1))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,aa(B,fun(B,bool),fequal(B),A1)),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_88_Collect__conv__if,axiom,
    ! [B: $tType,A1: B,Pa: fun(B,bool)] :
      ( ( pp(aa(B,bool,Pa,A1))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A1)),Pa)) = insert(B,A1,bot_bot(fun(B,bool))) ) )
      & ( ~ pp(aa(B,bool,Pa,A1))
       => ( collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fconj,combc(B,B,bool,fequal(B),A1)),Pa)) = bot_bot(fun(B,bool)) ) ) ) ).

tff(fact_89_insert__compr,axiom,
    ! [B: $tType,B2: fun(B,bool),A1: B] : ( insert(B,A1,B2) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),A1)),combc(B,fun(B,bool),bool,member(B),B2))) ) ).

tff(fact_90_insert__is__Un,axiom,
    ! [B: $tType,A2: fun(B,bool),A1: B] : ( insert(B,A1,A2) = sup_sup(fun(B,bool),insert(B,A1,bot_bot(fun(B,bool))),A2) ) ).

tff(fact_91_insert__Collect,axiom,
    ! [B: $tType,Pa: fun(B,bool),A1: B] : ( insert(B,A1,collect(B,Pa)) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fimplies,combb(bool,bool,B,fNot,combc(B,B,bool,fequal(B),A1))),Pa)) ) ).

tff(fact_92_singleton__iff,axiom,
    ! [B: $tType,A1: B,B1: B] :
      ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),insert(B,A1,bot_bot(fun(B,bool)))))
    <=> ( B1 = A1 ) ) ).

tff(fact_93_insert__commute,axiom,
    ! [B: $tType,A2: fun(B,bool),Y1: B,X3: B] : ( insert(B,X3,insert(B,Y1,A2)) = insert(B,Y1,insert(B,X3,A2)) ) ).

tff(fact_94_doubleton__eq__iff,axiom,
    ! [B: $tType,D: B,C2: B,B1: B,A1: B] :
      ( ( insert(B,A1,insert(B,B1,bot_bot(fun(B,bool)))) = insert(B,C2,insert(B,D,bot_bot(fun(B,bool)))) )
    <=> ( ( ( A1 = C2 )
          & ( B1 = D ) )
        | ( ( A1 = D )
          & ( B1 = C2 ) ) ) ) ).

tff(fact_95_insert__code,axiom,
    ! [B: $tType,X3: B,A2: fun(B,bool),Y1: B] :
      ( pp(aa(B,bool,insert(B,Y1,A2),X3))
    <=> ( ( Y1 = X3 )
        | pp(aa(B,bool,A2,X3)) ) ) ).

tff(fact_96_insert__compr__raw,axiom,
    ! [B: $tType,X1: B,Xa: fun(B,bool)] : ( insert(B,X1,Xa) = collect(B,combs(B,bool,bool,combb(bool,fun(bool,bool),B,fdisj,combc(B,B,bool,fequal(B),X1)),combc(B,fun(B,bool),bool,member(B),Xa))) ) ).

tff(fact_97_insert__ident,axiom,
    ! [B: $tType,B2: fun(B,bool),A2: fun(B,bool),X3: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),A2))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X3),B2))
       => ( ( insert(B,X3,A2) = insert(B,X3,B2) )
        <=> ( A2 = B2 ) ) ) ) ).

tff(fact_98_insert__eq__iff,axiom,
    ! [B: $tType,B2: fun(B,bool),B1: B,A2: fun(B,bool),A1: B] :
      ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),A2))
     => ( ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),B2))
       => ( ( insert(B,A1,A2) = insert(B,B1,B2) )
        <=> ( ( ( A1 = B1 )
             => ( A2 = B2 ) )
            & ( ( A1 != B1 )
             => ? [C1: fun(B,bool)] :
                  ( ( A2 = insert(B,B1,C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B1),C1))
                  & ( B2 = insert(B,A1,C1) )
                  & ~ pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),A1),C1)) ) ) ) ) ) ) ).

%----Arities (10)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_bot(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__bot,axiom,
    bounded_lattice_bot(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

%----Helper facts (22)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X2: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X2),Y))
      | ( X2 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X2: A] :
      ( ( X2 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X2),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [N: nat] :
      ( ! [X: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X),sup_sup(fun(hoare_28830079triple(a),bool),g,image(pname,hoare_28830079triple(a),combs(pname,fun(a,fun(state,bool)),hoare_28830079triple(a),combs(pname,com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a)),combb(fun(a,fun(state,bool)),fun(com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a))),pname,hoare_1841697145triple(a),p),body),q),procs))))
         => hoare_1633586161_valid(a,N,X) )
     => ! [X1: hoare_28830079triple(a)] :
          ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X1),image(pname,hoare_28830079triple(a),combs(pname,fun(a,fun(state,bool)),hoare_28830079triple(a),combs(pname,com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a)),combb(fun(a,fun(state,bool)),fun(com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a))),pname,hoare_1841697145triple(a),p),combb(option(com),com,pname,the(com),body1)),q),procs)))
         => hoare_1633586161_valid(a,N,X1) ) ) ).

tff(conj_1,conjecture,
    ( ? [X1: hoare_28830079triple(a)] :
        ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X1),g))
        & ~ hoare_1633586161_valid(a,n,X1) )
    | ! [X: hoare_28830079triple(a)] :
        ( pp(aa(fun(hoare_28830079triple(a),bool),bool,aa(hoare_28830079triple(a),fun(fun(hoare_28830079triple(a),bool),bool),member(hoare_28830079triple(a)),X),image(pname,hoare_28830079triple(a),combs(pname,fun(a,fun(state,bool)),hoare_28830079triple(a),combs(pname,com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a)),combb(fun(a,fun(state,bool)),fun(com,fun(fun(a,fun(state,bool)),hoare_28830079triple(a))),pname,hoare_1841697145triple(a),p),body),q),procs)))
       => hoare_1633586161_valid(a,n,X) ) ) ).

%------------------------------------------------------------------------------
