%------------------------------------------------------------------------------
% File     : SWW469_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Hoare's Logic with Procedures line 112
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : hoare_112 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.3.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  197 (  68 unt;  57 typ;   0 def)
%            Number of atoms       :  265 (  96 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  165 (  40   ~;   5   |;   7   &)
%                                         (  28 <=>;  85  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  :   41 (  25   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   3 prp; 0-5 aty)
%            Number of functors    :   29 (  29 usr;   2 con; 0-4 aty)
%            Number of variables   :  311 ( 268   !;   4   ?; 311   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (12)
tff(ty_tc_Com_Ocom,type,
    com: $tType ).

tff(ty_tc_Com_Ostate,type,
    state: $tType ).

tff(ty_tc_Datatype_Onode,type,
    node: ( $tType * $tType ) > $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Hoare__Mirabelle__vtrypsmcwp_Otriple,type,
    hoare_28830079triple: $tType > $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_String_Onibble,type,
    nibble: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_sum,type,
    sum_sum: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osemigroup,type,
    semigroup: 
      !>[A: $tType] : ( fun(A,fun(A,A)) > $o ) ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_HOL_Oinduct__false,type,
    induct_false: $o ).

tff(sy_c_HOL_Oinduct__true,type,
    induct_true: $o ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_OAbs__triple,type,
    hoare_689268419triple: 
      !>[A: $tType] : fun(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A)) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_ORep__triple,type,
    hoare_334633230triple: 
      !>[A: $tType] : fun(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Ostate__not__singleton,type,
    hoare_531836380gleton: $o ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple,type,
    hoare_1841697145triple: 
      !>[A: $tType] : ( ( fun(A,fun(state,bool)) * com * fun(A,fun(state,bool)) ) > hoare_28830079triple(A) ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__case,type,
    hoare_376461865e_case: 
      !>[A: $tType,T3: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T3))) * hoare_28830079triple(A) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rec,type,
    hoare_678420151le_rec: 
      !>[A: $tType,T3: $tType] : ( ( fun(fun(A,fun(state,bool)),fun(com,fun(fun(A,fun(state,bool)),T3))) * hoare_28830079triple(A) ) > T3 ) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__rep__set,type,
    hoare_711253694ep_set: 
      !>[A: $tType] : fun(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),bool) ).

tff(sy_c_Hoare__Mirabelle__vtrypsmcwp_Otriple_Otriple__size,type,
    hoare_47506394e_size: 
      !>[A: $tType] : ( ( fun(A,nat) * hoare_28830079triple(A) ) > nat ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_String_Ochar_OChar,type,
    char1: ( nibble * nibble ) > char ).

tff(sy_c_String_Ochar_Ochar__case,type,
    char_case: 
      !>[T3: $tType] : ( ( fun(nibble,fun(nibble,T3)) * char ) > T3 ) ).

tff(sy_c_String_Ochar_Ochar__rec,type,
    char_rec: 
      !>[T3: $tType] : ( ( fun(nibble,fun(nibble,T3)) * char ) > T3 ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char > nat ).

tff(sy_c_Typedef_Otype__definition,type,
    type_definition: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,A) * fun(A,B1) * fun(A,bool) ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

%----Relevant facts (98)
tff(fact_0_state__not__singleton__def,axiom,
    ( hoare_531836380gleton
  <=> ? [S2: state,T2: state] : ( S2 != T2 ) ) ).

tff(fact_1_equal__triple__def,axiom,
    ! [A: $tType,Y2: hoare_28830079triple(A),X1: hoare_28830079triple(A)] :
      ( pp(aa(hoare_28830079triple(A),bool,aa(hoare_28830079triple(A),fun(hoare_28830079triple(A),bool),equal_equal(hoare_28830079triple(A)),X1),Y2))
    <=> ( X1 = Y2 ) ) ).

tff(fact_2_Rep__triple__inject,axiom,
    ! [A: $tType,Y2: hoare_28830079triple(A),X1: hoare_28830079triple(A)] :
      ( ( aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),X1) = aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),Y2) )
    <=> ( X1 = Y2 ) ) ).

tff(fact_3_triple_Oinject,axiom,
    ! [A: $tType,Fun22: fun(A,fun(state,bool)),Com2: com,Fun12: fun(A,fun(state,bool)),Fun2: fun(A,fun(state,bool)),Com: com,Fun1: fun(A,fun(state,bool))] :
      ( ( hoare_1841697145triple(A,Fun1,Com,Fun2) = hoare_1841697145triple(A,Fun12,Com2,Fun22) )
    <=> ( ( Fun1 = Fun12 )
        & ( Com = Com2 )
        & ( Fun2 = Fun22 ) ) ) ).

tff(fact_4_triple_Orecs,axiom,
    ! [A: $tType,B1: $tType,Fun2: fun(B1,fun(state,bool)),Com: com,Fun1: fun(B1,fun(state,bool)),F1: fun(fun(B1,fun(state,bool)),fun(com,fun(fun(B1,fun(state,bool)),A)))] : ( hoare_678420151le_rec(B1,A,F1,hoare_1841697145triple(B1,Fun1,Com,Fun2)) = aa(fun(B1,fun(state,bool)),A,aa(com,fun(fun(B1,fun(state,bool)),A),aa(fun(B1,fun(state,bool)),fun(com,fun(fun(B1,fun(state,bool)),A)),F1,Fun1),Com),Fun2) ) ).

tff(fact_5_triple_Osimps_I2_J,axiom,
    ! [A: $tType,B1: $tType,Fun2: fun(B1,fun(state,bool)),Com: com,Fun1: fun(B1,fun(state,bool)),F1: fun(fun(B1,fun(state,bool)),fun(com,fun(fun(B1,fun(state,bool)),A)))] : ( hoare_376461865e_case(B1,A,F1,hoare_1841697145triple(B1,Fun1,Com,Fun2)) = aa(fun(B1,fun(state,bool)),A,aa(com,fun(fun(B1,fun(state,bool)),A),aa(fun(B1,fun(state,bool)),fun(com,fun(fun(B1,fun(state,bool)),A)),F1,Fun1),Com),Fun2) ) ).

tff(fact_6_triple_Oexhaust,axiom,
    ! [A: $tType,Y2: hoare_28830079triple(A)] :
      ~ ! [Fun11: fun(A,fun(state,bool)),Com1: com,Fun21: fun(A,fun(state,bool))] : ( Y2 != hoare_1841697145triple(A,Fun11,Com1,Fun21) ) ).

tff(fact_7_equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( equal_equal(A) = fequal(A) ) ) ).

tff(fact_8_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X),X)) ) ).

tff(fact_9_equal__eq,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [Y2: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X1),Y2))
        <=> ( X1 = Y2 ) ) ) ).

tff(fact_10_eq__equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( fequal(A) = equal_equal(A) ) ) ).

tff(fact_11_Rep__triple__inverse,axiom,
    ! [A: $tType,X1: hoare_28830079triple(A)] : ( aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),X1)) = X1 ) ).

tff(fact_12_Rep__triple,axiom,
    ! [A: $tType,X1: hoare_28830079triple(A)] : member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),X1),collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A))) ).

tff(fact_13_Rep__triple__induct,axiom,
    ! [A: $tType,P1: fun(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),bool),Y2: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
      ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y2,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
     => ( ! [X2: hoare_28830079triple(A)] : pp(aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),bool,P1,aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),X2)))
       => pp(aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),bool,P1,Y2)) ) ) ).

tff(fact_14_Rep__triple__cases,axiom,
    ! [A: $tType,Y2: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
      ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y2,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
     => ~ ! [X2: hoare_28830079triple(A)] : ( Y2 != aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),X2) ) ) ).

tff(fact_15_Abs__triple__inject,axiom,
    ! [A: $tType,Y2: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),X1: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
      ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),X1,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
     => ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y2,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
       => ( ( aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),X1) = aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),Y2) )
        <=> ( X1 = Y2 ) ) ) ) ).

tff(fact_16_Abs__triple__inverse,axiom,
    ! [A: $tType,Y2: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
      ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y2,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
     => ( aa(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),Y2)) = Y2 ) ) ).

tff(fact_17_Abs__triple__induct,axiom,
    ! [A: $tType,X1: hoare_28830079triple(A),P1: fun(hoare_28830079triple(A),bool)] :
      ( ! [Y1: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
          ( member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y1,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A)))
         => pp(aa(hoare_28830079triple(A),bool,P1,aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),Y1))) )
     => pp(aa(hoare_28830079triple(A),bool,P1,X1)) ) ).

tff(fact_18_Abs__triple__cases,axiom,
    ! [A: $tType,X1: hoare_28830079triple(A)] :
      ~ ! [Y1: fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool)] :
          ( ( X1 = aa(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_28830079triple(A),hoare_689268419triple(A),Y1) )
         => ~ member(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),Y1,collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A))) ) ).

tff(fact_19_type__definition__triple,axiom,
    ! [A: $tType] : type_definition(hoare_28830079triple(A),fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_334633230triple(A),hoare_689268419triple(A),collect(fun(node(sum_sum(com,fun(A,fun(state,bool))),sum_sum(state,A)),bool),hoare_711253694ep_set(A))) ).

tff(fact_20_induct__false__def,axiom,
    ~ induct_false ).

tff(fact_21_triple_Osize_I1_J,axiom,
    ! [A: $tType,Fun2: fun(A,fun(state,bool)),Com: com,Fun1: fun(A,fun(state,bool)),Fa: fun(A,nat)] : ( hoare_47506394e_size(A,Fa,hoare_1841697145triple(A,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_22_triple_Osize_I2_J,axiom,
    ! [A: $tType,Fun2: fun(A,fun(state,bool)),Com: com,Fun1: fun(A,fun(state,bool))] : ( size_size(hoare_28830079triple(A),hoare_1841697145triple(A,Fun1,Com,Fun2)) = zero_zero(nat) ) ).

tff(fact_23_induct__true__def,axiom,
    induct_true ).

tff(fact_24_induct__trueI,axiom,
    induct_true ).

tff(fact_25_type__definition_ORep,axiom,
    ! [A: $tType,B1: $tType,X1: A,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => member(B1,aa(A,B1,Rep,X1),A3) ) ).

tff(fact_26_type__definition_ORep__inverse,axiom,
    ! [B1: $tType,A: $tType,X1: A,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( aa(B1,A,Abs,aa(A,B1,Rep,X1)) = X1 ) ) ).

tff(fact_27_type__definition_ORep__inject,axiom,
    ! [B1: $tType,A: $tType,Y2: A,X1: A,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( ( aa(A,B1,Rep,X1) = aa(A,B1,Rep,Y2) )
      <=> ( X1 = Y2 ) ) ) ).

tff(fact_28_type__definition_OAbs__inverse,axiom,
    ! [A: $tType,B1: $tType,Y2: B1,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( member(B1,Y2,A3)
       => ( aa(A,B1,Rep,aa(B1,A,Abs,Y2)) = Y2 ) ) ) ).

tff(fact_29_type__definition_OAbs__inject,axiom,
    ! [A: $tType,B1: $tType,Y2: B1,X1: B1,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( member(B1,X1,A3)
       => ( member(B1,Y2,A3)
         => ( ( aa(B1,A,Abs,X1) = aa(B1,A,Abs,Y2) )
          <=> ( X1 = Y2 ) ) ) ) ) ).

tff(fact_30_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_31_type__definition_ORep__cases,axiom,
    ! [B1: $tType,A: $tType,Y2: B1,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( member(B1,Y2,A3)
       => ~ ! [X2: A] : ( Y2 != aa(A,B1,Rep,X2) ) ) ) ).

tff(fact_32_type__definition_ORep__induct,axiom,
    ! [A: $tType,B1: $tType,P1: fun(B1,bool),Y2: B1,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( member(B1,Y2,A3)
       => ( ! [X2: A] : pp(aa(B1,bool,P1,aa(A,B1,Rep,X2)))
         => pp(aa(B1,bool,P1,Y2)) ) ) ) ).

tff(fact_33_type__definition_OAbs__induct,axiom,
    ! [B1: $tType,A: $tType,X1: A,P1: fun(A,bool),A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ( ! [Y1: B1] :
            ( member(B1,Y1,A3)
           => pp(aa(A,bool,P1,aa(B1,A,Abs,Y1))) )
       => pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_34_type__definition_OAbs__cases,axiom,
    ! [A: $tType,B1: $tType,X1: A,A3: fun(B1,bool),Abs: fun(B1,A),Rep: fun(A,B1)] :
      ( type_definition(A,B1,Rep,Abs,A3)
     => ~ ! [Y1: B1] :
            ( ( X1 = aa(B1,A,Abs,Y1) )
           => ~ member(B1,Y1,A3) ) ) ).

tff(fact_35_char__size,axiom,
    ! [C1: char] : ( char_size(C1) = zero_zero(nat) ) ).

tff(fact_36_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_37_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_38_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_39_size__char,axiom,
    ! [C1: char] : ( size_size(char,C1) = zero_zero(nat) ) ).

tff(fact_40_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_41_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_42_size__literal__def,axiom,
    ! [S1: literal] : ( size_size(literal,S1) = zero_zero(nat) ) ).

tff(fact_43_size__bool,axiom,
    ! [B: bool] : ( size_size(bool,B) = zero_zero(nat) ) ).

tff(fact_44_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_45_char_Osize_I2_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( size_size(char,char1(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_46_char_Osize_I1_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( char_size(char1(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_47_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_48_char_Oinject,axiom,
    ! [Nibble22: nibble,Nibble12: nibble,Nibble2: nibble,Nibble1: nibble] :
      ( ( char1(Nibble1,Nibble2) = char1(Nibble12,Nibble22) )
    <=> ( ( Nibble1 = Nibble12 )
        & ( Nibble2 = Nibble22 ) ) ) ).

tff(fact_49_nat__size,axiom,
    ! [N1: nat] : ( size_size(nat,N1) = N1 ) ).

tff(fact_50_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ( sgn_sgn(A,sgn_sgn(A,A2)) = sgn_sgn(A,A2) ) ) ).

tff(fact_51_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_52_char_Oexhaust,axiom,
    ! [Y: char] :
      ~ ! [Nibble11: nibble,Nibble21: nibble] : ( Y != char1(Nibble11,Nibble21) ) ).

tff(fact_53_char_Osimps_I2_J,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_case(A,F1,char1(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_54_char_Orecs,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_rec(A,F1,char1(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_55_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,sgn_sgn(A,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_56_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,A1))
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_57_semigroup_Oassoc,axiom,
    ! [A: $tType,C: A,B: A,A1: A,F: fun(A,fun(A,A))] :
      ( semigroup(A,F)
     => ( aa(A,A,aa(A,fun(A,A),F,aa(A,A,aa(A,fun(A,A),F,A1),B)),C) = aa(A,A,aa(A,fun(A,A),F,A1),aa(A,A,aa(A,fun(A,A),F,B),C)) ) ) ).

tff(fact_58_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_59_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_60_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_61_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_62_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_63_nat__neq__iff,axiom,
    ! [N: nat,M1: nat] :
      ( ( M1 != N )
    <=> ( ord_less(nat,M1,N)
        | ord_less(nat,N,M1) ) ) ).

tff(fact_64_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_65_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_66_less__not__refl2,axiom,
    ! [M: nat,N1: nat] :
      ( ord_less(nat,N1,M)
     => ( M != N1 ) ) ).

tff(fact_67_less__not__refl3,axiom,
    ! [T1: nat,S1: nat] :
      ( ord_less(nat,S1,T1)
     => ( S1 != T1 ) ) ).

tff(fact_68_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N: nat,M1: nat] :
      ( ( ord_less(nat,M1,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M1)) )
     => ( ( ( M1 = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M1)) )
       => ( ( ord_less(nat,N,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M1)) ) ) ) ).

tff(fact_69_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_70_gr__implies__not0,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(nat,M,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_71_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_72_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N))
        <=> ord_less(nat,zero_zero(nat),N) ) ) ).

tff(fact_73_infinite__descent0,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( ord_less(nat,zero_zero(nat),N2)
           => ( ~ pp(aa(nat,bool,P1,N2))
             => ? [M2: nat] :
                  ( ord_less(nat,M2,N2)
                  & ~ pp(aa(nat,bool,P1,M2)) ) ) )
       => pp(aa(nat,bool,P1,N)) ) ) ).

tff(fact_74_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X2: A] : ( aa(A,B1,F,X2) = aa(A,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A3: fun(A,bool),X1: A] :
      ( member(A,X1,A3)
    <=> pp(aa(A,bool,A3,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_sgn__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( sgn_sgn(A,A2) = one_one(A) ) ) ) ).

tff(fact_78_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,N) )
        <=> ( M1 = N ) ) ) ).

tff(fact_79_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_80_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_81_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N))
        <=> ord_less(nat,M1,N) ) ) ).

tff(fact_82_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_83_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_84_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_85_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_86_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_87_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_88_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1))
         => ord_less(nat,M,N1) ) ) ).

tff(fact_89_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(nat,M,N1)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1)) ) ) ).

tff(fact_90_sgn__1__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = one_one(A) )
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_91_zero__less__int__conv,axiom,
    ! [N: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N))
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_92_sgn__1__neg,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = uminus_uminus(A,one_one(A)) )
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_93_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B: A,A1: A] :
          ( ( uminus_uminus(A,A1) = uminus_uminus(A,B) )
        <=> ( A1 = B ) ) ) ).

tff(fact_94_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( uminus_uminus(A,A1) = A1 )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_95_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] :
          ( ( uminus_uminus(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_96_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( A1 = uminus_uminus(A,A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_97_neg__0__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = uminus_uminus(A,A1) )
        <=> ( zero_zero(A) = A1 ) ) ) ).

%----Arities (32)
tff(arity_String_Onibble___Enum_Oenum,axiom,
    enum(nibble) ).

tff(arity_sum___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(sum_sum(T_1,T_2)) ) ).

tff(arity_String_Ochar___Enum_Oenum,axiom,
    enum(char) ).

tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_Com_Ocom___HOL_Oequal,axiom,
    cl_HOL_Oequal(com) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Int_Oint___HOL_Oequal,axiom,
    cl_HOL_Oequal(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Nat_Onat___HOL_Oequal,axiom,
    cl_HOL_Oequal(nat) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_Com_Ostate___HOL_Oequal,axiom,
    cl_HOL_Oequal(state) ).

tff(arity_String_Ochar___HOL_Oequal,axiom,
    cl_HOL_Oequal(char) ).

tff(arity_sum___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] : cl_HOL_Oequal(sum_sum(T_1,T_2)) ).

tff(arity_String_Onibble___HOL_Oequal,axiom,
    cl_HOL_Oequal(nibble) ).

tff(arity_String_Oliteral___HOL_Oequal,axiom,
    cl_HOL_Oequal(literal) ).

tff(arity_Hoare__Mirabelle__vtrypsmcwp_Otriple___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(hoare_28830079triple(T_1)) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    hoare_531836380gleton ).

tff(conj_1,conjecture,
    ! [T: state] :
    ? [S: state] : ( S != T ) ).

%------------------------------------------------------------------------------
