%------------------------------------------------------------------------------
% File     : SWW421-1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Software Verification
% Problem  : Verification Condition generated by Smallfoot
% Version  : Especial.
% English  : This is one of the verification conditions that were gathered
%            from the output of Smallfoot when checking assertions on list
%            manipulating programs from its own benchmark suite.

% Refs     : [BCO06] Berdine et al. (2006), Smallfoot: Modular Automatic As
%          : [RN11]  Rybalchenko & Navarro Perez (2011), Separation Logic +
%          : [Nav11] Navarro Perez (2011), Email to Geoff Sutcliffe
% Source   : [Nav11]
% Names    : smallfoot-vc71 [Nav11]

% Status   : Unsatisfiable
% Rating   : 0.05 v9.0.0, 0.10 v8.1.0, 0.00 v7.5.0, 0.05 v7.4.0, 0.06 v7.3.0, 0.08 v7.1.0, 0.00 v7.0.0, 0.07 v6.4.0, 0.00 v6.3.0, 0.09 v6.2.0, 0.10 v6.1.0, 0.14 v6.0.0, 0.00 v5.5.0, 0.15 v5.3.0, 0.11 v5.2.0
% Syntax   : Number of clauses     :   16 (   9 unt;   3 nHn;  14 RR)
%            Number of literals    :   26 (  11 equ;  13 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :    8 (   8 usr;   5 con; 0-2 aty)
%            Number of variables   :   38 (   9 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments :
%------------------------------------------------------------------------------
%----Include axioms for Lists in Separation Logic
include('Axioms/SWV013-0.ax').
%------------------------------------------------------------------------------
cnf(premise_1,hypothesis,
    nil != x1 ).

cnf(premise_2,hypothesis,
    x2 != x1 ).

cnf(premise_3,hypothesis,
    x1 != x3 ).

cnf(premise_4,hypothesis,
    heap(sep(lseg(x2,x3),sep(next(x1,x2),emp))) ).

cnf(conclusion_1,negated_conjecture,
    ~ heap(sep(lseg(x1,x3),emp)) ).

%------------------------------------------------------------------------------
