%------------------------------------------------------------------------------
% File     : SWW414-1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Software Verification
% Problem  : Verification Condition generated by Smallfoot
% Version  : Especial.
% English  : This is one of the verification conditions that were gathered
%            from the output of Smallfoot when checking assertions on list
%            manipulating programs from its own benchmark suite.

% Refs     : [BCO06] Berdine et al. (2006), Smallfoot: Modular Automatic As
%          : [RN11]  Rybalchenko & Navarro Perez (2011), Separation Logic +
%          : [Nav11] Navarro Perez (2011), Email to Geoff Sutcliffe
% Source   : [Nav11]
% Names    : smallfoot-vc49 [Nav11]

% Status   : Satisfiable
% Rating   : 0.50 v9.1.0, 0.56 v9.0.0, 0.50 v8.2.0, 0.70 v8.1.0, 0.62 v7.5.0, 0.67 v7.4.0, 0.64 v7.3.0, 0.67 v7.1.0, 0.62 v7.0.0, 0.57 v6.4.0, 0.29 v6.3.0, 0.38 v6.2.0, 0.50 v6.1.0, 0.56 v6.0.0, 0.57 v5.5.0, 0.62 v5.4.0, 0.80 v5.3.0, 0.78 v5.2.0
% Syntax   : Number of clauses     :   15 (   8 unt;   3 nHn;  13 RR)
%            Number of literals    :   25 (  10 equ;  12 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :    7 (   7 usr;   4 con; 0-2 aty)
%            Number of variables   :   38 (   9 sgn)
% SPC      : CNF_SAT_RFO_EQU_NUE

% Comments :
%------------------------------------------------------------------------------
%----Include axioms for Lists in Separation Logic
include('Axioms/SWV013-0.ax').
%------------------------------------------------------------------------------
cnf(premise_1,hypothesis,
    nil != x1 ).

cnf(premise_2,hypothesis,
    x1 != x2 ).

cnf(premise_3,hypothesis,
    heap(sep(lseg(x2,nil),sep(lseg(x1,nil),emp))) ).

cnf(conclusion_1,negated_conjecture,
    ~ heap(sep(lseg(x2,nil),emp)) ).

%------------------------------------------------------------------------------
