%------------------------------------------------------------------------------
% File     : SWW412-1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Software Verification
% Problem  : Verification Condition generated by Smallfoot
% Version  : Especial.
% English  : This is one of the verification conditions that were gathered
%            from the output of Smallfoot when checking assertions on list
%            manipulating programs from its own benchmark suite.

% Refs     : [BCO06] Berdine et al. (2006), Smallfoot: Modular Automatic As
%          : [RN11]  Rybalchenko & Navarro Perez (2011), Separation Logic +
%          : [Nav11] Navarro Perez (2011), Email to Geoff Sutcliffe
% Source   : [Nav11]
% Names    : smallfoot-vc44 [Nav11]

% Status   : Unsatisfiable
% Rating   : 0.18 v9.1.0, 0.25 v8.2.0, 0.24 v8.1.0, 0.26 v7.5.0, 0.32 v7.4.0, 0.41 v7.3.0, 0.25 v7.1.0, 0.17 v7.0.0, 0.27 v6.2.0, 0.30 v6.1.0, 0.29 v6.0.0, 0.30 v5.5.0, 0.45 v5.4.0, 0.40 v5.3.0, 0.44 v5.2.0
% Syntax   : Number of clauses     :   20 (  13 unt;   3 nHn;  18 RR)
%            Number of literals    :   30 (  15 equ;  17 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :    9 (   9 usr;   6 con; 0-2 aty)
%            Number of variables   :   38 (   9 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments :
%------------------------------------------------------------------------------
%----Include axioms for Lists in Separation Logic
include('Axioms/SWV013-0.ax').
%------------------------------------------------------------------------------
cnf(premise_1,hypothesis,
    nil != x1 ).

cnf(premise_2,hypothesis,
    nil != x2 ).

cnf(premise_3,hypothesis,
    x3 != x1 ).

cnf(premise_4,hypothesis,
    x3 != x2 ).

cnf(premise_5,hypothesis,
    x1 != x2 ).

cnf(premise_6,hypothesis,
    x1 != x4 ).

cnf(premise_7,hypothesis,
    x2 != x4 ).

cnf(premise_8,hypothesis,
    heap(sep(lseg(x3,nil),sep(lseg(x4,nil),sep(next(x1,x4),sep(next(x2,x3),emp))))) ).

cnf(conclusion_1,negated_conjecture,
    ~ heap(sep(lseg(x2,nil),sep(lseg(x1,nil),emp))) ).

%------------------------------------------------------------------------------
