%------------------------------------------------------------------------------
% File     : SWW406-1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Software Verification
% Problem  : Verification Condition generated by Smallfoot
% Version  : Especial.
% English  : This is one of the verification conditions that were gathered
%            from the output of Smallfoot when checking assertions on list
%            manipulating programs from its own benchmark suite.

% Refs     : [BCO06] Berdine et al. (2006), Smallfoot: Modular Automatic As
%          : [RN11]  Rybalchenko & Navarro Perez (2011), Separation Logic +
%          : [Nav11] Navarro Perez (2011), Email to Geoff Sutcliffe
% Source   : [Nav11]
% Names    : smallfoot-vc37 [Nav11]

% Status   : Satisfiable
% Rating   : 0.62 v9.1.0, 0.56 v9.0.0, 0.60 v8.2.0, 0.80 v8.1.0, 0.75 v7.5.0, 0.78 v7.4.0, 0.73 v7.3.0, 0.67 v7.1.0, 0.62 v7.0.0, 0.71 v6.4.0, 0.43 v6.3.0, 0.50 v6.2.0, 0.80 v6.1.0, 0.78 v6.0.0, 0.71 v5.5.0, 0.75 v5.4.0, 0.80 v5.3.0, 0.78 v5.2.0
% Syntax   : Number of clauses     :   18 (  11 unt;   3 nHn;  16 RR)
%            Number of literals    :   28 (  13 equ;  15 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :    9 (   9 usr;   6 con; 0-2 aty)
%            Number of variables   :   38 (   9 sgn)
% SPC      : CNF_SAT_RFO_EQU_NUE

% Comments :
%------------------------------------------------------------------------------
%----Include axioms for Lists in Separation Logic
include('Axioms/SWV013-0.ax').
%------------------------------------------------------------------------------
cnf(premise_1,hypothesis,
    nil != x1 ).

cnf(premise_2,hypothesis,
    nil != x2 ).

cnf(premise_3,hypothesis,
    nil != x3 ).

cnf(premise_4,hypothesis,
    x1 != x3 ).

cnf(premise_5,hypothesis,
    x2 != x3 ).

cnf(premise_6,hypothesis,
    heap(sep(lseg(x2,x1),sep(next(x3,x2),sep(next(x1,x3),emp)))) ).

cnf(conclusion_1,negated_conjecture,
    ~ heap(sep(next(x4,x3),sep(lseg(x2,x4),sep(next(x3,x2),emp)))) ).

%------------------------------------------------------------------------------
