%------------------------------------------------------------------------------
% File     : SWW402-1 : TPTP v9.2.0. Released v5.2.0.
% Domain   : Software Verification
% Problem  : Verification Condition generated by Smallfoot
% Version  : Especial.
% English  : This is one of the verification conditions that were gathered
%            from the output of Smallfoot when checking assertions on list
%            manipulating programs from its own benchmark suite.

% Refs     : [BCO06] Berdine et al. (2006), Smallfoot: Modular Automatic As
%          : [RN11]  Rybalchenko & Navarro Perez (2011), Separation Logic +
%          : [Nav11] Navarro Perez (2011), Email to Geoff Sutcliffe
% Source   : [Nav11]
% Names    : smallfoot-vc31 [Nav11]

% Status   : Satisfiable
% Rating   : 0.62 v9.1.0, 0.56 v9.0.0, 0.60 v8.2.0, 0.80 v8.1.0, 0.75 v7.5.0, 0.78 v7.4.0, 0.73 v7.3.0, 0.78 v7.1.0, 0.75 v7.0.0, 0.71 v6.4.0, 0.43 v6.3.0, 0.38 v6.2.0, 0.90 v6.1.0, 0.78 v6.0.0, 0.71 v5.5.0, 0.75 v5.4.0, 0.80 v5.3.0, 0.78 v5.2.0
% Syntax   : Number of clauses     :   23 (  15 unt;   3 nHn;  21 RR)
%            Number of literals    :   34 (  19 equ;  20 neg)
%            Maximal clause size   :    3 (   1 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :   12 (  12 usr;   9 con; 0-2 aty)
%            Number of variables   :   38 (   9 sgn)
% SPC      : CNF_SAT_RFO_EQU_NUE

% Comments :
%------------------------------------------------------------------------------
%----Include axioms for Lists in Separation Logic
include('Axioms/SWV013-0.ax').
%------------------------------------------------------------------------------
cnf(premise_1,hypothesis,
    nil != x1 ).

cnf(premise_2,hypothesis,
    nil != x2 ).

cnf(premise_3,hypothesis,
    nil != x3 ).

cnf(premise_4,hypothesis,
    nil != x4 ).

cnf(premise_5,hypothesis,
    nil != x5 ).

cnf(premise_6,hypothesis,
    nil != x6 ).

cnf(premise_7,hypothesis,
    x1 != x6 ).

cnf(premise_8,hypothesis,
    x2 != x6 ).

cnf(premise_9,hypothesis,
    x3 != x4 ).

cnf(premise_10,hypothesis,
    x3 != x5 ).

cnf(premise_11,hypothesis,
    heap(sep(next(x1,x6),sep(lseg(x2,x1),sep(next(x6,x2),emp)))) ).

cnf(conclusion_1,negated_conjecture,
    ( x7 = x6
    | ~ heap(sep(lseg(x7,x6),sep(next(x6,x7),emp))) ) ).

%------------------------------------------------------------------------------
