%------------------------------------------------------------------------------
% File     : SWV811_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 495
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_495 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  152 (  46 unt;  41 typ;   0 def)
%            Number of atoms       :  217 (  72 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  152 (  46   ~;  12   |;   9   &)
%                                         (  19 <=>;  66  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :   10 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   43 (  24   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   32 (  32 usr;  10 con; 0-5 aty)
%            Number of variables   :  329 ( 309   !;   3   ?; 329   :)
%                                         (  17  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:31:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_OGets,type,
    gets: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_OinitState,type,
    initState: agent > fun(msg,bool) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_OIssues,type,
    nS_Sha512322870Issues: ( agent * agent * msg * list(event) ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NB,type,
    nb: nat ).

%----Relevant facts (100)
tff(fact_0_spies__evs__rev,axiom,
    ! [Evsa: list(event)] : ( knows(spy,Evsa) = knows(spy,rev(event,Evsa)) ) ).

tff(fact_1_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),X2: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent,S: agent] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,X2))))),set(event,Evsa))
     => member(msg,X2,parts(knows(spy,Evsa))) ) ).

tff(fact_2_Spy__in__bad,axiom,
    member(agent,spy,bad) ).

tff(fact_3_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),X2: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X2),set(event,Evsa))
     => member(msg,X2,parts(knows(spy,Evsa))) ) ).

tff(fact_4_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X2: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X2),set(event,Evsa))
     => member(msg,X2,analz(knows(spy,Evsa))) ) ).

tff(fact_5_takeWhile_Osimps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( takeWhile(A,P1,nil(A)) = nil(A) ) ).

tff(fact_6_takeWhile__eq__all__conv,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool)] :
      ( ( takeWhile(A,P1,Xs) = Xs )
    <=> ! [X5: A] :
          ( member(A,X5,set(A,Xs))
         => pp(aa(A,bool,P1,X5)) ) ) ).

tff(fact_7_rev_Osimps_I1_J,axiom,
    ! [A: $tType] : ( rev(A,nil(A)) = nil(A) ) ).

tff(fact_8_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( nil(A) = rev(A,Xs) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_9_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( rev(A,Xs) = nil(A) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_10_set__rev,axiom,
    ! [A: $tType,Xs: list(A)] : ( set(A,rev(A,Xs)) = set(A,Xs) ) ).

tff(fact_11_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),parts(H))
     => ~ ( member(msg,X2,parts(H))
         => ~ member(msg,Y2,parts(H)) ) ) ).

tff(fact_12_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_13_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_14_analz_OInj,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( member(msg,X2,H)
     => member(msg,X2,analz(H)) ) ).

tff(fact_15_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_16_msg_Osimps_I6_J,axiom,
    ! [Msg24: msg,Msg14: msg,Msg23: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg23) = mPair(Msg14,Msg24) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg23 = Msg24 ) ) ) ).

tff(fact_17_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_18_parts_OInj,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( member(msg,X2,H)
     => member(msg,X2,parts(H)) ) ).

tff(fact_19_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_20_msg_Osimps_I7_J,axiom,
    ! [Msg3: msg,Nat3: nat,Msg2: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg2) = crypt(Nat3,Msg3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_21_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_22_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent,Agent12: agent,Msg2: msg,Agent21: agent,Agent11: agent] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_23_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = rev(A,Ys) )
    <=> ( Xs = Ys ) ) ).

tff(fact_24_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),analz(H))
     => ~ ( member(msg,X2,analz(H))
         => ~ member(msg,Y2,analz(H)) ) ) ).

tff(fact_25_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( ( member(msg,X2,analz(H))
        | member(msg,X2,parts(H)) )
    <=> member(msg,X2,parts(H)) ) ).

tff(fact_26_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( ( member(msg,X2,analz(H))
        & member(msg,X2,parts(H)) )
    <=> member(msg,X2,analz(H)) ) ).

tff(fact_27_analz__analzD,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( member(msg,X2,analz(analz(H)))
     => member(msg,X2,analz(H)) ) ).

tff(fact_28_parts__partsD,axiom,
    ! [H: fun(msg,bool),X2: msg] :
      ( member(msg,X2,parts(parts(H)))
     => member(msg,X2,parts(H)) ) ).

tff(fact_29_rev__swap,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = Ys )
    <=> ( Xs = rev(A,Ys) ) ) ).

tff(fact_30_rev__rev__ident,axiom,
    ! [A: $tType,Xs1: list(A)] : ( rev(A,rev(A,Xs1)) = Xs1 ) ).

tff(fact_31_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),analz(H))
     => member(msg,Y2,analz(H)) ) ).

tff(fact_32_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),analz(H))
     => member(msg,X2,analz(H)) ) ).

tff(fact_33_msg_Osimps_I41_J,axiom,
    ! [Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != key(Nat) ) ).

tff(fact_34_msg_Osimps_I40_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat: nat] : ( key(Nat) != mPair(Msg11,Msg21) ) ).

tff(fact_35_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C2: msg] :
      ( member(msg,C2,analz(H))
     => member(msg,C2,parts(H)) ) ).

tff(fact_36_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C2: msg] :
      ( ~ member(msg,C2,parts(H))
     => ~ member(msg,C2,analz(H)) ) ).

tff(fact_37_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),parts(H))
     => member(msg,Y2,parts(H)) ) ).

tff(fact_38_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y2: msg,X2: msg] :
      ( member(msg,mPair(X2,Y2),parts(H))
     => member(msg,X2,parts(H)) ) ).

tff(fact_39_msg_Osimps_I48_J,axiom,
    ! [Msg1: msg,Nat1: nat,Msg22: msg,Msg12: msg] : ( mPair(Msg12,Msg22) != crypt(Nat1,Msg1) ) ).

tff(fact_40_msg_Osimps_I49_J,axiom,
    ! [Msg22: msg,Msg12: msg,Msg1: msg,Nat1: nat] : ( crypt(Nat1,Msg1) != mPair(Msg12,Msg22) ) ).

tff(fact_41_msg_Osimps_I43_J,axiom,
    ! [Nat: nat,Msg1: msg,Nat1: nat] : ( crypt(Nat1,Msg1) != key(Nat) ) ).

tff(fact_42_msg_Osimps_I42_J,axiom,
    ! [Msg1: msg,Nat1: nat,Nat: nat] : ( key(Nat) != crypt(Nat1,Msg1) ) ).

tff(fact_43_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),X2: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X2),parts(H))
     => member(msg,X2,parts(H)) ) ).

tff(fact_44_parts_OBody,axiom,
    ! [H: fun(msg,bool),X2: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X2),parts(H))
     => member(msg,X2,parts(H)) ) ).

tff(fact_45_msg_Osimps_I35_J,axiom,
    ! [Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != nonce(Nat) ) ).

tff(fact_46_msg_Osimps_I34_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat: nat] : ( nonce(Nat) != mPair(Msg11,Msg21) ) ).

tff(fact_47_msg_Osimps_I30_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( nonce(Nat) != key(Nat1) ) ).

tff(fact_48_msg_Osimps_I31_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( key(Nat1) != nonce(Nat) ) ).

tff(fact_49_msg_Osimps_I37_J,axiom,
    ! [Nat: nat,Msg1: msg,Nat1: nat] : ( crypt(Nat1,Msg1) != nonce(Nat) ) ).

tff(fact_50_msg_Osimps_I36_J,axiom,
    ! [Msg1: msg,Nat1: nat,Nat: nat] : ( nonce(Nat) != crypt(Nat1,Msg1) ) ).

tff(fact_51_set__takeWhileD,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool),X1: A] :
      ( member(A,X1,set(A,takeWhile(A,P1,Xs)))
     => ( member(A,X1,set(A,Xs))
        & pp(aa(A,bool,P1,X1)) ) ) ).

tff(fact_52_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y2: msg] :
      ( ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) )
     => ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) ) ) ).

tff(fact_53_Says__imp__knows,axiom,
    ! [Evsa: list(event),X2: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X2),set(event,Evsa))
     => member(msg,X2,knows(Aa,Evsa)) ) ).

tff(fact_54_Says__imp__spies,axiom,
    ! [Evsa: list(event),X2: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X2),set(event,Evsa))
     => member(msg,X2,knows(spy,Evsa)) ) ).

tff(fact_55_takeWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K1: list(A),L: list(A)] :
      ( ( L = K1 )
     => ( ! [X4: A] :
            ( member(A,X4,set(A,L))
           => ( pp(aa(A,bool,P1,X4))
            <=> pp(aa(A,bool,Q1,X4)) ) )
       => ( takeWhile(A,P1,L) = takeWhile(A,Q1,K1) ) ) ) ).

tff(fact_56_B__Issues__A,axiom,
    ! [Evsa: list(event),Nb: nat,Ka: nat,Aa: agent,Ba: agent] :
      ( member(event,says(Ba,Aa,crypt(Ka,nonce(Nb))),set(event,Evsa))
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( ~ member(agent,Aa,bad)
         => ( ~ member(agent,Ba,bad)
           => ( member(list(event),Evsa,nS_Sha254967238shared)
             => nS_Sha512322870Issues(Ba,Aa,crypt(Ka,nonce(Nb)),Evsa) ) ) ) ) ) ).

tff(fact_57_analz__trivial,axiom,
    ! [H: fun(msg,bool)] :
      ( ! [X3: msg,Y1: msg] : ~ member(msg,mPair(X3,Y1),H)
     => ( ! [X3: msg,K: nat] : ~ member(msg,crypt(K,X3),H)
       => ( analz(H) = H ) ) ) ).

tff(fact_58_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),X2: msg,Aa: agent] :
      ( member(event,notes(Aa,X2),set(event,Evsa))
     => ( member(agent,Aa,bad)
       => member(msg,X2,knows(spy,Evsa)) ) ) ).

tff(fact_59_knows__Nil,axiom,
    ! [Aa: agent] : ( knows(Aa,nil(event)) = initState(Aa) ) ).

tff(fact_60_parts__spies__takeWhile__mono,axiom,
    ! [Evsa: list(event),P1: fun(event,bool)] : ord_less_eq(fun(msg,bool),parts(knows(spy,takeWhile(event,P1,Evsa))),parts(knows(spy,Evsa))) ).

tff(fact_61_parts__spies__evs__revD2,axiom,
    ! [Evsa: list(event)] : ord_less_eq(fun(msg,bool),parts(knows(spy,rev(event,Evsa))),parts(knows(spy,Evsa))) ).

tff(fact_62_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_63_Gets__imp__knows__agents,axiom,
    ! [Evsa: list(event),X2: msg,Aa: agent] :
      ( ( Aa != spy )
     => ( member(event,gets(Aa,X2),set(event,Evsa))
       => member(msg,X2,knows(Aa,Evsa)) ) ) ).

tff(fact_64_event_Osimps_I3_J,axiom,
    ! [Msg3: msg,Agent5: agent,Msg2: msg,Agent4: agent] :
      ( ( notes(Agent4,Msg2) = notes(Agent5,Msg3) )
    <=> ( ( Agent4 = Agent5 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_65_event_Osimps_I2_J,axiom,
    ! [Msg3: msg,Agent5: agent,Msg2: msg,Agent4: agent] :
      ( ( gets(Agent4,Msg2) = gets(Agent5,Msg3) )
    <=> ( ( Agent4 = Agent5 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_66_analz__subset__iff,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),analz(G),analz(H))
    <=> ord_less_eq(fun(msg,bool),G,analz(H)) ) ).

tff(fact_67_parts__subset__iff,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),parts(G),parts(H))
    <=> ord_less_eq(fun(msg,bool),G,parts(H)) ) ).

tff(fact_68_event_Osimps_I8_J,axiom,
    ! [Msg1: msg,Agent: agent,Msg: msg,Agent3: agent] : ( gets(Agent3,Msg) != notes(Agent,Msg1) ) ).

tff(fact_69_event_Osimps_I9_J,axiom,
    ! [Msg: msg,Agent3: agent,Msg1: msg,Agent: agent] : ( notes(Agent,Msg1) != gets(Agent3,Msg) ) ).

tff(fact_70_initState__subset__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),initState(Aa),knows(Aa,Evsa)) ).

tff(fact_71_analz__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,analz(H)) ).

tff(fact_72_analz__mono,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G,H)
     => ord_less_eq(fun(msg,bool),analz(G),analz(H)) ) ).

tff(fact_73_analz__trans,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),X2: msg] :
      ( member(msg,X2,analz(G))
     => ( ord_less_eq(fun(msg,bool),G,analz(H))
       => member(msg,X2,analz(H)) ) ) ).

tff(fact_74_parts__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,parts(H)) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X1: A] :
      ( member(A,X1,Aa)
    <=> pp(aa(A,bool,Aa,X1)) ) ).

tff(fact_76_parts__mono,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G,H)
     => ord_less_eq(fun(msg,bool),parts(G),parts(H)) ) ).

tff(fact_77_parts__trans,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),X2: msg] :
      ( member(msg,X2,parts(G))
     => ( ord_less_eq(fun(msg,bool),G,parts(H))
       => member(msg,X2,parts(H)) ) ) ).

tff(fact_78_event_Osimps_I7_J,axiom,
    ! [Msg: msg,Agent2: agent,Agent1: agent,Msg1: msg,Agent: agent] : ( notes(Agent,Msg1) != says(Agent1,Agent2,Msg) ) ).

tff(fact_79_event_Osimps_I6_J,axiom,
    ! [Msg1: msg,Agent: agent,Msg: msg,Agent2: agent,Agent1: agent] : ( says(Agent1,Agent2,Msg) != notes(Agent,Msg1) ) ).

tff(fact_80_event_Osimps_I5_J,axiom,
    ! [Msg: msg,Agent2: agent,Agent1: agent,Msg1: msg,Agent: agent] : ( gets(Agent,Msg1) != says(Agent1,Agent2,Msg) ) ).

tff(fact_81_event_Osimps_I4_J,axiom,
    ! [Msg1: msg,Agent: agent,Msg: msg,Agent2: agent,Agent1: agent] : ( says(Agent1,Agent2,Msg) != gets(Agent,Msg1) ) ).

tff(fact_82_ns__shared_ONil,axiom,
    member(list(event),nil(event),nS_Sha254967238shared) ).

tff(fact_83_analz__subset__parts,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),analz(H),parts(H)) ).

tff(fact_84_Notes__imp__knows,axiom,
    ! [Evsa: list(event),X2: msg,Aa: agent] :
      ( member(event,notes(Aa,X2),set(event,Evsa))
     => member(msg,X2,knows(Aa,Evsa)) ) ).

tff(fact_85_spies__takeWhile,axiom,
    ! [Evsa: list(event),P1: fun(event,bool)] : ord_less_eq(fun(msg,bool),knows(spy,takeWhile(event,P1,Evsa)),knows(spy,Evsa)) ).

tff(fact_86_knows__imp__Says__Gets__Notes__initState,axiom,
    ! [Evsa: list(event),Aa: agent,X2: msg] :
      ( member(msg,X2,knows(Aa,Evsa))
     => ( ( Aa != spy )
       => ? [B1: agent] :
            ( member(event,says(Aa,B1,X2),set(event,Evsa))
            | member(event,gets(Aa,X2),set(event,Evsa))
            | member(event,notes(Aa,X2),set(event,Evsa))
            | member(msg,X2,initState(Aa)) ) ) ) ).

tff(fact_87_knows__Spy__imp__Says__Notes__initState,axiom,
    ! [Evsa: list(event),X2: msg] :
      ( member(msg,X2,knows(spy,Evsa))
     => ? [A1: agent,B1: agent] :
          ( member(event,says(A1,B1,X2),set(event,Evsa))
          | member(event,notes(A1,X2),set(event,Evsa))
          | member(msg,X2,initState(spy)) ) ) ).

tff(fact_88_Nonce__notin__initState,axiom,
    ! [Ba: agent,N: nat] : ~ member(msg,nonce(N),parts(initState(Ba))) ).

tff(fact_89_Crypt__notin__initState,axiom,
    ! [Ba: agent,X2: msg,Ka: nat] : ~ member(msg,crypt(Ka,X2),parts(initState(Ba))) ).

tff(fact_90_subsetD,axiom,
    ! [A: $tType,C2: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( member(A,C2,Aa)
       => member(A,C2,Ba) ) ) ).

tff(fact_91_equalityI,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( ord_less_eq(fun(A,bool),Ba,Aa)
       => ( Aa = Ba ) ) ) ).

tff(fact_92_equalityE,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ~ ( ord_less_eq(fun(A,bool),Aa,Ba)
         => ~ ord_less_eq(fun(A,bool),Ba,Aa) ) ) ).

tff(fact_93_subset__trans,axiom,
    ! [A: $tType,C1: fun(A,bool),Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( ord_less_eq(fun(A,bool),Ba,C1)
       => ord_less_eq(fun(A,bool),Aa,C1) ) ) ).

tff(fact_94_set__mp,axiom,
    ! [A: $tType,X1: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( member(A,X1,Aa)
       => member(A,X1,Ba) ) ) ).

tff(fact_95_set__rev__mp,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X1: A] :
      ( member(A,X1,Aa)
     => ( ord_less_eq(fun(A,bool),Aa,Ba)
       => member(A,X1,Ba) ) ) ).

tff(fact_96_in__mono,axiom,
    ! [A: $tType,X1: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( member(A,X1,Aa)
       => member(A,X1,Ba) ) ) ).

tff(fact_97_equalityD2,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ord_less_eq(fun(A,bool),Ba,Aa) ) ).

tff(fact_98_equalityD1,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ord_less_eq(fun(A,bool),Aa,Ba) ) ).

tff(fact_99_set__eq__subset,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
    <=> ( ord_less_eq(fun(A,bool),Aa,Ba)
        & ord_less_eq(fun(A,bool),Ba,Aa) ) ) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    ~ member(agent,a,bad) ).

tff(conj_1,hypothesis,
    ~ member(agent,b,bad) ).

tff(conj_2,conjecture,
    ( member(msg,key(k),analz(knows(spy,nil(event))))
    | ~ member(event,says(a,b,crypt(k,mPair(nonce(nb),nonce(nb)))),set(event,nil(event)))
    | ~ member(msg,crypt(k,mPair(nonce(nb),nonce(nb))),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(a,b,crypt(k,mPair(nonce(nb),nonce(nb)))))),rev(event,nil(event)))))) ) ).

%------------------------------------------------------------------------------
