%------------------------------------------------------------------------------
% File     : SWV807_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 491
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_491 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  171 (  59 unt;  44 typ;   0 def)
%            Number of atoms       :  233 (  98 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  169 (  63   ~;  21   |;  14   &)
%                                         (  19 <=>;  52  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   37 (  22   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    3 (   2 usr;   0 prp; 1-4 aty)
%            Number of functors    :   37 (  37 usr;  14 con; 0-5 aty)
%            Number of variables   :  360 ( 336   !;   3   ?; 360   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:30:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_OIssues,type,
    nS_Sha512322870Issues: ( agent * agent * msg * list(event) ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NB,type,
    nb: nat ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_spies__evs__rev,axiom,
    ! [Evsa: list(event)] : ( knows(spy,Evsa) = knows(spy,rev(event,Evsa)) ) ).

tff(fact_1_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),X1: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent,S: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,X1)))))),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(knows(spy,Evsa)))) ) ).

tff(fact_2_Issues__def,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( nS_Sha512322870Issues(Aa,Ba,X1,Evsa)
    <=> ? [Y3: msg] :
          ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,Y3)),set(event,Evsa)))
          & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(insert(msg,Y3,bot_bot(fun(msg,bool))))))
          & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(Aa,Ba,Y3))),rev(event,Evsa)))))) ) ) ).

tff(fact_3_B__Issues__A,axiom,
    ! [Evsa: list(event),Nb: nat,Ka: nat,Aa: agent,Ba: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Ba,Aa,crypt(Ka,nonce(Nb)))),set(event,Evsa)))
     => ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(Ka)),analz(knows(spy,Evsa))))
       => ( ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),Aa),bad))
         => ( ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),Ba),bad))
           => ( pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),Evsa),nS_Sha254967238shared))
             => nS_Sha512322870Issues(Ba,Aa,crypt(Ka,nonce(Nb)),Evsa) ) ) ) ) ) ).

tff(fact_4_parts__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( parts(insert(msg,nonce(N),H)) = insert(msg,nonce(N),parts(H)) ) ).

tff(fact_5_analz__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( analz(insert(msg,nonce(N),H)) = insert(msg,nonce(N),analz(H)) ) ).

tff(fact_6_parts__insert__Crypt,axiom,
    ! [H: fun(msg,bool),X1: msg,Ka: nat] : ( parts(insert(msg,crypt(Ka,X1),H)) = insert(msg,crypt(Ka,X1),parts(insert(msg,X1,H))) ) ).

tff(fact_7_parts__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( parts(insert(msg,key(Ka),H)) = insert(msg,key(Ka),parts(H)) ) ).

tff(fact_8_parts__insert__MPair,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] : ( parts(insert(msg,mPair(X1,Y1),H)) = insert(msg,mPair(X1,Y1),parts(insert(msg,X1,insert(msg,Y1,H)))) ) ).

tff(fact_9_analz__insert__MPair,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] : ( analz(insert(msg,mPair(X1,Y1),H)) = insert(msg,mPair(X1,Y1),analz(insert(msg,X1,insert(msg,Y1,H)))) ) ).

tff(fact_10_singleton__conv2,axiom,
    ! [A: $tType,A1: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_11_singleton__conv,axiom,
    ! [A: $tType,A1: A] : ( collect(A,combc(A,A,bool,fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_12_parts__empty,axiom,
    parts(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_13_parts__emptyE,axiom,
    ! [X1: msg] : ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(bot_bot(fun(msg,bool))))) ).

tff(fact_14_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_15_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_16_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_17_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_18_all__not__in__conv,axiom,
    ! [A: $tType,Aa: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
    <=> ( Aa = bot_bot(fun(A,bool)) ) ) ).

tff(fact_19_insertCI,axiom,
    ! [A: $tType,B1: A,Ba: fun(A,bool),A1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Ba))
       => ( A1 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Ba))) ) ).

tff(fact_20_insertE,axiom,
    ! [A: $tType,Aa: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Aa)))
     => ( ( A1 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ) ).

tff(fact_21_insert__iff,axiom,
    ! [A: $tType,Aa: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Aa)))
    <=> ( ( A1 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ) ).

tff(fact_22_insert__absorb2,axiom,
    ! [A: $tType,Aa: fun(A,bool),X4: A] : ( insert(A,X4,insert(A,X4,Aa)) = insert(A,X4,Aa) ) ).

tff(fact_23_analz_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_24_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_25_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg13: msg,Msg22: msg,Msg12: msg] :
      ( ( mPair(Msg12,Msg22) = mPair(Msg13,Msg23) )
    <=> ( ( Msg12 = Msg13 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_26_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_27_parts_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_28_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_29_msg_Osimps_I7_J,axiom,
    ! [Msg4: msg,Nat3: nat,Msg3: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg3) = crypt(Nat3,Msg4) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_30_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_31_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),analz(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(H))) ) ) ).

tff(fact_32_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
        | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_33_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
        & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_34_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_35_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_36_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),parts(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(H))) ) ) ).

tff(fact_37_analz__empty,axiom,
    analz(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_38_equals0D,axiom,
    ! [A: $tType,A1: A,Aa: fun(A,bool)] :
      ( ( Aa = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ).

tff(fact_39_ex__in__conv,axiom,
    ! [A: $tType,Aa: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
    <=> ( Aa != bot_bot(fun(A,bool)) ) ) ).

tff(fact_40_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_41_insert__absorb,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa))
     => ( insert(A,A1,Aa) = Aa ) ) ).

tff(fact_42_insertI2,axiom,
    ! [A: $tType,B1: A,Ba: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Ba))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Ba))) ) ).

tff(fact_43_insert__eq__iff,axiom,
    ! [A: $tType,Ba: fun(A,bool),B1: A,Aa: fun(A,bool),A1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),Ba))
       => ( ( insert(A,A1,Aa) = insert(A,B1,Ba) )
        <=> ( ( ( A1 = B1 )
             => ( Aa = Ba ) )
            & ( ( A1 != B1 )
             => ? [C2: fun(A,bool)] :
                  ( ( Aa = insert(A,B1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C2))
                  & ( Ba = insert(A,A1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),C2)) ) ) ) ) ) ) ).

tff(fact_44_insert__ident,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X4: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),Ba))
       => ( ( insert(A,X4,Aa) = insert(A,X4,Ba) )
        <=> ( Aa = Ba ) ) ) ) ).

tff(fact_45_insert__code,axiom,
    ! [A: $tType,X4: A,Aa: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,Aa),X4))
    <=> ( ( Y2 = X4 )
        | pp(aa(A,bool,Aa,X4)) ) ) ).

tff(fact_46_insert__commute,axiom,
    ! [A: $tType,Aa: fun(A,bool),Y2: A,X4: A] : ( insert(A,X4,insert(A,Y2,Aa)) = insert(A,Y2,insert(A,X4,Aa)) ) ).

tff(fact_47_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A1: A] : ( insert(A,A1,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A1))),P1)) ) ).

tff(fact_48_insert__compr,axiom,
    ! [A: $tType,Ba: fun(A,bool),A1: A] : ( insert(A,A1,Ba) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A1)),combc(A,fun(A,bool),bool,member(A),Ba))) ) ).

tff(fact_49_insertI1,axiom,
    ! [A: $tType,Ba: fun(A,bool),A1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,A1,Ba))) ).

tff(fact_50_analz__analzD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(analz(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_51_parts__partsD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(parts(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_52_insert__compr__raw,axiom,
    ! [A: $tType,X6: A,Xa: fun(A,bool)] : ( insert(A,X6,Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X6)),combc(A,fun(A,bool),bool,member(A),Xa))) ) ).

tff(fact_53_singleton__inject,axiom,
    ! [A: $tType,B1: A,A1: A] :
      ( ( insert(A,A1,bot_bot(fun(A,bool))) = insert(A,B1,bot_bot(fun(A,bool))) )
     => ( A1 = B1 ) ) ).

tff(fact_54_singletonE,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A1,bot_bot(fun(A,bool)))))
     => ( B1 = A1 ) ) ).

tff(fact_55_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B1: A,A1: A] :
      ( ( insert(A,A1,insert(A,B1,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A1 = C1 )
          & ( B1 = D ) )
        | ( ( A1 = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_56_singleton__iff,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A1,bot_bot(fun(A,bool)))))
    <=> ( B1 = A1 ) ) ).

tff(fact_57_insert__not__empty,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] : ( insert(A,A1,Aa) != bot_bot(fun(A,bool)) ) ).

tff(fact_58_empty__not__insert,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] : ( bot_bot(fun(A,bool)) != insert(A,A1,Aa) ) ).

tff(fact_59_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),analz(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(H))) ) ).

tff(fact_60_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),analz(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_61_analz__insert__cong,axiom,
    ! [X1: msg,H1: fun(msg,bool),H: fun(msg,bool)] :
      ( ( analz(H) = analz(H1) )
     => ( analz(insert(msg,X1,H)) = analz(insert(msg,X1,H1)) ) ) ).

tff(fact_62_analz__cut,axiom,
    ! [H: fun(msg,bool),X1: msg,Y1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(insert(msg,X1,H))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(H))) ) ) ).

tff(fact_63_analz__insert__eq,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
     => ( analz(insert(msg,X1,H)) = analz(H) ) ) ).

tff(fact_64_analz__insertI,axiom,
    ! [A1: msg,G1: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(G1)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(insert(msg,A1,G1)))) ) ).

tff(fact_65_msg_Osimps_I41_J,axiom,
    ! [Nat: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != key(Nat) ) ).

tff(fact_66_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat: nat] : ( key(Nat) != mPair(Msg1,Msg2) ) ).

tff(fact_67_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(H))) ) ).

tff(fact_68_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(H)))
     => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(H))) ) ).

tff(fact_69_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(H))) ) ).

tff(fact_70_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_71_parts__cut__eq,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H)))
     => ( parts(insert(msg,X1,H)) = parts(H) ) ) ).

tff(fact_72_parts__insertI,axiom,
    ! [A1: msg,G1: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(G1)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(insert(msg,A1,G1)))) ) ).

tff(fact_73_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != crypt(Nat1,Msg) ) ).

tff(fact_74_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg11: msg,Msg: msg,Nat1: nat] : ( crypt(Nat1,Msg) != mPair(Msg11,Msg21) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X5: A] : ( aa(A,B,F,X5) = aa(A,B,G,X5) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X4: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),Aa))
    <=> pp(aa(A,bool,Aa,X4)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_msg_Osimps_I43_J,axiom,
    ! [Nat: nat,Msg: msg,Nat1: nat] : ( crypt(Nat1,Msg) != key(Nat) ) ).

tff(fact_79_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat1: nat,Nat: nat] : ( key(Nat) != crypt(Nat1,Msg) ) ).

tff(fact_80_parts_OBody,axiom,
    ! [H: fun(msg,bool),X1: msg,Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(Ka,X1)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_81_msg_Osimps_I35_J,axiom,
    ! [Nat: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != nonce(Nat) ) ).

tff(fact_82_msg_Osimps_I34_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat: nat] : ( nonce(Nat) != mPair(Msg1,Msg2) ) ).

tff(fact_83_msg_Osimps_I30_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( nonce(Nat) != key(Nat1) ) ).

tff(fact_84_msg_Osimps_I31_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( key(Nat1) != nonce(Nat) ) ).

tff(fact_85_msg_Osimps_I37_J,axiom,
    ! [Nat: nat,Msg: msg,Nat1: nat] : ( crypt(Nat1,Msg) != nonce(Nat) ) ).

tff(fact_86_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat1: nat,Nat: nat] : ( nonce(Nat) != crypt(Nat1,Msg) ) ).

tff(fact_87_Collect__conv__if,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_88_Collect__conv__if2,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_89_pushes_I5_J,axiom,
    ! [Aa: fun(msg,bool),Y1: msg,X1: msg,Ka: nat] : ( insert(msg,key(Ka),insert(msg,mPair(X1,Y1),Aa)) = insert(msg,mPair(X1,Y1),insert(msg,key(Ka),Aa)) ) ).

tff(fact_90_pushes_I12_J,axiom,
    ! [Aa: fun(msg,bool),Y1: msg,X3: msg,Ka: msg,X1: nat] : ( insert(msg,crypt(X1,Ka),insert(msg,mPair(X3,Y1),Aa)) = insert(msg,mPair(X3,Y1),insert(msg,crypt(X1,Ka),Aa)) ) ).

tff(fact_91_pushes_I6_J,axiom,
    ! [Aa: fun(msg,bool),K: msg,X1: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,crypt(X1,K),Aa)) = insert(msg,crypt(X1,K),insert(msg,key(Ka),Aa)) ) ).

tff(fact_92_pushes_I2_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,key(Ka),Aa)) ) ).

tff(fact_93_pushes_I9_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: msg,X1: nat] : ( insert(msg,crypt(X1,Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,crypt(X1,Ka),Aa)) ) ).

tff(fact_94_Spy__in__bad,axiom,
    pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),spy),bad)) ).

tff(fact_95_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X1)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(knows(spy,Evsa)))) ) ).

tff(fact_96_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X1)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(knows(spy,Evsa)))) ) ).

tff(fact_97_takeWhile__eq__all__conv,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool)] :
      ( ( takeWhile(A,P1,Xs) = Xs )
    <=> ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),set(A,Xs)))
         => pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_98_set__rev,axiom,
    ! [A: $tType,Xs: list(A)] : ( set(A,rev(A,Xs)) = set(A,Xs) ) ).

tff(fact_99_Says__imp__spies,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X1)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),knows(spy,Evsa))) ) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (6)
tff(conj_0,hypothesis,
    pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(a,b,crypt(k,mPair(nonce(nb),nonce(nb))))),set(event,evs))) ).

tff(conj_1,hypothesis,
    ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),analz(knows(spy,evs)))) ).

tff(conj_2,hypothesis,
    ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),a),bad)) ).

tff(conj_3,hypothesis,
    ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),b),bad)) ).

tff(conj_4,hypothesis,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),evs),nS_Sha254967238shared)) ).

tff(conj_5,conjecture,
    ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(k,mPair(nonce(nb),nonce(nb)))),parts(insert(msg,crypt(k,mPair(nonce(nb),nonce(nb))),bot_bot(fun(msg,bool))))))
    & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(k,mPair(nonce(nb),nonce(nb)))),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(a,b,crypt(k,mPair(nonce(nb),nonce(nb)))))),rev(event,evs)))))) ) ).

%------------------------------------------------------------------------------
