%------------------------------------------------------------------------------
% File     : SWV799_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 472
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_472 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  145 (  38 unt;  40 typ;   0 def)
%            Number of atoms       :  262 (  58 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  233 (  76   ~;   4   |;   9   &)
%                                         (  15 <=>; 129  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   34 (  21   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   31 (  31 usr;  13 con; 0-4 aty)
%            Number of variables   :  363 ( 355   !;   2   ?; 363   :)
%                                         (   6  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:27:50
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent1: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_c_Event_Obad,type,
    bad: fun(agent1,bool) ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent1 * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent1 * agent1 * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent1 * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A2: $tType] : ( ( A2 * list(A2) ) > list(A2) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A2: $tType] : list(A2) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A2: $tType] : ( list(A2) > fun(A2,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent1 ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent1 ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent: agent1 > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_OIssues,type,
    nS_Sha512322870Issues: ( agent1 * agent1 * msg * list(event) ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Public_OshrK,type,
    shrK: agent1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A2: $tType,B1: $tType] : ( ( fun(A2,B1) * A2 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A2: $tType] : ( ( A2 * fun(A2,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent1 ).

tff(sy_v_B,type,
    b: agent1 ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NA,type,
    na: nat ).

tff(sy_v_NB,type,
    nb: nat ).

tff(sy_v_X,type,
    x: msg ).

%----Relevant facts (100)
tff(fact_0_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent1,S: agent1] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_1_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent1] :
      ( member(agent1,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_2_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent1] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_3_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),Xa),analz(knows(spy,Evsa)))
     => ( member(agent1,Aa,bad)
       => member(msg,Xa,analz(knows(spy,Evsa))) ) ) ).

tff(fact_4_Spy__in__bad,axiom,
    member(agent1,spy,bad) ).

tff(fact_5_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_6_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,analz(knows(spy,Evsa))) ) ).

tff(fact_7_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => ~ ( member(msg,Xa,parts(H))
         => ~ member(msg,Y,parts(H)) ) ) ).

tff(fact_8_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_9_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_10_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        & member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,analz(H)) ) ).

tff(fact_11_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        | member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,parts(H)) ) ).

tff(fact_12_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => ~ ( member(msg,Xa,analz(H))
         => ~ member(msg,Y,analz(H)) ) ) ).

tff(fact_13_analz_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,analz(H)) ) ).

tff(fact_14_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_15_msg_Osimps_I6_J,axiom,
    ! [Msg24: msg,Msg14: msg,Msg23: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg23) = mPair(Msg14,Msg24) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg23 = Msg24 ) ) ) ).

tff(fact_16_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_17_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,parts(H)) ) ).

tff(fact_18_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_19_msg_Osimps_I7_J,axiom,
    ! [Msg3: msg,Nat3: nat,Msg2: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg2) = crypt(Nat3,Msg3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_20_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_21_msg_Osimps_I1_J,axiom,
    ! [Agent4: agent1,Agent3: agent1] :
      ( ( agent(Agent3) = agent(Agent4) )
    <=> ( Agent3 = Agent4 ) ) ).

tff(fact_22_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent1,Agent12: agent1,Msg2: msg,Agent21: agent1,Agent11: agent1] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_23_shrK__injective,axiom,
    ! [Y1: agent1,X2: agent1] :
      ( ( shrK(X2) = shrK(Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_24_analz__analzD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,analz(analz(H)))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_25_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,parts(parts(H)))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_26_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Y,analz(H)) ) ).

tff(fact_27_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_28_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_29_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_30_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != key(Nat1) ) ).

tff(fact_31_msg_Osimps_I40_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_32_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Y,parts(H)) ) ).

tff(fact_33_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_34_msg_Osimps_I48_J,axiom,
    ! [Msg1: msg,Nat: nat,Msg22: msg,Msg12: msg] : ( mPair(Msg12,Msg22) != crypt(Nat,Msg1) ) ).

tff(fact_35_msg_Osimps_I49_J,axiom,
    ! [Msg22: msg,Msg12: msg,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != mPair(Msg12,Msg22) ) ).

tff(fact_36_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != key(Nat1) ) ).

tff(fact_37_msg_Osimps_I42_J,axiom,
    ! [Msg1: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg1) ) ).

tff(fact_38_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_39_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_40_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != nonce(Nat1) ) ).

tff(fact_41_msg_Osimps_I34_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_42_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_43_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_44_msg_Osimps_I17_J,axiom,
    ! [Agent5: agent1,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != agent(Agent5) ) ).

tff(fact_45_msg_Osimps_I16_J,axiom,
    ! [Msg21: msg,Msg11: msg,Agent5: agent1] : ( agent(Agent5) != mPair(Msg11,Msg21) ) ).

tff(fact_46_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent5: agent1] : ( agent(Agent5) != key(Nat) ) ).

tff(fact_47_msg_Osimps_I13_J,axiom,
    ! [Agent5: agent1,Nat: nat] : ( key(Nat) != agent(Agent5) ) ).

tff(fact_48_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != nonce(Nat1) ) ).

tff(fact_49_msg_Osimps_I36_J,axiom,
    ! [Msg1: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg1) ) ).

tff(fact_50_msg_Osimps_I19_J,axiom,
    ! [Agent5: agent1,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != agent(Agent5) ) ).

tff(fact_51_msg_Osimps_I18_J,axiom,
    ! [Msg1: msg,Nat: nat,Agent5: agent1] : ( agent(Agent5) != crypt(Nat,Msg1) ) ).

tff(fact_52_msg_Osimps_I11_J,axiom,
    ! [Agent5: agent1,Nat: nat] : ( nonce(Nat) != agent(Agent5) ) ).

tff(fact_53_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent5: agent1] : ( agent(Agent5) != nonce(Nat) ) ).

tff(fact_54_analz__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) )
     => ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) ) ) ).

tff(fact_55_Says__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_56_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),Xa),analz(H))
     => ( member(msg,key(shrK(Aa)),analz(H))
       => member(msg,Xa,analz(H)) ) ) ).

tff(fact_57_Says__imp__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(spy,Evsa)) ) ).

tff(fact_58_Oops__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Ka,parts(knows(spy,Evsa))) ) ).

tff(fact_59_A__authenticates__and__keydist__to__B,axiom,
    ! [Xa: msg,Ba: agent1,NAa: msg,Aa: agent1,Evsa: list(event),NBa: nat,Ka: nat] :
      ( member(msg,crypt(Ka,nonce(NBa)),parts(knows(spy,Evsa)))
     => ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
       => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
         => ( ~ member(agent1,Aa,bad)
           => ( ~ member(agent1,Ba,bad)
             => ( member(list(event),Evsa,nS_Sha254967238shared)
               => nS_Sha512322870Issues(Ba,Aa,crypt(Ka,nonce(NBa)),Evsa) ) ) ) ) ) ) ).

tff(fact_60_B__Issues__A,axiom,
    ! [Evsa: list(event),Nb: nat,Ka: nat,Aa: agent1,Ba: agent1] :
      ( member(event,says(Ba,Aa,crypt(Ka,nonce(Nb))),set(event,Evsa))
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( ~ member(agent1,Aa,bad)
         => ( ~ member(agent1,Ba,bad)
           => ( member(list(event),Evsa,nS_Sha254967238shared)
             => nS_Sha512322870Issues(Ba,Aa,crypt(Ka,nonce(Nb)),Evsa) ) ) ) ) ) ).

tff(fact_61_B__trusts__NS5__lemma,axiom,
    ! [NBa: nat,NAa: msg,Aa: agent1,Ka: nat,Evsa: list(event),Ba: agent1] :
      ( ~ member(agent1,Ba,bad)
     => ( member(list(event),Evsa,nS_Sha254967238shared)
       => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
         => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent(Aa)))))))),set(event,Evsa))
           => ( member(msg,crypt(Ka,mPair(nonce(NBa),nonce(NBa))),parts(knows(spy,Evsa)))
             => member(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),set(event,Evsa)) ) ) ) ) ) ).

tff(fact_62_Spy__see__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),parts(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_63_Spy__analz__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),analz(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_64_A__trusts__NS4__lemma,axiom,
    ! [NBa: nat,Xa: msg,Ba: agent1,NAa: msg,Aa: agent1,Ka: nat,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
         => ( member(msg,crypt(Ka,nonce(NBa)),parts(knows(spy,Evsa)))
           => member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evsa)) ) ) ) ) ).

tff(fact_65_A__trusts__NS2,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent1,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa)) ) ) ) ).

tff(fact_66_B__trusts__NS5,axiom,
    ! [Aa: agent1,Ba: agent1,Evsa: list(event),NBa: nat,Ka: nat] :
      ( member(msg,crypt(Ka,mPair(nonce(NBa),nonce(NBa))),parts(knows(spy,Evsa)))
     => ( member(msg,crypt(shrK(Ba),mPair(key(Ka),agent(Aa))),parts(knows(spy,Evsa)))
       => ( ! [NA: msg,NB: msg] : ~ member(event,notes(spy,mPair(NA,mPair(NB,key(Ka)))),set(event,Evsa))
         => ( ~ member(agent1,Aa,bad)
           => ( ~ member(agent1,Ba,bad)
             => ( member(list(event),Evsa,nS_Sha254967238shared)
               => member(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),set(event,Evsa)) ) ) ) ) ) ) ).

tff(fact_67_event_Osimps_I3_J,axiom,
    ! [Msg3: msg,Agent4: agent1,Msg2: msg,Agent3: agent1] :
      ( ( notes(Agent3,Msg2) = notes(Agent4,Msg3) )
    <=> ( ( Agent3 = Agent4 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_68_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_69_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_70_event_Osimps_I7_J,axiom,
    ! [Msg: msg,Agent2: agent1,Agent1: agent1,Msg1: msg,Agent: agent1] : ( notes(Agent,Msg1) != says(Agent1,Agent2,Msg) ) ).

tff(fact_71_event_Osimps_I6_J,axiom,
    ! [Msg1: msg,Agent: agent1,Msg: msg,Agent2: agent1,Agent1: agent1] : ( says(Agent1,Agent2,Msg) != notes(Agent,Msg1) ) ).

tff(fact_72_Server__not__bad,axiom,
    ~ member(agent1,server,bad) ).

tff(fact_73_ns__shared_ONil,axiom,
    member(list(event),nil(event),nS_Sha254967238shared) ).

tff(fact_74_Notes__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A2: $tType,G: fun(A2,B1),F: fun(A2,B1)] :
      ( ! [X3: A2] : ( aa(A2,B1,F,X3) = aa(A2,B1,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A2: $tType,Aa: fun(A2,bool),X2: A2] :
      ( member(A2,X2,Aa)
    <=> pp(aa(A2,bool,Aa,X2)) ) ).

tff(fact_77_unique__session__keys,axiom,
    ! [X1: msg,B: agent1,NA1: msg,A: agent1,Evsa: list(event),Xa: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(event,says(server,A,crypt(shrK(A),mPair(NA1,mPair(agent(B),mPair(key(Ka),X1))))),set(event,Evsa))
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ( Aa = A )
            & ( NAa = NA1 )
            & ( Ba = B )
            & ( Xa = X1 ) ) ) ) ) ).

tff(fact_78_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => ( member(agent1,Aa,bad)
       => member(msg,Xa,knows(spy,Evsa)) ) ) ).

tff(fact_79_secrecy__lemma,axiom,
    ! [Evsa: list(event),Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent(Aa)))))))),set(event,Evsa))
     => ( ~ member(agent1,Aa,bad)
       => ( ~ member(agent1,Ba,bad)
         => ( member(list(event),Evsa,nS_Sha254967238shared)
           => ( ! [NB: msg] : ~ member(event,notes(spy,mPair(NAa,mPair(NB,key(Ka)))),set(event,Evsa))
             => ~ member(msg,key(Ka),analz(knows(spy,Evsa))) ) ) ) ) ) ).

tff(fact_80_A__trusts__NS4,axiom,
    ! [Xa: msg,Ba: agent1,NAa: msg,Aa: agent1,Evsa: list(event),NBa: nat,Ka: nat] :
      ( member(msg,crypt(Ka,nonce(NBa)),parts(knows(spy,Evsa)))
     => ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
       => ( ! [NB: msg] : ~ member(event,notes(spy,mPair(NAa,mPair(NB,key(Ka)))),set(event,Evsa))
         => ( ~ member(agent1,Aa,bad)
           => ( ~ member(agent1,Ba,bad)
             => ( member(list(event),Evsa,nS_Sha254967238shared)
               => member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evsa)) ) ) ) ) ) ) ).

tff(fact_81_NS4__implies__NS3,axiom,
    ! [NBa: nat,Xa: msg,Ba: agent1,NAa: msg,Aa: agent1,Ka: nat,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
         => ( member(msg,crypt(Ka,nonce(NBa)),parts(knows(spy,Evsa)))
           => ? [A1: agent1] : member(event,says(A1,Ba,Xa),set(event,Evsa)) ) ) ) ) ).

tff(fact_82_Spy__not__see__encrypted__key,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent1,NAa: msg,K: nat,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(K,mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( ! [NB: msg] : ~ member(event,notes(spy,mPair(NAa,mPair(NB,key(Ka)))),set(event,Evsa))
       => ( ~ member(agent1,Aa,bad)
         => ( ~ member(agent1,Ba,bad)
           => ( member(list(event),Evsa,nS_Sha254967238shared)
             => ~ member(msg,key(Ka),analz(knows(spy,Evsa))) ) ) ) ) ) ).

tff(fact_83_B__trusts__NS3,axiom,
    ! [Evsa: list(event),Aa: agent1,Ka: nat,Ba: agent1] :
      ( member(msg,crypt(shrK(Ba),mPair(key(Ka),agent(Aa))),parts(knows(spy,Evsa)))
     => ( ~ member(agent1,Ba,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ? [NA: msg] : member(event,says(server,Aa,crypt(shrK(Aa),mPair(NA,mPair(agent(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent(Aa)))))))),set(event,Evsa)) ) ) ) ).

tff(fact_84_ns__shared_OOops,axiom,
    ! [Xa: msg,NAa: nat,NBa: nat,Ka: nat,Aa: agent1,Ba: agent1,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NBa),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_85_ns__shared_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent1,NAa: nat,S: agent1,Aa: agent1,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,Xa),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_86_analz__mono__contra_I1_J,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,says(Aa,Ba,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_87_analz__mono__contra_I2_J,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,notes(Aa,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_88_ns__sharedp_OOops,axiom,
    ! [Xa: msg,NAa: nat,NBa: nat,Ka: nat,Aa: agent1,Ba: agent1,Evso: list(event)] :
      ( nS_Sha993195050haredp(Evso)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => nS_Sha993195050haredp(cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NBa),key(Ka)))),Evso)) ) ) ) ).

tff(fact_89_ns__sharedp_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent1,NAa: nat,S: agent1,Aa: agent1,Evs3: list(event)] :
      ( nS_Sha993195050haredp(Evs3)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs3))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,Xa),Evs3)) ) ) ) ) ).

tff(fact_90_ns__sharedp__ns__shared__eq,axiom,
    ! [X: list(event)] :
      ( nS_Sha993195050haredp(X)
    <=> member(list(event),X,nS_Sha254967238shared) ) ).

tff(fact_91_ns__sharedp_ONil,axiom,
    nS_Sha993195050haredp(nil(event)) ).

tff(fact_92_ns__sharedp_ONS5,axiom,
    ! [Xa: msg,Ba: agent1,NAa: nat,S: agent1,NBa: nat,Aa: agent1,B: agent1,Ka: nat,Evs5: list(event)] :
      ( nS_Sha993195050haredp(Evs5)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B,Aa,crypt(Ka,nonce(NBa))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),Evs5)) ) ) ) ) ).

tff(fact_93_ns__shared_ONS5,axiom,
    ! [Xa: msg,Ba: agent1,NAa: nat,S: agent1,NBa: nat,Aa: agent1,B: agent1,Ka: nat,Evs5: list(event)] :
      ( member(list(event),Evs5,nS_Sha254967238shared)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B,Aa,crypt(Ka,nonce(NBa))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => member(list(event),cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),Evs5),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_94_sym__shrK,axiom,
    ! [Xa: agent1] : member(nat,shrK(Xa),symKeys) ).

tff(fact_95_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K,symKeys) )
     => ( Ka != K ) ) ).

tff(fact_96_analz__Decrypt_H,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),analz(H))
     => ( member(nat,Ka,symKeys)
       => ( member(msg,key(Ka),analz(H))
         => member(msg,Xa,analz(H)) ) ) ) ).

tff(fact_97_ns__sharedp_ONS2,axiom,
    ! [NAa: nat,Ba: agent1,Aa: agent1,A: agent1,KAB: nat,Evs2: list(event)] :
      ( nS_Sha993195050haredp(Evs2)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs2))
           => nS_Sha993195050haredp(cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent(Aa)))))))),Evs2)) ) ) ) ) ).

tff(fact_98_ns__shared_ONS2,axiom,
    ! [NAa: nat,Ba: agent1,Aa: agent1,A: agent1,KAB: nat,Evs2: list(event)] :
      ( member(list(event),Evs2,nS_Sha254967238shared)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs2))
           => member(list(event),cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent(Aa)))))))),Evs2),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_99_MPair__used,axiom,
    ! [H: list(event),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),used(H))
     => ~ ( member(msg,Xa,used(H))
         => ~ member(msg,Y,used(H)) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    ~ member(agent1,a,bad) ).

tff(conj_1,hypothesis,
    ~ member(agent1,b,bad) ).

tff(conj_2,conjecture,
    ( member(msg,key(k),analz(knows(spy,nil(event))))
    | ~ member(msg,crypt(shrK(a),mPair(nonce(na),mPair(agent(b),mPair(key(k),x)))),parts(knows(spy,nil(event))))
    | ~ member(msg,crypt(k,mPair(nonce(nb),nonce(nb))),parts(knows(spy,nil(event))))
    | member(event,says(a,b,crypt(k,mPair(nonce(nb),nonce(nb)))),set(event,nil(event))) ) ).

%------------------------------------------------------------------------------
