%------------------------------------------------------------------------------
% File     : SWV787_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 433
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_433 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  155 (  50 unt;  42 typ;   0 def)
%            Number of atoms       :  220 (  69 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  161 (  54   ~;   6   |;   8   &)
%                                         (  20 <=>;  73  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   39 (  24   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-3 aty)
%            Number of functors    :   33 (  33 usr;  12 con; 0-5 aty)
%            Number of variables   :  330 ( 316   !;   0   ?; 330   :)
%                                         (  14  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:53
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_OGets,type,
    gets: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent1: agent > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Osynthp,type,
    synthp: ( fun(msg,bool) * msg ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Public_OshrK,type,
    shrK: agent > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_Nb,type,
    nb: nat ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_spies__evs__rev,axiom,
    ! [Evsa: list(event)] : ( knows(spy,Evsa) = knows(spy,rev(event,Evsa)) ) ).

tff(fact_1_Spy__in__bad,axiom,
    member(agent,spy,bad) ).

tff(fact_2_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X1),set(event,Evsa))
     => member(msg,X1,parts(knows(spy,Evsa))) ) ).

tff(fact_3_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X1),set(event,Evsa))
     => member(msg,X1,analz(knows(spy,Evsa))) ) ).

tff(fact_4_takeWhile__eq__all__conv,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool)] :
      ( ( takeWhile(A,P1,Xs) = Xs )
    <=> ! [X4: A] :
          ( member(A,X4,set(A,Xs))
         => pp(aa(A,bool,P1,X4)) ) ) ).

tff(fact_5_set__rev,axiom,
    ! [A: $tType,Xs: list(A)] : ( set(A,rev(A,Xs)) = set(A,Xs) ) ).

tff(fact_6_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_7_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_8_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( member(msg,X1,analz(H))
        & member(msg,X1,parts(H)) )
    <=> member(msg,X1,analz(H)) ) ).

tff(fact_9_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( member(msg,X1,analz(H))
        | member(msg,X1,parts(H)) )
    <=> member(msg,X1,parts(H)) ) ).

tff(fact_10_Says__imp__spies,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X1),set(event,Evsa))
     => member(msg,X1,knows(spy,Evsa)) ) ).

tff(fact_11_Says__imp__knows,axiom,
    ! [Evsa: list(event),X1: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X1),set(event,Evsa))
     => member(msg,X1,knows(Aa,Evsa)) ) ).

tff(fact_12_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y2: msg] :
      ( ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) )
     => ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) ) ) ).

tff(fact_13_analz_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( member(msg,X1,H)
     => member(msg,X1,analz(H)) ) ).

tff(fact_14_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_15_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_16_parts_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( member(msg,X1,H)
     => member(msg,X1,parts(H)) ) ).

tff(fact_17_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_18_msg_Osimps_I7_J,axiom,
    ! [Msg5: msg,Nat3: nat,Msg4: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg4) = crypt(Nat3,Msg5) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_19_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_20_event_Osimps_I1_J,axiom,
    ! [Msg5: msg,Agent23: agent,Agent13: agent,Msg4: msg,Agent22: agent,Agent12: agent] :
      ( ( says(Agent12,Agent22,Msg4) = says(Agent13,Agent23,Msg5) )
    <=> ( ( Agent12 = Agent13 )
        & ( Agent22 = Agent23 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_21_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = rev(A,Ys) )
    <=> ( Xs = Ys ) ) ).

tff(fact_22_analz__analzD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( member(msg,X1,analz(analz(H)))
     => member(msg,X1,analz(H)) ) ).

tff(fact_23_parts__partsD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( member(msg,X1,parts(parts(H)))
     => member(msg,X1,parts(H)) ) ).

tff(fact_24_rev__swap,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = Ys )
    <=> ( Xs = rev(A,Ys) ) ) ).

tff(fact_25_rev__rev__ident,axiom,
    ! [A: $tType,Xs1: list(A)] : ( rev(A,rev(A,Xs1)) = Xs1 ) ).

tff(fact_26_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( member(msg,C1,analz(H))
     => member(msg,C1,parts(H)) ) ).

tff(fact_27_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( ~ member(msg,C1,parts(H))
     => ~ member(msg,C1,analz(H)) ) ).

tff(fact_28_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_29_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_30_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),X1: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X1),parts(H))
     => member(msg,X1,parts(H)) ) ).

tff(fact_31_parts_OBody,axiom,
    ! [H: fun(msg,bool),X1: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X1),parts(H))
     => member(msg,X1,parts(H)) ) ).

tff(fact_32_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_33_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_34_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != nonce(Nat1) ) ).

tff(fact_35_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_36_set__takeWhileD,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool),X2: A] :
      ( member(A,X2,set(A,takeWhile(A,P1,Xs)))
     => ( member(A,X2,set(A,Xs))
        & pp(aa(A,bool,P1,X2)) ) ) ).

tff(fact_37_takeWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K: list(A),L: list(A)] :
      ( ( L = K )
     => ( ! [X3: A] :
            ( member(A,X3,set(A,L))
           => ( pp(aa(A,bool,P1,X3))
            <=> pp(aa(A,bool,Q1,X3)) ) )
       => ( takeWhile(A,P1,L) = takeWhile(A,Q1,K) ) ) ) ).

tff(fact_38_Spy__see__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),parts(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_39_Spy__analz__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),analz(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_40_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),X1: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent,S: agent] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,X1))))),set(event,Evsa))
     => member(msg,X1,parts(knows(spy,Evsa))) ) ).

tff(fact_41_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),X1: msg,Aa: agent] :
      ( member(event,notes(Aa,X1),set(event,Evsa))
     => ( member(agent,Aa,bad)
       => member(msg,X1,knows(spy,Evsa)) ) ) ).

tff(fact_42_parts__spies__takeWhile__mono,axiom,
    ! [Evsa: list(event),P1: fun(event,bool)] : ord_less_eq(fun(msg,bool),parts(knows(spy,takeWhile(event,P1,Evsa))),parts(knows(spy,Evsa))) ).

tff(fact_43_parts__spies__evs__revD2,axiom,
    ! [Evsa: list(event)] : ord_less_eq(fun(msg,bool),parts(knows(spy,rev(event,Evsa))),parts(knows(spy,Evsa))) ).

tff(fact_44_Gets__imp__knows__agents,axiom,
    ! [Evsa: list(event),X1: msg,Aa: agent] :
      ( ( Aa != spy )
     => ( member(event,gets(Aa,X1),set(event,Evsa))
       => member(msg,X1,knows(Aa,Evsa)) ) ) ).

tff(fact_45_synthp_OCrypt,axiom,
    ! [Ka: nat,X1: msg,H: fun(msg,bool)] :
      ( synthp(H,X1)
     => ( pp(aa(msg,bool,H,key(Ka)))
       => synthp(H,crypt(Ka,X1)) ) ) ).

tff(fact_46_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg13: msg,Msg22: msg,Msg12: msg] :
      ( ( mPair(Msg12,Msg22) = mPair(Msg13,Msg23) )
    <=> ( ( Msg12 = Msg13 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_47_event_Osimps_I3_J,axiom,
    ! [Msg5: msg,Agent2: agent,Msg4: msg,Agent1: agent] :
      ( ( notes(Agent1,Msg4) = notes(Agent2,Msg5) )
    <=> ( ( Agent1 = Agent2 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_48_event_Osimps_I2_J,axiom,
    ! [Msg5: msg,Agent2: agent,Msg4: msg,Agent1: agent] :
      ( ( gets(Agent1,Msg4) = gets(Agent2,Msg5) )
    <=> ( ( Agent1 = Agent2 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_49_synthp_OInj,axiom,
    ! [X1: msg,H: fun(msg,bool)] :
      ( pp(aa(msg,bool,H,X1))
     => synthp(H,X1) ) ).

tff(fact_50_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),analz(H))
     => ~ ( member(msg,X1,analz(H))
         => ~ member(msg,Y2,analz(H)) ) ) ).

tff(fact_51_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),parts(H))
     => ~ ( member(msg,X1,parts(H))
         => ~ member(msg,Y2,parts(H)) ) ) ).

tff(fact_52_analz__subset__iff,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),analz(G),analz(H))
    <=> ord_less_eq(fun(msg,bool),G,analz(H)) ) ).

tff(fact_53_parts__subset__iff,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),parts(G),parts(H))
    <=> ord_less_eq(fun(msg,bool),G,parts(H)) ) ).

tff(fact_54_synthp_OMPair,axiom,
    ! [Y2: msg,X1: msg,H: fun(msg,bool)] :
      ( synthp(H,X1)
     => ( synthp(H,Y2)
       => synthp(H,mPair(X1,Y2)) ) ) ).

tff(fact_55_event_Osimps_I8_J,axiom,
    ! [Msg: msg,Agent3: agent,Msg3: msg,Agent: agent] : ( gets(Agent,Msg3) != notes(Agent3,Msg) ) ).

tff(fact_56_event_Osimps_I9_J,axiom,
    ! [Msg3: msg,Agent: agent,Msg: msg,Agent3: agent] : ( notes(Agent3,Msg) != gets(Agent,Msg3) ) ).

tff(fact_57_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),analz(H))
     => member(msg,X1,analz(H)) ) ).

tff(fact_58_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),analz(H))
     => member(msg,Y2,analz(H)) ) ).

tff(fact_59_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_60_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != key(Nat1) ) ).

tff(fact_61_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),parts(H))
     => member(msg,X1,parts(H)) ) ).

tff(fact_62_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y2: msg,X1: msg] :
      ( member(msg,mPair(X1,Y2),parts(H))
     => member(msg,Y2,parts(H)) ) ).

tff(fact_63_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg11: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg11,Msg21) ) ).

tff(fact_64_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != crypt(Nat,Msg) ) ).

tff(fact_65_msg_Osimps_I34_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_66_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != nonce(Nat1) ) ).

tff(fact_67_analz__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,analz(H)) ).

tff(fact_68_analz__mono,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G,H)
     => ord_less_eq(fun(msg,bool),analz(G),analz(H)) ) ).

tff(fact_69_analz__trans,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),X1: msg] :
      ( member(msg,X1,analz(G))
     => ( ord_less_eq(fun(msg,bool),G,analz(H))
       => member(msg,X1,analz(H)) ) ) ).

tff(fact_70_parts__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,parts(H)) ).

tff(fact_71_parts__mono,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G,H)
     => ord_less_eq(fun(msg,bool),parts(G),parts(H)) ) ).

tff(fact_72_parts__trans,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),X1: msg] :
      ( member(msg,X1,parts(G))
     => ( ord_less_eq(fun(msg,bool),G,parts(H))
       => member(msg,X1,parts(H)) ) ) ).

tff(fact_73_event_Osimps_I7_J,axiom,
    ! [Msg3: msg,Agent21: agent,Agent11: agent,Msg: msg,Agent3: agent] : ( notes(Agent3,Msg) != says(Agent11,Agent21,Msg3) ) ).

tff(fact_74_event_Osimps_I6_J,axiom,
    ! [Msg: msg,Agent3: agent,Msg3: msg,Agent21: agent,Agent11: agent] : ( says(Agent11,Agent21,Msg3) != notes(Agent3,Msg) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X2: A] :
      ( member(A,X2,Aa)
    <=> pp(aa(A,bool,Aa,X2)) ) ).

tff(fact_76_event_Osimps_I5_J,axiom,
    ! [Msg3: msg,Agent21: agent,Agent11: agent,Msg: msg,Agent3: agent] : ( gets(Agent3,Msg) != says(Agent11,Agent21,Msg3) ) ).

tff(fact_77_event_Osimps_I4_J,axiom,
    ! [Msg: msg,Agent3: agent,Msg3: msg,Agent21: agent,Agent11: agent] : ( says(Agent11,Agent21,Msg3) != gets(Agent3,Msg) ) ).

tff(fact_78_analz__subset__parts,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),analz(H),parts(H)) ).

tff(fact_79_Notes__imp__knows,axiom,
    ! [Evsa: list(event),X1: msg,Aa: agent] :
      ( member(event,notes(Aa,X1),set(event,Evsa))
     => member(msg,X1,knows(Aa,Evsa)) ) ).

tff(fact_80_spies__takeWhile,axiom,
    ! [Evsa: list(event),P1: fun(event,bool)] : ord_less_eq(fun(msg,bool),knows(spy,takeWhile(event,P1,Evsa)),knows(spy,Evsa)) ).

tff(fact_81_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent] :
      ( member(agent,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_82_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_83_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),X1: msg,Aa: agent] :
      ( member(msg,crypt(shrK(Aa),X1),analz(knows(spy,Evsa)))
     => ( member(agent,Aa,bad)
       => member(msg,X1,analz(knows(spy,Evsa))) ) ) ).

tff(fact_84_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),X1: msg,Aa: agent] :
      ( member(msg,crypt(shrK(Aa),X1),analz(H))
     => ( member(msg,key(shrK(Aa)),analz(H))
       => member(msg,X1,analz(H)) ) ) ).

tff(fact_85_shrK__injective,axiom,
    ! [Y1: agent,X2: agent] :
      ( ( shrK(X2) = shrK(Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_86_B__trusts__NS5,axiom,
    ! [Aa: agent,Ba: agent,Evsa: list(event),NB: nat,Ka: nat] :
      ( member(msg,crypt(Ka,mPair(nonce(NB),nonce(NB))),parts(knows(spy,Evsa)))
     => ( member(msg,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa))),parts(knows(spy,Evsa)))
       => ( ! [NA1: msg,NB1: msg] : ~ member(event,notes(spy,mPair(NA1,mPair(NB1,key(Ka)))),set(event,Evsa))
         => ( ~ member(agent,Aa,bad)
           => ( ~ member(agent,Ba,bad)
             => ( member(list(event),Evsa,nS_Sha254967238shared)
               => member(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NB),nonce(NB)))),set(event,Evsa)) ) ) ) ) ) ) ).

tff(fact_87_A__trusts__NS4,axiom,
    ! [X1: msg,Ba: agent,NA: msg,Aa: agent,Evsa: list(event),NB: nat,Ka: nat] :
      ( member(msg,crypt(Ka,nonce(NB)),parts(knows(spy,Evsa)))
     => ( member(msg,crypt(shrK(Aa),mPair(NA,mPair(agent1(Ba),mPair(key(Ka),X1)))),parts(knows(spy,Evsa)))
       => ( ! [NB1: msg] : ~ member(event,notes(spy,mPair(NA,mPair(NB1,key(Ka)))),set(event,Evsa))
         => ( ~ member(agent,Aa,bad)
           => ( ~ member(agent,Ba,bad)
             => ( member(list(event),Evsa,nS_Sha254967238shared)
               => member(event,says(Ba,Aa,crypt(Ka,nonce(NB))),set(event,Evsa)) ) ) ) ) ) ) ).

tff(fact_88_msg_Osimps_I1_J,axiom,
    ! [Agent2: agent,Agent1: agent] :
      ( ( agent1(Agent1) = agent1(Agent2) )
    <=> ( Agent1 = Agent2 ) ) ).

tff(fact_89_synthp_OAgent,axiom,
    ! [Agt: agent,H: fun(msg,bool)] : synthp(H,agent1(Agt)) ).

tff(fact_90_msg_Osimps_I11_J,axiom,
    ! [Agent: agent,Nat: nat] : ( nonce(Nat) != agent1(Agent) ) ).

tff(fact_91_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent: agent] : ( agent1(Agent) != nonce(Nat) ) ).

tff(fact_92_msg_Osimps_I19_J,axiom,
    ! [Agent: agent,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent1(Agent) ) ).

tff(fact_93_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent: agent] : ( agent1(Agent) != crypt(Nat,Msg) ) ).

tff(fact_94_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent: agent] : ( agent1(Agent) != key(Nat) ) ).

tff(fact_95_msg_Osimps_I13_J,axiom,
    ! [Agent: agent,Nat: nat] : ( key(Nat) != agent1(Agent) ) ).

tff(fact_96_msg_Osimps_I17_J,axiom,
    ! [Agent: agent,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != agent1(Agent) ) ).

tff(fact_97_msg_Osimps_I16_J,axiom,
    ! [Msg2: msg,Msg1: msg,Agent: agent] : ( agent1(Agent) != mPair(Msg1,Msg2) ) ).

tff(fact_98_B__trusts__NS5__lemma,axiom,
    ! [NB: nat,NA: msg,Aa: agent,Ka: nat,Evsa: list(event),Ba: agent] :
      ( ~ member(agent,Ba,bad)
     => ( member(list(event),Evsa,nS_Sha254967238shared)
       => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
         => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NA,mPair(agent1(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))))))),set(event,Evsa))
           => ( member(msg,crypt(Ka,mPair(nonce(NB),nonce(NB))),parts(knows(spy,Evsa)))
             => member(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NB),nonce(NB)))),set(event,Evsa)) ) ) ) ) ) ).

tff(fact_99_A__trusts__NS4__lemma,axiom,
    ! [NB: nat,X1: msg,Ba: agent,NA: msg,Aa: agent,Ka: nat,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NA,mPair(agent1(Ba),mPair(key(Ka),X1))))),set(event,Evsa))
         => ( member(msg,crypt(Ka,nonce(NB)),parts(knows(spy,Evsa)))
           => member(event,says(Ba,Aa,crypt(Ka,nonce(NB))),set(event,Evsa)) ) ) ) ) ).

%----Helper facts (8)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    ~ member(msg,key(k),analz(knows(spy,evs))) ).

tff(conj_1,hypothesis,
    ~ member(agent,a,bad) ).

tff(conj_2,hypothesis,
    ~ member(agent,b,bad) ).

tff(conj_3,hypothesis,
    member(list(event),evs,nS_Sha254967238shared) ).

tff(conj_4,conjecture,
    ( ~ member(event,says(b,a,crypt(k,nonce(nb))),set(event,evs))
    | ~ member(msg,crypt(k,nonce(nb)),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(b,a,crypt(k,nonce(nb))))),rev(event,evs))))) ) ).

%------------------------------------------------------------------------------
