%------------------------------------------------------------------------------
% File     : SWV783_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 429
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_429 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  176 (  54 unt;  46 typ;   0 def)
%            Number of atoms       :  251 ( 101 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  173 (  52   ~;  21   |;  18   &)
%                                         (  24 <=>;  58  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   37 (  23   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-4 aty)
%            Number of functors    :   38 (  38 usr;  14 con; 0-5 aty)
%            Number of variables   :  354 ( 326   !;   5   ?; 354   :)
%                                         (  23  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:51
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (39)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_OIssues,type,
    nS_Sha512322870Issues: ( agent * agent * msg * list(event) ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Public_OshrK,type,
    shrK: agent > nat ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_Nb,type,
    nb: nat ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_spies__evs__rev,axiom,
    ! [Evsa: list(event)] : ( knows(spy,Evsa) = knows(spy,rev(event,Evsa)) ) ).

tff(fact_1_Issues__def,axiom,
    ! [Evsa: list(event),X4: msg,Ba: agent,Aa: agent] :
      ( nS_Sha512322870Issues(Aa,Ba,X4,Evsa)
    <=> ? [Y4: msg] :
          ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,Y4)),set(event,Evsa)))
          & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(insert(msg,Y4,bot_bot(fun(msg,bool))))))
          & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(Aa,Ba,Y4))),rev(event,Evsa)))))) ) ) ).

tff(fact_2_parts__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( parts(insert(msg,nonce(N),H)) = insert(msg,nonce(N),parts(H)) ) ).

tff(fact_3_analz__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( analz(insert(msg,nonce(N),H)) = insert(msg,nonce(N),analz(H)) ) ).

tff(fact_4_parts__insert__Crypt,axiom,
    ! [H: fun(msg,bool),X4: msg,Ka: nat] : ( parts(insert(msg,crypt(Ka,X4),H)) = insert(msg,crypt(Ka,X4),parts(insert(msg,X4,H))) ) ).

tff(fact_5_parts__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( parts(insert(msg,key(Ka),H)) = insert(msg,key(Ka),parts(H)) ) ).

tff(fact_6_singleton__conv2,axiom,
    ! [A: $tType,A1: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_7_singleton__conv,axiom,
    ! [A: $tType,A1: A] : ( collect(A,combc(A,A,bool,fequal(A),A1)) = insert(A,A1,bot_bot(fun(A,bool))) ) ).

tff(fact_8_Spy__in__bad,axiom,
    pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),spy),bad)) ).

tff(fact_9_parts__empty,axiom,
    parts(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_10_parts__emptyE,axiom,
    ! [X4: msg] : ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(bot_bot(fun(msg,bool))))) ).

tff(fact_11_analz__empty,axiom,
    analz(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_12_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),X4: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X4)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(knows(spy,Evsa)))) ) ).

tff(fact_13_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_14_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_15_empty__iff,axiom,
    ! [A: $tType,C1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C1),bot_bot(fun(A,bool)))) ).

tff(fact_16_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_17_all__not__in__conv,axiom,
    ! [A: $tType,Aa: fun(A,bool)] :
      ( ! [X5: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),Aa))
    <=> ( Aa = bot_bot(fun(A,bool)) ) ) ).

tff(fact_18_insertCI,axiom,
    ! [A: $tType,B1: A,Ba: fun(A,bool),A1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Ba))
       => ( A1 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Ba))) ) ).

tff(fact_19_insertE,axiom,
    ! [A: $tType,Aa: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Aa)))
     => ( ( A1 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ) ).

tff(fact_20_insert__iff,axiom,
    ! [A: $tType,Aa: fun(A,bool),B1: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Aa)))
    <=> ( ( A1 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ) ).

tff(fact_21_insert__absorb2,axiom,
    ! [A: $tType,Aa: fun(A,bool),X3: A] : ( insert(A,X3,insert(A,X3,Aa)) = insert(A,X3,Aa) ) ).

tff(fact_22_analz_OInj,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H))) ) ).

tff(fact_23_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_24_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_25_parts_OInj,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) ) ).

tff(fact_26_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_27_msg_Osimps_I7_J,axiom,
    ! [Msg2: msg,Nat3: nat,Msg1: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg1) = crypt(Nat3,Msg2) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg1 = Msg2 ) ) ) ).

tff(fact_28_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_29_event_Osimps_I1_J,axiom,
    ! [Msg2: msg,Agent21: agent,Agent11: agent,Msg1: msg,Agent2: agent,Agent1: agent] :
      ( ( says(Agent1,Agent2,Msg1) = says(Agent11,Agent21,Msg2) )
    <=> ( ( Agent1 = Agent11 )
        & ( Agent2 = Agent21 )
        & ( Msg1 = Msg2 ) ) ) ).

tff(fact_30_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H)))
        | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) ) ).

tff(fact_31_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H)))
        & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H))) ) ).

tff(fact_32_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_33_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_34_equals0D,axiom,
    ! [A: $tType,A1: A,Aa: fun(A,bool)] :
      ( ( Aa = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa)) ) ).

tff(fact_35_ex__in__conv,axiom,
    ! [A: $tType,Aa: fun(A,bool)] :
      ( ? [X5: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),Aa))
    <=> ( Aa != bot_bot(fun(A,bool)) ) ) ).

tff(fact_36_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_37_insert__absorb,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa))
     => ( insert(A,A1,Aa) = Aa ) ) ).

tff(fact_38_insertI2,axiom,
    ! [A: $tType,B1: A,Ba: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Ba))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B1,Ba))) ) ).

tff(fact_39_insert__eq__iff,axiom,
    ! [A: $tType,Ba: fun(A,bool),B1: A,Aa: fun(A,bool),A1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),Ba))
       => ( ( insert(A,A1,Aa) = insert(A,B1,Ba) )
        <=> ( ( ( A1 = B1 )
             => ( Aa = Ba ) )
            & ( ( A1 != B1 )
             => ? [C2: fun(A,bool)] :
                  ( ( Aa = insert(A,B1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C2))
                  & ( Ba = insert(A,A1,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),C2)) ) ) ) ) ) ) ).

tff(fact_40_insert__ident,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),Ba))
       => ( ( insert(A,X3,Aa) = insert(A,X3,Ba) )
        <=> ( Aa = Ba ) ) ) ) ).

tff(fact_41_insert__code,axiom,
    ! [A: $tType,X3: A,Aa: fun(A,bool),Y3: A] :
      ( pp(aa(A,bool,insert(A,Y3,Aa),X3))
    <=> ( ( Y3 = X3 )
        | pp(aa(A,bool,Aa,X3)) ) ) ).

tff(fact_42_insert__commute,axiom,
    ! [A: $tType,Aa: fun(A,bool),Y3: A,X3: A] : ( insert(A,X3,insert(A,Y3,Aa)) = insert(A,Y3,insert(A,X3,Aa)) ) ).

tff(fact_43_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A1: A] : ( insert(A,A1,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A1))),P1)) ) ).

tff(fact_44_insert__compr,axiom,
    ! [A: $tType,Ba: fun(A,bool),A1: A] : ( insert(A,A1,Ba) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A1)),combc(A,fun(A,bool),bool,member(A),Ba))) ) ).

tff(fact_45_insertI1,axiom,
    ! [A: $tType,Ba: fun(A,bool),A1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,A1,Ba))) ).

tff(fact_46_analz__analzD,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(analz(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H))) ) ).

tff(fact_47_parts__partsD,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(parts(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) ) ).

tff(fact_48_insert__compr__raw,axiom,
    ! [A: $tType,X2: A,Xa: fun(A,bool)] : ( insert(A,X2,Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X2)),combc(A,fun(A,bool),bool,member(A),Xa))) ) ).

tff(fact_49_singleton__inject,axiom,
    ! [A: $tType,B1: A,A1: A] :
      ( ( insert(A,A1,bot_bot(fun(A,bool))) = insert(A,B1,bot_bot(fun(A,bool))) )
     => ( A1 = B1 ) ) ).

tff(fact_50_singletonE,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A1,bot_bot(fun(A,bool)))))
     => ( B1 = A1 ) ) ).

tff(fact_51_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C1: A,B1: A,A1: A] :
      ( ( insert(A,A1,insert(A,B1,bot_bot(fun(A,bool)))) = insert(A,C1,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A1 = C1 )
          & ( B1 = D ) )
        | ( ( A1 = D )
          & ( B1 = C1 ) ) ) ) ).

tff(fact_52_singleton__iff,axiom,
    ! [A: $tType,A1: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A1,bot_bot(fun(A,bool)))))
    <=> ( B1 = A1 ) ) ).

tff(fact_53_insert__not__empty,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] : ( insert(A,A1,Aa) != bot_bot(fun(A,bool)) ) ).

tff(fact_54_empty__not__insert,axiom,
    ! [A: $tType,Aa: fun(A,bool),A1: A] : ( bot_bot(fun(A,bool)) != insert(A,A1,Aa) ) ).

tff(fact_55_analz__insert__cong,axiom,
    ! [X4: msg,H1: fun(msg,bool),H: fun(msg,bool)] :
      ( ( analz(H) = analz(H1) )
     => ( analz(insert(msg,X4,H)) = analz(insert(msg,X4,H1)) ) ) ).

tff(fact_56_analz__cut,axiom,
    ! [H: fun(msg,bool),X4: msg,Y2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y2),analz(insert(msg,X4,H))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y2),analz(H))) ) ) ).

tff(fact_57_analz__insert__eq,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(H)))
     => ( analz(insert(msg,X4,H)) = analz(H) ) ) ).

tff(fact_58_analz__insertI,axiom,
    ! [A1: msg,G1: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(G1)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(insert(msg,A1,G1)))) ) ).

tff(fact_59_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(H))) ) ).

tff(fact_60_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C1: msg] :
      ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(H)))
     => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),analz(H))) ) ).

tff(fact_61_parts__cut__eq,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H)))
     => ( parts(insert(msg,X4,H)) = parts(H) ) ) ).

tff(fact_62_parts__insertI,axiom,
    ! [A1: msg,G1: fun(msg,bool),C1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(G1)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C1),parts(insert(msg,A1,G1)))) ) ).

tff(fact_63_msg_Osimps_I43_J,axiom,
    ! [Nat: nat,Msg: msg,Nat1: nat] : ( crypt(Nat1,Msg) != key(Nat) ) ).

tff(fact_64_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat1: nat,Nat: nat] : ( key(Nat) != crypt(Nat1,Msg) ) ).

tff(fact_65_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),X4: msg,Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(Ka,X4)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) ) ).

tff(fact_66_parts_OBody,axiom,
    ! [H: fun(msg,bool),X4: msg,Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(Ka,X4)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H))) ) ).

tff(fact_67_msg_Osimps_I30_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( nonce(Nat) != key(Nat1) ) ).

tff(fact_68_msg_Osimps_I31_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( key(Nat1) != nonce(Nat) ) ).

tff(fact_69_msg_Osimps_I37_J,axiom,
    ! [Nat: nat,Msg: msg,Nat1: nat] : ( crypt(Nat1,Msg) != nonce(Nat) ) ).

tff(fact_70_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat1: nat,Nat: nat] : ( nonce(Nat) != crypt(Nat1,Msg) ) ).

tff(fact_71_Collect__conv__if,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_72_Collect__conv__if2,axiom,
    ! [A: $tType,A1: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = insert(A,A1,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A1))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A1)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_73_pushes_I6_J,axiom,
    ! [Aa: fun(msg,bool),K1: msg,X4: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,crypt(X4,K1),Aa)) = insert(msg,crypt(X4,K1),insert(msg,key(Ka),Aa)) ) ).

tff(fact_74_pushes_I2_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,key(Ka),Aa)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),Aa))
    <=> pp(aa(A,bool,Aa,X3)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y2: msg] :
      ( ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y2),analz(knows(spy,Evsa))))
       => pp(Q1) )
     => ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y2),analz(knows(spy,Evsa))))
       => pp(Q1) ) ) ).

tff(fact_79_pushes_I9_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: msg,X4: nat] : ( insert(msg,crypt(X4,Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,crypt(X4,Ka),Aa)) ) ).

tff(fact_80_Says__imp__knows,axiom,
    ! [Evsa: list(event),X4: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X4)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),knows(Aa,Evsa))) ) ).

tff(fact_81_Says__imp__spies,axiom,
    ! [Evsa: list(event),X4: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X4)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),knows(spy,Evsa))) ) ).

tff(fact_82_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X4: msg,Ba: agent,Aa: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(Aa,Ba,X4)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(knows(spy,Evsa)))) ) ).

tff(fact_83_takeWhile__eq__all__conv,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool)] :
      ( ( takeWhile(A,P1,Xs) = Xs )
    <=> ! [X5: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),set(A,Xs)))
         => pp(aa(A,bool,P1,X5)) ) ) ).

tff(fact_84_set__rev,axiom,
    ! [A: $tType,Xs: list(A)] : ( set(A,rev(A,Xs)) = set(A,Xs) ) ).

tff(fact_85_parts__singleton,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(H)))
     => ? [X1: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
          & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(insert(msg,X1,bot_bot(fun(msg,bool)))))) ) ) ).

tff(fact_86_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = rev(A,Ys) )
    <=> ( Xs = Ys ) ) ).

tff(fact_87_parts__insert__eq__I,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ! [X1: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(insert(msg,X4,H))))
         => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),insert(msg,X4,parts(H)))) )
     => ( parts(insert(msg,X4,H)) = insert(msg,X4,parts(H)) ) ) ).

tff(fact_88_analz__insert__eq__I,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ! [X1: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(insert(msg,X4,H))))
         => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),insert(msg,X4,analz(H)))) )
     => ( analz(insert(msg,X4,H)) = insert(msg,X4,analz(H)) ) ) ).

tff(fact_89_the__elem__eq,axiom,
    ! [A: $tType,X3: A] : ( the_elem(A,insert(A,X3,bot_bot(fun(A,bool)))) = X3 ) ).

tff(fact_90_set__takeWhileD,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,takeWhile(A,P1,Xs))))
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),set(A,Xs)))
        & pp(aa(A,bool,P1,X3)) ) ) ).

tff(fact_91_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_92_rev__rev__ident,axiom,
    ! [A: $tType,Xs1: list(A)] : ( rev(A,rev(A,Xs1)) = Xs1 ) ).

tff(fact_93_rev__swap,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = Ys )
    <=> ( Xs = rev(A,Ys) ) ) ).

tff(fact_94_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X2: A] : ( aa(A,B,bot_bot(fun(A,B)),X2) = bot_bot(B) ) ) ).

tff(fact_95_takeWhile__cong,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool),K: list(A),L: list(A)] :
      ( ( L = K )
     => ( ! [X1: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X1),set(A,L)))
           => ( pp(aa(A,bool,P1,X1))
            <=> pp(aa(A,bool,Q1,X1)) ) )
       => ( takeWhile(A,P1,L) = takeWhile(A,Q1,K) ) ) ) ).

tff(fact_96_Spy__see__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),Evsa),nS_Sha254967238shared))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(Aa))),parts(knows(spy,Evsa))))
      <=> pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),Aa),bad)) ) ) ).

tff(fact_97_Spy__analz__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),Evsa),nS_Sha254967238shared))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(Aa))),analz(knows(spy,Evsa))))
      <=> pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),Aa),bad)) ) ) ).

tff(fact_98_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent] :
      ( pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),Aa),bad))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(Aa))),knows(spy,Evsa))) ) ).

tff(fact_99_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(Aa))),knows(Aa,Evsa))) ).

%----Arities (3)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y1: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y1))
      | ( X = Y1 ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y1: A,X: A] :
      ( ( X != Y1 )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y1)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (6)
tff(conj_0,hypothesis,
    pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(b,a,crypt(k,nonce(nb)))),set(event,evs))) ).

tff(conj_1,hypothesis,
    ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),analz(knows(spy,evs)))) ).

tff(conj_2,hypothesis,
    ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),a),bad)) ).

tff(conj_3,hypothesis,
    ~ pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),b),bad)) ).

tff(conj_4,hypothesis,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),evs),nS_Sha254967238shared)) ).

tff(conj_5,conjecture,
    ? [Y: msg] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(b,a,Y)),set(event,evs)))
      & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(k,nonce(nb))),parts(insert(msg,Y,bot_bot(fun(msg,bool))))))
      & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(k,nonce(nb))),parts(knows(spy,takeWhile(event,combb(bool,bool,event,fNot,combc(event,event,bool,fequal(event),says(b,a,Y))),rev(event,evs)))))) ) ).

%------------------------------------------------------------------------------
