%------------------------------------------------------------------------------
% File     : SWV779_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 405
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_405 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  153 (  48 unt;  37 typ;   0 def)
%            Number of atoms       :  236 ( 136 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  158 (  38   ~;  17   |;  20   &)
%                                         (  34 <=>;  49  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   39 (  22   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   28 (  28 usr;   7 con; 0-5 aty)
%            Number of variables   :  419 ( 385   !;   6   ?; 419   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:17
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Oevent_OGets,type,
    gets: ( agent * msg ) > event ).

tff(sy_c_Event_OinitState,type,
    initState: agent > fun(msg,bool) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

%----Relevant facts (100)
tff(fact_0_rev_Osimps_I1_J,axiom,
    ! [A: $tType] : ( rev(A,nil(A)) = nil(A) ) ).

tff(fact_1_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( nil(A) = rev(A,Xs1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_2_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rev(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_3_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = rev(A,Ys1) )
    <=> ( Xs1 = Ys1 ) ) ).

tff(fact_4_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list(A)] : ( rev(A,rev(A,Xs)) = Xs ) ).

tff(fact_5_rev__swap,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = Ys1 )
    <=> ( Xs1 = rev(A,Ys1) ) ) ).

tff(fact_6_knows__Nil,axiom,
    ! [A1: agent] : ( knows(A1,nil(event)) = initState(A1) ) ).

tff(fact_7_ns__sharedp_ONil,axiom,
    nS_Sha993195050haredp(nil(event)) ).

tff(fact_8_ns__shared_ONil,axiom,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),nil(event)),nS_Sha254967238shared)) ).

tff(fact_9_rev__singleton__conv,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)) )
    <=> ( Xs1 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)) ) ) ).

tff(fact_10_singleton__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)) = rev(A,Xs1) )
    <=> ( Xs1 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A)) ) ) ).

tff(fact_11_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_12_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List3) )
    <=> ( ( A2 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_13_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_14_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_15_ns__sharedp__ns__shared__eq,axiom,
    ! [X1: list(event)] :
      ( nS_Sha993195050haredp(X1)
    <=> pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),X1),nS_Sha254967238shared)) ) ).

tff(fact_16_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A2),List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List2) ) ).

tff(fact_17_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List1) != nil(A) ) ).

tff(fact_18_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List1) ) ).

tff(fact_19_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List) ) ) ).

tff(fact_20_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs1 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys4) ) ) ).

tff(fact_21_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert1(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_22_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_23_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_24_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys3: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys3)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),splice(A,Xs,Ys3))) ) ).

tff(fact_25_knows__Spy__Gets,axiom,
    ! [Evsa: list(event),X4: msg,A1: agent] : ( knows(spy,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),gets(A1,X4)),Evsa)) = knows(spy,Evsa) ) ).

tff(fact_26_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( ! [X3: A] : pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),nil(A))))
       => ( ! [X3: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs2))
               => pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),Xs2))) ) )
         => pp(aa(list(A),bool,P1,Xs1)) ) ) ) ).

tff(fact_27_rev__foldl__cons,axiom,
    ! [A: $tType,Xs1: list(A)] : ( rev(A,Xs1) = foldl(list(A),A,combc(A,list(A),list(A),cons(A)),nil(A),Xs1) ) ).

tff(fact_28_event_Osimps_I2_J,axiom,
    ! [Msg1: msg,Agent1: agent,Msg: msg,Agent: agent] :
      ( ( gets(Agent,Msg) = gets(Agent1,Msg1) )
    <=> ( ( Agent = Agent1 )
        & ( Msg = Msg1 ) ) ) ).

tff(fact_29_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X2: B,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X2),Xs1)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A2),X2),Xs1) ) ).

tff(fact_30_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,nil(B)) = A2 ) ).

tff(fact_31_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys3: list(A)] : ( splice(A,nil(A),Ys3) = Ys3 ) ).

tff(fact_32_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_33_foldl__rev,axiom,
    ! [B: $tType,A: $tType,Xs1: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y2: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X3)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y2)),X3) )
     => ( foldl(B,A,F,S,rev(A,Xs1)) = foldl(B,A,F,S,Xs1) ) ) ).

tff(fact_34_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1))
    <=> ( ( pp(aa(A,bool,P1,X2))
         => list_all(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combb(bool,bool,A,fNot,P1)),aa(A,fun(A,bool),fequal(A),X2)),Xs1) )
        & ( ~ pp(aa(A,bool,P1,X2))
         => list_ex1(A,P1,Xs1) ) ) ) ).

tff(fact_35_spies__Gets__rev,axiom,
    ! [X4: msg,A1: agent,Evsa: list(event)] : ( knows(spy,append(event,Evsa,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),gets(A1,X4)),nil(event)))) = knows(spy,Evsa) ) ).

tff(fact_36_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs1: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y2: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X3)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y2)),X3) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs1)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X2),Xs1) ) ) ).

tff(fact_37_knows__Spy__subset__knows__Spy__Gets,axiom,
    ! [X4: msg,A1: agent,Evsa: list(event)] : ord_less_eq(fun(msg,bool),knows(spy,Evsa),knows(spy,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),gets(A1,X4)),Evsa))) ).

tff(fact_38_knows__Gets,axiom,
    ! [Evsa: list(event),X4: msg,A1: agent] :
      ( ( A1 != spy )
     => ( knows(A1,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),gets(A1,X4)),Evsa)) = insert(msg,X4,knows(A1,Evsa)) ) ) ).

tff(fact_39_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs1: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Xs1) = append(A,Zs,Xs1) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_40_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Xs1,Zs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_41_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys3: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys3),Zs1) = append(A,Xs,append(A,Ys3,Zs1)) ) ).

tff(fact_42_append__Cons,axiom,
    ! [A: $tType,Ys3: list(A),Xs: list(A),X: A] : ( append(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs),Ys3) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),append(A,Xs,Ys3)) ) ).

tff(fact_43_append__self__conv2,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Ys1 )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_44_append__self__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Xs1 )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_45_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = nil(A) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_46_self__append__conv2,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( Ys1 = append(A,Xs1,Ys1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_47_self__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( Xs1 = append(A,Xs1,Ys1) )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_48_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( nil(A) = append(A,Xs1,Ys1) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_49_rev__append,axiom,
    ! [A: $tType,Ys3: list(A),Xs: list(A)] : ( rev(A,append(A,Xs,Ys3)) = append(A,rev(A,Ys3),rev(A,Xs)) ) ).

tff(fact_50_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),Xs1: list(B),A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,append(B,Xs1,Ys1)) = foldl(A,B,F,foldl(A,B,F,A2,Xs1),Ys1) ) ).

tff(fact_51_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,P1: fun(A,bool)] :
      ( list_all(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1))
    <=> ( pp(aa(A,bool,P1,X2))
        & list_all(A,P1,Xs1) ) ) ).

tff(fact_52_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_53_list__all__append,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),P1: fun(A,bool)] :
      ( list_all(A,P1,append(A,Xs1,Ys1))
    <=> ( list_all(A,P1,Xs1)
        & list_all(A,P1,Ys1) ) ) ).

tff(fact_54_list__all__rev,axiom,
    ! [A: $tType,Xs1: list(A),P1: fun(A,bool)] :
      ( list_all(A,P1,rev(A,Xs1))
    <=> list_all(A,P1,Xs1) ) ).

tff(fact_55_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys1: list(A),X2: A,Xs1: list(A)] :
      ( ( append(A,Xs1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A))) = append(A,Ys1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),nil(A))) )
    <=> ( ( Xs1 = Ys1 )
        & ( X2 = Y1 ) ) ) ).

tff(fact_56_rev__eq__Cons__iff,axiom,
    ! [A: $tType,Ys1: list(A),Y1: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys1) )
    <=> ( Xs1 = append(A,rev(A,Ys1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),nil(A))) ) ) ).

tff(fact_57_rev_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( rev(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs)) = append(A,rev(A,Xs),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A))) ) ).

tff(fact_58_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys3: list(A),Zs1: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs1 )
     => ( ( Ys3 = append(A,Xs11,Us1) )
       => ( append(A,Xs,Ys3) = append(A,Zs1,Us1) ) ) ) ).

tff(fact_59_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Zs,Ts) )
    <=> ? [Us: list(A)] :
          ( ( ( Xs1 = append(A,Zs,Us) )
            & ( append(A,Us,Ys1) = Ts ) )
          | ( ( append(A,Xs1,Us) = Zs )
            & ( Ys1 = append(A,Us,Ts) ) ) ) ) ).

tff(fact_60_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys3: list(A),Xs11: list(A),X: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs11) = Ys3 )
     => ( ( Xs = append(A,Xs11,Zs1) )
       => ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) = append(A,Ys3,Zs1) ) ) ) ).

tff(fact_61_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys3: list(A),Xs: list(A)] :
      ( ( Xs = Ys3 )
     => ( Xs = append(A,nil(A),Ys3) ) ) ).

tff(fact_62_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_63_append__Nil,axiom,
    ! [A: $tType,Ys3: list(A)] : ( append(A,nil(A),Ys3) = Ys3 ) ).

tff(fact_64_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,Zs: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Zs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( Zs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1) ) )
        | ? [Ys2: list(A)] :
            ( ( Ys1 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Ys2) )
            & ( append(A,Ys2,Zs) = Xs1 ) ) ) ) ).

tff(fact_65_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A),X2: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1) = append(A,Ys1,Zs) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs1) = Zs ) )
        | ? [Ys2: list(A)] :
            ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Ys2) = Ys1 )
            & ( Xs1 = append(A,Ys2,Zs) ) ) ) ) ).

tff(fact_66_knows__subset__knows__Cons,axiom,
    ! [E: event,Evsa: list(event),A1: agent] : ord_less_eq(fun(msg,bool),knows(A1,Evsa),knows(A1,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),E),Evsa))) ).

tff(fact_67_initState__subset__knows,axiom,
    ! [Evsa: list(event),A1: agent] : ord_less_eq(fun(msg,bool),initState(A1),knows(A1,Evsa)) ).

tff(fact_68_knows__subset__knows__Gets,axiom,
    ! [X4: msg,A3: agent,Evsa: list(event),A1: agent] : ord_less_eq(fun(msg,bool),knows(A1,Evsa),knows(A1,aa(list(event),list(event),aa(event,fun(list(event),list(event)),cons(event),gets(A3,X4)),Evsa))) ).

tff(fact_69_insert__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( ord_less_eq(fun(A,bool),insert(A,X2,A1),B1)
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
        & ord_less_eq(fun(A,bool),A1,B1) ) ) ).

tff(fact_70_rev__induct,axiom,
    ! [A: $tType,Xs1: list(A),P1: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P1,nil(A)))
     => ( ! [X3: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P1,Xs2))
           => pp(aa(list(A),bool,P1,append(A,Xs2,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X3),nil(A))))) )
       => pp(aa(list(A),bool,P1,Xs1)) ) ) ).

tff(fact_71_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys: list(A),Y2: A] : ( Xs != append(A,Ys,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),nil(A))) ) ) ).

tff(fact_72_subsetD,axiom,
    ! [A: $tType,C3: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),B1)) ) ) ).

tff(fact_73_equalityI,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( ord_less_eq(fun(A,bool),B1,A1)
       => ( A1 = B1 ) ) ) ).

tff(fact_74_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B1))
       => ( A2 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,B1))) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,A1)))
     => ( ( A2 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_79_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B2: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,A1)))
    <=> ( ( A2 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_80_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,A1)) = insert(A,X2,A1) ) ).

tff(fact_81_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,A1) = A1 ) ) ).

tff(fact_82_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B2,B1))) ) ).

tff(fact_83_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,A2,A1) = insert(A,B2,B1) )
        <=> ( ( ( A2 = B2 )
             => ( A1 = B1 ) )
            & ( ( A2 != B2 )
             => ? [C2: fun(A,bool)] :
                  ( ( A1 = insert(A,B2,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C2))
                  & ( B1 = insert(A,A2,C2) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C2)) ) ) ) ) ) ) ).

tff(fact_84_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
       => ( ( insert(A,X2,A1) = insert(A,X2,B1) )
        <=> ( A1 = B1 ) ) ) ) ).

tff(fact_85_insert__code,axiom,
    ! [A: $tType,X2: A,A1: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,A1),X2))
    <=> ( ( Y1 = X2 )
        | pp(aa(A,bool,A1,X2)) ) ) ).

tff(fact_86_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y1: A,X2: A] : ( insert(A,X2,insert(A,Y1,A1)) = insert(A,Y1,insert(A,X2,A1)) ) ).

tff(fact_87_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( insert(A,A2,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,aa(A,fun(A,bool),combc(A,A,bool,fequal(A)),A2))),P1)) ) ).

tff(fact_88_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: A] : ( insert(A,A2,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,aa(A,fun(A,bool),combc(A,A,bool,fequal(A)),A2)),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),B1))) ) ).

tff(fact_89_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,A2,B1))) ).

tff(fact_90_equalityE,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ~ ( ord_less_eq(fun(A,bool),A1,B1)
         => ~ ord_less_eq(fun(A,bool),B1,A1) ) ) ).

tff(fact_91_subset__trans,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( ord_less_eq(fun(A,bool),B1,C1)
       => ord_less_eq(fun(A,bool),A1,C1) ) ) ).

tff(fact_92_set__mp,axiom,
    ! [A: $tType,X2: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1)) ) ) ).

tff(fact_93_set__rev__mp,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
     => ( ord_less_eq(fun(A,bool),A1,B1)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1)) ) ) ).

tff(fact_94_in__mono,axiom,
    ! [A: $tType,X2: A,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A1,B1)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1)) ) ) ).

tff(fact_95_equalityD2,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),B1,A1) ) ).

tff(fact_96_equalityD1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
     => ord_less_eq(fun(A,bool),A1,B1) ) ).

tff(fact_97_set__eq__subset,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool)] :
      ( ( A1 = B1 )
    <=> ( ord_less_eq(fun(A,bool),A1,B1)
        & ord_less_eq(fun(A,bool),B1,A1) ) ) ).

tff(fact_98_subset__refl,axiom,
    ! [A: $tType,A1: fun(A,bool)] : ord_less_eq(fun(A,bool),A1,A1) ).

tff(fact_99_insert__compr__raw,axiom,
    ! [A: $tType,X1: A,Xa: fun(A,bool)] : ( insert(A,X1,Xa) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,aa(A,fun(A,bool),combc(A,A,bool,fequal(A)),X1)),aa(fun(A,bool),fun(A,bool),combc(A,fun(A,bool),bool,member(A)),Xa))) ) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    knows(spy,nil(event)) = knows(spy,rev(event,nil(event))) ).

%------------------------------------------------------------------------------
