%------------------------------------------------------------------------------
% File     : SWV771_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 387
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_387 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  47 unt;  42 typ;   0 def)
%            Number of atoms       :  264 ( 127 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  180 (  39   ~;  18   |;  21   &)
%                                         (  28 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   39 (  21   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;  10 con; 0-5 aty)
%            Number of variables   :  443 ( 407   !;   6   ?; 443   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:56
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Oevent_OGets,type,
    gets: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_OinitState,type,
    initState: agent > fun(msg,bool) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oinsert,type,
    insert1: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_knows__Spy__Says,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] : ( knows(spy,cons(event,says(Aa,Ba,Xa),Evsa)) = insert(msg,Xa,knows(spy,Evsa)) ) ).

tff(fact_1_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys3: list(A),X2: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X2,nil(A))) = append(A,Ys3,cons(A,Y1,nil(A))) )
    <=> ( ( Xs1 = Ys3 )
        & ( X2 = Y1 ) ) ) ).

tff(fact_2_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( nil(A) = append(A,Xs1,Ys3) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys3 = nil(A) ) ) ) ).

tff(fact_3_self__append__conv,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( Xs1 = append(A,Xs1,Ys3) )
    <=> ( Ys3 = nil(A) ) ) ).

tff(fact_4_self__append__conv2,axiom,
    ! [A: $tType,Xs1: list(A),Ys3: list(A)] :
      ( ( Ys3 = append(A,Xs1,Ys3) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_5_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys3) = nil(A) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys3 = nil(A) ) ) ) ).

tff(fact_6_append__self__conv,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys3) = Xs1 )
    <=> ( Ys3 = nil(A) ) ) ).

tff(fact_7_append__self__conv2,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys3) = Ys3 )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_8_append__Cons,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),X: A] : ( append(A,cons(A,X,Xs),Ys) = cons(A,X,append(A,Xs,Ys)) ) ).

tff(fact_9_knows__Says,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] : ( knows(Aa,cons(event,says(Aa,Ba,Xa),Evsa)) = insert(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_10_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,Zs1: list(A),Ys3: list(A)] :
      ( ( append(A,Ys3,Zs1) = cons(A,X2,Xs1) )
    <=> ( ( ( Ys3 = nil(A) )
          & ( Zs1 = cons(A,X2,Xs1) ) )
        | ? [Ys4: list(A)] :
            ( ( Ys3 = cons(A,X2,Ys4) )
            & ( append(A,Ys4,Zs1) = Xs1 ) ) ) ) ).

tff(fact_11_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs1: list(A),Ys3: list(A),Xs1: list(A),X2: A] :
      ( ( cons(A,X2,Xs1) = append(A,Ys3,Zs1) )
    <=> ( ( ( Ys3 = nil(A) )
          & ( cons(A,X2,Xs1) = Zs1 ) )
        | ? [Ys4: list(A)] :
            ( ( cons(A,X2,Ys4) = Ys3 )
            & ( Xs1 = append(A,Ys4,Zs1) ) ) ) ) ).

tff(fact_12_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),A3: A] :
      ( ( cons(A,A3,List) = cons(A,A6,List3) )
    <=> ( ( A3 = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_13_append__same__eq,axiom,
    ! [A: $tType,Zs1: list(A),Xs1: list(A),Ys3: list(A)] :
      ( ( append(A,Ys3,Xs1) = append(A,Zs1,Xs1) )
    <=> ( Ys3 = Zs1 ) ) ).

tff(fact_14_same__append__eq,axiom,
    ! [A: $tType,Zs1: list(A),Ys3: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys3) = append(A,Xs1,Zs1) )
    <=> ( Ys3 = Zs1 ) ) ).

tff(fact_15_append__assoc,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys),Zs) = append(A,Xs,append(A,Ys,Zs)) ) ).

tff(fact_16_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent,Agent12: agent,Msg2: msg,Agent21: agent,Agent11: agent] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_17_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_18_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_19_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys: list(A),Zs: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs )
     => ( ( Ys = append(A,Xs11,Us1) )
       => ( append(A,Xs,Ys) = append(A,Zs,Us1) ) ) ) ).

tff(fact_20_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs1: list(A),Ys3: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys3) = append(A,Zs1,Ts) )
    <=> ? [Us: list(A)] :
          ( ( ( Xs1 = append(A,Zs1,Us) )
            & ( append(A,Us,Ys3) = Ts ) )
          | ( ( append(A,Xs1,Us) = Zs1 )
            & ( Ys3 = append(A,Us,Ts) ) ) ) ) ).

tff(fact_21_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_22_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_23_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys: list(A),Xs11: list(A),X: A] :
      ( ( cons(A,X,Xs11) = Ys )
     => ( ( Xs = append(A,Xs11,Zs) )
       => ( cons(A,X,Xs) = append(A,Ys,Zs) ) ) ) ).

tff(fact_24_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = Ys )
     => ( Xs = append(A,nil(A),Ys) ) ) ).

tff(fact_25_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_26_append__Nil,axiom,
    ! [A: $tType,Ys: list(A)] : ( append(A,nil(A),Ys) = Ys ) ).

tff(fact_27_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys2: list(A),Y3: A] : ( Xs != append(A,Ys2,cons(A,Y3,nil(A))) ) ) ).

tff(fact_28_rev__induct,axiom,
    ! [A: $tType,Xs1: list(A),P1: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P1,nil(A)))
     => ( ! [X3: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P1,Xs2))
           => pp(aa(list(A),bool,P1,append(A,Xs2,cons(A,X3,nil(A))))) )
       => pp(aa(list(A),bool,P1,Xs1)) ) ) ).

tff(fact_29_insertCI,axiom,
    ! [A: $tType,B2: A,Ba: fun(A,bool),A3: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Ba))
       => ( A3 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B2,Ba))) ) ).

tff(fact_30_insertE,axiom,
    ! [A: $tType,Aa: fun(A,bool),B2: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B2,Aa)))
     => ( ( A3 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Aa)) ) ) ).

tff(fact_31_insert__iff,axiom,
    ! [A: $tType,Aa: fun(A,bool),B2: A,A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B2,Aa)))
    <=> ( ( A3 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Aa)) ) ) ).

tff(fact_32_insert__absorb2,axiom,
    ! [A: $tType,Aa: fun(A,bool),X2: A] : ( insert(A,X2,insert(A,X2,Aa)) = insert(A,X2,Aa) ) ).

tff(fact_33_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List1: list(A)] : ( Y != cons(A,A4,List1) ) ) ).

tff(fact_34_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xs1 = cons(A,Y2,Ys1) ) ) ).

tff(fact_35_knows__Spy__Gets,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] : ( knows(spy,cons(event,gets(Aa,Xa),Evsa)) = knows(spy,Evsa) ) ).

tff(fact_36_event_Osimps_I2_J,axiom,
    ! [Msg3: msg,Agent4: agent,Msg2: msg,Agent3: agent] :
      ( ( gets(Agent3,Msg2) = gets(Agent4,Msg3) )
    <=> ( ( Agent3 = Agent4 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_37_event_Osimps_I5_J,axiom,
    ! [Msg: msg,Agent2: agent,Agent1: agent,Msg1: msg,Agent: agent] : ( gets(Agent,Msg1) != says(Agent1,Agent2,Msg) ) ).

tff(fact_38_event_Osimps_I4_J,axiom,
    ! [Msg1: msg,Agent: agent,Msg: msg,Agent2: agent,Agent1: agent] : ( says(Agent1,Agent2,Msg) != gets(Agent,Msg1) ) ).

tff(fact_39_insertI1,axiom,
    ! [A: $tType,Ba: fun(A,bool),A3: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,A3,Ba))) ).

tff(fact_40_insert__compr,axiom,
    ! [A: $tType,Ba: fun(A,bool),A3: A] : ( insert(A,A3,Ba) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A3)),combc(A,fun(A,bool),bool,member(A),Ba))) ) ).

tff(fact_41_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A3: A] : ( insert(A,A3,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A3))),P1)) ) ).

tff(fact_42_insert__commute,axiom,
    ! [A: $tType,Aa: fun(A,bool),Y1: A,X2: A] : ( insert(A,X2,insert(A,Y1,Aa)) = insert(A,Y1,insert(A,X2,Aa)) ) ).

tff(fact_43_insert__code,axiom,
    ! [A: $tType,X2: A,Aa: fun(A,bool),Y1: A] :
      ( pp(aa(A,bool,insert(A,Y1,Aa),X2))
    <=> ( ( Y1 = X2 )
        | pp(aa(A,bool,Aa,X2)) ) ) ).

tff(fact_44_insert__ident,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Ba))
       => ( ( insert(A,X2,Aa) = insert(A,X2,Ba) )
        <=> ( Aa = Ba ) ) ) ) ).

tff(fact_45_insert__eq__iff,axiom,
    ! [A: $tType,Ba: fun(A,bool),B2: A,Aa: fun(A,bool),A3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Aa))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),Ba))
       => ( ( insert(A,A3,Aa) = insert(A,B2,Ba) )
        <=> ( ( ( A3 = B2 )
             => ( Aa = Ba ) )
            & ( ( A3 != B2 )
             => ? [C4: fun(A,bool)] :
                  ( ( Aa = insert(A,B2,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C4))
                  & ( Ba = insert(A,A3,C4) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),C4)) ) ) ) ) ) ) ).

tff(fact_46_insertI2,axiom,
    ! [A: $tType,B2: A,Ba: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Ba))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),insert(A,B2,Ba))) ) ).

tff(fact_47_insert__absorb,axiom,
    ! [A: $tType,Aa: fun(A,bool),A3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A3),Aa))
     => ( insert(A,A3,Aa) = Aa ) ) ).

tff(fact_48_knows__Gets,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( ( Aa != spy )
     => ( knows(Aa,cons(event,gets(Aa,Xa),Evsa)) = insert(msg,Xa,knows(Aa,Evsa)) ) ) ).

tff(fact_49_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert1(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_50_knows__Nil,axiom,
    ! [Aa: agent] : ( knows(Aa,nil(event)) = initState(Aa) ) ).

tff(fact_51_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,cons(B,X,Xs)) = append(B,Xs,cons(B,X,nil(B))) ) ) ).

tff(fact_52_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X2: B,F: fun(B,list(A))] : ( maps(B,A,F,cons(B,X2,Xs1)) = append(A,aa(B,list(A),F,X2),maps(B,A,F,Xs1)) ) ).

tff(fact_53_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_54_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rotate1(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_55_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_56_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_57_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_58_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_59_knows__Spy__subset__knows__Spy__Gets,axiom,
    ! [Xa: msg,Aa: agent,Evsa: list(event)] : ord_less_eq(fun(msg,bool),knows(spy,Evsa),knows(spy,cons(event,gets(Aa,Xa),Evsa))) ).

tff(fact_60_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_61_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A3,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List) ) ).

tff(fact_62_Set_Oset__insert,axiom,
    ! [A: $tType,Aa: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
     => ~ ! [B3: fun(A,bool)] :
            ( ( Aa = insert(A,X2,B3) )
           => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B3)) ) ) ).

tff(fact_63_subsetD,axiom,
    ! [A: $tType,C3: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),Aa))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C3),Ba)) ) ) ).

tff(fact_64_equalityI,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( ord_less_eq(fun(A,bool),Ba,Aa)
       => ( Aa = Ba ) ) ) ).

tff(fact_65_insert__subset,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X2: A] :
      ( ord_less_eq(fun(A,bool),insert(A,X2,Aa),Ba)
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Ba))
        & ord_less_eq(fun(A,bool),Aa,Ba) ) ) ).

tff(fact_66_insert__mono,axiom,
    ! [A: $tType,A3: A,D: fun(A,bool),C2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),C2,D)
     => ord_less_eq(fun(A,bool),insert(A,A3,C2),insert(A,A3,D)) ) ).

tff(fact_67_subset__insertI2,axiom,
    ! [A: $tType,B2: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ord_less_eq(fun(A,bool),Aa,insert(A,B2,Ba)) ) ).

tff(fact_68_subset__insert,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
     => ( ord_less_eq(fun(A,bool),Aa,insert(A,X2,Ba))
      <=> ord_less_eq(fun(A,bool),Aa,Ba) ) ) ).

tff(fact_69_subset__insertI,axiom,
    ! [A: $tType,A3: A,Ba: fun(A,bool)] : ord_less_eq(fun(A,bool),Ba,insert(A,A3,Ba)) ).

tff(fact_70_subset__refl,axiom,
    ! [A: $tType,Aa: fun(A,bool)] : ord_less_eq(fun(A,bool),Aa,Aa) ).

tff(fact_71_set__eq__subset,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
    <=> ( ord_less_eq(fun(A,bool),Aa,Ba)
        & ord_less_eq(fun(A,bool),Ba,Aa) ) ) ).

tff(fact_72_equalityD1,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ord_less_eq(fun(A,bool),Aa,Ba) ) ).

tff(fact_73_equalityD2,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ord_less_eq(fun(A,bool),Ba,Aa) ) ).

tff(fact_74_in__mono,axiom,
    ! [A: $tType,X2: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Ba)) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
    <=> pp(aa(A,bool,Aa,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_set__rev__mp,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
     => ( ord_less_eq(fun(A,bool),Aa,Ba)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Ba)) ) ) ).

tff(fact_79_set__mp,axiom,
    ! [A: $tType,X2: A,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Aa))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),Ba)) ) ) ).

tff(fact_80_subset__trans,axiom,
    ! [A: $tType,C2: fun(A,bool),Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,Ba)
     => ( ord_less_eq(fun(A,bool),Ba,C2)
       => ord_less_eq(fun(A,bool),Aa,C2) ) ) ).

tff(fact_81_equalityE,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = Ba )
     => ~ ( ord_less_eq(fun(A,bool),Aa,Ba)
         => ~ ord_less_eq(fun(A,bool),Ba,Aa) ) ) ).

tff(fact_82_knows__subset__knows__Cons,axiom,
    ! [E: event,Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),knows(Aa,Evsa),knows(Aa,cons(event,E,Evsa))) ).

tff(fact_83_initState__subset__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),initState(Aa),knows(Aa,Evsa)) ).

tff(fact_84_knows__subset__knows__Says,axiom,
    ! [Xa: msg,Ba: agent,A2: agent,Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),knows(Aa,Evsa),knows(Aa,cons(event,says(A2,Ba,Xa),Evsa))) ).

tff(fact_85_knows__subset__knows__Gets,axiom,
    ! [Xa: msg,A2: agent,Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),knows(Aa,Evsa),knows(Aa,cons(event,gets(A2,Xa),Evsa))) ).

tff(fact_86_knows__Spy__subset__knows__Spy__Says,axiom,
    ! [Xa: msg,Ba: agent,Aa: agent,Evsa: list(event)] : ord_less_eq(fun(msg,bool),knows(spy,Evsa),knows(spy,cons(event,says(Aa,Ba,Xa),Evsa))) ).

tff(fact_87_subsetI,axiom,
    ! [A: $tType,Ba: fun(A,bool),Aa: fun(A,bool)] :
      ( ! [X3: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),Aa))
         => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),Ba)) )
     => ord_less_eq(fun(A,bool),Aa,Ba) ) ).

tff(fact_88_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_89_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_90_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_91_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
        <=> ( ord_less_eq(A,X2,Y1)
            & ord_less_eq(A,Y1,X2) ) ) ) ).

tff(fact_92_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_93_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ( ord_less_eq(A,X2,Y1)
          <=> ( X2 = Y1 ) ) ) ) ).

tff(fact_94_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C1)
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_95_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C1 )
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_96_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_97_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_98_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_99_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X1: A] : ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

%----Arities (7)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    knows(spy,append(event,evs,cons(event,says(a,b,x),nil(event)))) = insert(msg,x,knows(spy,evs)) ).

%------------------------------------------------------------------------------
