%------------------------------------------------------------------------------
% File     : SWV763_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 346
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_346 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  154 (  40 unt;  45 typ;   0 def)
%            Number of atoms       :  249 (  65 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  205 (  65   ~;   7   |;  10   &)
%                                         (  15 <=>; 108  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   31 (  21   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   37 (  37 usr;  19 con; 0-4 aty)
%            Number of variables   :  344 ( 336   !;   3   ?; 344   :)
%                                         (   5  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:53
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A3: $tType] : ( ( A3 * list(A3) ) > list(A3) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A3: $tType] : ( list(A3) > fun(A3,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OkeysFor,type,
    keysFor: fun(msg,bool) > fun(nat,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent1: agent > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Public_OshrK,type,
    shrK: agent > nat ).

tff(sy_c_aa,type,
    aa1: 
      !>[A3: $tType,B1: $tType] : ( ( fun(A3,B1) * A3 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A3: $tType] : ( ( A3 * fun(A3,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_A_H,type,
    a1: agent ).

tff(sy_v_Aa,type,
    aa: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_Ba,type,
    ba: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_KAB,type,
    kab: nat ).

tff(sy_v_NA,type,
    na: msg ).

tff(sy_v_NAa,type,
    nAa: nat ).

tff(sy_v_NB,type,
    nb: nat ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evs2,type,
    evs2: list(event) ).

%----Relevant facts (100)
tff(fact_0_A__trusts__NS4__lemma,axiom,
    ! [NBa: nat,Xa: msg,Ba: agent,NAa: msg,Aa: agent,Ka: nat,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( ~ member(msg,key(Ka),analz(knows(spy,Evsa)))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
         => ( member(msg,crypt(Ka,nonce(NBa)),parts(knows(spy,Evsa)))
           => member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evsa)) ) ) ) ) ).

tff(fact_1_Oops__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,NAa: msg,Aa: agent] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Ka,parts(knows(spy,Evsa))) ) ).

tff(fact_2_unique__session__keys,axiom,
    ! [X3: msg,B: agent,NA1: msg,A2: agent,Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(event,says(server,A2,crypt(shrK(A2),mPair(NA1,mPair(agent1(B),mPair(key(Ka),X3))))),set(event,Evsa))
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ( Aa = A2 )
            & ( NAa = NA1 )
            & ( Ba = B )
            & ( Xa = X3 ) ) ) ) ) ).

tff(fact_3_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent,S: agent] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_4_usedI,axiom,
    ! [Evsa: list(event),C: msg] :
      ( member(msg,C,parts(knows(spy,Evsa)))
     => member(msg,C,used(Evsa)) ) ).

tff(fact_5_shrK__in__used,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(shrK(Aa)),used(Evsa)) ).

tff(fact_6_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_7_sym__shrK,axiom,
    ! [Xa: agent] : member(nat,shrK(Xa),symKeys) ).

tff(fact_8_MPair__used,axiom,
    ! [H: list(event),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),used(H))
     => ~ ( member(msg,Xa,used(H))
         => ~ member(msg,Y,used(H)) ) ) ).

tff(fact_9_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_10_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,analz(knows(spy,Evsa))) ) ).

tff(fact_11_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => ~ ( member(msg,Xa,parts(H))
         => ~ member(msg,Y,parts(H)) ) ) ).

tff(fact_12_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_13_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_14_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        & member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,analz(H)) ) ).

tff(fact_15_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        | member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,parts(H)) ) ).

tff(fact_16_analz_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,analz(H)) ) ).

tff(fact_17_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_18_msg_Osimps_I6_J,axiom,
    ! [Msg24: msg,Msg14: msg,Msg23: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg23) = mPair(Msg14,Msg24) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg23 = Msg24 ) ) ) ).

tff(fact_19_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_20_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,parts(H)) ) ).

tff(fact_21_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_22_msg_Osimps_I7_J,axiom,
    ! [Msg3: msg,Nat3: nat,Msg2: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg2) = crypt(Nat3,Msg3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_23_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_24_msg_Osimps_I1_J,axiom,
    ! [Agent4: agent,Agent3: agent] :
      ( ( agent1(Agent3) = agent1(Agent4) )
    <=> ( Agent3 = Agent4 ) ) ).

tff(fact_25_shrK__injective,axiom,
    ! [Y1: agent,X1: agent] :
      ( ( shrK(X1) = shrK(Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_26_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent,Agent12: agent,Msg2: msg,Agent21: agent,Agent11: agent] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_27_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => ~ ( member(msg,Xa,analz(H))
         => ~ member(msg,Y,analz(H)) ) ) ).

tff(fact_28_analz__analzD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,analz(analz(H)))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_29_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,parts(parts(H)))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_30_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K,symKeys) )
     => ( Ka != K ) ) ).

tff(fact_31_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Y,analz(H)) ) ).

tff(fact_32_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_33_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_34_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_35_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != key(Nat1) ) ).

tff(fact_36_msg_Osimps_I40_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_37_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Y,parts(H)) ) ).

tff(fact_38_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_39_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg22: msg,Msg12: msg] : ( mPair(Msg12,Msg22) != crypt(Nat,Msg) ) ).

tff(fact_40_msg_Osimps_I49_J,axiom,
    ! [Msg22: msg,Msg12: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg12,Msg22) ) ).

tff(fact_41_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_42_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_43_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_44_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_45_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != nonce(Nat1) ) ).

tff(fact_46_msg_Osimps_I34_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_47_msg_Osimps_I17_J,axiom,
    ! [Agent5: agent,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != agent1(Agent5) ) ).

tff(fact_48_msg_Osimps_I16_J,axiom,
    ! [Msg21: msg,Msg11: msg,Agent5: agent] : ( agent1(Agent5) != mPair(Msg11,Msg21) ) ).

tff(fact_49_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_50_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_51_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent5: agent] : ( agent1(Agent5) != key(Nat) ) ).

tff(fact_52_msg_Osimps_I13_J,axiom,
    ! [Agent5: agent,Nat: nat] : ( key(Nat) != agent1(Agent5) ) ).

tff(fact_53_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != nonce(Nat1) ) ).

tff(fact_54_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_55_msg_Osimps_I19_J,axiom,
    ! [Agent5: agent,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent1(Agent5) ) ).

tff(fact_56_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent5: agent] : ( agent1(Agent5) != crypt(Nat,Msg) ) ).

tff(fact_57_msg_Osimps_I11_J,axiom,
    ! [Agent5: agent,Nat: nat] : ( nonce(Nat) != agent1(Agent5) ) ).

tff(fact_58_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent5: agent] : ( agent1(Agent5) != nonce(Nat) ) ).

tff(fact_59_MPair__used__D,axiom,
    ! [H: list(event),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),used(H))
     => ( member(msg,Xa,used(H))
        & member(msg,Y,used(H)) ) ) ).

tff(fact_60_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_61_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_62_analz__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) )
     => ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) ) ) ).

tff(fact_63_shrK__neq,axiom,
    ! [Ba: agent,Evsa: list(event),Ka: nat] :
      ( ~ member(msg,key(Ka),used(Evsa))
     => ( shrK(Ba) != Ka ) ) ).

tff(fact_64_neq__shrK,axiom,
    ! [Ba: agent,Evsa: list(event),S1: nat] :
      ( ~ member(msg,key(S1),used(Evsa))
     => ( S1 != shrK(Ba) ) ) ).

tff(fact_65_Says__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_66_Says__imp__used,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,used(Evsa)) ) ).

tff(fact_67_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Aa: agent] :
      ( member(msg,crypt(shrK(Aa),Xa),analz(H))
     => ( member(msg,key(shrK(Aa)),analz(H))
       => member(msg,Xa,analz(H)) ) ) ).

tff(fact_68_analz__Decrypt_H,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),analz(H))
     => ( member(nat,Ka,symKeys)
       => ( member(msg,key(Ka),analz(H))
         => member(msg,Xa,analz(H)) ) ) ) ).

tff(fact_69_Says__imp__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(spy,Evsa)) ) ).

tff(fact_70_A__trusts__NS2,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa)) ) ) ) ).

tff(fact_71_B__trusts__NS3,axiom,
    ! [Evsa: list(event),Aa: agent,Ka: nat,Ba: agent] :
      ( member(msg,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa))),parts(knows(spy,Evsa)))
     => ( ~ member(agent,Ba,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ? [NA: msg] : member(event,says(server,Aa,crypt(shrK(Aa),mPair(NA,mPair(agent1(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))))))),set(event,Evsa)) ) ) ) ).

tff(fact_72_ns__shared_ONS2,axiom,
    ! [NAa: nat,Ba: agent,Aa: agent,A2: agent,KAB: nat,Evs2: list(event)] :
      ( member(list(event),Evs2,nS_Sha254967238shared)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A2,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs2))
           => member(list(event),cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent1(Aa)))))))),Evs2),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_73_ns__shared_ONS4,axiom,
    ! [Aa: agent,Ba: agent,A2: agent,Ka: nat,NBa: nat,Evs4: list(event)] :
      ( member(list(event),Evs4,nS_Sha254967238shared)
     => ( ~ member(msg,nonce(NBa),used(Evs4))
       => ( member(nat,Ka,symKeys)
         => ( member(event,says(A2,Ba,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))),set(event,Evs4))
           => member(list(event),cons(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),Evs4),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_74_ns__shared_ONS5,axiom,
    ! [Xa: msg,Ba: agent,NAa: nat,S: agent,NBa: nat,Aa: agent,B: agent,Ka: nat,Evs5: list(event)] :
      ( member(list(event),Evs5,nS_Sha254967238shared)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B,Aa,crypt(Ka,nonce(NBa))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => member(list(event),cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),Evs5),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A3: $tType,G: fun(A3,B1),F: fun(A3,B1)] :
      ( ! [X2: A3] : ( aa1(A3,B1,F,X2) = aa1(A3,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A3: $tType,Aa: fun(A3,bool),X1: A3] :
      ( member(A3,X1,Aa)
    <=> pp(aa1(A3,bool,Aa,X1)) ) ).

tff(fact_77_ns__shared_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent,NAa: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,Xa),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_78_new__keys__not__used,axiom,
    ! [Evsa: list(event),Ka: nat] :
      ( ~ member(msg,key(Ka),used(Evsa))
     => ( member(nat,Ka,symKeys)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ~ member(nat,Ka,keysFor(parts(knows(spy,Evsa)))) ) ) ) ).

tff(fact_79_Spy__see__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),parts(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_80_Spy__in__bad,axiom,
    member(agent,spy,bad) ).

tff(fact_81_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent] :
      ( member(agent,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_82_Server__not__bad,axiom,
    ~ member(agent,server,bad) ).

tff(fact_83_Crypt__imp__keysFor,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),H)
     => ( member(nat,Ka,symKeys)
       => member(nat,Ka,keysFor(H)) ) ) ).

tff(fact_84_analz__mono__contra_I1_J,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,says(Aa,Ba,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_85_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( member(msg,crypt(shrK(Aa),Xa),analz(knows(spy,Evsa)))
     => ( member(agent,Aa,bad)
       => member(msg,Xa,analz(knows(spy,Evsa))) ) ) ).

tff(fact_86_ns__shared_ONS1,axiom,
    ! [Ba: agent,Aa: agent,NAa: nat,Evs1: list(event)] :
      ( member(list(event),Evs1,nS_Sha254967238shared)
     => ( ~ member(msg,nonce(NAa),used(Evs1))
       => member(list(event),cons(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),Evs1),nS_Sha254967238shared) ) ) ).

tff(fact_87_Spy__analz__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),analz(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_88_ns__sharedp_ONS2,axiom,
    ! [NAa: nat,Ba: agent,Aa: agent,A2: agent,KAB: nat,Evs2: list(event)] :
      ( nS_Sha993195050haredp(Evs2)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A2,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs2))
           => nS_Sha993195050haredp(cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent1(Aa)))))))),Evs2)) ) ) ) ) ).

tff(fact_89_ns__sharedp_ONS4,axiom,
    ! [Aa: agent,Ba: agent,A2: agent,Ka: nat,NBa: nat,Evs4: list(event)] :
      ( nS_Sha993195050haredp(Evs4)
     => ( ~ member(msg,nonce(NBa),used(Evs4))
       => ( member(nat,Ka,symKeys)
         => ( member(event,says(A2,Ba,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))),set(event,Evs4))
           => nS_Sha993195050haredp(cons(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),Evs4)) ) ) ) ) ).

tff(fact_90_ns__sharedp__ns__shared__eq,axiom,
    ! [X: list(event)] :
      ( nS_Sha993195050haredp(X)
    <=> member(list(event),X,nS_Sha254967238shared) ) ).

tff(fact_91_ns__sharedp_ONS1,axiom,
    ! [Ba: agent,Aa: agent,NAa: nat,Evs1: list(event)] :
      ( nS_Sha993195050haredp(Evs1)
     => ( ~ member(msg,nonce(NAa),used(Evs1))
       => nS_Sha993195050haredp(cons(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),Evs1)) ) ) ).

tff(fact_92_ns__sharedp_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent,NAa: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( nS_Sha993195050haredp(Evs3)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs3))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,Xa),Evs3)) ) ) ) ) ).

tff(fact_93_ns__sharedp_ONS5,axiom,
    ! [Xa: msg,Ba: agent,NAa: nat,S: agent,NBa: nat,Aa: agent,B: agent,Ka: nat,Evs5: list(event)] :
      ( nS_Sha993195050haredp(Evs5)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B,Aa,crypt(Ka,nonce(NBa))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),Evs5)) ) ) ) ) ).

tff(fact_94_ns__sharedp_OOops,axiom,
    ! [Xa: msg,NAa: nat,NBa: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( nS_Sha993195050haredp(Evso)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => nS_Sha993195050haredp(cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NBa),key(Ka)))),Evso)) ) ) ) ).

tff(fact_95_ns__shared_OOops,axiom,
    ! [Xa: msg,NAa: nat,NBa: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NBa),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_96_event_Osimps_I3_J,axiom,
    ! [Msg3: msg,Agent4: agent,Msg2: msg,Agent3: agent] :
      ( ( notes(Agent3,Msg2) = notes(Agent4,Msg3) )
    <=> ( ( Agent3 = Agent4 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_97_event_Osimps_I6_J,axiom,
    ! [Msg: msg,Agent: agent,Msg1: msg,Agent2: agent,Agent1: agent] : ( says(Agent1,Agent2,Msg1) != notes(Agent,Msg) ) ).

tff(fact_98_event_Osimps_I7_J,axiom,
    ! [Msg1: msg,Agent2: agent,Agent1: agent,Msg: msg,Agent: agent] : ( notes(Agent,Msg) != says(Agent1,Agent2,Msg1) ) ).

tff(fact_99_Notes__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    member(list(event),evs2,nS_Sha254967238shared) ).

tff(conj_1,hypothesis,
    ~ member(msg,key(kab),used(evs2)) ).

tff(conj_2,hypothesis,
    member(nat,kab,symKeys) ).

tff(conj_3,hypothesis,
    member(event,says(a1,server,mPair(agent1(aa),mPair(agent1(ba),nonce(nAa)))),set(event,evs2)) ).

tff(conj_4,hypothesis,
    ~ member(msg,key(k),analz(knows(spy,evs2))) ).

tff(conj_5,hypothesis,
    ( member(event,says(server,a,crypt(shrK(a),mPair(na,mPair(agent1(b),mPair(key(k),x))))),set(event,evs2))
   => ( member(msg,crypt(k,nonce(nb)),parts(knows(spy,evs2)))
     => ? [A1: agent] : member(event,says(A1,b,x),set(event,evs2)) ) ) ).

tff(conj_6,conjecture,
    ( ( a != aa )
    | ( na != nonce(nAa) )
    | ( b != ba )
    | ( k != kab )
    | ( x != crypt(shrK(ba),mPair(key(kab),agent1(aa))) )
    | ~ member(msg,crypt(kab,nonce(nb)),parts(knows(spy,evs2)))
    | ? [A: agent] : member(event,says(A,ba,crypt(shrK(ba),mPair(key(kab),agent1(aa)))),set(event,evs2)) ) ).

%------------------------------------------------------------------------------
