%------------------------------------------------------------------------------
% File     : SWV755_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 314
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_314 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  39 unt;  41 typ;   0 def)
%            Number of atoms       :  227 (  59 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  171 (  50   ~;   6   |;  12   &)
%                                         (  22 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   30 (  20   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   33 (  33 usr;  16 con; 0-4 aty)
%            Number of variables   :  308 ( 302   !;   1   ?; 308   :)
%                                         (   5  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:39
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent1: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_c_Event_Obad,type,
    bad: fun(agent1,bool) ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent1 * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent1 * agent1 * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent1 * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent1 ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent1 ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent: agent1 > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_Message_Osynth,type,
    synth: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Public_OshrK,type,
    shrK: agent1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent1 ).

tff(sy_v_B,type,
    b: agent1 ).

tff(sy_v_Ba,type,
    ba: agent1 ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NA,type,
    na: msg ).

tff(sy_v_NB,type,
    nb: nat ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_Xa,type,
    xa: msg ).

tff(sy_v_evsf,type,
    evsf: list(event) ).

%----Relevant facts (100)
tff(fact_0_ns__shared_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent1,NAa: nat,S: agent1,Aa: agent1,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,Xa),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_1_ns__shared_OFake,axiom,
    ! [Ba: agent1,Xa: msg,Evsf: list(event)] :
      ( member(list(event),Evsf,nS_Sha254967238shared)
     => ( member(msg,Xa,synth(analz(knows(spy,Evsf))))
       => member(list(event),cons(event,says(spy,Ba,Xa),Evsf),nS_Sha254967238shared) ) ) ).

tff(fact_2_Oops__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Ka,parts(knows(spy,Evsa))) ) ).

tff(fact_3_unique__session__keys,axiom,
    ! [X3: msg,B: agent1,NA1: msg,A1: agent1,Evsa: list(event),Xa: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(event,says(server,A1,crypt(shrK(A1),mPair(NA1,mPair(agent(B),mPair(key(Ka),X3))))),set(event,Evsa))
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ( Aa = A1 )
            & ( NAa = NA1 )
            & ( Ba = B )
            & ( Xa = X3 ) ) ) ) ) ).

tff(fact_4_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,N1: msg,KA: nat,Aa: agent1,S: agent1] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N1,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_5_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent1] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_6_synth__simps_I5_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),synth(H))
    <=> ( member(msg,crypt(Ka,Xa),H)
        | ( member(msg,Xa,synth(H))
          & member(msg,key(Ka),H) ) ) ) ).

tff(fact_7_synth_OCrypt,axiom,
    ! [Ka: nat,H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,synth(H))
     => ( member(msg,key(Ka),H)
       => member(msg,crypt(Ka,Xa),synth(H)) ) ) ).

tff(fact_8_MPair__synth__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),synth(analz(H)))
    <=> ( member(msg,Xa,synth(analz(H)))
        & member(msg,Y,synth(analz(H))) ) ) ).

tff(fact_9_analz__mono__contra_I1_J,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,says(Aa,Ba,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_10_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_11_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,analz(knows(spy,Evsa))) ) ).

tff(fact_12_synth_OAgent,axiom,
    ! [H: fun(msg,bool),Agt: agent1] : member(msg,agent(Agt),synth(H)) ).

tff(fact_13_Nonce__synth__eq,axiom,
    ! [H: fun(msg,bool),N1: nat] :
      ( member(msg,nonce(N1),synth(H))
    <=> member(msg,nonce(N1),H) ) ).

tff(fact_14_synth__simps_I1_J,axiom,
    ! [H: fun(msg,bool),N: nat] :
      ( member(msg,nonce(N),synth(H))
    <=> member(msg,nonce(N),H) ) ).

tff(fact_15_Key__synth__eq,axiom,
    ! [H: fun(msg,bool),Ka: nat] :
      ( member(msg,key(Ka),synth(H))
    <=> member(msg,key(Ka),H) ) ).

tff(fact_16_synth__simps_I4_J,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),synth(H))
    <=> ( member(msg,mPair(Xa,Y),H)
        | ( member(msg,Xa,synth(H))
          & member(msg,Y,synth(H)) ) ) ) ).

tff(fact_17_analz_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,analz(H)) ) ).

tff(fact_18_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_19_msg_Osimps_I6_J,axiom,
    ! [Msg24: msg,Msg14: msg,Msg23: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg23) = mPair(Msg14,Msg24) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg23 = Msg24 ) ) ) ).

tff(fact_20_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_21_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,parts(H)) ) ).

tff(fact_22_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_23_msg_Osimps_I7_J,axiom,
    ! [Msg3: msg,Nat3: nat,Msg2: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg2) = crypt(Nat3,Msg3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_24_synth_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,synth(H)) ) ).

tff(fact_25_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_26_msg_Osimps_I1_J,axiom,
    ! [Agent4: agent1,Agent3: agent1] :
      ( ( agent(Agent3) = agent(Agent4) )
    <=> ( Agent3 = Agent4 ) ) ).

tff(fact_27_shrK__injective,axiom,
    ! [Y1: agent1,X1: agent1] :
      ( ( shrK(X1) = shrK(Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_28_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent1,Agent12: agent1,Msg2: msg,Agent21: agent1,Agent11: agent1] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_29_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => ~ ( member(msg,Xa,analz(H))
         => ~ member(msg,Y,analz(H)) ) ) ).

tff(fact_30_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        | member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,parts(H)) ) ).

tff(fact_31_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        & member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,analz(H)) ) ).

tff(fact_32_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_33_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_34_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => ~ ( member(msg,Xa,parts(H))
         => ~ member(msg,Y,parts(H)) ) ) ).

tff(fact_35_synth_OMPair,axiom,
    ! [Y: msg,H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,synth(H))
     => ( member(msg,Y,synth(H))
       => member(msg,mPair(Xa,Y),synth(H)) ) ) ).

tff(fact_36_analz__analzD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,analz(analz(H)))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_37_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,parts(parts(H)))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_38_synth__synthD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,synth(synth(H)))
     => member(msg,Xa,synth(H)) ) ).

tff(fact_39_synth__idem,axiom,
    ! [H: fun(msg,bool)] : ( synth(synth(H)) = synth(H) ) ).

tff(fact_40_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Y,analz(H)) ) ).

tff(fact_41_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_42_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_43_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_44_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != key(Nat1) ) ).

tff(fact_45_msg_Osimps_I40_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_46_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Y,parts(H)) ) ).

tff(fact_47_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_48_msg_Osimps_I48_J,axiom,
    ! [Msg1: msg,Nat: nat,Msg22: msg,Msg12: msg] : ( mPair(Msg12,Msg22) != crypt(Nat,Msg1) ) ).

tff(fact_49_msg_Osimps_I49_J,axiom,
    ! [Msg22: msg,Msg12: msg,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != mPair(Msg12,Msg22) ) ).

tff(fact_50_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != key(Nat1) ) ).

tff(fact_51_msg_Osimps_I42_J,axiom,
    ! [Msg1: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg1) ) ).

tff(fact_52_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_53_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_54_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != nonce(Nat1) ) ).

tff(fact_55_msg_Osimps_I17_J,axiom,
    ! [Agent5: agent1,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != agent(Agent5) ) ).

tff(fact_56_msg_Osimps_I34_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_57_msg_Osimps_I16_J,axiom,
    ! [Msg21: msg,Msg11: msg,Agent5: agent1] : ( agent(Agent5) != mPair(Msg11,Msg21) ) ).

tff(fact_58_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_59_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent5: agent1] : ( agent(Agent5) != key(Nat) ) ).

tff(fact_60_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_61_msg_Osimps_I13_J,axiom,
    ! [Agent5: agent1,Nat: nat] : ( key(Nat) != agent(Agent5) ) ).

tff(fact_62_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != nonce(Nat1) ) ).

tff(fact_63_msg_Osimps_I19_J,axiom,
    ! [Agent5: agent1,Msg1: msg,Nat: nat] : ( crypt(Nat,Msg1) != agent(Agent5) ) ).

tff(fact_64_msg_Osimps_I36_J,axiom,
    ! [Msg1: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg1) ) ).

tff(fact_65_msg_Osimps_I18_J,axiom,
    ! [Msg1: msg,Nat: nat,Agent5: agent1] : ( agent(Agent5) != crypt(Nat,Msg1) ) ).

tff(fact_66_Agent__synth,axiom,
    ! [H: fun(msg,bool),Aa: agent1] : member(msg,agent(Aa),synth(H)) ).

tff(fact_67_msg_Osimps_I11_J,axiom,
    ! [Agent5: agent1,Nat: nat] : ( nonce(Nat) != agent(Agent5) ) ).

tff(fact_68_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent5: agent1] : ( agent(Agent5) != nonce(Nat) ) ).

tff(fact_69_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_70_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_71_Crypt__synth__eq,axiom,
    ! [Xa: msg,H: fun(msg,bool),Ka: nat] :
      ( ~ member(msg,key(Ka),H)
     => ( member(msg,crypt(Ka,Xa),synth(H))
      <=> member(msg,crypt(Ka,Xa),H) ) ) ).

tff(fact_72_analz__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) )
     => ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) ) ) ).

tff(fact_73_Says__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_74_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),Xa),analz(H))
     => ( member(msg,key(shrK(Aa)),analz(H))
       => member(msg,Xa,analz(H)) ) ) ).

tff(fact_75_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X2: A] : ( aa(A,B1,F,X2) = aa(A,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X1: A] :
      ( member(A,X1,Aa)
    <=> pp(aa(A,bool,Aa,X1)) ) ).

tff(fact_77_syan__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,synth(analz(knows(spy,Evsa))))
       => pp(Q) )
     => ( ~ member(msg,Y,synth(analz(knows(spy,Evsa))))
       => pp(Q) ) ) ).

tff(fact_78_Says__imp__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(spy,Evsa)) ) ).

tff(fact_79_A__trusts__NS2,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent1,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evsa)) ) ) ) ).

tff(fact_80_ns__sharedp_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent1,NAa: nat,S: agent1,Aa: agent1,Evs3: list(event)] :
      ( nS_Sha993195050haredp(Evs3)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs3))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,Xa),Evs3)) ) ) ) ) ).

tff(fact_81_ns__shared_OOops,axiom,
    ! [Xa: msg,NAa: nat,NBa: nat,Ka: nat,Aa: agent1,Ba: agent1,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NBa))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NBa),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_82_ns__shared_ONS5,axiom,
    ! [Xa: msg,Ba: agent1,NAa: nat,S: agent1,NBa: nat,Aa: agent1,B: agent1,Ka: nat,Evs5: list(event)] :
      ( member(list(event),Evs5,nS_Sha254967238shared)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B,Aa,crypt(Ka,nonce(NBa))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => member(list(event),cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NBa),nonce(NBa)))),Evs5),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_83_B__trusts__NS3,axiom,
    ! [Evsa: list(event),Aa: agent1,Ka: nat,Ba: agent1] :
      ( member(msg,crypt(shrK(Ba),mPair(key(Ka),agent(Aa))),parts(knows(spy,Evsa)))
     => ( ~ member(agent1,Ba,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ? [NA: msg] : member(event,says(server,Aa,crypt(shrK(Aa),mPair(NA,mPair(agent(Ba),mPair(key(Ka),crypt(shrK(Ba),mPair(key(Ka),agent(Aa)))))))),set(event,Evsa)) ) ) ) ).

tff(fact_84_ns__sharedp_OFake,axiom,
    ! [Ba: agent1,Xa: msg,Evsf: list(event)] :
      ( nS_Sha993195050haredp(Evsf)
     => ( member(msg,Xa,synth(analz(knows(spy,Evsf))))
       => nS_Sha993195050haredp(cons(event,says(spy,Ba,Xa),Evsf)) ) ) ).

tff(fact_85_Spy__see__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),parts(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_86_Spy__analz__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),analz(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_87_event_Osimps_I3_J,axiom,
    ! [Msg3: msg,Agent4: agent1,Msg2: msg,Agent3: agent1] :
      ( ( notes(Agent3,Msg2) = notes(Agent4,Msg3) )
    <=> ( ( Agent3 = Agent4 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_88_Spy__in__bad,axiom,
    member(agent1,spy,bad) ).

tff(fact_89_sym__shrK,axiom,
    ! [Xa: agent1] : member(nat,shrK(Xa),symKeys) ).

tff(fact_90_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent1] :
      ( member(agent1,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_91_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K,symKeys) )
     => ( Ka != K ) ) ).

tff(fact_92_event_Osimps_I7_J,axiom,
    ! [Msg: msg,Agent2: agent1,Agent1: agent1,Msg1: msg,Agent: agent1] : ( notes(Agent,Msg1) != says(Agent1,Agent2,Msg) ) ).

tff(fact_93_event_Osimps_I6_J,axiom,
    ! [Msg1: msg,Agent: agent1,Msg: msg,Agent2: agent1,Agent1: agent1] : ( says(Agent1,Agent2,Msg) != notes(Agent,Msg1) ) ).

tff(fact_94_Server__not__bad,axiom,
    ~ member(agent1,server,bad) ).

tff(fact_95_ns__sharedp__ns__shared__eq,axiom,
    ! [X: list(event)] :
      ( nS_Sha993195050haredp(X)
    <=> member(list(event),X,nS_Sha254967238shared) ) ).

tff(fact_96_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => ( member(agent1,Aa,bad)
       => member(msg,Xa,knows(spy,Evsa)) ) ) ).

tff(fact_97_Notes__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_98_analz__Decrypt_H,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),analz(H))
     => ( member(nat,Ka,symKeys)
       => ( member(msg,key(Ka),analz(H))
         => member(msg,Xa,analz(H)) ) ) ) ).

tff(fact_99_analz__mono__contra_I2_J,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,notes(Aa,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    member(list(event),evsf,nS_Sha254967238shared) ).

tff(conj_1,hypothesis,
    ( ~ member(msg,key(k),analz(knows(spy,evsf)))
   => ( member(event,says(server,a,crypt(shrK(a),mPair(na,mPair(agent(b),mPair(key(k),x))))),set(event,evsf))
     => ( member(msg,crypt(k,nonce(nb)),parts(knows(spy,evsf)))
       => member(event,says(b,a,crypt(k,nonce(nb))),set(event,evsf)) ) ) ) ).

tff(conj_2,hypothesis,
    member(msg,xa,synth(analz(knows(spy,evsf)))) ).

tff(conj_3,conjecture,
    ( member(msg,key(k),analz(knows(spy,cons(event,says(spy,ba,xa),evsf))))
    | ~ member(event,says(server,a,crypt(shrK(a),mPair(na,mPair(agent(b),mPair(key(k),x))))),set(event,cons(event,says(spy,ba,xa),evsf)))
    | ~ member(msg,crypt(k,nonce(nb)),parts(knows(spy,cons(event,says(spy,ba,xa),evsf))))
    | member(event,says(b,a,crypt(k,nonce(nb))),set(event,cons(event,says(spy,ba,xa),evsf))) ) ).

%------------------------------------------------------------------------------
