%------------------------------------------------------------------------------
% File     : SWV751_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 289
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_289 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  150 (  47 unt;  42 typ;   0 def)
%            Number of atoms       :  225 (  72 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  179 (  62   ~;   2   |;  16   &)
%                                         (  18 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   6 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   31 (  20   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   33 (  33 usr;  15 con; 0-4 aty)
%            Number of variables   :  340 ( 332   !;   0   ?; 340   :)
%                                         (   8  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:09
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Public_Okeymode,type,
    keymode: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A1: $tType] : ( list(A1) > fun(A1,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent1: agent > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A1: $tType] : A1 ).

tff(sy_c_Public_OpublicKey,type,
    publicKey: keymode > fun(agent,nat) ).

tff(sy_c_Public_OshrK,type,
    shrK: fun(agent,nat) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A1: $tType,B3: $tType] : ( ( fun(A1,B3) * fun(A1,bool) ) > fun(B3,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B3: $tType] : ( ( fun(A1,B3) * A1 ) > B3 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_K_H,type,
    k1: nat ).

tff(sy_v_NA,type,
    na: msg ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_Spy__in__bad,axiom,
    member(agent,spy,bad) ).

tff(fact_1_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => ( member(agent,Aa,bad)
       => member(msg,Xa,knows(spy,Evsa)) ) ) ).

tff(fact_2_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,analz(knows(spy,Evsa))) ) ).

tff(fact_3_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),analz(H))
     => ~ ( member(msg,Xa,analz(H))
         => ~ member(msg,Y1,analz(H)) ) ) ).

tff(fact_4_Says__imp__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(spy,Evsa)) ) ).

tff(fact_5_Notes__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( member(event,notes(Aa,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_6_Says__imp__knows,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,knows(Aa,Evsa)) ) ).

tff(fact_7_secrecy__lemma,axiom,
    ! [Evsa: list(event),Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),crypt(aa(agent,nat,shrK,Ba),mPair(key(Ka),agent1(Aa)))))))),set(event,Evsa))
     => ( ~ member(agent,Aa,bad)
       => ( ~ member(agent,Ba,bad)
         => ( member(list(event),Evsa,nS_Sha254967238shared)
           => ( ! [NB2: msg] : ~ member(event,notes(spy,mPair(NAa,mPair(NB2,key(Ka)))),set(event,Evsa))
             => ~ member(msg,key(Ka),analz(knows(spy,Evsa))) ) ) ) ) ) ).

tff(fact_8_analz__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y1: msg] :
      ( ( ~ member(msg,Y1,analz(knows(spy,Evsa)))
       => pp(Q) )
     => ( ~ member(msg,Y1,analz(knows(spy,Evsa)))
       => pp(Q) ) ) ).

tff(fact_9_event_Osimps_I3_J,axiom,
    ! [Msg5: msg,Agent4: agent,Msg4: msg,Agent3: agent] :
      ( ( notes(Agent3,Msg4) = notes(Agent4,Msg5) )
    <=> ( ( Agent3 = Agent4 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_10_event_Osimps_I1_J,axiom,
    ! [Msg5: msg,Agent22: agent,Agent13: agent,Msg4: msg,Agent21: agent,Agent12: agent] :
      ( ( says(Agent12,Agent21,Msg4) = says(Agent13,Agent22,Msg5) )
    <=> ( ( Agent12 = Agent13 )
        & ( Agent21 = Agent22 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_11_msg_Osimps_I1_J,axiom,
    ! [Agent4: agent,Agent3: agent] :
      ( ( agent1(Agent3) = agent1(Agent4) )
    <=> ( Agent3 = Agent4 ) ) ).

tff(fact_12_analz_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,analz(H)) ) ).

tff(fact_13_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_14_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg13: msg,Msg22: msg,Msg12: msg] :
      ( ( mPair(Msg12,Msg22) = mPair(Msg13,Msg23) )
    <=> ( ( Msg12 = Msg13 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_15_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_16_msg_Osimps_I7_J,axiom,
    ! [Msg5: msg,Nat3: nat,Msg4: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg4) = crypt(Nat3,Msg5) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg4 = Msg5 ) ) ) ).

tff(fact_17_analz__analzD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,analz(analz(H)))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_18_Spy__analz__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(aa(agent,nat,shrK,Aa)),analz(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_19_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),analz(H))
     => member(msg,Y1,analz(H)) ) ).

tff(fact_20_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),analz(H))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_21_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != key(Nat1) ) ).

tff(fact_22_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_23_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != crypt(Nat,Msg) ) ).

tff(fact_24_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg11: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg11,Msg21) ) ).

tff(fact_25_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_26_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_27_msg_Osimps_I17_J,axiom,
    ! [Agent: agent,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != agent1(Agent) ) ).

tff(fact_28_msg_Osimps_I16_J,axiom,
    ! [Msg2: msg,Msg1: msg,Agent: agent] : ( agent1(Agent) != mPair(Msg1,Msg2) ) ).

tff(fact_29_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent: agent] : ( agent1(Agent) != key(Nat) ) ).

tff(fact_30_msg_Osimps_I13_J,axiom,
    ! [Agent: agent,Nat: nat] : ( key(Nat) != agent1(Agent) ) ).

tff(fact_31_msg_Osimps_I19_J,axiom,
    ! [Agent: agent,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent1(Agent) ) ).

tff(fact_32_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent: agent] : ( agent1(Agent) != crypt(Nat,Msg) ) ).

tff(fact_33_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_34_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_35_event_Osimps_I6_J,axiom,
    ! [Msg: msg,Agent1: agent,Msg3: msg,Agent2: agent,Agent11: agent] : ( says(Agent11,Agent2,Msg3) != notes(Agent1,Msg) ) ).

tff(fact_36_event_Osimps_I7_J,axiom,
    ! [Msg3: msg,Agent2: agent,Agent11: agent,Msg: msg,Agent1: agent] : ( notes(Agent1,Msg) != says(Agent11,Agent2,Msg3) ) ).

tff(fact_37_Server__not__bad,axiom,
    ~ member(agent,server,bad) ).

tff(fact_38_unique__session__keys,axiom,
    ! [X4: msg,B1: agent,NA: msg,A3: agent,Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(event,says(server,A3,crypt(aa(agent,nat,shrK,A3),mPair(NA,mPair(agent1(B1),mPair(key(Ka),X4))))),set(event,Evsa))
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ( Aa = A3 )
            & ( NAa = NA )
            & ( Ba = B1 )
            & ( Xa = X4 ) ) ) ) ) ).

tff(fact_39_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent] :
      ( member(agent,Aa,bad)
     => member(msg,key(aa(agent,nat,shrK,Aa)),knows(spy,Evsa)) ) ).

tff(fact_40_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(aa(agent,nat,shrK,Aa)),knows(Aa,Evsa)) ).

tff(fact_41_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent] :
      ( member(msg,crypt(aa(agent,nat,shrK,Aa),Xa),analz(knows(spy,Evsa)))
     => ( member(agent,Aa,bad)
       => member(msg,Xa,analz(knows(spy,Evsa))) ) ) ).

tff(fact_42_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Aa: agent] :
      ( member(msg,crypt(aa(agent,nat,shrK,Aa),Xa),analz(H))
     => ( member(msg,key(aa(agent,nat,shrK,Aa)),analz(H))
       => member(msg,Xa,analz(H)) ) ) ).

tff(fact_43_A__trusts__NS2,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(msg,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa)) ) ) ) ).

tff(fact_44_shrK__injective,axiom,
    ! [Y2: agent,X1: agent] :
      ( ( aa(agent,nat,shrK,X1) = aa(agent,nat,shrK,Y2) )
    <=> ( X1 = Y2 ) ) ).

tff(fact_45_Oops__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,NAa: msg,Aa: agent] :
      ( member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Ka,parts(knows(spy,Evsa))) ) ).

tff(fact_46_Spy__see__shrK,axiom,
    ! [Aa: agent,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(aa(agent,nat,shrK,Aa)),parts(knows(spy,Evsa)))
      <=> member(agent,Aa,bad) ) ) ).

tff(fact_47_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,Ba: msg,N: msg,KA: nat,Aa: agent,S: agent] :
      ( member(event,says(S,Aa,crypt(KA,mPair(N,mPair(Ba,mPair(Ka,Xa))))),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_48_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_49_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,parts(H)) ) ).

tff(fact_50_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_51_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_52_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        & member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,analz(H)) ) ).

tff(fact_53_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        | member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,parts(H)) ) ).

tff(fact_54_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),parts(H))
     => ~ ( member(msg,Xa,parts(H))
         => ~ member(msg,Y1,parts(H)) ) ) ).

tff(fact_55_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,parts(parts(H)))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_56_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_57_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_58_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_59_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y1),parts(H))
     => member(msg,Y1,parts(H)) ) ).

tff(fact_60_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_61_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_62_Says__imp__parts__knows__Spy,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,Xa),set(event,Evsa))
     => member(msg,Xa,parts(knows(spy,Evsa))) ) ).

tff(fact_63_analz__trivial,axiom,
    ! [H: fun(msg,bool)] :
      ( ! [X3: msg,Y: msg] : ~ member(msg,mPair(X3,Y),H)
     => ( ! [X3: msg,K: nat] : ~ member(msg,crypt(K,X3),H)
       => ( analz(H) = H ) ) ) ).

tff(fact_64_ns__shared_OOops,axiom,
    ! [Xa: msg,NAa: nat,NB1: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB1))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NB1),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_65_analz__spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent,B: keymode] : member(msg,key(aa(agent,nat,publicKey(B),Aa)),analz(knows(spy,Evsa))) ).

tff(fact_66_cert__A__form,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: msg,Aa: agent] :
      ( member(msg,crypt(aa(agent,nat,shrK,Aa),mPair(NAa,mPair(agent1(Ba),mPair(key(Ka),Xa)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ~ member(nat,Ka,image(agent,nat,shrK,top_top(fun(agent,bool))))
            & ( Xa = crypt(aa(agent,nat,shrK,Ba),mPair(key(Ka),agent1(Aa))) ) ) ) ) ) ).

tff(fact_67_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_68_publicKey__inject,axiom,
    ! [A3: agent,C: keymode,Aa: agent,B: keymode] :
      ( ( aa(agent,nat,publicKey(B),Aa) = aa(agent,nat,publicKey(C),A3) )
    <=> ( ( B = C )
        & ( Aa = A3 ) ) ) ).

tff(fact_69_shrK__image__eq,axiom,
    ! [AA: fun(agent,bool),X1: agent] :
      ( member(nat,aa(agent,nat,shrK,X1),image(agent,nat,shrK,AA))
    <=> member(agent,X1,AA) ) ).

tff(fact_70_publicKey__image__eq,axiom,
    ! [AA: fun(agent,bool),C: keymode,X1: agent,B: keymode] :
      ( member(nat,aa(agent,nat,publicKey(B),X1),image(agent,nat,publicKey(C),AA))
    <=> ( ( B = C )
        & member(agent,X1,AA) ) ) ).

tff(fact_71_spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent,B: keymode] : member(msg,key(aa(agent,nat,publicKey(B),Aa)),knows(spy,Evsa)) ).

tff(fact_72_shrK__notin__image__publicKey,axiom,
    ! [AA: fun(agent,bool),B: keymode,X1: agent] : ~ member(nat,aa(agent,nat,shrK,X1),image(agent,nat,publicKey(B),AA)) ).

tff(fact_73_publicKey__notin__image__shrK,axiom,
    ! [AA: fun(agent,bool),X1: agent,B: keymode] : ~ member(nat,aa(agent,nat,publicKey(B),X1),image(agent,nat,shrK,AA)) ).

tff(fact_74_injective__publicKey,axiom,
    ! [A2: agent,C2: keymode,A: agent,B2: keymode] :
      ( ( aa(agent,nat,publicKey(B2),A) = aa(agent,nat,publicKey(C2),A2) )
     => ( ( B2 = C2 )
        & ( A = A2 ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B3: $tType,A1: $tType,G: fun(A1,B3),F: fun(A1,B3)] :
      ( ! [X2: A1] : ( aa(A1,B3,F,X2) = aa(A1,B3,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A1: $tType,Aa: fun(A1,bool),X1: A1] :
      ( member(A1,X1,Aa)
    <=> pp(aa(A1,bool,Aa,X1)) ) ).

tff(fact_77_shrK__neq__pubK,axiom,
    ! [A: agent,C1: agent,B2: keymode] : ( aa(agent,nat,publicKey(B2),C1) != aa(agent,nat,shrK,A) ) ).

tff(fact_78_pubK__neq__shrK,axiom,
    ! [C1: agent,B2: keymode,A: agent] : ( aa(agent,nat,shrK,A) != aa(agent,nat,publicKey(B2),C1) ) ).

tff(fact_79_msg_Osimps_I34_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_80_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != nonce(Nat1) ) ).

tff(fact_81_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_82_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_83_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_84_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != nonce(Nat1) ) ).

tff(fact_85_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent: agent] : ( agent1(Agent) != nonce(Nat) ) ).

tff(fact_86_msg_Osimps_I11_J,axiom,
    ! [Agent: agent,Nat: nat] : ( nonce(Nat) != agent1(Agent) ) ).

tff(fact_87_Says__S__message__form,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,NAa: nat,Aa: agent,S: agent] :
      ( member(event,says(S,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(list(event),Evsa,nS_Sha254967238shared)
       => ( ( ~ member(nat,Ka,image(agent,nat,shrK,top_top(fun(agent,bool))))
            & ( Xa = crypt(aa(agent,nat,shrK,Ba),mPair(key(Ka),agent1(Aa))) ) )
          | member(msg,Xa,analz(knows(spy,Evsa))) ) ) ) ).

tff(fact_88_analz__mono__contra_I1_J,axiom,
    ! [Evsa: list(event),Xa: msg,Ba: agent,Aa: agent,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,says(Aa,Ba,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_89_analz__mono__contra_I2_J,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,notes(Aa,Xa),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_90_ns__shared_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent,NAa: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,Xa),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_91_Says__Server__message__form,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,Ba: agent,N: msg,K_a: nat,Aa: agent] :
      ( member(event,says(server,Aa,crypt(K_a,mPair(N,mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evsa))
     => ( member(list(event),Evsa,nS_Sha254967238shared)
       => ( ~ member(nat,Ka,image(agent,nat,shrK,top_top(fun(agent,bool))))
          & ( Xa = crypt(aa(agent,nat,shrK,Ba),mPair(key(Ka),agent1(Aa))) )
          & ( K_a = aa(agent,nat,shrK,Aa) ) ) ) ) ).

tff(fact_92_ns__sharedp_OOops,axiom,
    ! [Xa: msg,NAa: nat,NB1: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( nS_Sha993195050haredp(Evso)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB1))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evso))
         => nS_Sha993195050haredp(cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NB1),key(Ka)))),Evso)) ) ) ) ).

tff(fact_93_ns__sharedp_ONS3,axiom,
    ! [Xa: msg,Ka: nat,Ba: agent,NAa: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( nS_Sha993195050haredp(Evs3)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NAa)))),set(event,Evs3))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,Xa),Evs3)) ) ) ) ) ).

tff(fact_94_ns__shared_ONS5,axiom,
    ! [Xa: msg,Ba: agent,NAa: nat,S: agent,NB1: nat,Aa: agent,B1: agent,Ka: nat,Evs5: list(event)] :
      ( member(list(event),Evs5,nS_Sha254967238shared)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B1,Aa,crypt(Ka,nonce(NB1))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(aa(agent,nat,shrK,Aa),mPair(nonce(NAa),mPair(agent1(Ba),mPair(key(Ka),Xa))))),set(event,Evs5))
           => member(list(event),cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NB1),nonce(NB1)))),Evs5),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_95_sym__shrK,axiom,
    ! [Xa: agent] : member(nat,aa(agent,nat,shrK,Xa),symKeys) ).

tff(fact_96_not__symKeys__pubK,axiom,
    ! [Aa: agent,B: keymode] : ~ member(nat,aa(agent,nat,publicKey(B),Aa),symKeys) ).

tff(fact_97_symKeys__neq__imp__neq,axiom,
    ! [K_a: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K_a,symKeys) )
     => ( Ka != K_a ) ) ).

tff(fact_98_ns__sharedp__ns__shared__eq,axiom,
    ! [X: list(event)] :
      ( nS_Sha993195050haredp(X)
    <=> member(list(event),X,nS_Sha254967238shared) ) ).

tff(fact_99_analz__Decrypt_H,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),analz(H))
     => ( member(nat,Ka,symKeys)
       => ( member(msg,key(Ka),analz(H))
         => member(msg,Xa,analz(H)) ) ) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (6)
tff(conj_0,hypothesis,
    member(event,says(server,a,crypt(k1,mPair(na,mPair(agent1(b),mPair(key(k),x))))),set(event,evs)) ).

tff(conj_1,hypothesis,
    ! [NB: msg] : ~ member(event,notes(spy,mPair(na,mPair(NB,key(k)))),set(event,evs)) ).

tff(conj_2,hypothesis,
    ~ member(agent,a,bad) ).

tff(conj_3,hypothesis,
    ~ member(agent,b,bad) ).

tff(conj_4,hypothesis,
    member(list(event),evs,nS_Sha254967238shared) ).

tff(conj_5,conjecture,
    ~ member(msg,key(k),analz(knows(spy,evs))) ).

%------------------------------------------------------------------------------
