%------------------------------------------------------------------------------
% File     : SWV747_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 271
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_271 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  45 unt;  39 typ;   0 def)
%            Number of atoms       :  217 (  66 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  152 (  43   ~;   5   |;  14   &)
%                                         (  20 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   17 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   32 (  21   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   31 (  31 usr;  13 con; 0-4 aty)
%            Number of variables   :  302 ( 295   !;   1   ?; 302   :)
%                                         (   6  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:10
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent1: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_c_Event_Obad,type,
    bad: fun(agent1,bool) ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent1 * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent1 * agent1 * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent1 * list(event) ) > fun(msg,bool) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A1: $tType] : ( list(A1) > fun(A1,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent1 ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent1 ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent: agent1 > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Osynth,type,
    synth: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Public_OshrK,type,
    shrK: agent1 > nat ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > fun(A1,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B1: $tType] : ( ( fun(A1,B1) * A1 ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent1 ).

tff(sy_v_B,type,
    b: agent1 ).

tff(sy_v_Ba,type,
    ba: agent1 ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NA,type,
    na: msg ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evsf,type,
    evsf: list(event) ).

%----Relevant facts (100)
tff(fact_0_Spy__analz__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,key(shrK(Aa)),analz(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_1_ns__shared_OFake,axiom,
    ! [Ba: agent1,X: msg,Evsf: list(event)] :
      ( member(list(event),Evsf,nS_Sha254967238shared)
     => ( member(msg,X,synth(analz(knows(spy,Evsf))))
       => member(list(event),cons(event,says(spy,Ba,X),Evsf),nS_Sha254967238shared) ) ) ).

tff(fact_2_unique__session__keys,axiom,
    ! [X2: msg,B: agent1,NA: msg,A3: agent1,Evsa: list(event),X: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),X))))),set(event,Evsa))
     => ( member(event,says(server,A3,crypt(shrK(A3),mPair(NA,mPair(agent(B),mPair(key(Ka),X2))))),set(event,Evsa))
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ( ( Aa = A3 )
            & ( NAa = NA )
            & ( Ba = B )
            & ( X = X2 ) ) ) ) ) ).

tff(fact_3_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent1] :
      ( member(agent1,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_4_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent1] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_5_synth__simps_I5_J,axiom,
    ! [H: fun(msg,bool),X: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X),synth(H))
    <=> ( member(msg,crypt(Ka,X),H)
        | ( member(msg,X,synth(H))
          & member(msg,key(Ka),H) ) ) ) ).

tff(fact_6_synth_OCrypt,axiom,
    ! [Ka: nat,H: fun(msg,bool),X: msg] :
      ( member(msg,X,synth(H))
     => ( member(msg,key(Ka),H)
       => member(msg,crypt(Ka,X),synth(H)) ) ) ).

tff(fact_7_MPair__synth__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),synth(analz(H)))
    <=> ( member(msg,X,synth(analz(H)))
        & member(msg,Y,synth(analz(H))) ) ) ).

tff(fact_8_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),X: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),X),analz(knows(spy,Evsa)))
     => ( member(agent1,Aa,bad)
       => member(msg,X,analz(knows(spy,Evsa))) ) ) ).

tff(fact_9_Spy__in__bad,axiom,
    member(agent1,spy,bad) ).

tff(fact_10_Notes__imp__knows__Spy,axiom,
    ! [Evsa: list(event),X: msg,Aa: agent1] :
      ( member(event,notes(Aa,X),set(event,Evsa))
     => ( member(agent1,Aa,bad)
       => member(msg,X,knows(spy,Evsa)) ) ) ).

tff(fact_11_analz__mono__contra_I2_J,axiom,
    ! [Evsa: list(event),X: msg,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,notes(Aa,X),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_12_analz__mono__contra_I1_J,axiom,
    ! [Evsa: list(event),X: msg,Ba: agent1,Aa: agent1,C: msg] :
      ( ~ member(msg,C,analz(knows(spy,cons(event,says(Aa,Ba,X),Evsa))))
     => ~ member(msg,C,analz(knows(spy,Evsa))) ) ).

tff(fact_13_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,X),set(event,Evsa))
     => member(msg,X,analz(knows(spy,Evsa))) ) ).

tff(fact_14_synth_OAgent,axiom,
    ! [H: fun(msg,bool),Agt: agent1] : member(msg,agent(Agt),synth(H)) ).

tff(fact_15_analz_OInj,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,H)
     => member(msg,X,analz(H)) ) ).

tff(fact_16_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_17_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg14: msg,Msg22: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg22) = mPair(Msg14,Msg23) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_18_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_19_msg_Osimps_I7_J,axiom,
    ! [Msg4: msg,Nat3: nat,Msg3: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg3) = crypt(Nat3,Msg4) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_20_synth_OInj,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,H)
     => member(msg,X,synth(H)) ) ).

tff(fact_21_msg_Osimps_I1_J,axiom,
    ! [Agent5: agent1,Agent4: agent1] :
      ( ( agent(Agent4) = agent(Agent5) )
    <=> ( Agent4 = Agent5 ) ) ).

tff(fact_22_event_Osimps_I1_J,axiom,
    ! [Msg4: msg,Agent22: agent1,Agent12: agent1,Msg3: msg,Agent21: agent1,Agent11: agent1] :
      ( ( says(Agent11,Agent21,Msg3) = says(Agent12,Agent22,Msg4) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_23_shrK__injective,axiom,
    ! [Y1: agent1,X1: agent1] :
      ( ( shrK(X1) = shrK(Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_24_event_Osimps_I3_J,axiom,
    ! [Msg4: msg,Agent5: agent1,Msg3: msg,Agent4: agent1] :
      ( ( notes(Agent4,Msg3) = notes(Agent5,Msg4) )
    <=> ( ( Agent4 = Agent5 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_25_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),analz(H))
     => ~ ( member(msg,X,analz(H))
         => ~ member(msg,Y,analz(H)) ) ) ).

tff(fact_26_synth_OMPair,axiom,
    ! [Y: msg,H: fun(msg,bool),X: msg] :
      ( member(msg,X,synth(H))
     => ( member(msg,Y,synth(H))
       => member(msg,mPair(X,Y),synth(H)) ) ) ).

tff(fact_27_synth__simps_I4_J,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),synth(H))
    <=> ( member(msg,mPair(X,Y),H)
        | ( member(msg,X,synth(H))
          & member(msg,Y,synth(H)) ) ) ) ).

tff(fact_28_Key__synth__eq,axiom,
    ! [H: fun(msg,bool),Ka: nat] :
      ( member(msg,key(Ka),synth(H))
    <=> member(msg,key(Ka),H) ) ).

tff(fact_29_analz__analzD,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,analz(analz(H)))
     => member(msg,X,analz(H)) ) ).

tff(fact_30_synth__synthD,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,synth(synth(H)))
     => member(msg,X,synth(H)) ) ).

tff(fact_31_synth__idem,axiom,
    ! [H: fun(msg,bool)] : ( synth(synth(H)) = synth(H) ) ).

tff(fact_32_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),analz(H))
     => member(msg,Y,analz(H)) ) ).

tff(fact_33_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),analz(H))
     => member(msg,X,analz(H)) ) ).

tff(fact_34_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg11: msg] : ( mPair(Msg11,Msg2) != key(Nat1) ) ).

tff(fact_35_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg11: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg11,Msg2) ) ).

tff(fact_36_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg21: msg,Msg12: msg] : ( mPair(Msg12,Msg21) != crypt(Nat,Msg) ) ).

tff(fact_37_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg12: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg12,Msg21) ) ).

tff(fact_38_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_39_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_40_msg_Osimps_I17_J,axiom,
    ! [Agent3: agent1,Msg2: msg,Msg11: msg] : ( mPair(Msg11,Msg2) != agent(Agent3) ) ).

tff(fact_41_msg_Osimps_I16_J,axiom,
    ! [Msg2: msg,Msg11: msg,Agent3: agent1] : ( agent(Agent3) != mPair(Msg11,Msg2) ) ).

tff(fact_42_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent3: agent1] : ( agent(Agent3) != key(Nat) ) ).

tff(fact_43_msg_Osimps_I13_J,axiom,
    ! [Agent3: agent1,Nat: nat] : ( key(Nat) != agent(Agent3) ) ).

tff(fact_44_msg_Osimps_I19_J,axiom,
    ! [Agent3: agent1,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent(Agent3) ) ).

tff(fact_45_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent3: agent1] : ( agent(Agent3) != crypt(Nat,Msg) ) ).

tff(fact_46_Agent__synth,axiom,
    ! [H: fun(msg,bool),Aa: agent1] : member(msg,agent(Aa),synth(H)) ).

tff(fact_47_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_48_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_49_event_Osimps_I6_J,axiom,
    ! [Msg: msg,Agent: agent1,Msg1: msg,Agent2: agent1,Agent1: agent1] : ( says(Agent1,Agent2,Msg1) != notes(Agent,Msg) ) ).

tff(fact_50_event_Osimps_I7_J,axiom,
    ! [Msg1: msg,Agent2: agent1,Agent1: agent1,Msg: msg,Agent: agent1] : ( notes(Agent,Msg) != says(Agent1,Agent2,Msg1) ) ).

tff(fact_51_Server__not__bad,axiom,
    ~ member(agent1,server,bad) ).

tff(fact_52_Crypt__synth__eq,axiom,
    ! [X: msg,H: fun(msg,bool),Ka: nat] :
      ( ~ member(msg,key(Ka),H)
     => ( member(msg,crypt(Ka,X),synth(H))
      <=> member(msg,crypt(Ka,X),H) ) ) ).

tff(fact_53_analz__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) )
     => ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q) ) ) ).

tff(fact_54_Says__imp__knows,axiom,
    ! [Evsa: list(event),X: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,X),set(event,Evsa))
     => member(msg,X,knows(Aa,Evsa)) ) ).

tff(fact_55_Notes__imp__knows,axiom,
    ! [Evsa: list(event),X: msg,Aa: agent1] :
      ( member(event,notes(Aa,X),set(event,Evsa))
     => member(msg,X,knows(Aa,Evsa)) ) ).

tff(fact_56_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),X: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),X),analz(H))
     => ( member(msg,key(shrK(Aa)),analz(H))
       => member(msg,X,analz(H)) ) ) ).

tff(fact_57_syan__impI,axiom,
    ! [Q: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,synth(analz(knows(spy,Evsa))))
       => pp(Q) )
     => ( ~ member(msg,Y,synth(analz(knows(spy,Evsa))))
       => pp(Q) ) ) ).

tff(fact_58_Says__imp__spies,axiom,
    ! [Evsa: list(event),X: msg,Ba: agent1,Aa: agent1] :
      ( member(event,says(Aa,Ba,X),set(event,Evsa))
     => member(msg,X,knows(spy,Evsa)) ) ).

tff(fact_59_ns__shared_OOops,axiom,
    ! [X: msg,NAa: nat,NB2: nat,Ka: nat,Aa: agent1,Ba: agent1,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB2))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),X))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NB2),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_60_A__trusts__NS2,axiom,
    ! [Evsa: list(event),X: msg,Ka: nat,Ba: agent1,NAa: msg,Aa: agent1] :
      ( member(msg,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),X)))),parts(knows(spy,Evsa)))
     => ( ~ member(agent1,Aa,bad)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(agent(Ba),mPair(key(Ka),X))))),set(event,Evsa)) ) ) ) ).

tff(fact_61_ns__shared_ONS3,axiom,
    ! [X: msg,Ka: nat,Ba: agent1,NAa: nat,S: agent1,Aa: agent1,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),X))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent(Aa),mPair(agent(Ba),nonce(NAa)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,X),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_62_ns__sharedp_OFake,axiom,
    ! [Ba: agent1,X: msg,Evsf: list(event)] :
      ( nS_Sha993195050haredp(Evsf)
     => ( member(msg,X,synth(analz(knows(spy,Evsf))))
       => nS_Sha993195050haredp(cons(event,says(spy,Ba,X),Evsf)) ) ) ).

tff(fact_63_list_Oinject,axiom,
    ! [A1: $tType,List1: list(A1),A2: A1,List: list(A1),A: A1] :
      ( ( cons(A1,A,List) = cons(A1,A2,List1) )
    <=> ( ( A = A2 )
        & ( List = List1 ) ) ) ).

tff(fact_64_Oops__parts__spies,axiom,
    ! [Evsa: list(event),X: msg,Ka: msg,Ba: msg,NAa: msg,Aa: agent1] :
      ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(NAa,mPair(Ba,mPair(Ka,X))))),set(event,Evsa))
     => member(msg,Ka,parts(knows(spy,Evsa))) ) ).

tff(fact_65_ns__sharedp_OOops,axiom,
    ! [X: msg,NAa: nat,NB2: nat,Ka: nat,Aa: agent1,Ba: agent1,Evso: list(event)] :
      ( nS_Sha993195050haredp(Evso)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB2))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NAa),mPair(agent(Ba),mPair(key(Ka),X))))),set(event,Evso))
         => nS_Sha993195050haredp(cons(event,notes(spy,mPair(nonce(NAa),mPair(nonce(NB2),key(Ka)))),Evso)) ) ) ) ).

tff(fact_66_knows__Spy__Notes,axiom,
    ! [Evsa: list(event),X: msg,Aa: agent1] :
      ( ( member(agent1,Aa,bad)
       => ( knows(spy,cons(event,notes(Aa,X),Evsa)) = insert(msg,X,knows(spy,Evsa)) ) )
      & ( ~ member(agent1,Aa,bad)
       => ( knows(spy,cons(event,notes(Aa,X),Evsa)) = knows(spy,Evsa) ) ) ) ).

tff(fact_67_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_68_parts_OInj,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,H)
     => member(msg,X,parts(H)) ) ).

tff(fact_69_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_70_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_71_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_72_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( ( member(msg,X,analz(H))
        & member(msg,X,parts(H)) )
    <=> member(msg,X,analz(H)) ) ).

tff(fact_73_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( ( member(msg,X,analz(H))
        | member(msg,X,parts(H)) )
    <=> member(msg,X,parts(H)) ) ).

tff(fact_74_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),parts(H))
     => ~ ( member(msg,X,parts(H))
         => ~ member(msg,Y,parts(H)) ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A1: $tType,Aa: fun(A1,bool),X1: A1] :
      ( member(A1,X1,Aa)
    <=> pp(aa(A1,bool,Aa,X1)) ) ).

tff(fact_76_Nonce__synth__eq,axiom,
    ! [H: fun(msg,bool),N: nat] :
      ( member(msg,nonce(N),synth(H))
    <=> member(msg,nonce(N),H) ) ).

tff(fact_77_synth__simps_I1_J,axiom,
    ! [H: fun(msg,bool),N1: nat] :
      ( member(msg,nonce(N1),synth(H))
    <=> member(msg,nonce(N1),H) ) ).

tff(fact_78_List_Oset_Osimps_I2_J,axiom,
    ! [A1: $tType,Xs: list(A1),X1: A1] : ( set(A1,cons(A1,X1,Xs)) = insert(A1,X1,set(A1,Xs)) ) ).

tff(fact_79_analz__insert__MPair,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] : ( analz(insert(msg,mPair(X,Y),H)) = insert(msg,mPair(X,Y),analz(insert(msg,X,insert(msg,Y,H)))) ) ).

tff(fact_80_parts__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( parts(insert(msg,key(Ka),H)) = insert(msg,key(Ka),parts(H)) ) ).

tff(fact_81_parts__insert__MPair,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] : ( parts(insert(msg,mPair(X,Y),H)) = insert(msg,mPair(X,Y),parts(insert(msg,X,insert(msg,Y,H)))) ) ).

tff(fact_82_parts__insert__Crypt,axiom,
    ! [H: fun(msg,bool),X: msg,Ka: nat] : ( parts(insert(msg,crypt(Ka,X),H)) = insert(msg,crypt(Ka,X),parts(insert(msg,X,H))) ) ).

tff(fact_83_analz__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( analz(insert(msg,nonce(N),H)) = insert(msg,nonce(N),analz(H)) ) ).

tff(fact_84_analz__insert__Agent,axiom,
    ! [H: fun(msg,bool),Agt: agent1] : ( analz(insert(msg,agent(Agt),H)) = insert(msg,agent(Agt),analz(H)) ) ).

tff(fact_85_parts__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( parts(insert(msg,nonce(N),H)) = insert(msg,nonce(N),parts(H)) ) ).

tff(fact_86_parts__insert__Agent,axiom,
    ! [H: fun(msg,bool),Agt: agent1] : ( parts(insert(msg,agent(Agt),H)) = insert(msg,agent(Agt),parts(H)) ) ).

tff(fact_87_knows__Spy__Says,axiom,
    ! [Evsa: list(event),X: msg,Ba: agent1,Aa: agent1] : ( knows(spy,cons(event,says(Aa,Ba,X),Evsa)) = insert(msg,X,knows(spy,Evsa)) ) ).

tff(fact_88_pushes_I2_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,key(Ka),Aa)) ) ).

tff(fact_89_pushes_I9_J,axiom,
    ! [Aa: fun(msg,bool),N: nat,Ka: msg,X: nat] : ( insert(msg,crypt(X,Ka),insert(msg,nonce(N),Aa)) = insert(msg,nonce(N),insert(msg,crypt(X,Ka),Aa)) ) ).

tff(fact_90_parts__insertI,axiom,
    ! [A: msg,G: fun(msg,bool),C: msg] :
      ( member(msg,C,parts(G))
     => member(msg,C,parts(insert(msg,A,G))) ) ).

tff(fact_91_parts__cut__eq,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,parts(H))
     => ( parts(insert(msg,X,H)) = parts(H) ) ) ).

tff(fact_92_parts__partsD,axiom,
    ! [H: fun(msg,bool),X: msg] :
      ( member(msg,X,parts(parts(H)))
     => member(msg,X,parts(H)) ) ).

tff(fact_93_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_94_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_95_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),parts(H))
     => member(msg,X,parts(H)) ) ).

tff(fact_96_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,X: msg] :
      ( member(msg,mPair(X,Y),parts(H))
     => member(msg,Y,parts(H)) ) ).

tff(fact_97_parts_OBody,axiom,
    ! [H: fun(msg,bool),X: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X),parts(H))
     => member(msg,X,parts(H)) ) ).

tff(fact_98_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),X: msg,Ka: nat] :
      ( member(msg,crypt(Ka,X),parts(H))
     => member(msg,X,parts(H)) ) ).

tff(fact_99_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (6)
tff(conj_0,hypothesis,
    ~ member(agent1,a,bad) ).

tff(conj_1,hypothesis,
    ~ member(agent1,b,bad) ).

tff(conj_2,hypothesis,
    member(list(event),evsf,nS_Sha254967238shared) ).

tff(conj_3,hypothesis,
    ( member(event,says(server,a,crypt(shrK(a),mPair(na,mPair(agent(b),mPair(key(k),crypt(shrK(b),mPair(key(k),agent(a)))))))),set(event,evsf))
   => ( ! [NB1: msg] : ~ member(event,notes(spy,mPair(na,mPair(NB1,key(k)))),set(event,evsf))
     => ~ member(msg,key(k),analz(knows(spy,evsf))) ) ) ).

tff(conj_4,hypothesis,
    member(msg,x,synth(analz(knows(spy,evsf)))) ).

tff(conj_5,conjecture,
    ( ~ member(event,says(server,a,crypt(shrK(a),mPair(na,mPair(agent(b),mPair(key(k),crypt(shrK(b),mPair(key(k),agent(a)))))))),set(event,cons(event,says(spy,ba,x),evsf)))
    | ? [NB: msg] : member(event,notes(spy,mPair(na,mPair(NB,key(k)))),set(event,cons(event,says(spy,ba,x),evsf)))
    | ~ member(msg,key(k),analz(knows(spy,cons(event,says(spy,ba,x),evsf)))) ) ).

%------------------------------------------------------------------------------
