%------------------------------------------------------------------------------
% File     : SWV739_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 235
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_235 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.67 v7.4.0, 0.75 v7.3.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  185 (  45 unt;  52 typ;   0 def)
%            Number of atoms       :  296 (  82 equ)
%            Maximal formula atoms :   30 (   1 avg)
%            Number of connectives :  205 (  42   ~;  28   |;  21   &)
%                                         (  23 <=>;  91  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   33 (  21   >;  12   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-3 aty)
%            Number of functors    :   40 (  40 usr;  18 con; 0-5 aty)
%            Number of variables   :  388 ( 356   !;   4   ?; 388   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:29
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Obounded__lattice__top,type,
    bounded_lattice_top: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent1: agent > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: fun(nat,msg) ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Public_OshrK,type,
    shrK: fun(agent,nat) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_A_H,type,
    a1: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_KAB,type,
    kab: nat ).

tff(sy_v_KK,type,
    kk: fun(nat,bool) ).

tff(sy_v_NA,type,
    na: nat ).

tff(sy_v_evs2,type,
    evs2: list(event) ).

%----Relevant facts (100)
tff(fact_0_shrK__in__used,axiom,
    ! [Evsa: list(event),A2: agent] : pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,A2))),used(Evsa))) ).

tff(fact_1_analz__image__Key,axiom,
    ! [N: fun(nat,bool)] : ( analz(image(nat,msg,key,N)) = image(nat,msg,key,N) ) ).

tff(fact_2_shrK__in__knows,axiom,
    ! [Evsa: list(event),A2: agent] : pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,A2))),knows(A2,Evsa))) ).

tff(fact_3_compl__sup__top,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [X: A] : ( sup_sup(A,uminus_uminus(A,X),X) = top_top(A) ) ) ).

tff(fact_4_sym__shrK,axiom,
    ! [X1: agent] : pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,X1)),symKeys)) ).

tff(fact_5_shrK__image__eq,axiom,
    ! [AA: fun(agent,bool),X2: agent] :
      ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,X2)),image(agent,nat,shrK,AA)))
    <=> pp(aa(fun(agent,bool),bool,aa(agent,fun(fun(agent,bool),bool),member(agent),X2),AA)) ) ).

tff(fact_6_Key__not__used,axiom,
    ! [Evsa: list(event),K1: nat] :
      ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,K1)),used(Evsa)))
     => ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),K1),image(agent,nat,shrK,top_top(fun(agent,bool))))) ) ).

tff(fact_7_Key__image__eq,axiom,
    ! [A2: fun(nat,bool),X2: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,X2)),image(nat,msg,key,A2)))
    <=> pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),X2),A2)) ) ).

tff(fact_8_Says__imp__analz__Spy,axiom,
    ! [Evsa: list(event),X1: msg,B2: agent,A2: agent] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(A2,B2,X1)),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(knows(spy,Evsa)))) ) ).

tff(fact_9_MPair__used,axiom,
    ! [H: list(event),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),used(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),used(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),used(H))) ) ) ).

tff(fact_10_analz__analz__Un,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] : ( analz(sup_sup(fun(msg,bool),analz(G1),H)) = analz(sup_sup(fun(msg,bool),G1,H)) ) ).

tff(fact_11_Compl__subset__Compl__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),uminus_uminus(fun(A,bool),A2),uminus_uminus(fun(A,bool),B2))
    <=> ord_less_eq(fun(A,bool),B2,A2) ) ).

tff(fact_12_sup__left__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_13_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B1: A,A1: A] : ( sup_sup(A,A1,sup_sup(A,A1,B1)) = sup_sup(A,A1,B1) ) ) ).

tff(fact_14_equalityI,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B2)
     => ( ord_less_eq(fun(A,bool),B2,A2)
       => ( A2 = B2 ) ) ) ).

tff(fact_15_subsetD,axiom,
    ! [A: $tType,C2: A,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B2)) ) ) ).

tff(fact_16_image__eqI,axiom,
    ! [A: $tType,B: $tType,A2: fun(B,bool),X2: B,F: fun(B,A),B3: A] :
      ( ( B3 = aa(B,A,F,X2) )
     => ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B3),image(B,A,F,A2))) ) ) ).

tff(fact_17_UNIV__I,axiom,
    ! [A: $tType,X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),top_top(fun(A,bool)))) ).

tff(fact_18_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [Y2: A,X2: A] :
          ( ( uminus_uminus(A,X2) = uminus_uminus(A,Y2) )
        <=> ( X2 = Y2 ) ) ) ).

tff(fact_19_UnCI,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: fun(A,bool),C2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B2))) ) ).

tff(fact_20_UnE,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B2)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B2)) ) ) ).

tff(fact_21_Un__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B2)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B2)) ) ) ).

tff(fact_22_analz__subset__iff,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),analz(G1),analz(H))
    <=> ord_less_eq(fun(msg,bool),G1,analz(H)) ) ).

tff(fact_23_analz_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_24_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_25_msg_Osimps_I6_J,axiom,
    ! [Msg21: msg,Msg12: msg,Msg2: msg,Msg11: msg] :
      ( ( mPair(Msg11,Msg2) = mPair(Msg12,Msg21) )
    <=> ( ( Msg11 = Msg12 )
        & ( Msg2 = Msg21 ) ) ) ).

tff(fact_26_msg_Osimps_I4_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( aa(nat,msg,key,Nat) = aa(nat,msg,key,Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_27_msg_Osimps_I3_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( nonce(Nat) = nonce(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_28_ComplI,axiom,
    ! [A: $tType,A2: fun(A,bool),C2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),uminus_uminus(fun(A,bool),A2))) ) ).

tff(fact_29_Compl__eq__Compl__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ( uminus_uminus(fun(A,bool),A2) = uminus_uminus(fun(A,bool),B2) )
    <=> ( A2 = B2 ) ) ).

tff(fact_30_Compl__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),uminus_uminus(fun(A,bool),A2)))
    <=> ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2)) ) ).

tff(fact_31_msg_Osimps_I1_J,axiom,
    ! [Agent3: agent,Agent: agent] :
      ( ( agent1(Agent) = agent1(Agent3) )
    <=> ( Agent = Agent3 ) ) ).

tff(fact_32_event_Osimps_I1_J,axiom,
    ! [Msg1: msg,Agent21: agent,Agent11: agent,Msg: msg,Agent2: agent,Agent1: agent] :
      ( ( says(Agent1,Agent2,Msg) = says(Agent11,Agent21,Msg1) )
    <=> ( ( Agent1 = Agent11 )
        & ( Agent2 = Agent21 )
        & ( Msg = Msg1 ) ) ) ).

tff(fact_33_shrK__injective,axiom,
    ! [Y2: agent,X2: agent] :
      ( ( aa(agent,nat,shrK,X2) = aa(agent,nat,shrK,Y2) )
    <=> ( X2 = Y2 ) ) ).

tff(fact_34_le__sup__iff,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z1: A,Y2: A,X2: A] :
          ( ord_less_eq(A,sup_sup(A,X2,Y2),Z1)
        <=> ( ord_less_eq(A,X2,Z1)
            & ord_less_eq(A,Y2,Z1) ) ) ) ).

tff(fact_35_compl__le__compl__iff,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [Y2: A,X2: A] :
          ( ord_less_eq(A,uminus_uminus(A,X2),uminus_uminus(A,Y2))
        <=> ord_less_eq(A,Y2,X2) ) ) ).

tff(fact_36_sup__top__right,axiom,
    ! [A: $tType] :
      ( bounded_lattice_top(A)
     => ! [X: A] : ( sup_sup(A,X,top_top(A)) = top_top(A) ) ) ).

tff(fact_37_sup__top__left,axiom,
    ! [A: $tType] :
      ( bounded_lattice_top(A)
     => ! [X: A] : ( sup_sup(A,top_top(A),X) = top_top(A) ) ) ).

tff(fact_38_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y1: msg,X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(X1,Y1)),analz(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(H))) ) ) ).

tff(fact_39_analz__trans,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(G1)))
     => ( ord_less_eq(fun(msg,bool),G1,analz(H))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ) ).

tff(fact_40_analz__mono,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G1,H)
     => ord_less_eq(fun(msg,bool),analz(G1),analz(H)) ) ).

tff(fact_41_analz__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,analz(H)) ).

tff(fact_42_analz__subset__cong,axiom,
    ! [H1: fun(msg,bool),H: fun(msg,bool),G2: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),analz(G1),analz(G2))
     => ( ord_less_eq(fun(msg,bool),analz(H),analz(H1))
       => ord_less_eq(fun(msg,bool),analz(sup_sup(fun(msg,bool),G1,H)),analz(sup_sup(fun(msg,bool),G2,H1))) ) ) ).

tff(fact_43_analz__Un,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] : ord_less_eq(fun(msg,bool),sup_sup(fun(msg,bool),analz(G1),analz(H)),analz(sup_sup(fun(msg,bool),G1,H))) ).

tff(fact_44_sup__assoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_45_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,sup_sup(A,X,Y),Z) = sup_sup(A,X,sup_sup(A,Y,Z)) ) ) ).

tff(fact_46_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C1: A,B1: A,A1: A] : ( sup_sup(A,sup_sup(A,A1,B1),C1) = sup_sup(A,A1,sup_sup(A,B1,C1)) ) ) ).

tff(fact_47_sup__left__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_48_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Z: A,Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,Y,Z)) = sup_sup(A,Y,sup_sup(A,X,Z)) ) ) ).

tff(fact_49_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [C1: A,A1: A,B1: A] : ( sup_sup(A,B1,sup_sup(A,A1,C1)) = sup_sup(A,A1,sup_sup(A,B1,C1)) ) ) ).

tff(fact_50_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,sup_sup(A,X,Y)) = sup_sup(A,X,Y) ) ) ).

tff(fact_51_sup__commute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_52_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( lattice(A)
     => ! [Y: A,X: A] : ( sup_sup(A,X,Y) = sup_sup(A,Y,X) ) ) ).

tff(fact_53_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B1: A,A1: A] : ( sup_sup(A,A1,B1) = sup_sup(A,B1,A1) ) ) ).

tff(fact_54_sup__idem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X: A] : ( sup_sup(A,X,X) = X ) ) ).

tff(fact_55_sup_Oidem,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [A1: A] : ( sup_sup(A,A1,A1) = A1 ) ) ).

tff(fact_56_equalityE,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B2 )
     => ~ ( ord_less_eq(fun(A,bool),A2,B2)
         => ~ ord_less_eq(fun(A,bool),B2,A2) ) ) ).

tff(fact_57_subset__trans,axiom,
    ! [A: $tType,C3: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B2)
     => ( ord_less_eq(fun(A,bool),B2,C3)
       => ord_less_eq(fun(A,bool),A2,C3) ) ) ).

tff(fact_58_set__mp,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_59_set__rev__mp,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => ( ord_less_eq(fun(A,bool),A2,B2)
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_60_in__mono,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),A2,B2)
     => ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B2)) ) ) ).

tff(fact_61_equalityD2,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(A,bool),B2,A2) ) ).

tff(fact_62_equalityD1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B2 )
     => ord_less_eq(fun(A,bool),A2,B2) ) ).

tff(fact_63_set__eq__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] :
      ( ( A2 = B2 )
    <=> ( ord_less_eq(fun(A,bool),A2,B2)
        & ord_less_eq(fun(A,bool),B2,A2) ) ) ).

tff(fact_64_subset__refl,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ord_less_eq(fun(A,bool),A2,A2) ).

tff(fact_65_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B3: B,A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => ( ( B3 = aa(A,B,F,X2) )
       => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),B3),image(A,B,F,A2))) ) ) ).

tff(fact_66_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
     => pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),aa(A,B,F,X2)),image(A,B,F,A2))) ) ).

tff(fact_67_image__iff,axiom,
    ! [A: $tType,B: $tType,A2: fun(B,bool),F: fun(B,A),Z1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),Z1),image(B,A,F,A2)))
    <=> ? [X4: B] :
          ( pp(aa(fun(B,bool),bool,aa(B,fun(fun(B,bool),bool),member(B),X4),A2))
          & ( Z1 = aa(B,A,F,X4) ) ) ) ).

tff(fact_68_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_69_double__compl,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [X: A] : ( uminus_uminus(A,uminus_uminus(A,X)) = X ) ) ).

tff(fact_70_UnI2,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B2))) ) ).

tff(fact_71_UnI1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B2))) ) ).

tff(fact_72_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] :
      ( ! [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),sup_sup(fun(A,bool),A2,B2)))
         => pp(aa(A,bool,P1,X4)) )
    <=> ( ! [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A2))
           => pp(aa(A,bool,P1,X4)) )
        & ! [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),B2))
           => pp(aa(A,bool,P1,X4)) ) ) ) ).

tff(fact_73_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] :
      ( ? [X4: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),sup_sup(fun(A,bool),A2,B2)))
          & pp(aa(A,bool,P1,X4)) )
    <=> ( ? [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),A2))
            & pp(aa(A,bool,P1,X4)) )
        | ? [X4: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X4),B2))
            & pp(aa(A,bool,P1,X4)) ) ) ) ).

tff(fact_74_Un__assoc,axiom,
    ! [A: $tType,C3: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A2,B2),C3) = sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B2,C3)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_analz__image__freshK__simps_I65_J,axiom,
    ! [A: $tType,C3: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B2,C3)) = sup_sup(fun(A,bool),sup_sup(fun(A,bool),A2,B2),C3) ) ).

tff(fact_79_Un__left__commute,axiom,
    ! [A: $tType,C3: fun(A,bool),B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B2,C3)) = sup_sup(fun(A,bool),B2,sup_sup(fun(A,bool),A2,C3)) ) ).

tff(fact_80_Un__left__absorb,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),A2,B2)) = sup_sup(fun(A,bool),A2,B2) ) ).

tff(fact_81_Un__commute,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B2) = sup_sup(fun(A,bool),B2,A2) ) ).

tff(fact_82_Un__def,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A2)),combc(A,fun(A,bool),bool,member(A),B2))) ) ).

tff(fact_83_Un__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,A2) = A2 ) ).

tff(fact_84_analz__analzD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(analz(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_85_ComplE,axiom,
    ! [A: $tType,A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),uminus_uminus(fun(A,bool),A2)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2)) ) ).

tff(fact_86_ComplD,axiom,
    ! [A: $tType,A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),uminus_uminus(fun(A,bool),A2)))
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2)) ) ).

tff(fact_87_double__complement,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( uminus_uminus(fun(A,bool),uminus_uminus(fun(A,bool),A2)) = A2 ) ).

tff(fact_88_Compl__eq,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( uminus_uminus(fun(A,bool),A2) = collect(A,combb(bool,bool,A,fNot,combc(A,fun(A,bool),bool,member(A),A2))) ) ).

tff(fact_89_symKeys__neq__imp__neq,axiom,
    ! [K2: nat,K1: nat] :
      ( ~ ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),K1),symKeys))
        <=> pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),K2),symKeys)) )
     => ( K1 != K2 ) ) ).

tff(fact_90_image__ident,axiom,
    ! [A: $tType,Y1: fun(A,bool)] : ( image(A,A,combi(A),Y1) = Y1 ) ).

tff(fact_91_image__image,axiom,
    ! [B: $tType,A: $tType,C: $tType,A2: fun(C,bool),G: fun(C,B),F: fun(B,A)] : ( image(B,A,F,image(C,B,G,A2)) = image(C,A,combb(B,A,C,F,G),A2) ) ).

tff(fact_92_Collect__disj__eq,axiom,
    ! [A: $tType,Q1: fun(A,bool),P1: fun(A,bool)] : ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,P1),Q1)) = sup_sup(fun(A,bool),collect(A,P1),collect(A,Q1)) ) ).

tff(fact_93_Collect__neg__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,combb(bool,bool,A,fNot,P1)) = uminus_uminus(fun(A,bool),collect(A,P1)) ) ).

tff(fact_94_le__supE,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X: A,B1: A,A1: A] :
          ( ord_less_eq(A,sup_sup(A,A1,B1),X)
         => ~ ( ord_less_eq(A,A1,X)
             => ~ ord_less_eq(A,B1,X) ) ) ) ).

tff(fact_95_sup__mono,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [D: A,B1: A,C1: A,A1: A] :
          ( ord_less_eq(A,A1,C1)
         => ( ord_less_eq(A,B1,D)
           => ord_less_eq(A,sup_sup(A,A1,B1),sup_sup(A,C1,D)) ) ) ) ).

tff(fact_96_sup__least,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Z: A,X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ( ord_less_eq(A,Z,X)
           => ord_less_eq(A,sup_sup(A,Y,Z),X) ) ) ) ).

tff(fact_97_le__supI,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [B1: A,X: A,A1: A] :
          ( ord_less_eq(A,A1,X)
         => ( ord_less_eq(A,B1,X)
           => ord_less_eq(A,sup_sup(A,A1,B1),X) ) ) ) ).

tff(fact_98_sup__absorb1,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ( sup_sup(A,X,Y) = X ) ) ) ).

tff(fact_99_sup__absorb2,axiom,
    ! [A: $tType] :
      ( semilattice_sup(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( sup_sup(A,X,Y) = Y ) ) ) ).

%----Arities (12)
tff(arity_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice(bool) ).

tff(arity_fun___Lattices_Obounded__lattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Obounded__lattice__top,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bounded_lattice(T_2)
     => bounded_lattice_top(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Osemilattice__sup,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => semilattice_sup(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Oboolean__algebra,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( boolean_algebra(T_2)
     => boolean_algebra(fun(T_1,T_2)) ) ).

tff(arity_fun___Lattices_Olattice,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( lattice(T_2)
     => lattice(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(nat) ).

tff(arity_Nat_Onat___Lattices_Olattice,axiom,
    lattice(nat) ).

tff(arity_HOL_Obool___Lattices_Obounded__lattice__top,axiom,
    bounded_lattice_top(bool) ).

tff(arity_HOL_Obool___Lattices_Osemilattice__sup,axiom,
    semilattice_sup(bool) ).

tff(arity_HOL_Obool___Lattices_Oboolean__algebra,axiom,
    boolean_algebra(bool) ).

tff(arity_HOL_Obool___Lattices_Olattice,axiom,
    lattice(bool) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),evs2),nS_Sha254967238shared)) ).

tff(conj_1,hypothesis,
    ! [K: nat,KK: fun(nat,bool)] :
      ( ord_less_eq(fun(nat,bool),KK,uminus_uminus(fun(nat,bool),image(agent,nat,shrK,top_top(fun(agent,bool)))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,K)),analz(sup_sup(fun(msg,bool),image(nat,msg,key,KK),knows(spy,evs2)))))
      <=> ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),K),KK))
          | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,K)),analz(knows(spy,evs2)))) ) ) ) ).

tff(conj_2,hypothesis,
    ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,kab)),used(evs2))) ).

tff(conj_3,hypothesis,
    pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),kab),symKeys)) ).

tff(conj_4,hypothesis,
    pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(a1,server,mPair(agent1(a),mPair(agent1(b),nonce(na))))),set(event,evs2))) ).

tff(conj_5,hypothesis,
    ord_less_eq(fun(nat,bool),kk,uminus_uminus(fun(nat,bool),image(agent,nat,shrK,top_top(fun(agent,bool))))) ).

tff(conj_6,conjecture,
    ( ( ( ( aa(agent,nat,shrK,b) != kab )
        & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,b))),analz(knows(spy,evs2)))) )
      | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,a))),analz(knows(spy,evs2))))
      | ( ( ( ( aa(agent,nat,shrK,b) != kab )
            & ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,b)),kk))
            & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,b))),analz(knows(spy,evs2)))) )
          | ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,a)),kk))
          | ( ( k != kab )
            & ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
            & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) )
          | pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
          | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) )
        & ( ( aa(agent,nat,shrK,b) = kab )
          | pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,b)),kk))
          | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,b))),analz(knows(spy,evs2))))
          | ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,a)),kk))
          | ( ( k != kab )
            & ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
            & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) )
          | pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
          | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) ) ) )
    & ( ( aa(agent,nat,shrK,b) = kab )
      | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,b))),analz(knows(spy,evs2))))
      | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,aa(agent,nat,shrK,a))),analz(knows(spy,evs2))))
      | ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),aa(agent,nat,shrK,a)),kk))
      | ( ( k != kab )
        & ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
        & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) )
      | pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),kk))
      | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),aa(nat,msg,key,k)),analz(knows(spy,evs2)))) ) ) ).

%------------------------------------------------------------------------------
