%------------------------------------------------------------------------------
% File     : SWV735_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 218
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_218 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  178 (  66 unt;  50 typ;   0 def)
%            Number of atoms       :  232 ( 112 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  179 (  75   ~;  25   |;  16   &)
%                                         (  20 <=>;  43  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   32 (  21   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :   44 (  44 usr;  21 con; 0-5 aty)
%            Number of variables   :  355 ( 334   !;   2   ?; 355   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent1: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent1,bool) ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent1 * agent1 * msg ) > event ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent1 * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent1 ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent1 ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent: agent1 > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Public_OshrK,type,
    shrK: agent1 > nat ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent1 ).

tff(sy_v_A_H,type,
    a1: agent1 ).

tff(sy_v_B,type,
    b: agent1 ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_KAB,type,
    kab: nat ).

tff(sy_v_KABa,type,
    kABa: nat ).

tff(sy_v_Kab,type,
    kab1: nat ).

tff(sy_v_NA,type,
    na: nat ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evs2,type,
    evs2: list(event) ).

%----Relevant facts (100)
tff(fact_0_Oops__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,B2: msg,NA: msg,A1: agent1] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(server,A1,crypt(shrK(A1),mPair(NA,mPair(B2,mPair(Ka,Xa)))))),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Ka),parts(knows(spy,Evsa)))) ) ).

tff(fact_1_NS3__msg__in__parts__spies,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: msg,B2: msg,N: msg,KA: nat,A1: agent1,S: agent1] :
      ( pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(S,A1,crypt(KA,mPair(N,mPair(B2,mPair(Ka,Xa)))))),set(event,Evsa)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(knows(spy,Evsa)))) ) ).

tff(fact_2_usedI,axiom,
    ! [Evsa: list(event),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(knows(spy,Evsa))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),used(Evsa))) ) ).

tff(fact_3_shrK__in__used,axiom,
    ! [Evsa: list(event),A1: agent1] : pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(A1))),used(Evsa))) ).

tff(fact_4_shrK__in__knows,axiom,
    ! [Evsa: list(event),A1: agent1] : pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(A1))),knows(A1,Evsa))) ).

tff(fact_5_parts__insert__Agent,axiom,
    ! [H: fun(msg,bool),Agt: agent1] : ( parts(insert(msg,agent(Agt),H)) = insert(msg,agent(Agt),parts(H)) ) ).

tff(fact_6_parts__insert__Nonce,axiom,
    ! [H: fun(msg,bool),N: nat] : ( parts(insert(msg,nonce(N),H)) = insert(msg,nonce(N),parts(H)) ) ).

tff(fact_7_parts__insert__Crypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] : ( parts(insert(msg,crypt(Ka,Xa),H)) = insert(msg,crypt(Ka,Xa),parts(insert(msg,Xa,H))) ) ).

tff(fact_8_parts__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( parts(insert(msg,key(Ka),H)) = insert(msg,key(Ka),parts(H)) ) ).

tff(fact_9_parts__insert__MPair,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] : ( parts(insert(msg,mPair(Xa,Y1),H)) = insert(msg,mPair(Xa,Y1),parts(insert(msg,Xa,insert(msg,Y1,H)))) ) ).

tff(fact_10_sym__shrK,axiom,
    ! [Xa: agent1] : pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),shrK(Xa)),symKeys)) ).

tff(fact_11_A__trusts__NS2,axiom,
    ! [Evsa: list(event),Xa: msg,Ka: nat,B2: agent1,NA: msg,A1: agent1] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(shrK(A1),mPair(NA,mPair(agent(B2),mPair(key(Ka),Xa))))),parts(knows(spy,Evsa))))
     => ( ~ pp(aa(fun(agent1,bool),bool,aa(agent1,fun(fun(agent1,bool),bool),member(agent1),A1),bad))
       => ( pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),Evsa),nS_Sha254967238shared))
         => pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(server,A1,crypt(shrK(A1),mPair(NA,mPair(agent(B2),mPair(key(Ka),Xa)))))),set(event,Evsa))) ) ) ) ).

tff(fact_12_singleton__conv2,axiom,
    ! [A: $tType,A2: A] : ( collect(A,aa(A,fun(A,bool),fequal(A),A2)) = insert(A,A2,bot_bot(fun(A,bool))) ) ).

tff(fact_13_singleton__conv,axiom,
    ! [A: $tType,A2: A] : ( collect(A,combc(A,A,bool,fequal(A),A2)) = insert(A,A2,bot_bot(fun(A,bool))) ) ).

tff(fact_14_emptyE,axiom,
    ! [A: $tType,A2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),bot_bot(fun(A,bool)))) ).

tff(fact_15_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_16_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_17_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X5: A] : ~ pp(aa(A,bool,P1,X5)) ) ).

tff(fact_18_all__not__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ! [X5: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),A1))
    <=> ( A1 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_19_insertCI,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
       => ( A2 = B1 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,B2))) ) ).

tff(fact_20_insertE,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,A1)))
     => ( ( A2 != B1 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_21_insert__iff,axiom,
    ! [A: $tType,A1: fun(A,bool),B1: A,A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,A1)))
    <=> ( ( A2 = B1 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ) ).

tff(fact_22_insert__absorb2,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] : ( insert(A,X3,insert(A,X3,A1)) = insert(A,X3,A1) ) ).

tff(fact_23_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H))) ) ).

tff(fact_24_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_25_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg13: msg,Msg22: msg,Msg12: msg] :
      ( ( mPair(Msg12,Msg22) = mPair(Msg13,Msg23) )
    <=> ( ( Msg12 = Msg13 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_26_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_27_msg_Osimps_I7_J,axiom,
    ! [Msg4: msg,Nat3: nat,Msg3: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg3) = crypt(Nat3,Msg4) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_28_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_29_msg_Osimps_I1_J,axiom,
    ! [Agent4: agent1,Agent3: agent1] :
      ( ( agent(Agent3) = agent(Agent4) )
    <=> ( Agent3 = Agent4 ) ) ).

tff(fact_30_event_Osimps_I1_J,axiom,
    ! [Msg4: msg,Agent21: agent1,Agent11: agent1,Msg3: msg,Agent2: agent1,Agent1: agent1] :
      ( ( says(Agent1,Agent2,Msg3) = says(Agent11,Agent21,Msg4) )
    <=> ( ( Agent1 = Agent11 )
        & ( Agent2 = Agent21 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_31_shrK__injective,axiom,
    ! [Y2: agent1,X3: agent1] :
      ( ( shrK(X3) = shrK(Y2) )
    <=> ( X3 = Y2 ) ) ).

tff(fact_32_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(Xa,Y1)),parts(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(H))) ) ) ).

tff(fact_33_MPair__used,axiom,
    ! [H: list(event),Y1: msg,Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(Xa,Y1)),used(H)))
     => ~ ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),used(H)))
         => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),used(H))) ) ) ).

tff(fact_34_parts__emptyE,axiom,
    ! [Xa: msg] : ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(bot_bot(fun(msg,bool))))) ).

tff(fact_35_parts__empty,axiom,
    parts(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_36_Spy__in__bad,axiom,
    pp(aa(fun(agent1,bool),bool,aa(agent1,fun(fun(agent1,bool),bool),member(agent1),spy),bad)) ).

tff(fact_37_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),A1: agent1] :
      ( pp(aa(fun(agent1,bool),bool,aa(agent1,fun(fun(agent1,bool),bool),member(agent1),A1),bad))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(A1))),knows(spy,Evsa))) ) ).

tff(fact_38_Server__not__bad,axiom,
    ~ pp(aa(fun(agent1,bool),bool,aa(agent1,fun(fun(agent1,bool),bool),member(agent1),server),bad)) ).

tff(fact_39_equals0D,axiom,
    ! [A: $tType,A2: A,A1: fun(A,bool)] :
      ( ( A1 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1)) ) ).

tff(fact_40_ex__in__conv,axiom,
    ! [A: $tType,A1: fun(A,bool)] :
      ( ? [X5: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X5),A1))
    <=> ( A1 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_41_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_42_insert__absorb,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( insert(A,A2,A1) = A1 ) ) ).

tff(fact_43_insertI2,axiom,
    ! [A: $tType,B1: A,B2: fun(A,bool),A2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),B2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,B1,B2))) ) ).

tff(fact_44_insert__eq__iff,axiom,
    ! [A: $tType,B2: fun(A,bool),B1: A,A1: fun(A,bool),A2: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),B2))
       => ( ( insert(A,A2,A1) = insert(A,B1,B2) )
        <=> ( ( ( A2 = B1 )
             => ( A1 = B2 ) )
            & ( ( A2 != B1 )
             => ? [C3: fun(A,bool)] :
                  ( ( A1 = insert(A,B1,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),C3))
                  & ( B2 = insert(A,A2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),C3)) ) ) ) ) ) ) ).

tff(fact_45_insert__ident,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B2))
       => ( ( insert(A,X3,A1) = insert(A,X3,B2) )
        <=> ( A1 = B2 ) ) ) ) ).

tff(fact_46_insert__code,axiom,
    ! [A: $tType,X3: A,A1: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A1),X3))
    <=> ( ( Y2 = X3 )
        | pp(aa(A,bool,A1,X3)) ) ) ).

tff(fact_47_insert__commute,axiom,
    ! [A: $tType,A1: fun(A,bool),Y2: A,X3: A] : ( insert(A,X3,insert(A,Y2,A1)) = insert(A,Y2,insert(A,X3,A1)) ) ).

tff(fact_48_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A2: A] : ( insert(A,A2,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A2))),P1)) ) ).

tff(fact_49_insert__compr,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : ( insert(A,A2,B2) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A2)),combc(A,fun(A,bool),bool,member(A),B2))) ) ).

tff(fact_50_insertI1,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A2),insert(A,A2,B2))) ).

tff(fact_51_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(parts(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H))) ) ).

tff(fact_52_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),Ka),symKeys))
        <=> pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),K),symKeys)) )
     => ( Ka != K ) ) ).

tff(fact_53_insert__compr__raw,axiom,
    ! [A: $tType,X: A,Xa1: fun(A,bool)] : ( insert(A,X,Xa1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),X)),combc(A,fun(A,bool),bool,member(A),Xa1))) ) ).

tff(fact_54_singleton__inject,axiom,
    ! [A: $tType,B1: A,A2: A] :
      ( ( insert(A,A2,bot_bot(fun(A,bool))) = insert(A,B1,bot_bot(fun(A,bool))) )
     => ( A2 = B1 ) ) ).

tff(fact_55_singletonE,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A2,bot_bot(fun(A,bool)))))
     => ( B1 = A2 ) ) ).

tff(fact_56_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C2: A,B1: A,A2: A] :
      ( ( insert(A,A2,insert(A,B1,bot_bot(fun(A,bool)))) = insert(A,C2,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A2 = C2 )
          & ( B1 = D ) )
        | ( ( A2 = D )
          & ( B1 = C2 ) ) ) ) ).

tff(fact_57_singleton__iff,axiom,
    ! [A: $tType,A2: A,B1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B1),insert(A,A2,bot_bot(fun(A,bool)))))
    <=> ( B1 = A2 ) ) ).

tff(fact_58_insert__not__empty,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( insert(A,A2,A1) != bot_bot(fun(A,bool)) ) ).

tff(fact_59_empty__not__insert,axiom,
    ! [A: $tType,A1: fun(A,bool),A2: A] : ( bot_bot(fun(A,bool)) != insert(A,A2,A1) ) ).

tff(fact_60_parts__cut__eq,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H)))
     => ( parts(insert(msg,Xa,H)) = parts(H) ) ) ).

tff(fact_61_parts__insertI,axiom,
    ! [A2: msg,G1: fun(msg,bool),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(G1)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(insert(msg,A2,G1)))) ) ).

tff(fact_62_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(Xa,Y1)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(H))) ) ).

tff(fact_63_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y1: msg,Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(Xa,Y1)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H))) ) ).

tff(fact_64_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != key(Nat1) ) ).

tff(fact_65_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_66_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(Ka,Xa)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H))) ) ).

tff(fact_67_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(Ka,Xa)),parts(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),parts(H))) ) ).

tff(fact_68_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != crypt(Nat,Msg) ) ).

tff(fact_69_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg11: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg11,Msg21) ) ).

tff(fact_70_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_71_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_72_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != nonce(Nat1) ) ).

tff(fact_73_msg_Osimps_I34_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_74_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G,X4) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A1))
    <=> pp(aa(A,bool,A1,X3)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_79_msg_Osimps_I17_J,axiom,
    ! [Agent: agent1,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != agent(Agent) ) ).

tff(fact_80_msg_Osimps_I16_J,axiom,
    ! [Msg2: msg,Msg1: msg,Agent: agent1] : ( agent(Agent) != mPair(Msg1,Msg2) ) ).

tff(fact_81_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent: agent1] : ( agent(Agent) != key(Nat) ) ).

tff(fact_82_msg_Osimps_I13_J,axiom,
    ! [Agent: agent1,Nat: nat] : ( key(Nat) != agent(Agent) ) ).

tff(fact_83_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != nonce(Nat1) ) ).

tff(fact_84_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_85_msg_Osimps_I19_J,axiom,
    ! [Agent: agent1,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent(Agent) ) ).

tff(fact_86_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent: agent1] : ( agent(Agent) != crypt(Nat,Msg) ) ).

tff(fact_87_MPair__used__D,axiom,
    ! [H: list(event),Y1: msg,Xa: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),mPair(Xa,Y1)),used(H)))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Xa),used(H)))
        & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),used(H))) ) ) ).

tff(fact_88_msg_Osimps_I11_J,axiom,
    ! [Agent: agent1,Nat: nat] : ( nonce(Nat) != agent(Agent) ) ).

tff(fact_89_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent: agent1] : ( agent(Agent) != nonce(Nat) ) ).

tff(fact_90_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_91_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_92_Collect__conv__if,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A2)),P1)) = insert(A,A2,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,combc(A,A,bool,fequal(A),A2)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_93_Collect__conv__if2,axiom,
    ! [A: $tType,A2: A,P1: fun(A,bool)] :
      ( ( pp(aa(A,bool,P1,A2))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A2)),P1)) = insert(A,A2,bot_bot(fun(A,bool))) ) )
      & ( ~ pp(aa(A,bool,P1,A2))
       => ( collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,aa(A,fun(A,bool),fequal(A),A2)),P1)) = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_94_Spy__see__shrK,axiom,
    ! [A1: agent1,Evsa: list(event)] :
      ( pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),Evsa),nS_Sha254967238shared))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(shrK(A1))),parts(knows(spy,Evsa))))
      <=> pp(aa(fun(agent1,bool),bool,aa(agent1,fun(fun(agent1,bool),bool),member(agent1),A1),bad)) ) ) ).

tff(fact_95_pushes_I5_J,axiom,
    ! [A1: fun(msg,bool),Y1: msg,Xa: msg,Ka: nat] : ( insert(msg,key(Ka),insert(msg,mPair(Xa,Y1),A1)) = insert(msg,mPair(Xa,Y1),insert(msg,key(Ka),A1)) ) ).

tff(fact_96_pushes_I12_J,axiom,
    ! [A1: fun(msg,bool),Y1: msg,X2: msg,Ka: msg,Xa: nat] : ( insert(msg,crypt(Xa,Ka),insert(msg,mPair(X2,Y1),A1)) = insert(msg,mPair(X2,Y1),insert(msg,crypt(Xa,Ka),A1)) ) ).

tff(fact_97_pushes_I6_J,axiom,
    ! [A1: fun(msg,bool),K: msg,Xa: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,crypt(Xa,K),A1)) = insert(msg,crypt(Xa,K),insert(msg,key(Ka),A1)) ) ).

tff(fact_98_pushes_I2_J,axiom,
    ! [A1: fun(msg,bool),N: nat,Ka: nat] : ( insert(msg,key(Ka),insert(msg,nonce(N),A1)) = insert(msg,nonce(N),insert(msg,key(Ka),A1)) ) ).

tff(fact_99_pushes_I1_J,axiom,
    ! [A1: fun(msg,bool),C1: agent1,Ka: nat] : ( insert(msg,key(Ka),insert(msg,agent(C1),A1)) = insert(msg,agent(C1),insert(msg,key(Ka),A1)) ) ).

%----Helper facts (21)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y))
      | ( X1 = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X1: A] :
      ( ( X1 != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X1),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (7)
tff(conj_0,hypothesis,
    ! [X: agent1] : ( kab1 != shrK(X) ) ).

tff(conj_1,hypothesis,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),evs2),nS_Sha254967238shared)) ).

tff(conj_2,hypothesis,
    ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(kab,x)),parts(knows(spy,evs2))))
      & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),parts(insert(msg,x,bot_bot(fun(msg,bool)))))) )
   => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),parts(knows(spy,evs2)))) ) ).

tff(conj_3,hypothesis,
    ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(kABa)),used(evs2))) ).

tff(conj_4,hypothesis,
    pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),kABa),symKeys)) ).

tff(conj_5,hypothesis,
    pp(aa(fun(event,bool),bool,aa(event,fun(fun(event,bool),bool),member(event),says(a1,server,mPair(agent(a),mPair(agent(b),nonce(na))))),set(event,evs2))) ).

tff(conj_6,conjecture,
    ( ( ( ( kab != shrK(a) )
        | ( x != mPair(nonce(na),mPair(agent(b),mPair(key(kABa),crypt(shrK(b),mPair(key(kABa),agent(a)))))) ) )
      & ( ( kab != shrK(b) )
        | ( x != mPair(key(kABa),agent(a)) ) )
      & ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),crypt(kab,x)),parts(knows(spy,evs2)))) )
    | ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),parts(insert(msg,x,bot_bot(fun(msg,bool))))))
    | ( k = kABa )
    | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),parts(knows(spy,evs2)))) ) ).

%------------------------------------------------------------------------------
