%------------------------------------------------------------------------------
% File     : SWV731_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 174
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_174 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  152 (  51 unt;  41 typ;   0 def)
%            Number of atoms       :  198 (  61 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  131 (  44   ~;   2   |;  10   &)
%                                         (  20 <=>;  55  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   25 (  18   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;  15 con; 0-4 aty)
%            Number of variables   :  284 ( 273   !;   1   ?; 284   :)
%                                         (  10  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent1: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Public_Okeymode,type,
    keymode: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent1,bool) ).

tff(sy_c_Event_OinitState,type,
    initState: agent1 > fun(msg,bool) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent1 * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent1 ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OinvKey,type,
    invKey: fun(nat,nat) ).

tff(sy_c_Message_OkeysFor,type,
    keysFor: fun(msg,bool) > fun(nat,bool) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent: agent1 > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: fun(nat,msg) ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

tff(sy_c_Public_OpublicKey,type,
    publicKey: keymode > fun(agent1,nat) ).

tff(sy_c_Public_OshrK,type,
    shrK: fun(agent1,nat) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * fun(A,bool) ) > fun(B,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent1 ).

tff(sy_v_B,type,
    b: agent1 ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_NA,type,
    na: msg ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_Spy__see__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),parts(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_1_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent1] :
      ( member(agent1,Aa,bad)
     => member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),knows(spy,Evsa)) ) ).

tff(fact_2_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent1] : member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),knows(Aa,Evsa)) ).

tff(fact_3_Spy__in__bad,axiom,
    member(agent1,spy,bad) ).

tff(fact_4_shrK__image__eq,axiom,
    ! [AA: fun(agent1,bool),X: agent1] :
      ( member(nat,aa(agent1,nat,shrK,X),image(agent1,nat,shrK,AA))
    <=> member(agent1,X,AA) ) ).

tff(fact_5_MPair__parts,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => ~ ( member(msg,Xa,parts(H))
         => ~ member(msg,Y,parts(H)) ) ) ).

tff(fact_6_shrK__injective,axiom,
    ! [Y2: agent1,X: agent1] :
      ( ( aa(agent1,nat,shrK,X) = aa(agent1,nat,shrK,Y2) )
    <=> ( X = Y2 ) ) ).

tff(fact_7_msg_Osimps_I1_J,axiom,
    ! [Agent2: agent1,Agent1: agent1] :
      ( ( agent(Agent1) = agent(Agent2) )
    <=> ( Agent1 = Agent2 ) ) ).

tff(fact_8_msg_Osimps_I7_J,axiom,
    ! [Msg4: msg,Nat3: nat,Msg3: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg3) = crypt(Nat3,Msg4) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg3 = Msg4 ) ) ) ).

tff(fact_9_msg_Osimps_I6_J,axiom,
    ! [Msg23: msg,Msg13: msg,Msg22: msg,Msg12: msg] :
      ( ( mPair(Msg12,Msg22) = mPair(Msg13,Msg23) )
    <=> ( ( Msg12 = Msg13 )
        & ( Msg22 = Msg23 ) ) ) ).

tff(fact_10_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( aa(nat,msg,key,Nat2) = aa(nat,msg,key,Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_11_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_12_parts_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,parts(H)) ) ).

tff(fact_13_parts__partsD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,parts(parts(H)))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_14_parts_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Y,parts(H)) ) ).

tff(fact_15_parts_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_16_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != aa(nat,msg,key,Nat1) ) ).

tff(fact_17_msg_Osimps_I40_J,axiom,
    ! [Msg2: msg,Msg1: msg,Nat1: nat] : ( aa(nat,msg,key,Nat1) != mPair(Msg1,Msg2) ) ).

tff(fact_18_spies__partsEs_I2_J,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_19_parts_OBody,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),parts(H))
     => member(msg,Xa,parts(H)) ) ).

tff(fact_20_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != aa(nat,msg,key,Nat1) ) ).

tff(fact_21_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( aa(nat,msg,key,Nat1) != crypt(Nat,Msg) ) ).

tff(fact_22_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != crypt(Nat,Msg) ) ).

tff(fact_23_msg_Osimps_I49_J,axiom,
    ! [Msg21: msg,Msg11: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg11,Msg21) ) ).

tff(fact_24_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent: agent1] : ( agent(Agent) != aa(nat,msg,key,Nat) ) ).

tff(fact_25_msg_Osimps_I13_J,axiom,
    ! [Agent: agent1,Nat: nat] : ( aa(nat,msg,key,Nat) != agent(Agent) ) ).

tff(fact_26_msg_Osimps_I17_J,axiom,
    ! [Agent: agent1,Msg2: msg,Msg1: msg] : ( mPair(Msg1,Msg2) != agent(Agent) ) ).

tff(fact_27_msg_Osimps_I16_J,axiom,
    ! [Msg2: msg,Msg1: msg,Agent: agent1] : ( agent(Agent) != mPair(Msg1,Msg2) ) ).

tff(fact_28_msg_Osimps_I19_J,axiom,
    ! [Agent: agent1,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent(Agent) ) ).

tff(fact_29_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent: agent1] : ( agent(Agent) != crypt(Nat,Msg) ) ).

tff(fact_30_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_31_UNIV__I,axiom,
    ! [A: $tType,X: A] : member(A,X,top_top(fun(A,bool))) ).

tff(fact_32_top1I,axiom,
    ! [A: $tType,X: A] : pp(aa(A,bool,top_top(fun(A,bool)),X)) ).

tff(fact_33_image__eqI,axiom,
    ! [A: $tType,B: $tType,Aa: fun(B,bool),X: B,F: fun(B,A),B1: A] :
      ( ( B1 = aa(B,A,F,X) )
     => ( member(B,X,Aa)
       => member(A,B1,image(B,A,F,Aa)) ) ) ).

tff(fact_34_range__eqI,axiom,
    ! [A: $tType,B: $tType,X: B,F: fun(B,A),B1: A] :
      ( ( B1 = aa(B,A,F,X) )
     => member(A,B1,image(B,A,F,top_top(fun(B,bool)))) ) ).

tff(fact_35_rangeI,axiom,
    ! [A: $tType,B: $tType,X: B,F: fun(B,A)] : member(A,aa(B,A,F,X),image(B,A,F,top_top(fun(B,bool)))) ).

tff(fact_36_top__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( top(A)
     => ! [X: B] : ( aa(B,A,top_top(fun(B,A)),X) = top_top(A) ) ) ).

tff(fact_37_Spy__analz__shrK,axiom,
    ! [Aa: agent1,Evsa: list(event)] :
      ( member(list(event),Evsa,nS_Sha254967238shared)
     => ( member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),analz(knows(spy,Evsa)))
      <=> member(agent1,Aa,bad) ) ) ).

tff(fact_38_Crypt__Spy__analz__bad,axiom,
    ! [Evsa: list(event),Xa: msg,Aa: agent1] :
      ( member(msg,crypt(aa(agent1,nat,shrK,Aa),Xa),analz(knows(spy,Evsa)))
     => ( member(agent1,Aa,bad)
       => member(msg,Xa,analz(knows(spy,Evsa))) ) ) ).

tff(fact_39_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_40_analz_OInj,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,H)
     => member(msg,Xa,analz(H)) ) ).

tff(fact_41_Key__image__eq,axiom,
    ! [Aa: fun(nat,bool),X: nat] :
      ( member(msg,aa(nat,msg,key,X),image(nat,msg,key,Aa))
    <=> member(nat,X,Aa) ) ).

tff(fact_42_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_43_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_44_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        & member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,analz(H)) ) ).

tff(fact_45_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( ( member(msg,Xa,analz(H))
        | member(msg,Xa,parts(H)) )
    <=> member(msg,Xa,parts(H)) ) ).

tff(fact_46_analz__image__Key,axiom,
    ! [N: fun(nat,bool)] : ( analz(image(nat,msg,key,N)) = image(nat,msg,key,N) ) ).

tff(fact_47_MPair__analz,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => ~ ( member(msg,Xa,analz(H))
         => ~ member(msg,Y,analz(H)) ) ) ).

tff(fact_48_parts__image__Key,axiom,
    ! [N: fun(nat,bool)] : ( parts(image(nat,msg,key,N)) = image(nat,msg,key,N) ) ).

tff(fact_49_analz__analzD,axiom,
    ! [H: fun(msg,bool),Xa: msg] :
      ( member(msg,Xa,analz(analz(H)))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_50_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( ~ member(msg,C,parts(H))
     => ~ member(msg,C,analz(H)) ) ).

tff(fact_51_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C: msg] :
      ( member(msg,C,analz(H))
     => member(msg,C,parts(H)) ) ).

tff(fact_52_analz_OFst,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Xa,analz(H)) ) ).

tff(fact_53_analz_OSnd,axiom,
    ! [H: fun(msg,bool),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),analz(H))
     => member(msg,Y,analz(H)) ) ).

tff(fact_54_Crypt__notin__image__Key,axiom,
    ! [Aa: fun(nat,bool),Xa: msg,Ka: nat] : ~ member(msg,crypt(Ka,Xa),image(nat,msg,key,Aa)) ).

tff(fact_55_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y: msg] :
      ( ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q1) )
     => ( ~ member(msg,Y,analz(knows(spy,Evsa)))
       => pp(Q1) ) ) ).

tff(fact_56_analz__shrK__Decrypt,axiom,
    ! [H: fun(msg,bool),Xa: msg,Aa: agent1] :
      ( member(msg,crypt(aa(agent1,nat,shrK,Aa),Xa),analz(H))
     => ( member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),analz(H))
       => member(msg,Xa,analz(H)) ) ) ).

tff(fact_57_image__iff,axiom,
    ! [A: $tType,B: $tType,Aa: fun(B,bool),F: fun(B,A),Z: A] :
      ( member(A,Z,image(B,A,F,Aa))
    <=> ? [X3: B] :
          ( member(B,X3,Aa)
          & ( Z = aa(B,A,F,X3) ) ) ) ).

tff(fact_58_imageI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Aa: fun(A,bool),X: A] :
      ( member(A,X,Aa)
     => member(B,aa(A,B,F,X),image(A,B,F,Aa)) ) ).

tff(fact_59_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),B1: B,Aa: fun(A,bool),X: A] :
      ( member(A,X,Aa)
     => ( ( B1 = aa(A,B,F,X) )
       => member(B,B1,image(A,B,F,Aa)) ) ) ).

tff(fact_60_UNIV__def,axiom,
    ! [A: $tType] : ( top_top(fun(A,bool)) = collect(A,combk(bool,A,fTrue)) ) ).

tff(fact_61_analz__trivial,axiom,
    ! [H: fun(msg,bool)] :
      ( ! [X2: msg,Y1: msg] : ~ member(msg,mPair(X2,Y1),H)
     => ( ! [X2: msg,K1: nat] : ~ member(msg,crypt(K1,X2),H)
       => ( analz(H) = H ) ) ) ).

tff(fact_62_analz__spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(agent1,nat,publicKey(B1),Aa)),analz(knows(spy,Evsa))) ).

tff(fact_63_Key__not__used,axiom,
    ! [Evsa: list(event),Ka: nat] :
      ( ~ member(msg,aa(nat,msg,key,Ka),used(Evsa))
     => ~ member(nat,Ka,image(agent1,nat,shrK,top_top(fun(agent1,bool)))) ) ).

tff(fact_64_analz__Decrypt_H,axiom,
    ! [H: fun(msg,bool),Xa: msg,Ka: nat] :
      ( member(msg,crypt(Ka,Xa),analz(H))
     => ( member(nat,Ka,symKeys)
       => ( member(msg,aa(nat,msg,key,Ka),analz(H))
         => member(msg,Xa,analz(H)) ) ) ) ).

tff(fact_65_shrK__in__initState,axiom,
    ! [Aa: agent1] : member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),initState(Aa)) ).

tff(fact_66_publicKey__inject,axiom,
    ! [A3: agent1,C: keymode,Aa: agent1,B1: keymode] :
      ( ( aa(agent1,nat,publicKey(B1),Aa) = aa(agent1,nat,publicKey(C),A3) )
    <=> ( ( B1 = C )
        & ( Aa = A3 ) ) ) ).

tff(fact_67_MPair__used,axiom,
    ! [H: list(event),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),used(H))
     => ~ ( member(msg,Xa,used(H))
         => ~ member(msg,Y,used(H)) ) ) ).

tff(fact_68_publicKey__image__eq,axiom,
    ! [AA: fun(agent1,bool),C: keymode,X: agent1,B1: keymode] :
      ( member(nat,aa(agent1,nat,publicKey(B1),X),image(agent1,nat,publicKey(C),AA))
    <=> ( ( B1 = C )
        & member(agent1,X,AA) ) ) ).

tff(fact_69_sym__shrK,axiom,
    ! [Xa: agent1] : member(nat,aa(agent1,nat,shrK,Xa),symKeys) ).

tff(fact_70_shrK__in__used,axiom,
    ! [Evsa: list(event),Aa: agent1] : member(msg,aa(nat,msg,key,aa(agent1,nat,shrK,Aa)),used(Evsa)) ).

tff(fact_71_publicKey__into__used,axiom,
    ! [Evsa: list(event),Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(agent1,nat,publicKey(B1),Aa)),used(Evsa)) ).

tff(fact_72_publicKey__in__initState,axiom,
    ! [Ba: agent1,Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(agent1,nat,publicKey(B1),Aa)),initState(Ba)) ).

tff(fact_73_usedI,axiom,
    ! [Evsa: list(event),C: msg] :
      ( member(msg,C,parts(knows(spy,Evsa)))
     => member(msg,C,used(Evsa)) ) ).

tff(fact_74_spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(agent1,nat,publicKey(B1),Aa)),knows(spy,Evsa)) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X: A] :
      ( member(A,X,Aa)
    <=> pp(aa(A,bool,Aa,X)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_initState__into__used,axiom,
    ! [Evsa: list(event),Ba: agent1,Xa: msg] :
      ( member(msg,Xa,parts(initState(Ba)))
     => member(msg,Xa,used(Evsa)) ) ).

tff(fact_79_injective__publicKey,axiom,
    ! [A2: agent1,C2: keymode,A1: agent1,B2: keymode] :
      ( ( aa(agent1,nat,publicKey(B2),A1) = aa(agent1,nat,publicKey(C2),A2) )
     => ( ( B2 = C2 )
        & ( A1 = A2 ) ) ) ).

tff(fact_80_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K,symKeys) )
     => ( Ka != K ) ) ).

tff(fact_81_not__symKeys__pubK,axiom,
    ! [Aa: agent1,B1: keymode] : ~ member(nat,aa(agent1,nat,publicKey(B1),Aa),symKeys) ).

tff(fact_82_MPair__used__D,axiom,
    ! [H: list(event),Y: msg,Xa: msg] :
      ( member(msg,mPair(Xa,Y),used(H))
     => ( member(msg,Xa,used(H))
        & member(msg,Y,used(H)) ) ) ).

tff(fact_83_shrK__neq__pubK,axiom,
    ! [A1: agent1,C1: agent1,B2: keymode] : ( aa(agent1,nat,publicKey(B2),C1) != aa(agent1,nat,shrK,A1) ) ).

tff(fact_84_pubK__neq__shrK,axiom,
    ! [C1: agent1,B2: keymode,A1: agent1] : ( aa(agent1,nat,shrK,A1) != aa(agent1,nat,publicKey(B2),C1) ) ).

tff(fact_85_shrK__neq,axiom,
    ! [Ba: agent1,Evsa: list(event),Ka: nat] :
      ( ~ member(msg,aa(nat,msg,key,Ka),used(Evsa))
     => ( aa(agent1,nat,shrK,Ba) != Ka ) ) ).

tff(fact_86_neq__shrK,axiom,
    ! [Ba: agent1,Evsa: list(event),S: nat] :
      ( ~ member(msg,aa(nat,msg,key,S),used(Evsa))
     => ( S != aa(agent1,nat,shrK,Ba) ) ) ).

tff(fact_87_publicKey__notin__image__shrK,axiom,
    ! [AA: fun(agent1,bool),X: agent1,B1: keymode] : ~ member(nat,aa(agent1,nat,publicKey(B1),X),image(agent1,nat,shrK,AA)) ).

tff(fact_88_shrK__notin__image__publicKey,axiom,
    ! [AA: fun(agent1,bool),B1: keymode,X: agent1] : ~ member(nat,aa(agent1,nat,shrK,X),image(agent1,nat,publicKey(B1),AA)) ).

tff(fact_89_Crypt__notin__initState,axiom,
    ! [Ba: agent1,Xa: msg,Ka: nat] : ~ member(msg,crypt(Ka,Xa),parts(initState(Ba))) ).

tff(fact_90_new__keys__not__used,axiom,
    ! [Evsa: list(event),Ka: nat] :
      ( ~ member(msg,aa(nat,msg,key,Ka),used(Evsa))
     => ( member(nat,Ka,symKeys)
       => ( member(list(event),Evsa,nS_Sha254967238shared)
         => ~ member(nat,Ka,keysFor(parts(knows(spy,Evsa)))) ) ) ) ).

tff(fact_91_Spy__spies__bad__privateKey,axiom,
    ! [Evsa: list(event),B1: keymode,Aa: agent1] :
      ( member(agent1,Aa,bad)
     => member(msg,aa(nat,msg,key,aa(nat,nat,invKey,aa(agent1,nat,publicKey(B1),Aa))),knows(spy,Evsa)) ) ).

tff(fact_92_priK__in__initState,axiom,
    ! [Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(nat,nat,invKey,aa(agent1,nat,publicKey(B1),Aa))),initState(Aa)) ).

tff(fact_93_invKey__image__eq,axiom,
    ! [Aa: fun(nat,bool),X: nat] :
      ( member(nat,aa(nat,nat,invKey,X),image(nat,nat,invKey,Aa))
    <=> member(nat,X,Aa) ) ).

tff(fact_94_invKey__eq,axiom,
    ! [K: nat,Ka: nat] :
      ( ( aa(nat,nat,invKey,Ka) = aa(nat,nat,invKey,K) )
    <=> ( Ka = K ) ) ).

tff(fact_95_invKey__shrK,axiom,
    ! [A1: agent1] : ( aa(nat,nat,invKey,aa(agent1,nat,shrK,A1)) = aa(agent1,nat,shrK,A1) ) ).

tff(fact_96_symKeys__invKey__iff,axiom,
    ! [Ka: nat] :
      ( member(nat,aa(nat,nat,invKey,Ka),symKeys)
    <=> member(nat,Ka,symKeys) ) ).

tff(fact_97_privateKey__image__eq,axiom,
    ! [AS: fun(agent1,bool),C: keymode,Aa: agent1,B1: keymode] :
      ( member(nat,aa(nat,nat,invKey,aa(agent1,nat,publicKey(B1),Aa)),image(nat,nat,invKey,image(agent1,nat,publicKey(C),AS)))
    <=> ( ( B1 = C )
        & member(agent1,Aa,AS) ) ) ).

tff(fact_98_privateKey__into__used,axiom,
    ! [Evsa: list(event),Aa: agent1,B1: keymode] : member(msg,aa(nat,msg,key,aa(nat,nat,invKey,aa(agent1,nat,publicKey(B1),Aa))),used(Evsa)) ).

tff(fact_99_invKey__K,axiom,
    ! [Ka: nat] :
      ( member(nat,Ka,symKeys)
     => ( aa(nat,nat,invKey,Ka) = Ka ) ) ).

%----Arities (2)
tff(arity_fun___Orderings_Otop,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( top(T_2)
     => top(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Otop,axiom,
    top(bool) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    member(msg,crypt(aa(agent1,nat,shrK,a),mPair(na,mPair(agent(b),mPair(aa(nat,msg,key,k),x)))),parts(knows(spy,evs))) ).

tff(conj_1,hypothesis,
    ~ member(agent1,a,bad) ).

tff(conj_2,hypothesis,
    member(list(event),evs,nS_Sha254967238shared) ).

tff(conj_3,conjecture,
    ( ~ member(nat,k,image(agent1,nat,shrK,top_top(fun(agent1,bool))))
    & ( x = crypt(aa(agent1,nat,shrK,b),mPair(aa(nat,msg,key,k),agent(a))) ) ) ).

%------------------------------------------------------------------------------
