%------------------------------------------------------------------------------
% File     : SWV727_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 145
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_145 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  52 unt;  39 typ;   0 def)
%            Number of atoms       :  247 (  91 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  165 (  44   ~;  21   |;  13   &)
%                                         (  19 <=>;  68  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   16 (   5 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   27 (  19   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :    3 (   2 usr;   0 prp; 1-2 aty)
%            Number of functors    :   32 (  32 usr;  11 con; 0-5 aty)
%            Number of variables   :  342 ( 315   !;   6   ?; 342   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:36
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OkeysFor,type,
    keysFor: fun(msg,bool) > fun(nat,bool) ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_Message_Osynth,type,
    synth: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > fun(A,bool) ) ).

tff(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( fun(A,bool) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun(A,fun(fun(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_K,type,
    k: nat ).

tff(sy_v_X,type,
    x: msg ).

tff(sy_v_evsf,type,
    evsf: list(event) ).

%----Relevant facts (100)
tff(fact_0_usedI,axiom,
    ! [Evsa: list(event),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(knows(spy,Evsa))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),used(Evsa))) ) ).

tff(fact_1_keysFor__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( keysFor(insert(msg,key(Ka),H)) = keysFor(H) ) ).

tff(fact_2_parts__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] : ( parts(insert(msg,key(Ka),H)) = insert(msg,key(Ka),parts(H)) ) ).

tff(fact_3_parts__empty,axiom,
    parts(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_4_parts__emptyE,axiom,
    ! [X1: msg] : ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(bot_bot(fun(msg,bool))))) ).

tff(fact_5_analz__empty,axiom,
    analz(bot_bot(fun(msg,bool))) = bot_bot(fun(msg,bool)) ).

tff(fact_6_Key__synth__eq,axiom,
    ! [H: fun(msg,bool),Ka: nat] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(Ka)),synth(H)))
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(Ka)),H)) ) ).

tff(fact_7_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_8_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_9_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
        & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_10_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
        | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) )
    <=> pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_11_syan__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y1: msg] :
      ( ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),synth(analz(knows(spy,Evsa)))))
       => pp(Q1) )
     => ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),synth(analz(knows(spy,Evsa)))))
       => pp(Q1) ) ) ).

tff(fact_12_analz_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_13_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_14_parts_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_15_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_16_msg_Osimps_I4_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( key(Nat) = key(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_17_synth_OInj,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),H))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(H))) ) ).

tff(fact_18_analz__analzD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(analz(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H))) ) ).

tff(fact_19_parts__partsD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(parts(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H))) ) ).

tff(fact_20_synth__synthD,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(synth(H))))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(H))) ) ).

tff(fact_21_synth__idem,axiom,
    ! [H: fun(msg,bool)] : ( synth(synth(H)) = synth(H) ) ).

tff(fact_22_analz__insert__cong,axiom,
    ! [X1: msg,H1: fun(msg,bool),H: fun(msg,bool)] :
      ( ( analz(H) = analz(H1) )
     => ( analz(insert(msg,X1,H)) = analz(insert(msg,X1,H1)) ) ) ).

tff(fact_23_analz__cut,axiom,
    ! [H: fun(msg,bool),X1: msg,Y1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(insert(msg,X1,H))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(H))) ) ) ).

tff(fact_24_analz__insert__eq,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),analz(H)))
     => ( analz(insert(msg,X1,H)) = analz(H) ) ) ).

tff(fact_25_analz__insertI,axiom,
    ! [A1: msg,G: fun(msg,bool),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),analz(G)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),analz(insert(msg,A1,G)))) ) ).

tff(fact_26_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),analz(H)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(H))) ) ).

tff(fact_27_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C2: msg] :
      ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(H)))
     => ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),analz(H))) ) ).

tff(fact_28_parts__cut__eq,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H)))
     => ( parts(insert(msg,X1,H)) = parts(H) ) ) ).

tff(fact_29_parts__insertI,axiom,
    ! [A1: msg,G: fun(msg,bool),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(G)))
     => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(insert(msg,A1,G)))) ) ).

tff(fact_30_synth__cut,axiom,
    ! [H: fun(msg,bool),X1: msg,Y1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),synth(insert(msg,X1,H))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(H)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),synth(H))) ) ) ).

tff(fact_31_Fake__analz__eq,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(analz(H))))
     => ( synth(analz(insert(msg,X1,H))) = synth(analz(H)) ) ) ).

tff(fact_32_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y1: msg] :
      ( ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(knows(spy,Evsa))))
       => pp(Q1) )
     => ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),analz(knows(spy,Evsa))))
       => pp(Q1) ) ) ).

tff(fact_33_analz__insert__Key,axiom,
    ! [H: fun(msg,bool),Ka: nat] :
      ( ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),Ka),keysFor(analz(H))))
     => ( analz(insert(msg,key(Ka),H)) = insert(msg,key(Ka),analz(H)) ) ) ).

tff(fact_34_parts__singleton,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H)))
     => ? [X4: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),H))
          & pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(insert(msg,X4,bot_bot(fun(msg,bool)))))) ) ) ).

tff(fact_35_parts__insert__eq__I,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ! [X4: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),parts(insert(msg,X1,H))))
         => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),insert(msg,X1,parts(H)))) )
     => ( parts(insert(msg,X1,H)) = insert(msg,X1,parts(H)) ) ) ).

tff(fact_36_insertCI,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A1: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B1))
       => ( A1 = B2 ) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,B1))) ) ).

tff(fact_37_insertE,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,A2)))
     => ( ( A1 != B2 )
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_38_insert__iff,axiom,
    ! [A: $tType,A2: fun(A,bool),B2: A,A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,A2)))
    <=> ( ( A1 = B2 )
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ) ).

tff(fact_39_insert__absorb2,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] : ( insert(A,X3,insert(A,X3,A2)) = insert(A,X3,A2) ) ).

tff(fact_40_analz__insert__eq__I,axiom,
    ! [H: fun(msg,bool),X1: msg] :
      ( ! [X4: msg] :
          ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),analz(insert(msg,X1,H))))
         => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X4),insert(msg,X1,analz(H)))) )
     => ( analz(insert(msg,X1,H)) = insert(msg,X1,analz(H)) ) ) ).

tff(fact_41_emptyE,axiom,
    ! [A: $tType,A1: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),bot_bot(fun(A,bool)))) ).

tff(fact_42_Collect__empty__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( collect(A,P1) = bot_bot(fun(A,bool)) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_43_all__not__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ! [X2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
    <=> ( A2 = bot_bot(fun(A,bool)) ) ) ).

tff(fact_44_empty__Collect__eq,axiom,
    ! [A: $tType,P1: fun(A,bool)] :
      ( ( bot_bot(fun(A,bool)) = collect(A,P1) )
    <=> ! [X2: A] : ~ pp(aa(A,bool,P1,X2)) ) ).

tff(fact_45_empty__iff,axiom,
    ! [A: $tType,C2: A] : ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),bot_bot(fun(A,bool)))) ).

tff(fact_46_keysFor__empty,axiom,
    keysFor(bot_bot(fun(msg,bool))) = bot_bot(fun(nat,bool)) ).

tff(fact_47_empty__def,axiom,
    ! [A: $tType] : ( bot_bot(fun(A,bool)) = collect(A,combk(bool,A,fFalse)) ) ).

tff(fact_48_ex__in__conv,axiom,
    ! [A: $tType,A2: fun(A,bool)] :
      ( ? [X2: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
    <=> ( A2 != bot_bot(fun(A,bool)) ) ) ).

tff(fact_49_equals0D,axiom,
    ! [A: $tType,A1: A,A2: fun(A,bool)] :
      ( ( A2 = bot_bot(fun(A,bool)) )
     => ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2)) ) ).

tff(fact_50_insertI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A] : pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,A1,B1))) ).

tff(fact_51_insert__compr,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A] : ( insert(A,A1,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,A,bool,fequal(A),A1)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_52_insert__Collect,axiom,
    ! [A: $tType,P1: fun(A,bool),A1: A] : ( insert(A,A1,collect(A,P1)) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fimplies,combb(bool,bool,A,fNot,combc(A,A,bool,fequal(A),A1))),P1)) ) ).

tff(fact_53_insert__commute,axiom,
    ! [A: $tType,A2: fun(A,bool),Y2: A,X3: A] : ( insert(A,X3,insert(A,Y2,A2)) = insert(A,Y2,insert(A,X3,A2)) ) ).

tff(fact_54_insert__code,axiom,
    ! [A: $tType,X3: A,A2: fun(A,bool),Y2: A] :
      ( pp(aa(A,bool,insert(A,Y2,A2),X3))
    <=> ( ( Y2 = X3 )
        | pp(aa(A,bool,A2,X3)) ) ) ).

tff(fact_55_insert__ident,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X3: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),B1))
       => ( ( insert(A,X3,A2) = insert(A,X3,B1) )
        <=> ( A2 = B1 ) ) ) ) ).

tff(fact_56_insert__eq__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),B2: A,A2: fun(A,bool),A1: A] :
      ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),B1))
       => ( ( insert(A,A1,A2) = insert(A,B2,B1) )
        <=> ( ( ( A1 = B2 )
             => ( A2 = B1 ) )
            & ( ( A1 != B2 )
             => ? [C3: fun(A,bool)] :
                  ( ( A2 = insert(A,B2,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),C3))
                  & ( B1 = insert(A,A1,C3) )
                  & ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),C3)) ) ) ) ) ) ) ).

tff(fact_57_insertI2,axiom,
    ! [A: $tType,B2: A,B1: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),insert(A,B2,B1))) ) ).

tff(fact_58_insert__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),A1),A2))
     => ( insert(A,A1,A2) = A2 ) ) ).

tff(fact_59_empty__not__insert,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( bot_bot(fun(A,bool)) != insert(A,A1,A2) ) ).

tff(fact_60_insert__not__empty,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( insert(A,A1,A2) != bot_bot(fun(A,bool)) ) ).

tff(fact_61_singleton__iff,axiom,
    ! [A: $tType,A1: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A1,bot_bot(fun(A,bool)))))
    <=> ( B2 = A1 ) ) ).

tff(fact_62_doubleton__eq__iff,axiom,
    ! [A: $tType,D: A,C2: A,B2: A,A1: A] :
      ( ( insert(A,A1,insert(A,B2,bot_bot(fun(A,bool)))) = insert(A,C2,insert(A,D,bot_bot(fun(A,bool)))) )
    <=> ( ( ( A1 = C2 )
          & ( B2 = D ) )
        | ( ( A1 = D )
          & ( B2 = C2 ) ) ) ) ).

tff(fact_63_singletonE,axiom,
    ! [A: $tType,A1: A,B2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),B2),insert(A,A1,bot_bot(fun(A,bool)))))
     => ( B2 = A1 ) ) ).

tff(fact_64_singleton__inject,axiom,
    ! [A: $tType,B2: A,A1: A] :
      ( ( insert(A,A1,bot_bot(fun(A,bool))) = insert(A,B2,bot_bot(fun(A,bool))) )
     => ( A1 = B2 ) ) ).

tff(fact_65_the__elem__eq,axiom,
    ! [A: $tType,X3: A] : ( the_elem(A,insert(A,X3,bot_bot(fun(A,bool)))) = X3 ) ).

tff(fact_66_bot__fun__def,axiom,
    ! [A: $tType,B: $tType] :
      ( bot(B)
     => ! [X5: A] : ( aa(A,B,bot_bot(fun(A,B)),X5) = bot_bot(B) ) ) ).

tff(fact_67_bot__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( bot(A)
     => ! [X3: B] : ( aa(B,A,bot_bot(fun(B,A)),X3) = bot_bot(A) ) ) ).

tff(fact_68_parts__insert__spies,axiom,
    ! [Evsa: list(event),X1: msg] : ( parts(insert(msg,X1,knows(spy,Evsa))) = sup_sup(fun(msg,bool),parts(insert(msg,X1,bot_bot(fun(msg,bool)))),parts(knows(spy,Evsa))) ) ).

tff(fact_69_Fake__parts__sing__imp__Un,axiom,
    ! [H: fun(msg,bool),X1: msg,C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(insert(msg,X1,bot_bot(fun(msg,bool))))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),synth(analz(H))))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),sup_sup(fun(msg,bool),synth(analz(H)),parts(H)))) ) ) ).

tff(fact_70_UnCI,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: fun(A,bool),C2: A] :
      ( ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2)) )
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_71_UnE,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B1)))
     => ( ~ pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
       => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_72_Un__iff,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B1)))
    <=> ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
        | pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1)) ) ) ).

tff(fact_73_Un__empty,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] :
      ( ( sup_sup(fun(A,bool),A2,B1) = bot_bot(fun(A,bool)) )
    <=> ( ( A2 = bot_bot(fun(A,bool)) )
        & ( B1 = bot_bot(fun(A,bool)) ) ) ) ).

tff(fact_74_Un__insert__left,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A1: A] : ( sup_sup(fun(A,bool),insert(A,A1,B1),C1) = insert(A,A1,sup_sup(fun(A,bool),B1,C1)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G2: fun(A,B),F: fun(A,B)] :
      ( ! [X4: A] : ( aa(A,B,F,X4) = aa(A,B,G2,X4) )
     => ( F = G2 ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X3: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X3),A2))
    <=> pp(aa(A,bool,A2,X3)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_Un__insert__right,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: A,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,insert(A,A1,B1)) = insert(A,A1,sup_sup(fun(A,bool),A2,B1)) ) ).

tff(fact_79_analz__analz__Un,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] : ( analz(sup_sup(fun(msg,bool),analz(G),H)) = analz(sup_sup(fun(msg,bool),G,H)) ) ).

tff(fact_80_in__parts__UnE,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),C2: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(sup_sup(fun(msg,bool),G,H))))
     => ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(G)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),C2),parts(H))) ) ) ).

tff(fact_81_parts__Un,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] : ( parts(sup_sup(fun(msg,bool),G,H)) = sup_sup(fun(msg,bool),parts(G),parts(H)) ) ).

tff(fact_82_analz__synth__Un,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool)] : ( analz(sup_sup(fun(msg,bool),synth(G),H)) = sup_sup(fun(msg,bool),analz(sup_sup(fun(msg,bool),G,H)),synth(G)) ) ).

tff(fact_83_analz__synth,axiom,
    ! [H: fun(msg,bool)] : ( analz(synth(H)) = sup_sup(fun(msg,bool),analz(H),synth(H)) ) ).

tff(fact_84_parts__synth,axiom,
    ! [H: fun(msg,bool)] : ( parts(synth(H)) = sup_sup(fun(msg,bool),parts(H),synth(H)) ) ).

tff(fact_85_Un__empty__right,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,bot_bot(fun(A,bool))) = A2 ) ).

tff(fact_86_Un__empty__left,axiom,
    ! [A: $tType,B1: fun(A,bool)] : ( sup_sup(fun(A,bool),bot_bot(fun(A,bool)),B1) = B1 ) ).

tff(fact_87_UnI2,axiom,
    ! [A: $tType,A2: fun(A,bool),B1: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),B1))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_88_UnI1,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),C2: A] :
      ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),A2))
     => pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),C2),sup_sup(fun(A,bool),A2,B1))) ) ).

tff(fact_89_ball__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] :
      ( ! [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),sup_sup(fun(A,bool),A2,B1)))
         => pp(aa(A,bool,P1,X2)) )
    <=> ( ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
           => pp(aa(A,bool,P1,X2)) )
        & ! [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
           => pp(aa(A,bool,P1,X2)) ) ) ) ).

tff(fact_90_bex__Un,axiom,
    ! [A: $tType,P1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] :
      ( ? [X2: A] :
          ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),sup_sup(fun(A,bool),A2,B1)))
          & pp(aa(A,bool,P1,X2)) )
    <=> ( ? [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),A2))
            & pp(aa(A,bool,P1,X2)) )
        | ? [X2: A] :
            ( pp(aa(fun(A,bool),bool,aa(A,fun(fun(A,bool),bool),member(A),X2),B1))
            & pp(aa(A,bool,P1,X2)) ) ) ) ).

tff(fact_91_Un__assoc,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),sup_sup(fun(A,bool),A2,B1),C1) = sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B1,C1)) ) ).

tff(fact_92_Un__left__commute,axiom,
    ! [A: $tType,C1: fun(A,bool),B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),B1,C1)) = sup_sup(fun(A,bool),B1,sup_sup(fun(A,bool),A2,C1)) ) ).

tff(fact_93_Un__left__absorb,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,sup_sup(fun(A,bool),A2,B1)) = sup_sup(fun(A,bool),A2,B1) ) ).

tff(fact_94_Un__commute,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B1) = sup_sup(fun(A,bool),B1,A2) ) ).

tff(fact_95_Un__def,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,B1) = collect(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combc(A,fun(A,bool),bool,member(A),A2)),combc(A,fun(A,bool),bool,member(A),B1))) ) ).

tff(fact_96_Un__absorb,axiom,
    ! [A: $tType,A2: fun(A,bool)] : ( sup_sup(fun(A,bool),A2,A2) = A2 ) ).

tff(fact_97_analz__cong,axiom,
    ! [H1: fun(msg,bool),H: fun(msg,bool),G1: fun(msg,bool),G: fun(msg,bool)] :
      ( ( analz(G) = analz(G1) )
     => ( ( analz(H) = analz(H1) )
       => ( analz(sup_sup(fun(msg,bool),G,H)) = analz(sup_sup(fun(msg,bool),G1,H1)) ) ) ) ).

tff(fact_98_insert__is__Un,axiom,
    ! [A: $tType,A2: fun(A,bool),A1: A] : ( insert(A,A1,A2) = sup_sup(fun(A,bool),insert(A,A1,bot_bot(fun(A,bool))),A2) ) ).

tff(fact_99_parts__cut,axiom,
    ! [H: fun(msg,bool),G: fun(msg,bool),X1: msg,Y1: msg] :
      ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(insert(msg,X1,G))))
     => ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),X1),parts(H)))
       => pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),Y1),parts(sup_sup(fun(msg,bool),G,H)))) ) ) ).

%----Arities (3)
tff(arity_fun___Orderings_Obot,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( bot(T_2)
     => bot(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Obot,axiom,
    bot(nat) ).

tff(arity_HOL_Obool___Orderings_Obot,axiom,
    bot(bool) ).

%----Helper facts (18)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),symKeys)) ).

tff(conj_1,hypothesis,
    pp(aa(fun(list(event),bool),bool,aa(list(event),fun(fun(list(event),bool),bool),member(list(event)),evsf),nS_Sha254967238shared)) ).

tff(conj_2,hypothesis,
    ( ~ pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),used(evsf)))
   => ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),keysFor(parts(knows(spy,evsf))))) ) ).

tff(conj_3,hypothesis,
    pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),x),synth(analz(knows(spy,evsf))))) ).

tff(conj_4,conjecture,
    ( pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),parts(insert(msg,x,bot_bot(fun(msg,bool))))))
    | pp(aa(fun(msg,bool),bool,aa(msg,fun(fun(msg,bool),bool),member(msg),key(k)),used(evsf)))
    | ~ pp(aa(fun(nat,bool),bool,aa(nat,fun(fun(nat,bool),bool),member(nat),k),keysFor(parts(insert(msg,x,knows(spy,evsf)))))) ) ).

%------------------------------------------------------------------------------
