%------------------------------------------------------------------------------
% File     : SWV723_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 130
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_130 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  56 unt;  45 typ;   0 def)
%            Number of atoms       :  221 (  55 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :  127 (  26   ~;   4   |;   5   &)
%                                         (  17 <=>;  75  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   4 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   40 (  22   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-3 aty)
%            Number of functors    :   31 (  31 usr;  10 con; 0-5 aty)
%            Number of variables   :  298 ( 276   !;   0   ?; 298   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:19
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Public_Okeymode,type,
    keymode: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Event_Obad,type,
    bad: fun(agent,bool) ).

tff(sy_c_Event_OinitState,type,
    initState: agent > fun(msg,bool) ).

tff(sy_c_Event_Oknows,type,
    knows: ( agent * list(event) ) > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oagent_Oagent__case,type,
    agent_case: 
      !>[T: $tType] : ( ( T * fun(nat,T) * T * agent ) > T ) ).

tff(sy_c_Message_Oagent_Oagent__rec,type,
    agent_rec: 
      !>[T: $tType] : ( ( T * fun(nat,T) * T * agent ) > T ) ).

tff(sy_c_Message_Oanalz,type,
    analz: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OinvKey,type,
    invKey: fun(nat,nat) ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Oparts,type,
    parts: fun(msg,bool) > fun(msg,bool) ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Public_Okeymode_OEncryption,type,
    encryption: keymode ).

tff(sy_c_Public_Okeymode_Okeymode__case,type,
    keymode_case: 
      !>[T: $tType] : ( ( T * T * keymode ) > T ) ).

tff(sy_c_Public_Okeymode_Okeymode__rec,type,
    keymode_rec: 
      !>[T: $tType] : ( ( T * T * keymode ) > T ) ).

tff(sy_c_Public_OpublicKey,type,
    publicKey: ( keymode * agent ) > nat ).

tff(sy_c_Public_OshrK,type,
    shrK: agent > nat ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun(A,bool) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_evs,type,
    evs: list(event) ).

%----Relevant facts (100)
tff(fact_0_Spy__spies__bad__shrK,axiom,
    ! [Evsa: list(event),Aa: agent] :
      ( member(agent,Aa,bad)
     => member(msg,key(shrK(Aa)),knows(spy,Evsa)) ) ).

tff(fact_1_shrK__in__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(shrK(Aa)),knows(Aa,Evsa)) ).

tff(fact_2_Spy__in__bad,axiom,
    member(agent,spy,bad) ).

tff(fact_3_shrK__injective,axiom,
    ! [Y1: agent,X2: agent] :
      ( ( shrK(X2) = shrK(Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_4_msg_Osimps_I4_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( key(Nat) = key(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_5_parts__idem,axiom,
    ! [H: fun(msg,bool)] : ( parts(parts(H)) = parts(H) ) ).

tff(fact_6_parts_OInj,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( member(msg,X4,H)
     => member(msg,X4,parts(H)) ) ).

tff(fact_7_parts__partsD,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( member(msg,X4,parts(parts(H)))
     => member(msg,X4,parts(H)) ) ).

tff(fact_8_usedI,axiom,
    ! [Evsa: list(event),C3: msg] :
      ( member(msg,C3,parts(knows(spy,Evsa)))
     => member(msg,C3,used(Evsa)) ) ).

tff(fact_9_spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent,B4: keymode] : member(msg,key(publicKey(B4,Aa)),knows(spy,Evsa)) ).

tff(fact_10_shrK__in__initState,axiom,
    ! [Aa: agent] : member(msg,key(shrK(Aa)),initState(Aa)) ).

tff(fact_11_ns__sharedp__ns__shared__eq,axiom,
    ! [X5: list(event)] :
      ( nS_Sha993195050haredp(X5)
    <=> member(list(event),X5,nS_Sha254967238shared) ) ).

tff(fact_12_publicKey__inject,axiom,
    ! [A4: agent,C3: keymode,Aa: agent,B4: keymode] :
      ( ( publicKey(B4,Aa) = publicKey(C3,A4) )
    <=> ( ( B4 = C3 )
        & ( Aa = A4 ) ) ) ).

tff(fact_13_publicKey__into__used,axiom,
    ! [Evsa: list(event),Aa: agent,B4: keymode] : member(msg,key(publicKey(B4,Aa)),used(Evsa)) ).

tff(fact_14_shrK__in__used,axiom,
    ! [Evsa: list(event),Aa: agent] : member(msg,key(shrK(Aa)),used(Evsa)) ).

tff(fact_15_publicKey__in__initState,axiom,
    ! [B2: agent,Aa: agent,B4: keymode] : member(msg,key(publicKey(B4,Aa)),initState(B2)) ).

tff(fact_16_injective__publicKey,axiom,
    ! [A3: agent,C2: keymode,A1: agent,B3: keymode] :
      ( ( publicKey(B3,A1) = publicKey(C2,A3) )
     => ( ( B3 = C2 )
        & ( A1 = A3 ) ) ) ).

tff(fact_17_initState__into__used,axiom,
    ! [Evsa: list(event),B2: agent,X4: msg] :
      ( member(msg,X4,parts(initState(B2)))
     => member(msg,X4,used(Evsa)) ) ).

tff(fact_18_shrK__neq__pubK,axiom,
    ! [A1: agent,C4: agent,B3: keymode] : ( publicKey(B3,C4) != shrK(A1) ) ).

tff(fact_19_pubK__neq__shrK,axiom,
    ! [C4: agent,B3: keymode,A1: agent] : ( shrK(A1) != publicKey(B3,C4) ) ).

tff(fact_20_shrK__neq,axiom,
    ! [B2: agent,Evsa: list(event),K: nat] :
      ( ~ member(msg,key(K),used(Evsa))
     => ( shrK(B2) != K ) ) ).

tff(fact_21_neq__shrK,axiom,
    ! [B2: agent,Evsa: list(event),S: nat] :
      ( ~ member(msg,key(S),used(Evsa))
     => ( S != shrK(B2) ) ) ).

tff(fact_22_Spy__spies__bad__privateKey,axiom,
    ! [Evsa: list(event),B4: keymode,Aa: agent] :
      ( member(agent,Aa,bad)
     => member(msg,key(aa(nat,nat,invKey,publicKey(B4,Aa))),knows(spy,Evsa)) ) ).

tff(fact_23_analz__spies__pubK,axiom,
    ! [Evsa: list(event),Aa: agent,B4: keymode] : member(msg,key(publicKey(B4,Aa)),analz(knows(spy,Evsa))) ).

tff(fact_24_priK__in__initState,axiom,
    ! [Aa: agent,B4: keymode] : member(msg,key(aa(nat,nat,invKey,publicKey(B4,Aa))),initState(Aa)) ).

tff(fact_25_parts__knows__Spy__subset__used,axiom,
    ! [Evsa: list(event)] : ord_less_eq(fun(msg,bool),parts(knows(spy,Evsa)),used(Evsa)) ).

tff(fact_26_privateKey__into__used,axiom,
    ! [Evsa: list(event),Aa: agent,B4: keymode] : member(msg,key(aa(nat,nat,invKey,publicKey(B4,Aa))),used(Evsa)) ).

tff(fact_27_agent_Osimps_I10_J,axiom,
    ! [A: $tType,F3: A,F21: fun(nat,A),F11: A] : ( agent_case(A,F11,F21,F3,spy) = F3 ) ).

tff(fact_28_agent_Orecs_I3_J,axiom,
    ! [A: $tType,F3: A,F21: fun(nat,A),F11: A] : ( agent_rec(A,F11,F21,F3,spy) = F3 ) ).

tff(fact_29_knows__Nil,axiom,
    ! [Aa: agent] : ( knows(Aa,nil(event)) = initState(Aa) ) ).

tff(fact_30_sym__shrK,axiom,
    ! [X4: agent] : member(nat,shrK(X4),symKeys) ).

tff(fact_31_analz__idem,axiom,
    ! [H: fun(msg,bool)] : ( analz(analz(H)) = analz(H) ) ).

tff(fact_32_analz_OInj,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( member(msg,X4,H)
     => member(msg,X4,analz(H)) ) ).

tff(fact_33_invKey__eq,axiom,
    ! [K1: nat,K: nat] :
      ( ( aa(nat,nat,invKey,K) = aa(nat,nat,invKey,K1) )
    <=> ( K = K1 ) ) ).

tff(fact_34_analz__parts,axiom,
    ! [H: fun(msg,bool)] : ( analz(parts(H)) = parts(H) ) ).

tff(fact_35_parts__analz,axiom,
    ! [H: fun(msg,bool)] : ( parts(analz(H)) = parts(H) ) ).

tff(fact_36_analz__conj__parts,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ( member(msg,X4,analz(H))
        & member(msg,X4,parts(H)) )
    <=> member(msg,X4,analz(H)) ) ).

tff(fact_37_analz__disj__parts,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( ( member(msg,X4,analz(H))
        | member(msg,X4,parts(H)) )
    <=> member(msg,X4,parts(H)) ) ).

tff(fact_38_analz__subset__iff,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),analz(G1),analz(H))
    <=> ord_less_eq(fun(msg,bool),G1,analz(H)) ) ).

tff(fact_39_parts__subset__iff,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),parts(G1),parts(H))
    <=> ord_less_eq(fun(msg,bool),G1,parts(H)) ) ).

tff(fact_40_invKey__shrK,axiom,
    ! [A1: agent] : ( aa(nat,nat,invKey,shrK(A1)) = shrK(A1) ) ).

tff(fact_41_symKeys__invKey__iff,axiom,
    ! [K: nat] :
      ( member(nat,aa(nat,nat,invKey,K),symKeys)
    <=> member(nat,K,symKeys) ) ).

tff(fact_42_analz__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,analz(H)) ).

tff(fact_43_analz__subset__parts,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),analz(H),parts(H)) ).

tff(fact_44_invKey,axiom,
    ! [K2: nat] : ( aa(nat,nat,invKey,aa(nat,nat,invKey,K2)) = K2 ) ).

tff(fact_45_symKeys__def,axiom,
    symKeys = collect(nat,combs(nat,nat,bool,combb(nat,fun(nat,bool),nat,fequal(nat),invKey),combi(nat))) ).

tff(fact_46_symKeys__neq__imp__neq,axiom,
    ! [K1: nat,K: nat] :
      ( ~ ( member(nat,K,symKeys)
        <=> member(nat,K1,symKeys) )
     => ( K != K1 ) ) ).

tff(fact_47_invKey__K,axiom,
    ! [K: nat] :
      ( member(nat,K,symKeys)
     => ( aa(nat,nat,invKey,K) = K ) ) ).

tff(fact_48_analz__mono,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G1,H)
     => ord_less_eq(fun(msg,bool),analz(G1),analz(H)) ) ).

tff(fact_49_analz__trans,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool),X4: msg] :
      ( member(msg,X4,analz(G1))
     => ( ord_less_eq(fun(msg,bool),G1,analz(H))
       => member(msg,X4,analz(H)) ) ) ).

tff(fact_50_analz__analzD,axiom,
    ! [H: fun(msg,bool),X4: msg] :
      ( member(msg,X4,analz(analz(H)))
     => member(msg,X4,analz(H)) ) ).

tff(fact_51_used__nil__subset,axiom,
    ! [Evsa: list(event)] : ord_less_eq(fun(msg,bool),used(nil(event)),used(Evsa)) ).

tff(fact_52_not__symKeys__priK,axiom,
    ! [Aa: agent,B4: keymode] : ~ member(nat,aa(nat,nat,invKey,publicKey(B4,Aa)),symKeys) ).

tff(fact_53_not__parts__not__analz,axiom,
    ! [H: fun(msg,bool),C3: msg] :
      ( ~ member(msg,C3,parts(H))
     => ~ member(msg,C3,analz(H)) ) ).

tff(fact_54_analz__into__parts,axiom,
    ! [H: fun(msg,bool),C3: msg] :
      ( member(msg,C3,analz(H))
     => member(msg,C3,parts(H)) ) ).

tff(fact_55_parts__increasing,axiom,
    ! [H: fun(msg,bool)] : ord_less_eq(fun(msg,bool),H,parts(H)) ).

tff(fact_56_parts__mono,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool)] :
      ( ord_less_eq(fun(msg,bool),G1,H)
     => ord_less_eq(fun(msg,bool),parts(G1),parts(H)) ) ).

tff(fact_57_parts__trans,axiom,
    ! [H: fun(msg,bool),G1: fun(msg,bool),X4: msg] :
      ( member(msg,X4,parts(G1))
     => ( ord_less_eq(fun(msg,bool),G1,parts(H))
       => member(msg,X4,parts(H)) ) ) ).

tff(fact_58_publicKey__neq__privateKey,axiom,
    ! [A1: agent,B3: keymode,A3: agent,C2: keymode] : ( publicKey(C2,A3) != aa(nat,nat,invKey,publicKey(B3,A1)) ) ).

tff(fact_59_privateKey__neq__publicKey,axiom,
    ! [A3: agent,C2: keymode,A1: agent,B3: keymode] : ( aa(nat,nat,invKey,publicKey(B3,A1)) != publicKey(C2,A3) ) ).

tff(fact_60_ns__shared_ONil,axiom,
    member(list(event),nil(event),nS_Sha254967238shared) ).

tff(fact_61_ns__sharedp_ONil,axiom,
    nS_Sha993195050haredp(nil(event)) ).

tff(fact_62_not__symKeys__pubK,axiom,
    ! [Aa: agent,B4: keymode] : ~ member(nat,publicKey(B4,Aa),symKeys) ).

tff(fact_63_analz__impI,axiom,
    ! [Q1: bool,Evsa: list(event),Y2: msg] :
      ( ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) )
     => ( ~ member(msg,Y2,analz(knows(spy,Evsa)))
       => pp(Q1) ) ) ).

tff(fact_64_initState__subset__knows,axiom,
    ! [Evsa: list(event),Aa: agent] : ord_less_eq(fun(msg,bool),initState(Aa),knows(Aa,Evsa)) ).

tff(fact_65_shrK__neq__priK,axiom,
    ! [A1: agent,C4: agent,B3: keymode] : ( aa(nat,nat,invKey,publicKey(B3,C4)) != shrK(A1) ) ).

tff(fact_66_priK__neq__shrK,axiom,
    ! [C4: agent,B3: keymode,A1: agent] : ( shrK(A1) != aa(nat,nat,invKey,publicKey(B3,C4)) ) ).

tff(fact_67_equalityI,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,B2)
     => ( ord_less_eq(fun(A,bool),B2,Aa)
       => ( Aa = B2 ) ) ) ).

tff(fact_68_subsetD,axiom,
    ! [A: $tType,C3: A,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,B2)
     => ( member(A,C3,Aa)
       => member(A,C3,B2) ) ) ).

tff(fact_69_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_70_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_71_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X2: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_72_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X3: A] : ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3)) ) ) ).

tff(fact_73_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_74_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 = Y1 )
        <=> ( ord_less_eq(A,X2,Y1)
            & ord_less_eq(A,Y1,X2) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X2: A] :
      ( member(A,X2,Aa)
    <=> pp(aa(A,bool,Aa,X2)) ) ).

tff(fact_77_Collect__def,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_78_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_79_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X2: A,Y1: A] :
          ( ord_less_eq(A,Y1,X2)
         => ( ord_less_eq(A,X2,Y1)
          <=> ( X2 = Y1 ) ) ) ) ).

tff(fact_80_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B3: A,A2: A] :
          ( ( A2 = B3 )
         => ( ord_less_eq(A,B3,C2)
           => ord_less_eq(A,A2,C2) ) ) ) ).

tff(fact_81_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C2: A,B3: A,A2: A] :
          ( ord_less_eq(A,A2,B3)
         => ( ( B3 = C2 )
           => ord_less_eq(A,A2,C2) ) ) ) ).

tff(fact_82_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_83_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_84_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_85_subset__refl,axiom,
    ! [A: $tType,Aa: fun(A,bool)] : ord_less_eq(fun(A,bool),Aa,Aa) ).

tff(fact_86_set__eq__subset,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = B2 )
    <=> ( ord_less_eq(fun(A,bool),Aa,B2)
        & ord_less_eq(fun(A,bool),B2,Aa) ) ) ).

tff(fact_87_equalityD1,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = B2 )
     => ord_less_eq(fun(A,bool),Aa,B2) ) ).

tff(fact_88_equalityD2,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = B2 )
     => ord_less_eq(fun(A,bool),B2,Aa) ) ).

tff(fact_89_in__mono,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,B2)
     => ( member(A,X2,Aa)
       => member(A,X2,B2) ) ) ).

tff(fact_90_set__rev__mp,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool),X2: A] :
      ( member(A,X2,Aa)
     => ( ord_less_eq(fun(A,bool),Aa,B2)
       => member(A,X2,B2) ) ) ).

tff(fact_91_set__mp,axiom,
    ! [A: $tType,X2: A,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,B2)
     => ( member(A,X2,Aa)
       => member(A,X2,B2) ) ) ).

tff(fact_92_subset__trans,axiom,
    ! [A: $tType,C1: fun(A,bool),B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ord_less_eq(fun(A,bool),Aa,B2)
     => ( ord_less_eq(fun(A,bool),B2,C1)
       => ord_less_eq(fun(A,bool),Aa,C1) ) ) ).

tff(fact_93_equalityE,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ( Aa = B2 )
     => ~ ( ord_less_eq(fun(A,bool),Aa,B2)
         => ~ ord_less_eq(fun(A,bool),B2,Aa) ) ) ).

tff(fact_94_subsetI,axiom,
    ! [A: $tType,B2: fun(A,bool),Aa: fun(A,bool)] :
      ( ! [X1: A] :
          ( member(A,X1,Aa)
         => member(A,X1,B2) )
     => ord_less_eq(fun(A,bool),Aa,B2) ) ).

tff(fact_95_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X1: A] : ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_96_symKey__neq__priEK,axiom,
    ! [Aa: agent,K: nat] :
      ( member(nat,K,symKeys)
     => ( K != aa(nat,nat,invKey,publicKey(encryption,Aa)) ) ) ).

tff(fact_97_priEK__noteq__shrK,axiom,
    ! [B1: agent,A1: agent] : ( aa(nat,nat,invKey,publicKey(encryption,A1)) != shrK(B1) ) ).

tff(fact_98_keymode_Osimps_I4_J,axiom,
    ! [T: $tType,F2: T,F1: T] : ( keymode_case(T,F1,F2,encryption) = F2 ) ).

tff(fact_99_keymode_Orecs_I2_J,axiom,
    ! [T: $tType,F2: T,F1: T] : ( keymode_rec(T,F1,F2,encryption) = F2 ) ).

%----Arities (11)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (7)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    member(list(event),evs,nS_Sha254967238shared) ).

tff(conj_1,conjecture,
    ( member(msg,key(shrK(a)),parts(knows(spy,evs)))
  <=> member(agent,a,bad) ) ).

%------------------------------------------------------------------------------
