%------------------------------------------------------------------------------
% File     : SWV718_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Needham-Schroeder shared-key protocol line 96
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : ns_96 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  149 (  63 unt;  43 typ;   0 def)
%            Number of atoms       :  198 (  93 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  152 (  60   ~;   1   |;  13   &)
%                                         (  15 <=>;  63  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   56 (  28   >;  28   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   33 (  33 usr;   9 con; 0-5 aty)
%            Number of variables   :  373 ( 352   !;   6   ?; 373   :)
%                                         (  15  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (7)
tff(ty_tc_Event_Oevent,type,
    event: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Message_Oagent,type,
    agent: $tType ).

tff(ty_tc_Message_Omsg,type,
    msg: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_c_Event_Oevent_OGets,type,
    gets: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_ONotes,type,
    notes: ( agent * msg ) > event ).

tff(sy_c_Event_Oevent_OSays,type,
    says: ( agent * agent * msg ) > event ).

tff(sy_c_Event_Oevent_Oevent__case,type,
    event_case: 
      !>[T: $tType] : ( ( fun(agent,fun(agent,fun(msg,T))) * fun(agent,fun(msg,T)) * fun(agent,fun(msg,T)) * event ) > T ) ).

tff(sy_c_Event_Oevent_Oevent__rec,type,
    event_rec: 
      !>[T: $tType] : ( ( fun(agent,fun(agent,fun(msg,T))) * fun(agent,fun(msg,T)) * fun(agent,fun(msg,T)) * event ) > T ) ).

tff(sy_c_Event_OinitState,type,
    initState: agent > fun(msg,bool) ).

tff(sy_c_Event_Oused,type,
    used: list(event) > fun(msg,bool) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Oset,type,
    set: 
      !>[A: $tType] : ( list(A) > fun(A,bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Message_Oagent_OServer,type,
    server: agent ).

tff(sy_c_Message_Oagent_OSpy,type,
    spy: agent ).

tff(sy_c_Message_Oagent_Oagent__case,type,
    agent_case: 
      !>[T: $tType] : ( ( T * fun(nat,T) * T * agent ) > T ) ).

tff(sy_c_Message_Oagent_Oagent__rec,type,
    agent_rec: 
      !>[T: $tType] : ( ( T * fun(nat,T) * T * agent ) > T ) ).

tff(sy_c_Message_Omsg_OAgent,type,
    agent1: agent > msg ).

tff(sy_c_Message_Omsg_OCrypt,type,
    crypt: ( nat * msg ) > msg ).

tff(sy_c_Message_Omsg_OKey,type,
    key: nat > msg ).

tff(sy_c_Message_Omsg_OMPair,type,
    mPair: ( msg * msg ) > msg ).

tff(sy_c_Message_Omsg_ONonce,type,
    nonce: nat > msg ).

tff(sy_c_Message_OsymKeys,type,
    symKeys: fun(nat,bool) ).

tff(sy_c_Message_Osynthp,type,
    synthp: ( fun(msg,bool) * msg ) > $o ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__shared,type,
    nS_Sha254967238shared: fun(list(event),bool) ).

tff(sy_c_NS__Shared__Mirabelle__iywubrjwsc_Ons__sharedp,type,
    nS_Sha993195050haredp: list(event) > $o ).

tff(sy_c_Public_OshrK,type,
    shrK: agent > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_A,type,
    a: agent ).

tff(sy_v_B,type,
    b: agent ).

tff(sy_v_K,type,
    k: nat ).

%----Relevant facts (100)
tff(fact_0_ns__shared_ONil,axiom,
    member(list(event),nil(event),nS_Sha254967238shared) ).

tff(fact_1_MPair__used,axiom,
    ! [H: list(event),Y3: msg,X2: msg] :
      ( member(msg,mPair(X2,Y3),used(H))
     => ~ ( member(msg,X2,used(H))
         => ~ member(msg,Y3,used(H)) ) ) ).

tff(fact_2_Nonce__notin__used__empty,axiom,
    ! [N2: nat] : ~ member(msg,nonce(N2),used(nil(event))) ).

tff(fact_3_Crypt__notin__used__empty,axiom,
    ! [X2: msg,Ka: nat] : ~ member(msg,crypt(Ka,X2),used(nil(event))) ).

tff(fact_4_Says__imp__used,axiom,
    ! [Evs: list(event),X2: msg,Ba: agent,Aa: agent] :
      ( member(event,says(Aa,Ba,X2),set(event,Evs))
     => member(msg,X2,used(Evs)) ) ).

tff(fact_5_event_Osimps_I1_J,axiom,
    ! [Msg3: msg,Agent22: agent,Agent12: agent,Msg2: msg,Agent21: agent,Agent11: agent] :
      ( ( says(Agent11,Agent21,Msg2) = says(Agent12,Agent22,Msg3) )
    <=> ( ( Agent11 = Agent12 )
        & ( Agent21 = Agent22 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_6_msg_Osimps_I3_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( nonce(Nat2) = nonce(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_7_msg_Osimps_I7_J,axiom,
    ! [Msg3: msg,Nat3: nat,Msg2: msg,Nat2: nat] :
      ( ( crypt(Nat2,Msg2) = crypt(Nat3,Msg3) )
    <=> ( ( Nat2 = Nat3 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_8_msg_Osimps_I6_J,axiom,
    ! [Msg24: msg,Msg14: msg,Msg23: msg,Msg13: msg] :
      ( ( mPair(Msg13,Msg23) = mPair(Msg14,Msg24) )
    <=> ( ( Msg13 = Msg14 )
        & ( Msg23 = Msg24 ) ) ) ).

tff(fact_9_msg_Osimps_I4_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( key(Nat2) = key(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_10_MPair__used__D,axiom,
    ! [H: list(event),Y3: msg,X2: msg] :
      ( member(msg,mPair(X2,Y3),used(H))
     => ( member(msg,X2,used(H))
        & member(msg,Y3,used(H)) ) ) ).

tff(fact_11_msg_Osimps_I36_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( nonce(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_12_msg_Osimps_I37_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != nonce(Nat1) ) ).

tff(fact_13_symKeys__neq__imp__neq,axiom,
    ! [K: nat,Ka: nat] :
      ( ~ ( member(nat,Ka,symKeys)
        <=> member(nat,K,symKeys) )
     => ( Ka != K ) ) ).

tff(fact_14_msg_Osimps_I41_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != key(Nat1) ) ).

tff(fact_15_msg_Osimps_I40_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( key(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_16_msg_Osimps_I43_J,axiom,
    ! [Nat1: nat,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != key(Nat1) ) ).

tff(fact_17_msg_Osimps_I42_J,axiom,
    ! [Msg: msg,Nat: nat,Nat1: nat] : ( key(Nat1) != crypt(Nat,Msg) ) ).

tff(fact_18_msg_Osimps_I48_J,axiom,
    ! [Msg: msg,Nat: nat,Msg22: msg,Msg12: msg] : ( mPair(Msg12,Msg22) != crypt(Nat,Msg) ) ).

tff(fact_19_msg_Osimps_I49_J,axiom,
    ! [Msg22: msg,Msg12: msg,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != mPair(Msg12,Msg22) ) ).

tff(fact_20_msg_Osimps_I30_J,axiom,
    ! [Nat: nat,Nat1: nat] : ( nonce(Nat1) != key(Nat) ) ).

tff(fact_21_msg_Osimps_I31_J,axiom,
    ! [Nat1: nat,Nat: nat] : ( key(Nat) != nonce(Nat1) ) ).

tff(fact_22_msg_Osimps_I35_J,axiom,
    ! [Nat1: nat,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != nonce(Nat1) ) ).

tff(fact_23_msg_Osimps_I34_J,axiom,
    ! [Msg21: msg,Msg11: msg,Nat1: nat] : ( nonce(Nat1) != mPair(Msg11,Msg21) ) ).

tff(fact_24_Nonce__supply1,axiom,
    ! [Evs: list(event)] :
    ? [N1: nat] : ~ member(msg,nonce(N1),used(Evs)) ).

tff(fact_25_synthp_OCrypt,axiom,
    ! [Ka: nat,X2: msg,H: fun(msg,bool)] :
      ( synthp(H,X2)
     => ( pp(aa(msg,bool,H,key(Ka)))
       => synthp(H,crypt(Ka,X2)) ) ) ).

tff(fact_26_agent_Osimps_I8_J,axiom,
    ! [A: $tType,F3: A,F2: fun(nat,A),F1: A] : ( agent_case(A,F1,F2,F3,server) = F1 ) ).

tff(fact_27_agent_Orecs_I1_J,axiom,
    ! [A: $tType,F3: A,F2: fun(nat,A),F1: A] : ( agent_rec(A,F1,F2,F3,server) = F1 ) ).

tff(fact_28_event_Osimps_I10_J,axiom,
    ! [A: $tType,Msg2: msg,Agent21: agent,Agent11: agent,F3: fun(agent,fun(msg,A)),F2: fun(agent,fun(msg,A)),F1: fun(agent,fun(agent,fun(msg,A)))] : ( event_case(A,F1,F2,F3,says(Agent11,Agent21,Msg2)) = aa(msg,A,aa(agent,fun(msg,A),aa(agent,fun(agent,fun(msg,A)),F1,Agent11),Agent21),Msg2) ) ).

tff(fact_29_event_Orecs_I1_J,axiom,
    ! [A: $tType,Msg2: msg,Agent21: agent,Agent11: agent,F3: fun(agent,fun(msg,A)),F2: fun(agent,fun(msg,A)),F1: fun(agent,fun(agent,fun(msg,A)))] : ( event_rec(A,F1,F2,F3,says(Agent11,Agent21,Msg2)) = aa(msg,A,aa(agent,fun(msg,A),aa(agent,fun(agent,fun(msg,A)),F1,Agent11),Agent21),Msg2) ) ).

tff(fact_30_ns__shared_ONS2,axiom,
    ! [NA: nat,Ba: agent,Aa: agent,A5: agent,KAB: nat,Evs2: list(event)] :
      ( member(list(event),Evs2,nS_Sha254967238shared)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A5,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),set(event,Evs2))
           => member(list(event),cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent1(Aa)))))))),Evs2),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_31_ns__shared_ONS4,axiom,
    ! [Aa: agent,Ba: agent,A5: agent,Ka: nat,NB: nat,Evs4: list(event)] :
      ( member(list(event),Evs4,nS_Sha254967238shared)
     => ( ~ member(msg,nonce(NB),used(Evs4))
       => ( member(nat,Ka,symKeys)
         => ( member(event,says(A5,Ba,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))),set(event,Evs4))
           => member(list(event),cons(event,says(Ba,Aa,crypt(Ka,nonce(NB))),Evs4),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_32_ns__shared_ONS1,axiom,
    ! [Ba: agent,Aa: agent,NA: nat,Evs1: list(event)] :
      ( member(list(event),Evs1,nS_Sha254967238shared)
     => ( ~ member(msg,nonce(NA),used(Evs1))
       => member(list(event),cons(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),Evs1),nS_Sha254967238shared) ) ) ).

tff(fact_33_msg_Osimps_I1_J,axiom,
    ! [Agent5: agent,Agent4: agent] :
      ( ( agent1(Agent4) = agent1(Agent5) )
    <=> ( Agent4 = Agent5 ) ) ).

tff(fact_34_shrK__injective,axiom,
    ! [Y2: agent,X3: agent] :
      ( ( shrK(X3) = shrK(Y2) )
    <=> ( X3 = Y2 ) ) ).

tff(fact_35_synthp_OInj,axiom,
    ! [X2: msg,H: fun(msg,bool)] :
      ( pp(aa(msg,bool,H,X2))
     => synthp(H,X2) ) ).

tff(fact_36_synthp_OMPair,axiom,
    ! [Y3: msg,X2: msg,H: fun(msg,bool)] :
      ( synthp(H,X2)
     => ( synthp(H,Y3)
       => synthp(H,mPair(X2,Y3)) ) ) ).

tff(fact_37_synthp_OAgent,axiom,
    ! [Agt: agent,H: fun(msg,bool)] : synthp(H,agent1(Agt)) ).

tff(fact_38_sym__shrK,axiom,
    ! [X2: agent] : member(nat,shrK(X2),symKeys) ).

tff(fact_39_shrK__in__used,axiom,
    ! [Evs: list(event),Aa: agent] : member(msg,key(shrK(Aa)),used(Evs)) ).

tff(fact_40_msg_Osimps_I13_J,axiom,
    ! [Agent3: agent,Nat: nat] : ( key(Nat) != agent1(Agent3) ) ).

tff(fact_41_msg_Osimps_I12_J,axiom,
    ! [Nat: nat,Agent3: agent] : ( agent1(Agent3) != key(Nat) ) ).

tff(fact_42_msg_Osimps_I16_J,axiom,
    ! [Msg21: msg,Msg11: msg,Agent3: agent] : ( agent1(Agent3) != mPair(Msg11,Msg21) ) ).

tff(fact_43_msg_Osimps_I17_J,axiom,
    ! [Agent3: agent,Msg21: msg,Msg11: msg] : ( mPair(Msg11,Msg21) != agent1(Agent3) ) ).

tff(fact_44_msg_Osimps_I18_J,axiom,
    ! [Msg: msg,Nat: nat,Agent3: agent] : ( agent1(Agent3) != crypt(Nat,Msg) ) ).

tff(fact_45_msg_Osimps_I19_J,axiom,
    ! [Agent3: agent,Msg: msg,Nat: nat] : ( crypt(Nat,Msg) != agent1(Agent3) ) ).

tff(fact_46_msg_Osimps_I10_J,axiom,
    ! [Nat: nat,Agent3: agent] : ( agent1(Agent3) != nonce(Nat) ) ).

tff(fact_47_msg_Osimps_I11_J,axiom,
    ! [Agent3: agent,Nat: nat] : ( nonce(Nat) != agent1(Agent3) ) ).

tff(fact_48_neq__shrK,axiom,
    ! [Ba: agent,Evs: list(event),S1: nat] :
      ( ~ member(msg,key(S1),used(Evs))
     => ( S1 != shrK(Ba) ) ) ).

tff(fact_49_shrK__neq,axiom,
    ! [Ba: agent,Evs: list(event),Ka: nat] :
      ( ~ member(msg,key(Ka),used(Evs))
     => ( shrK(Ba) != Ka ) ) ).

tff(fact_50_ns__shared_ONS3,axiom,
    ! [X2: msg,Ka: nat,Ba: agent,NA: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( member(list(event),Evs3,nS_Sha254967238shared)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),set(event,Evs3))
           => member(list(event),cons(event,says(Aa,Ba,X2),Evs3),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_51_ns__shared_ONS5,axiom,
    ! [X2: msg,Ba: agent,NA: nat,S: agent,NB: nat,Aa: agent,B1: agent,Ka: nat,Evs5: list(event)] :
      ( member(list(event),Evs5,nS_Sha254967238shared)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B1,Aa,crypt(Ka,nonce(NB))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evs5))
           => member(list(event),cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NB),nonce(NB)))),Evs5),nS_Sha254967238shared) ) ) ) ) ).

tff(fact_52_ns__sharedp_ONS2,axiom,
    ! [NA: nat,Ba: agent,Aa: agent,A5: agent,KAB: nat,Evs2: list(event)] :
      ( nS_Sha993195050haredp(Evs2)
     => ( ~ member(msg,key(KAB),used(Evs2))
       => ( member(nat,KAB,symKeys)
         => ( member(event,says(A5,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),set(event,Evs2))
           => nS_Sha993195050haredp(cons(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(KAB),crypt(shrK(Ba),mPair(key(KAB),agent1(Aa)))))))),Evs2)) ) ) ) ) ).

tff(fact_53_ns__sharedp_ONS4,axiom,
    ! [Aa: agent,Ba: agent,A5: agent,Ka: nat,NB: nat,Evs4: list(event)] :
      ( nS_Sha993195050haredp(Evs4)
     => ( ~ member(msg,nonce(NB),used(Evs4))
       => ( member(nat,Ka,symKeys)
         => ( member(event,says(A5,Ba,crypt(shrK(Ba),mPair(key(Ka),agent1(Aa)))),set(event,Evs4))
           => nS_Sha993195050haredp(cons(event,says(Ba,Aa,crypt(Ka,nonce(NB))),Evs4)) ) ) ) ) ).

tff(fact_54_ns__sharedp_ONS5,axiom,
    ! [X2: msg,Ba: agent,NA: nat,S: agent,NB: nat,Aa: agent,B1: agent,Ka: nat,Evs5: list(event)] :
      ( nS_Sha993195050haredp(Evs5)
     => ( member(nat,Ka,symKeys)
       => ( member(event,says(B1,Aa,crypt(Ka,nonce(NB))),set(event,Evs5))
         => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evs5))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,crypt(Ka,mPair(nonce(NB),nonce(NB)))),Evs5)) ) ) ) ) ).

tff(fact_55_ns__sharedp_ONS3,axiom,
    ! [X2: msg,Ka: nat,Ba: agent,NA: nat,S: agent,Aa: agent,Evs3: list(event)] :
      ( nS_Sha993195050haredp(Evs3)
     => ( ( Aa != server )
       => ( member(event,says(S,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evs3))
         => ( member(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),set(event,Evs3))
           => nS_Sha993195050haredp(cons(event,says(Aa,Ba,X2),Evs3)) ) ) ) ) ).

tff(fact_56_ns__sharedp_ONS1,axiom,
    ! [Ba: agent,Aa: agent,NA: nat,Evs1: list(event)] :
      ( nS_Sha993195050haredp(Evs1)
     => ( ~ member(msg,nonce(NA),used(Evs1))
       => nS_Sha993195050haredp(cons(event,says(Aa,server,mPair(agent1(Aa),mPair(agent1(Ba),nonce(NA)))),Evs1)) ) ) ).

tff(fact_57_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List: list(A),A1: A] :
      ( ( cons(A,A1,List) = cons(A,A4,List3) )
    <=> ( ( A1 = A4 )
        & ( List = List3 ) ) ) ).

tff(fact_58_ns__sharedp__ns__shared__eq,axiom,
    ! [X: list(event)] :
      ( nS_Sha993195050haredp(X)
    <=> member(list(event),X,nS_Sha254967238shared) ) ).

tff(fact_59_ns__sharedp_ONil,axiom,
    nS_Sha993195050haredp(nil(event)) ).

tff(fact_60_not__Cons__self,axiom,
    ! [A: $tType,X4: A,Xs1: list(A)] : ( Xs1 != cons(A,X4,Xs1) ) ).

tff(fact_61_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X4: A] : ( cons(A,X4,Xs1) != Xs1 ) ).

tff(fact_62_set__ConsD,axiom,
    ! [A: $tType,Xs: list(A),X3: A,Y2: A] :
      ( member(A,Y2,set(A,cons(A,X3,Xs)))
     => ( ( Y2 = X3 )
        | member(A,Y2,set(A,Xs)) ) ) ).

tff(fact_63_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A3: A] : ( nil(A) != cons(A,A3,List2) ) ).

tff(fact_64_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A3: A] : ( cons(A,A3,List2) != nil(A) ) ).

tff(fact_65_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y: A,Ys1: list(A)] : ( Xs = cons(A,Y,Ys1) ) ) ).

tff(fact_66_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y1 != cons(A,A2,List1) ) ) ).

tff(fact_67_ns__sharedp_OOops,axiom,
    ! [X2: msg,NA: nat,NB: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( nS_Sha993195050haredp(Evso)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evso))
         => nS_Sha993195050haredp(cons(event,notes(spy,mPair(nonce(NA),mPair(nonce(NB),key(Ka)))),Evso)) ) ) ) ).

tff(fact_68_event_Osimps_I3_J,axiom,
    ! [Msg3: msg,Agent5: agent,Msg2: msg,Agent4: agent] :
      ( ( notes(Agent4,Msg2) = notes(Agent5,Msg3) )
    <=> ( ( Agent4 = Agent5 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_69_agent_Osimps_I4_J,axiom,
    server != spy ).

tff(fact_70_agent_Osimps_I5_J,axiom,
    spy != server ).

tff(fact_71_event_Osimps_I7_J,axiom,
    ! [Msg1: msg,Agent2: agent,Agent1: agent,Msg: msg,Agent: agent] : ( notes(Agent,Msg) != says(Agent1,Agent2,Msg1) ) ).

tff(fact_72_event_Osimps_I6_J,axiom,
    ! [Msg: msg,Agent: agent,Msg1: msg,Agent2: agent,Agent1: agent] : ( says(Agent1,Agent2,Msg1) != notes(Agent,Msg) ) ).

tff(fact_73_agent_Orecs_I3_J,axiom,
    ! [A: $tType,F3: A,F2: fun(nat,A),F1: A] : ( agent_rec(A,F1,F2,F3,spy) = F3 ) ).

tff(fact_74_agent_Osimps_I10_J,axiom,
    ! [A: $tType,F3: A,F2: fun(nat,A),F1: A] : ( agent_case(A,F1,F2,F3,spy) = F3 ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X5: A] : ( aa(A,B,F,X5) = aa(A,B,G,X5) )
     => ( F = G ) ) ).

tff(fact_76_mem__def,axiom,
    ! [A: $tType,Aa: fun(A,bool),X3: A] :
      ( member(A,X3,Aa)
    <=> pp(aa(A,bool,Aa,X3)) ) ).

tff(fact_77_event_Osimps_I12_J,axiom,
    ! [A: $tType,Msg2: msg,Agent4: agent,F3: fun(agent,fun(msg,A)),F2: fun(agent,fun(msg,A)),F1: fun(agent,fun(agent,fun(msg,A)))] : ( event_case(A,F1,F2,F3,notes(Agent4,Msg2)) = aa(msg,A,aa(agent,fun(msg,A),F3,Agent4),Msg2) ) ).

tff(fact_78_event_Orecs_I3_J,axiom,
    ! [A: $tType,Msg2: msg,Agent4: agent,F3: fun(agent,fun(msg,A)),F2: fun(agent,fun(msg,A)),F1: fun(agent,fun(agent,fun(msg,A)))] : ( event_rec(A,F1,F2,F3,notes(Agent4,Msg2)) = aa(msg,A,aa(agent,fun(msg,A),F3,Agent4),Msg2) ) ).

tff(fact_79_Notes__imp__used,axiom,
    ! [Evs: list(event),X2: msg,Aa: agent] :
      ( member(event,notes(Aa,X2),set(event,Evs))
     => member(msg,X2,used(Evs)) ) ).

tff(fact_80_ns__shared_OOops,axiom,
    ! [X2: msg,NA: nat,NB: nat,Ka: nat,Aa: agent,Ba: agent,Evso: list(event)] :
      ( member(list(event),Evso,nS_Sha254967238shared)
     => ( member(event,says(Ba,Aa,crypt(Ka,nonce(NB))),set(event,Evso))
       => ( member(event,says(server,Aa,crypt(shrK(Aa),mPair(nonce(NA),mPair(agent1(Ba),mPair(key(Ka),X2))))),set(event,Evso))
         => member(list(event),cons(event,notes(spy,mPair(nonce(NA),mPair(nonce(NB),key(Ka)))),Evso),nS_Sha254967238shared) ) ) ) ).

tff(fact_81_insert__Nil,axiom,
    ! [A: $tType,X4: A] : ( insert(A,X4,nil(A)) = cons(A,X4,nil(A)) ) ).

tff(fact_82_shrK__in__initState,axiom,
    ! [Aa: agent] : member(msg,key(shrK(Aa)),initState(Aa)) ).

tff(fact_83_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_84_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y1: A,Xs1: list(A),X4: A] : ( splice(A,cons(A,X4,Xs1),cons(A,Y1,Ys)) = cons(A,X4,cons(A,Y1,splice(A,Xs1,Ys))) ) ).

tff(fact_85_in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X3: A] :
      ( member(A,X3,set(A,Xs))
     => ( insert(A,X3,Xs) = Xs ) ) ).

tff(fact_86_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_87_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_88_List_Oinsert__def,axiom,
    ! [A: $tType,Xs: list(A),X3: A] :
      ( ( member(A,X3,set(A,Xs))
       => ( insert(A,X3,Xs) = Xs ) )
      & ( ~ member(A,X3,set(A,Xs))
       => ( insert(A,X3,Xs) = cons(A,X3,Xs) ) ) ) ).

tff(fact_89_not__in__set__insert,axiom,
    ! [A: $tType,Xs: list(A),X3: A] :
      ( ~ member(A,X3,set(A,Xs))
     => ( insert(A,X3,Xs) = cons(A,X3,Xs) ) ) ).

tff(fact_90_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_91_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A1,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List) ) ).

tff(fact_92_used__Gets,axiom,
    ! [Evs: list(event),X2: msg,Aa: agent] : ( used(cons(event,gets(Aa,X2),Evs)) = used(Evs) ) ).

tff(fact_93_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_94_event_Osimps_I2_J,axiom,
    ! [Msg3: msg,Agent5: agent,Msg2: msg,Agent4: agent] :
      ( ( gets(Agent4,Msg2) = gets(Agent5,Msg3) )
    <=> ( ( Agent4 = Agent5 )
        & ( Msg2 = Msg3 ) ) ) ).

tff(fact_95_list__ex1__iff,axiom,
    ! [A: $tType,Xs: list(A),P: fun(A,bool)] :
      ( list_ex1(A,P,Xs)
    <=> ? [X1: A] :
          ( member(A,X1,set(A,Xs))
          & pp(aa(A,bool,P,X1))
          & ! [Y: A] :
              ( ( member(A,Y,set(A,Xs))
                & pp(aa(A,bool,P,Y)) )
             => ( Y = X1 ) ) ) ) ).

tff(fact_96_event_Orecs_I2_J,axiom,
    ! [A: $tType,Msg2: msg,Agent4: agent,F3: fun(agent,fun(msg,A)),F2: fun(agent,fun(msg,A)),F1: fun(agent,fun(agent,fun(msg,A)))] : ( event_rec(A,F1,F2,F3,gets(Agent4,Msg2)) = aa(msg,A,aa(agent,fun(msg,A),F2,Agent4),Msg2) ) ).

tff(fact_97_event_Osimps_I8_J,axiom,
    ! [Msg: msg,Agent: agent,Msg1: msg,Agent3: agent] : ( gets(Agent3,Msg1) != notes(Agent,Msg) ) ).

tff(fact_98_event_Osimps_I9_J,axiom,
    ! [Msg1: msg,Agent3: agent,Msg: msg,Agent: agent] : ( notes(Agent,Msg) != gets(Agent3,Msg1) ) ).

tff(fact_99_event_Osimps_I5_J,axiom,
    ! [Msg1: msg,Agent2: agent,Agent1: agent,Msg: msg,Agent: agent] : ( gets(Agent,Msg) != says(Agent1,Agent2,Msg1) ) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    a != server ).

tff(conj_1,hypothesis,
    ~ member(msg,key(k),used(nil(event))) ).

tff(conj_2,hypothesis,
    member(nat,k,symKeys) ).

tff(conj_3,conjecture,
    ? [N: nat,X: list(event)] :
      ( member(list(event),X,nS_Sha254967238shared)
      & member(event,says(a,b,crypt(k,mPair(nonce(N),nonce(N)))),set(event,X)) ) ).

%------------------------------------------------------------------------------
