%------------------------------------------------------------------------------
% File     : SWV669_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 381
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_381 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  200 (  77 unt;  51 typ;   0 def)
%            Number of atoms       :  345 (  98 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  227 (  31   ~;   5   |;  47   &)
%                                         (  33 <=>; 111  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   4 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   25 (  16   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   25 (  24 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;   7 con; 0-5 aty)
%            Number of variables   :  308 ( 265   !;   0   ?; 308   :)
%                                         (  43  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:21:40
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: fun(nat,nat) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (97)
tff(fact_0_mbound,axiom,
    ord_less(nat,zero_zero(nat),m) ).

tff(fact_1_ibound,axiom,
    ord_less_eq(nat,m,i) ).

tff(fact_2_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),M))),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),J))) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),J)) ) ).

tff(fact_3_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W1: int] : ( aa(nat,B,power_power(B,number_number_of(B,W1)),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,W1)),number_number_of(B,W1)) ) ) ).

tff(fact_4_add__2__eq__Suc_H,axiom,
    ! [N: nat] : ( aa(nat,nat,plus_plus(nat,N),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,suc,aa(nat,nat,suc,N)) ) ).

tff(fact_5_add__2__eq__Suc,axiom,
    ! [N: nat] : ( aa(nat,nat,plus_plus(nat,number_number_of(nat,bit0(bit1(pls)))),N) = aa(nat,nat,suc,aa(nat,nat,suc,N)) ) ).

tff(fact_6_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_7_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_8_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W1: int,V1: int] : ( aa(nat,B,power_power(B,number_number_of(B,V1)),number_number_of(nat,bit0(W1))) = aa(B,B,aa(B,fun(B,B),times_times(B),aa(nat,B,power_power(B,number_number_of(B,V1)),number_number_of(nat,W1))),aa(nat,B,power_power(B,number_number_of(B,V1)),number_number_of(nat,W1))) ) ) ).

tff(fact_9_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W: int,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,W)) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( number_number_of(nat,W) != zero_zero(nat) ) ) ) ) ).

tff(fact_10_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,B2: A,Aa: A] :
          ( ( Aa = aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)) )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)) = B2 ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_11_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [Aa: A,W: int,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)) = Aa )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( B2 = aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)) ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_12_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_13_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X: A] : ( aa(nat,A,power_power(A,X),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X),N)),aa(nat,A,power_power(A,X),N))) ) ) ).

tff(fact_14_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X: A] : ( aa(nat,A,power_power(A,aa(A,A,plus_plus(A,X),Y)),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls))))),aa(nat,A,power_power(A,Y),number_number_of(nat,bit0(bit1(pls)))))),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,bit0(bit1(pls)))),X)),Y)) ) ) ).

tff(fact_15_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X1: int] :
          ( ( number_number_of(A,X1) = number_number_of(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_16_rel__simps_I51_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit1(K1) = bit1(L) )
    <=> ( K1 = L ) ) ).

tff(fact_17_mult__Pls,axiom,
    ! [W1: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),pls),W1) = pls ) ).

tff(fact_18_add__Bit0__Bit0,axiom,
    ! [L1: int,K: int] : ( aa(int,int,plus_plus(int,bit0(K)),bit0(L1)) = bit0(aa(int,int,plus_plus(int,K),L1)) ) ).

tff(fact_19_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),bit0(K)),L1) = bit0(aa(int,int,aa(int,fun(int,int),times_times(int),K),L1)) ) ).

tff(fact_20_rel__simps_I48_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit0(K1) = bit0(L) )
    <=> ( K1 = L ) ) ).

tff(fact_21_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( aa(A,A,plus_plus(A,Aa),Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_22_le__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X1: int] :
          ( ord_less_eq(A,number_number_of(A,X1),number_number_of(A,Y1))
        <=> ord_less_eq(int,X1,Y1) ) ) ).

tff(fact_23_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X1: int] :
          ( ord_less(A,number_number_of(A,X1),number_number_of(A,Y1))
        <=> ord_less(int,X1,Y1) ) ) ).

tff(fact_24_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V1: int] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,V1)),aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W1)),Z)) = aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),times_times(int),V1),W1))),Z) ) ) ).

tff(fact_25_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V1: int] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,V1)),number_number_of(A,W1)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),times_times(int),V1),W1)) ) ) ).

tff(fact_26_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V1: int] : ( aa(A,A,plus_plus(A,number_number_of(A,V1)),aa(A,A,plus_plus(A,number_number_of(A,W1)),Z)) = aa(A,A,plus_plus(A,number_number_of(A,aa(int,int,plus_plus(int,V1),W1))),Z) ) ) ).

tff(fact_27_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V1: int] : ( aa(A,A,plus_plus(A,number_number_of(A,V1)),number_number_of(A,W1)) = number_number_of(A,aa(int,int,plus_plus(int,V1),W1)) ) ) ).

tff(fact_28_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_29_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_30_mult__Bit1,axiom,
    ! [L1: int,K: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),bit1(K)),L1) = aa(int,int,plus_plus(int,bit0(aa(int,int,aa(int,fun(int,int),times_times(int),K),L1))),L1) ) ).

tff(fact_31_add__Bit1__Bit0,axiom,
    ! [L1: int,K: int] : ( aa(int,int,plus_plus(int,bit1(K)),bit0(L1)) = bit1(aa(int,int,plus_plus(int,K),L1)) ) ).

tff(fact_32_add__Bit0__Bit1,axiom,
    ! [L1: int,K: int] : ( aa(int,int,plus_plus(int,bit0(K)),bit1(L1)) = bit1(aa(int,int,plus_plus(int,K),L1)) ) ).

tff(fact_33_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_34_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_35_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_36_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_37_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_38_left__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [V1: int,B1: B,A1: B] : ( aa(B,B,aa(B,fun(B,B),times_times(B),aa(B,B,plus_plus(B,A1),B1)),number_number_of(B,V1)) = aa(B,B,plus_plus(B,aa(B,B,aa(B,fun(B,B),times_times(B),A1),number_number_of(B,V1))),aa(B,B,aa(B,fun(B,B),times_times(B),B1),number_number_of(B,V1))) ) ) ).

tff(fact_39_right__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [C1: B,B1: B,V1: int] : ( aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V1)),aa(B,B,plus_plus(B,B1),C1)) = aa(B,B,plus_plus(B,aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V1)),B1)),aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V1)),C1)) ) ) ).

tff(fact_40_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_41_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_42_zero__less__power__nat__eq__number__of,axiom,
    ! [W: int,X1: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X1),number_number_of(nat,W)))
    <=> ( ( number_number_of(nat,W) = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X1) ) ) ).

tff(fact_43_le__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X1: int] :
          ( ord_less_eq(A,number_number_of(A,X1),zero_zero(A))
        <=> ord_less_eq(int,X1,pls) ) ) ).

tff(fact_44_le__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int] :
          ( ord_less_eq(A,zero_zero(A),number_number_of(A,Y1))
        <=> ord_less_eq(int,pls,Y1) ) ) ).

tff(fact_45_less__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X1: int] :
          ( ord_less(A,number_number_of(A,X1),zero_zero(A))
        <=> ord_less(int,X1,pls) ) ) ).

tff(fact_46_less__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int] :
          ( ord_less(A,zero_zero(A),number_number_of(A,Y1))
        <=> ord_less(int,pls,Y1) ) ) ).

tff(fact_47_divide__less__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [Aa: A,W: int,B2: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)),Aa)
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W))) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)),B2) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,zero_zero(A),Aa) ) ) ) ) ) ) ).

tff(fact_48_less__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,B2: A,Aa: A] :
          ( ord_less(A,Aa,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)))
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)),B2) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W))) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,Aa,zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_49_divide__le__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [Aa: A,W: int,B2: A] :
          ( ord_less_eq(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)),Aa)
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less_eq(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W))) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less_eq(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)),B2) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less_eq(A,zero_zero(A),Aa) ) ) ) ) ) ) ).

tff(fact_50_le__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,B2: A,Aa: A] :
          ( ord_less_eq(A,Aa,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W)))
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less_eq(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W)),B2) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less_eq(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),number_number_of(A,W))) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less_eq(A,Aa,zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_51_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,zero_zero(A),aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))))
        <=> ( Aa != zero_zero(A) ) ) ) ).

tff(fact_52_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_53_zero__less__power__nat__eq,axiom,
    ! [N1: nat,X1: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X1),N1))
    <=> ( ( N1 = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X1) ) ) ).

tff(fact_54_le__number__of__eq__not__less,axiom,
    ! [A: $tType] :
      ( ( number(A)
        & linorder(A) )
     => ! [W: int,V: int] :
          ( ord_less_eq(A,number_number_of(A,V),number_number_of(A,W))
        <=> ~ ord_less(A,number_number_of(A,W),number_number_of(A,V)) ) ) ).

tff(fact_55_add__Pls__right,axiom,
    ! [K: int] : ( aa(int,int,plus_plus(int,K),pls) = K ) ).

tff(fact_56_add__Pls,axiom,
    ! [K: int] : ( aa(int,int,plus_plus(int,pls),K) = K ) ).

tff(fact_57_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = aa(int,int,plus_plus(int,K),K) ) ).

tff(fact_58_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( aa(nat,int,power_power(int,aa(nat,int,power_power(int,X),Y)),Z) = aa(nat,int,power_power(int,X),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Y),Z)) ) ).

tff(fact_59_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_60_zpower__number__of__even,axiom,
    ! [W1: int,Z: int] : ( aa(nat,int,power_power(int,Z),number_number_of(nat,bit0(W1))) = aa(int,int,aa(int,fun(int,int),times_times(int),aa(nat,int,power_power(int,Z),number_number_of(nat,W1))),aa(nat,int,power_power(int,Z),number_number_of(nat,W1))) ) ).

tff(fact_61_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ord_less(A,aa(A,A,plus_plus(A,Aa),Aa),zero_zero(A))
        <=> ord_less(A,Aa,zero_zero(A)) ) ) ).

tff(fact_62_nat__lt__two__imp__zero__or__one,axiom,
    ! [X: nat] :
      ( ord_less(nat,X,aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))))
     => ( ( X = zero_zero(nat) )
        | ( X = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_63_divide__le__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,C2: A,B2: A] :
          ( ord_less_eq(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2),number_number_of(A,W))
        <=> ( ( ord_less(A,zero_zero(A),C2)
             => ord_less_eq(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2)) )
            & ( ~ ord_less(A,zero_zero(A),C2)
             => ( ( ord_less(A,C2,zero_zero(A))
                 => ord_less_eq(A,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2),B2) )
                & ( ~ ord_less(A,C2,zero_zero(A))
                 => ord_less_eq(A,zero_zero(A),number_number_of(A,W)) ) ) ) ) ) ) ).

tff(fact_64_le__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [C2: A,B2: A,W: int] :
          ( ord_less_eq(A,number_number_of(A,W),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2))
        <=> ( ( ord_less(A,zero_zero(A),C2)
             => ord_less_eq(A,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2),B2) )
            & ( ~ ord_less(A,zero_zero(A),C2)
             => ( ( ord_less(A,C2,zero_zero(A))
                 => ord_less_eq(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2)) )
                & ( ~ ord_less(A,C2,zero_zero(A))
                 => ord_less_eq(A,number_number_of(A,W),zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_65_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_66_sum__squares__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y1: A,X1: A] :
          ( ord_less(A,zero_zero(A),aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X1),X1)),aa(A,A,aa(A,fun(A,A),times_times(A),Y1),Y1)))
        <=> ( ( X1 != zero_zero(A) )
            | ( Y1 != zero_zero(A) ) ) ) ) ).

tff(fact_67_not__sum__squares__lt__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [Y: A,X: A] : ~ ord_less(A,aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X),X)),aa(A,A,aa(A,fun(A,A),times_times(A),Y),Y)),zero_zero(A)) ) ).

tff(fact_68_sum__squares__le__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y1: A,X1: A] :
          ( ord_less_eq(A,aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X1),X1)),aa(A,A,aa(A,fun(A,A),times_times(A),Y1),Y1)),zero_zero(A))
        <=> ( ( X1 = zero_zero(A) )
            & ( Y1 = zero_zero(A) ) ) ) ) ).

tff(fact_69_sum__squares__ge__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [Y: A,X: A] : ord_less_eq(A,zero_zero(A),aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X),X)),aa(A,A,aa(A,fun(A,A),times_times(A),Y),Y))) ) ).

tff(fact_70_power2__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls)))),aa(nat,A,power_power(A,Y),number_number_of(nat,bit0(bit1(pls)))))
         => ( ord_less_eq(A,zero_zero(A),Y)
           => ord_less(A,X,Y) ) ) ) ).

tff(fact_71_divide__less__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,C2: A,B2: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2),number_number_of(A,W))
        <=> ( ( ord_less(A,zero_zero(A),C2)
             => ord_less(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2)) )
            & ( ~ ord_less(A,zero_zero(A),C2)
             => ( ( ord_less(A,C2,zero_zero(A))
                 => ord_less(A,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2),B2) )
                & ( ~ ord_less(A,C2,zero_zero(A))
                 => ord_less(A,zero_zero(A),number_number_of(A,W)) ) ) ) ) ) ) ).

tff(fact_72_less__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [C2: A,B2: A,W: int] :
          ( ord_less(A,number_number_of(A,W),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2))
        <=> ( ( ord_less(A,zero_zero(A),C2)
             => ord_less(A,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2),B2) )
            & ( ~ ord_less(A,zero_zero(A),C2)
             => ( ( ord_less(A,C2,zero_zero(A))
                 => ord_less(A,B2,aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),C2)) )
                & ( ~ ord_less(A,C2,zero_zero(A))
                 => ord_less(A,number_number_of(A,W),zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Ry)) ) ) ).

tff(fact_74_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Ry)) ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry))) ) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ly) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Rx)) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ry) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ry)) ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1) = aa(A,A,aa(A,fun(A,A),times_times(A),B1),A1) ) ) ).

tff(fact_81_root__summation,axiom,
    ! [N1: nat,K1: nat] :
      ( ord_less(nat,zero_zero(nat),K1)
     => ( ord_less(nat,K1,N1)
       => ( big_co1399186613setsum(nat,complex,power_power(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N1)),K1)),ord_atLeastLessThan(nat,zero_zero(nat),N1)) = zero_zero(complex) ) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),aa(A,A,plus_plus(A,B1),D)) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),C1) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),B1) ) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),C1) = aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,B1),C1)) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),D) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,C1),aa(A,A,plus_plus(A,A1),D)) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),C1) = aa(A,A,plus_plus(A,C1),A1) ) ) ).

tff(fact_88_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X1: A,W: int] :
          ( ( number_number_of(A,W) = X1 )
        <=> ( X1 = number_number_of(A,W) ) ) ) ).

tff(fact_89_half__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number_ring(A) )
     => ! [R2: A] :
          ( ord_less(A,zero_zero(A),R2)
         => ord_less(A,zero_zero(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),R2),number_number_of(A,bit0(bit1(pls))))) ) ) ).

tff(fact_90_half__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number_ring(A) )
     => ! [R1: A] :
          ( ord_less(A,zero_zero(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),R1),number_number_of(A,bit0(bit1(pls)))))
        <=> ord_less(A,zero_zero(A),R1) ) ) ).

tff(fact_91_power2__less__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ~ ord_less(A,aa(nat,A,power_power(A,A1),number_number_of(nat,bit0(bit1(pls)))),zero_zero(A)) ) ).

tff(fact_92_power2__eq__imp__eq,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y: A,X: A] :
          ( ( aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,A,power_power(A,Y),number_number_of(nat,bit0(bit1(pls)))) )
         => ( ord_less_eq(A,zero_zero(A),X)
           => ( ord_less_eq(A,zero_zero(A),Y)
             => ( X = Y ) ) ) ) ) ).

tff(fact_93_power2__le__imp__le,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls)))),aa(nat,A,power_power(A,Y),number_number_of(nat,bit0(bit1(pls)))))
         => ( ord_less_eq(A,zero_zero(A),Y)
           => ord_less_eq(A,X,Y) ) ) ) ).

tff(fact_94_zero__le__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ord_less_eq(A,zero_zero(A),aa(nat,A,power_power(A,A1),number_number_of(nat,bit0(bit1(pls))))) ) ).

tff(fact_95_less__2__cases,axiom,
    ! [N: nat] :
      ( ord_less(nat,N,number_number_of(nat,bit0(bit1(pls))))
     => ( ( N = zero_zero(nat) )
        | ( N = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_96_root__cancel,axiom,
    ! [K: nat,N: nat,D: nat] :
      ( ord_less(nat,zero_zero(nat),D)
     => ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),D),N))),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),D),K)) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N)),K) ) ) ).

%----Arities (46)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring,axiom,
    semiring(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls))))))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,plus_plus(nat,i),combb(nat,nat,nat,aa(nat,fun(nat,nat),times_times(nat),i),aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))))))),ord_atLeastLessThan(nat,zero_zero(nat),m)) = big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls))))))),combc(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),power_power(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(m)),i))),aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),i))),ord_atLeastLessThan(nat,zero_zero(nat),m)) ).

%------------------------------------------------------------------------------
