%------------------------------------------------------------------------------
% File     : SWV661_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 352
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_352 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  192 (  82 unt;  46 typ;   0 def)
%            Number of atoms       :  256 ( 142 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  130 (  20   ~;   4   |;  24   &)
%                                         (  20 <=>;  62  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  15   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   20 (  19 usr;   0 prp; 1-2 aty)
%            Number of functors    :   23 (  23 usr;   7 con; 0-5 aty)
%            Number of variables   :  266 ( 230   !;   0   ?; 266   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:43
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (41)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_OIDFT,type,
    fFT_Mirabelle_IDFT: ( nat * fun(nat,complex) * nat ) > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: fun(nat,nat) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (97)
tff(fact_0_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),M))),aa(nat,nat,times_times(nat,I),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),J))) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(M)),aa(nat,nat,times_times(nat,I),J)) ) ).

tff(fact_1_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( aa(nat,B,power_power(B,number_number_of(B,W)),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,times_times(B,number_number_of(B,W)),number_number_of(B,W)) ) ) ).

tff(fact_2_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_3_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_4_IDFT__def,axiom,
    ! [Aa: fun(nat,complex),N1: nat,X2: nat] : ( fFT_Mirabelle_IDFT(N1,Aa,X2) = big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),Aa),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(N1)),times_times(nat,X2))),ord_atLeastLessThan(nat,zero_zero(nat),N1)) ) ).

tff(fact_5_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int,V: int] : ( aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,bit0(W))) = aa(B,B,times_times(B,aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))) ) ) ).

tff(fact_6_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_7_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,B2: A,Aa: A] :
          ( ( Aa = aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W1)) )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( aa(A,A,times_times(A,Aa),number_number_of(A,W1)) = B2 ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_8_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [Aa: A,W1: int,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),number_number_of(A,W1)) = Aa )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( B2 = aa(A,A,times_times(A,Aa),number_number_of(A,W1)) ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_9_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,times_times(A,A1),aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_10_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( aa(nat,A,power_power(A,X1),aa(nat,nat,suc,aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,times_times(A,X1),aa(A,A,times_times(A,aa(nat,A,power_power(A,X1),N)),aa(nat,A,power_power(A,X1),N))) ) ) ).

tff(fact_11_mult__eq__1__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,times_times(nat,Ma),N1) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( Ma = aa(nat,nat,suc,zero_zero(nat)) )
        & ( N1 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_12_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_13_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y1) )
        <=> ( X = Y1 ) ) ) ).

tff(fact_14_rel__simps_I51_J,axiom,
    ! [L: int,K: int] :
      ( ( bit1(K) = bit1(L) )
    <=> ( K = L ) ) ).

tff(fact_15_mult__Pls,axiom,
    ! [W: int] : ( aa(int,int,times_times(int,pls),W) = pls ) ).

tff(fact_16_mult__Bit0,axiom,
    ! [L1: int,K1: int] : ( aa(int,int,times_times(int,bit0(K1)),L1) = bit0(aa(int,int,times_times(int,K1),L1)) ) ).

tff(fact_17_rel__simps_I48_J,axiom,
    ! [L: int,K: int] :
      ( ( bit0(K) = bit0(L) )
    <=> ( K = L ) ) ).

tff(fact_18_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( aa(nat,nat,suc,Nat2) = aa(nat,nat,suc,Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_19_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),aa(A,A,times_times(A,number_number_of(A,W)),Z)) = aa(A,A,times_times(A,number_number_of(A,aa(int,int,times_times(int,V),W))),Z) ) ) ).

tff(fact_20_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,times_times(int,V),W)) ) ) ).

tff(fact_21_rel__simps_I46_J,axiom,
    ! [K1: int] : ( bit1(K1) != pls ) ).

tff(fact_22_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_23_rel__simps_I50_J,axiom,
    ! [L1: int,K1: int] : ( bit1(K1) != bit0(L1) ) ).

tff(fact_24_rel__simps_I49_J,axiom,
    ! [L1: int,K1: int] : ( bit0(K1) != bit1(L1) ) ).

tff(fact_25_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_26_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_27_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_28_mult__cancel2,axiom,
    ! [N1: nat,K: nat,Ma: nat] :
      ( ( aa(nat,nat,times_times(nat,Ma),K) = aa(nat,nat,times_times(nat,N1),K) )
    <=> ( ( Ma = N1 )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_29_mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K: nat] :
      ( ( aa(nat,nat,times_times(nat,K),Ma) = aa(nat,nat,times_times(nat,K),N1) )
    <=> ( ( Ma = N1 )
        | ( K = zero_zero(nat) ) ) ) ).

tff(fact_30_mult__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,times_times(nat,Ma),N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_31_mult__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,times_times(nat,M),zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_32_mult__0,axiom,
    ! [N: nat] : ( aa(nat,nat,times_times(nat,zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_33_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_34_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_35_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X1: int] : ( aa(nat,int,power_power(int,aa(nat,int,power_power(int,X1),Y)),Z) = aa(nat,int,power_power(int,X1),aa(nat,nat,times_times(nat,Y),Z)) ) ).

tff(fact_36_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_37_zpower__number__of__even,axiom,
    ! [W: int,Z: int] : ( aa(nat,int,power_power(int,Z),number_number_of(nat,bit0(W))) = aa(int,int,times_times(int,aa(nat,int,power_power(int,Z),number_number_of(nat,W))),aa(nat,int,power_power(int,Z),number_number_of(nat,W))) ) ).

tff(fact_38_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_39_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),aa(A,A,times_times(A,Ly),Ry)) ) ) ).

tff(fact_40_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Ry)) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),aa(A,A,times_times(A,Rx),Ry))) ) ) ).

tff(fact_42_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ly) ) ) ).

tff(fact_43_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Ly)),Rx) = aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Ly),Rx)) ) ) ).

tff(fact_44_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,aa(A,A,times_times(A,Lx),Rx)),Ry) ) ) ).

tff(fact_45_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,times_times(A,Lx),aa(A,A,times_times(A,Rx),Ry)) = aa(A,A,times_times(A,Rx),aa(A,A,times_times(A,Lx),Ry)) ) ) ).

tff(fact_46_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A1: A] : ( aa(A,A,times_times(A,A1),B1) = aa(A,A,times_times(A,B1),A1) ) ) ).

tff(fact_47_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W1: int] :
          ( ( number_number_of(A,W1) = X )
        <=> ( X = number_number_of(A,W1) ) ) ) ).

tff(fact_48_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( aa(nat,nat,suc,X1) = aa(nat,nat,suc,Y) )
     => ( X1 = Y ) ) ).

tff(fact_49_Suc__n__not__n,axiom,
    ! [N: nat] : ( aa(nat,nat,suc,N) != N ) ).

tff(fact_50_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != aa(nat,nat,suc,N) ) ).

tff(fact_51_nat__mult__assoc,axiom,
    ! [K1: nat,N: nat,M: nat] : ( aa(nat,nat,times_times(nat,aa(nat,nat,times_times(nat,M),N)),K1) = aa(nat,nat,times_times(nat,M),aa(nat,nat,times_times(nat,N),K1)) ) ).

tff(fact_52_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,times_times(nat,M),N) = aa(nat,nat,times_times(nat,N),M) ) ).

tff(fact_53_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_54_comm__semiring__1__class_Onormalizing__semiring__rules_I9_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,zero_zero(A)),A1) = zero_zero(A) ) ) ).

tff(fact_55_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,times_times(int,V),W)) = aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_56_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,Y: A,X1: A] : ( aa(nat,A,power_power(A,aa(A,A,times_times(A,X1),Y)),Q1) = aa(A,A,times_times(A,aa(nat,A,power_power(A,X1),Q1)),aa(nat,A,power_power(A,Y),Q1)) ) ) ).

tff(fact_57_Suc__neq__Zero,axiom,
    ! [M: nat] : ( aa(nat,nat,suc,M) != zero_zero(nat) ) ).

tff(fact_58_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M) ) ).

tff(fact_59_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( aa(nat,nat,suc,Nat1) != zero_zero(nat) ) ).

tff(fact_60_Suc__not__Zero,axiom,
    ! [M: nat] : ( aa(nat,nat,suc,M) != zero_zero(nat) ) ).

tff(fact_61_nat_Osimps_I2_J,axiom,
    ! [Nat: nat] : ( zero_zero(nat) != aa(nat,nat,suc,Nat) ) ).

tff(fact_62_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M) ) ).

tff(fact_63_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,P1: nat,X1: A] : ( aa(nat,A,power_power(A,aa(nat,A,power_power(A,X1),P1)),Q1) = aa(nat,A,power_power(A,X1),aa(nat,nat,times_times(nat,P1),Q1)) ) ) ).

tff(fact_64_Suc__mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K: nat] :
      ( ( aa(nat,nat,times_times(nat,aa(nat,nat,suc,K)),Ma) = aa(nat,nat,times_times(nat,aa(nat,nat,suc,K)),N1) )
    <=> ( Ma = N1 ) ) ).

tff(fact_65_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_66_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I28_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X1: A] : ( aa(A,A,times_times(A,aa(nat,A,power_power(A,X1),Q1)),X1) = aa(nat,A,power_power(A,X1),aa(nat,nat,suc,Q1)) ) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I27_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X1: A] : ( aa(A,A,times_times(A,X1),aa(nat,A,power_power(A,X1),Q1)) = aa(nat,A,power_power(A,X1),aa(nat,nat,suc,Q1)) ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I35_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X1: A] : ( aa(nat,A,power_power(A,X1),aa(nat,nat,suc,Q1)) = aa(A,A,times_times(A,X1),aa(nat,A,power_power(A,X1),Q1)) ) ) ).

tff(fact_70_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_71_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,C2: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2) = number_number_of(A,W1) )
        <=> ( ( ( C2 != zero_zero(A) )
             => ( B2 = aa(A,A,times_times(A,number_number_of(A,W1)),C2) ) )
            & ( ( C2 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_72_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C2: A,B2: A,W1: int] :
          ( ( number_number_of(A,W1) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C2) )
        <=> ( ( ( C2 != zero_zero(A) )
             => ( aa(A,A,times_times(A,number_number_of(A,W1)),C2) = B2 ) )
            & ( ( C2 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_73_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X1: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),X1),number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_74_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,number_number_of(A,bit1(pls))),A1) = A1 ) ) ).

tff(fact_75_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_76_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X1: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),X1),number_number_of(A,bit1(pls))) = X1 ) ) ).

tff(fact_77_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_78_power__number__of__even,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [W: int,Z: A] : ( aa(nat,A,power_power(A,Z),number_number_of(nat,bit0(W))) = aa(A,A,times_times(A,aa(nat,A,power_power(A,Z),number_number_of(nat,W))),aa(nat,A,power_power(A,Z),number_number_of(nat,W))) ) ) ).

tff(fact_79_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit1(bit1(pls)))) = aa(A,A,times_times(A,aa(A,A,times_times(A,A1),A1)),A1) ) ) ).

tff(fact_80_numeral__3__eq__3,axiom,
    number_number_of(nat,bit1(bit1(pls))) = aa(nat,nat,suc,aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat)))) ).

tff(fact_81_numeral__1__eq__Suc__0,axiom,
    number_number_of(nat,bit1(pls)) = aa(nat,nat,suc,zero_zero(nat)) ).

tff(fact_82_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,times_times(A,A1),A1) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( aa(A,A,times_times(A,X1),X1) = aa(nat,A,power_power(A,X1),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_84_numeral__2__eq__2,axiom,
    number_number_of(nat,bit0(bit1(pls))) = aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))) ).

tff(fact_85_semiring__norm_I115_J,axiom,
    aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_86_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N)) = aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( aa(nat,A,power_power(A,X1),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N)) = aa(A,A,times_times(A,aa(nat,A,power_power(A,X1),N)),aa(nat,A,power_power(A,X1),N)) ) ) ).

tff(fact_88_power__Suc,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,N)) = aa(A,A,times_times(A,A1),aa(nat,A,power_power(A,A1),N)) ) ) ).

tff(fact_89_power__0__Suc,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] : ( aa(nat,A,power_power(A,zero_zero(A)),aa(nat,nat,suc,N)) = zero_zero(A) ) ) ).

tff(fact_90_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [N1: nat,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),N1) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( N1 != zero_zero(nat) ) ) ) ) ).

tff(fact_91_setsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: fun(B,bool)] : ( big_co1399186613setsum(B,A,combk(A,B,zero_zero(A)),A2) = zero_zero(A) ) ) ).

tff(fact_92_setsum__shift__lb__Suc0__0__upt,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [K: nat,F: fun(nat,A)] :
          ( ( aa(nat,A,F,zero_zero(nat)) = zero_zero(A) )
         => ( big_co1399186613setsum(nat,A,F,ord_atLeastLessThan(nat,aa(nat,nat,suc,zero_zero(nat)),K)) = big_co1399186613setsum(nat,A,F,ord_atLeastLessThan(nat,zero_zero(nat),K)) ) ) ) ).

tff(fact_93_nat__power__eq__Suc__0__iff,axiom,
    ! [Ma: nat,X: nat] :
      ( ( aa(nat,nat,power_power(nat,X),Ma) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( X = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_94_power__Suc__0,axiom,
    ! [N: nat] : ( aa(nat,nat,power_power(nat,aa(nat,nat,suc,zero_zero(nat))),N) = aa(nat,nat,suc,zero_zero(nat)) ) ).

tff(fact_95_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,times_times(A,A1),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),C1)) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(A,A,times_times(A,A1),B1)),C1) ) ) ).

tff(fact_96_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),zero_zero(A)) = zero_zero(A) ) ) ).

%----Arities (43)
tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Osemiring__0,axiom,
    semiring_0(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,times_times(nat,number_number_of(nat,bit0(bit1(pls))))))),combb(complex,complex,nat,times_times(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),i)),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,times_times(nat,i),times_times(nat,number_number_of(nat,bit0(bit1(pls)))))))),ord_atLeastLessThan(nat,zero_zero(nat),m)) = big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,times_times(nat,number_number_of(nat,bit0(bit1(pls))))))),combb(complex,complex,nat,times_times(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),i)),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(m)),times_times(nat,i)))),ord_atLeastLessThan(nat,zero_zero(nat),m)) ).

%------------------------------------------------------------------------------
