%------------------------------------------------------------------------------
% File     : SWV657_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 347
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_347 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  196 (  89 unt;  48 typ;   0 def)
%            Number of atoms       :  252 ( 135 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  117 (  13   ~;   0   |;  24   &)
%                                         (  15 <=>;  65  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   24 (  15   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-2 aty)
%            Number of functors    :   24 (  24 usr;   6 con; 0-5 aty)
%            Number of variables   :  240 ( 200   !;   0   ?; 240   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:15
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_OIDFT,type,
    fFT_Mirabelle_IDFT: ( nat * fun(nat,complex) * nat ) > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (98)
tff(fact_0_root0,axiom,
    fFT_Mirabelle_root(zero_zero(nat)) = one_one(complex) ).

tff(fact_1_root1,axiom,
    fFT_Mirabelle_root(one_one(nat)) = one_one(complex) ).

tff(fact_2_calculation,axiom,
    big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),a),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),times_times(nat,i))),ord_atLeastLessThan(nat,zero_zero(nat),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))) = aa(complex,complex,aa(complex,fun(complex,complex),plus_plus(complex),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,times_times(nat,number_number_of(nat,bit0(bit1(pls)))))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,times_times(nat,i),times_times(nat,number_number_of(nat,bit0(bit1(pls))))))),ord_atLeastLessThan(nat,zero_zero(nat),m))),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat)))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,times_times(nat,i),combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat))))),ord_atLeastLessThan(nat,zero_zero(nat),m))) ).

tff(fact_3_Sum4,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [X1: fun(nat,A)] : ( big_co1399186613setsum(nat,A,X1,ord_atLeastLessThan(nat,zero_zero(nat),number_number_of(nat,bit0(bit0(bit1(pls)))))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(nat,A,X1,zero_zero(nat))),aa(nat,A,X1,one_one(nat)))),aa(nat,A,X1,number_number_of(nat,bit0(bit1(pls)))))),aa(nat,A,X1,number_number_of(nat,bit1(bit1(pls))))) ) ) ).

tff(fact_4_setsum__splice,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [N1: nat,F: fun(nat,A)] : ( big_co1399186613setsum(nat,A,F,ord_atLeastLessThan(nat,zero_zero(nat),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N1))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),big_co1399186613setsum(nat,A,combb(nat,A,nat,F,times_times(nat,number_number_of(nat,bit0(bit1(pls))))),ord_atLeastLessThan(nat,zero_zero(nat),N1))),big_co1399186613setsum(nat,A,combb(nat,A,nat,F,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat))),ord_atLeastLessThan(nat,zero_zero(nat),N1))) ) ) ).

tff(fact_5_root__unity,axiom,
    ! [N: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N)),N) = one_one(complex) ) ).

tff(fact_6_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),M))),aa(nat,nat,times_times(nat,I),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),J))) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(M)),aa(nat,nat,times_times(nat,I),J)) ) ).

tff(fact_7_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( aa(nat,B,power_power(B,number_number_of(B,W)),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,times_times(B,number_number_of(B,W)),number_number_of(B,W)) ) ) ).

tff(fact_8_nat__1__add__1,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),one_one(nat)),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_9_one__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,one_one(A)),number_number_of(nat,bit0(bit1(pls)))) = one_one(A) ) ) ).

tff(fact_10_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_11_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_12_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_13_IDFT__def,axiom,
    ! [Aa: fun(nat,complex),N1: nat,X2: nat] : ( fFT_Mirabelle_IDFT(N1,Aa,X2) = big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),Aa),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(N1)),times_times(nat,X2))),ord_atLeastLessThan(nat,zero_zero(nat),N1)) ) ).

tff(fact_14_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int,V: int] : ( aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,bit0(W))) = aa(B,B,times_times(B,aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))) ) ) ).

tff(fact_15_power__0__left__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [W: int] :
          ( ( ( number_number_of(nat,W) = zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,W)) = one_one(A) ) )
          & ( ( number_number_of(nat,W) != zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,W)) = zero_zero(A) ) ) ) ) ).

tff(fact_16_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(pls)),W)) ) ) ).

tff(fact_17_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),one_one(A)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),bit1(pls))) ) ) ).

tff(fact_18_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_19_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X1: int] :
          ( ( number_number_of(A,X1) = number_number_of(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_20_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_21_mult__Pls,axiom,
    ! [W: int] : ( aa(int,int,times_times(int,pls),W) = pls ) ).

tff(fact_22_mult__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,times_times(int,bit0(K)),L) = bit0(aa(int,int,times_times(int,K),L)) ) ).

tff(fact_23_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_24_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_25_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),aa(A,A,times_times(A,number_number_of(A,W)),Z)) = aa(A,A,times_times(A,number_number_of(A,aa(int,int,times_times(int,V),W))),Z) ) ) ).

tff(fact_26_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,times_times(int,V),W)) ) ) ).

tff(fact_27_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_28_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_29_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_30_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_31_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_32_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_33_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_34_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit0(L)) = bit0(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_35_left__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [V: int,B2: B,A1: B] : ( aa(B,B,times_times(B,aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),B2)),number_number_of(B,V)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,times_times(B,A1),number_number_of(B,V))),aa(B,B,times_times(B,B2),number_number_of(B,V))) ) ) ).

tff(fact_36_right__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [C2: B,B2: B,V: int] : ( aa(B,B,times_times(B,number_number_of(B,V)),aa(B,B,aa(B,fun(B,B),plus_plus(B),B2),C2)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,times_times(B,number_number_of(B,V)),B2)),aa(B,B,times_times(B,number_number_of(B,V)),C2)) ) ) ).

tff(fact_37_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_38_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,W)),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W))),Z) ) ) ).

tff(fact_39_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ) ).

tff(fact_40_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_41_mult__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,times_times(int,bit1(K)),L) = aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(aa(int,int,times_times(int,K),L))),L) ) ).

tff(fact_42_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(K)),bit0(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_43_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit1(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_44_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [Aa: A,W1: int,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),number_number_of(A,W1)) = Aa )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( B1 = aa(A,A,times_times(A,Aa),number_number_of(A,W1)) ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_45_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,B1: A,Aa: A] :
          ( ( Aa = aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),number_number_of(A,W1)) )
        <=> ( ( ( number_number_of(A,W1) != zero_zero(A) )
             => ( aa(A,A,times_times(A,Aa),number_number_of(A,W1)) = B1 ) )
            & ( ( number_number_of(A,W1) = zero_zero(A) )
             => ( Aa = zero_zero(A) ) ) ) ) ) ).

tff(fact_46_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_47_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_48_odd__nonzero,axiom,
    ! [Z: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),Z)),Z) != zero_zero(int) ) ).

tff(fact_49_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_50_Bit1__def,axiom,
    ! [K: int] : ( bit1(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),K)),K) ) ).

tff(fact_51_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( aa(int,int,times_times(int,W),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,W),Z1)),aa(int,int,times_times(int,W),Z2)) ) ).

tff(fact_52_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),number_number_of(int,V)),number_number_of(int,W)) = number_number_of(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ).

tff(fact_53_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( aa(int,int,times_times(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)),W) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,Z1),W)),aa(int,int,times_times(int,Z2),W)) ) ).

tff(fact_54_add__Pls__right,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),K),pls) = K ) ).

tff(fact_55_add__Pls,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),pls),K) = K ) ).

tff(fact_56_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),K),K) ) ).

tff(fact_57_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( aa(nat,int,power_power(int,aa(nat,int,power_power(int,X),Y)),Z) = aa(nat,int,power_power(int,X),aa(nat,nat,times_times(nat,Y),Z)) ) ).

tff(fact_58_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_59_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_60_zpower__number__of__even,axiom,
    ! [W: int,Z: int] : ( aa(nat,int,power_power(int,Z),number_number_of(nat,bit0(W))) = aa(int,int,times_times(int,aa(nat,int,power_power(int,Z),number_number_of(nat,W))),aa(nat,int,power_power(int,Z),number_number_of(nat,W))) ) ).

tff(fact_61_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_62_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X1: A,W1: int] :
          ( ( number_number_of(A,W1) = X1 )
        <=> ( X1 = number_number_of(A,W1) ) ) ) ).

tff(fact_63_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,times_times(int,V),W)) = aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_64_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_65_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y1: A,X1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,times_times(A,X1),X1)),aa(A,A,times_times(A,Y1),Y1)) = zero_zero(A) )
        <=> ( ( X1 = zero_zero(A) )
            & ( Y1 = zero_zero(A) ) ) ) ) ).

tff(fact_66_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_67_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_68_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,pls)),A1) = A1 ) ) ).

tff(fact_69_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),number_number_of(A,pls)) = A1 ) ) ).

tff(fact_70_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_71_nat__number__of__Bit0,axiom,
    ! [W: int] : ( number_number_of(nat,bit0(W)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),number_number_of(nat,W)),number_number_of(nat,W)) ) ).

tff(fact_72_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit0(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_73_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W1: int,C1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),C1) = number_number_of(A,W1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( B1 = aa(A,A,times_times(A,number_number_of(A,W1)),C1) ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_74_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C1: A,B1: A,W1: int] :
          ( ( number_number_of(A,W1) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),C1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( aa(A,A,times_times(A,number_number_of(A,W1)),C1) = B1 ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W1) = zero_zero(A) ) ) ) ) ) ).

tff(fact_75_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit1(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_76_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),X),number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_77_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,number_number_of(A,bit1(pls))),A1) = A1 ) ) ).

tff(fact_78_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_79_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_80_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

tff(fact_81_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),X),number_number_of(A,bit1(pls))) = X ) ) ).

tff(fact_82_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_83_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_84_power__number__of__even,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [W: int,Z: A] : ( aa(nat,A,power_power(A,Z),number_number_of(nat,bit0(W))) = aa(A,A,times_times(A,aa(nat,A,power_power(A,Z),number_number_of(nat,W))),aa(nat,A,power_power(A,Z),number_number_of(nat,W))) ) ) ).

tff(fact_85_double__number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),number_number_of(A,W)) = number_number_of(A,bit0(W)) ) ) ).

tff(fact_86_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit1(bit1(pls)))) = aa(A,A,times_times(A,aa(A,A,times_times(A,A1),A1)),A1) ) ) ).

tff(fact_87_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_88_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_89_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_90_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_91_semiring__one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_92_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,times_times(A,A1),A1) ) ) ).

tff(fact_93_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N)) = aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_94_nat__mult__2,axiom,
    ! [Z: nat] : ( aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),Z) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_95_nat__mult__2__right,axiom,
    ! [Z: nat] : ( aa(nat,nat,times_times(nat,Z),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_96_sum__power2__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(nat,A,power_power(A,X1),number_number_of(nat,bit0(bit1(pls))))),aa(nat,A,power_power(A,Y1),number_number_of(nat,bit0(bit1(pls))))) = zero_zero(A) )
        <=> ( ( X1 = zero_zero(A) )
            & ( Y1 = zero_zero(A) ) ) ) ) ).

tff(fact_97_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X: A] : ( aa(nat,A,power_power(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y)),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls))))),aa(nat,A,power_power(A,Y),number_number_of(nat,bit0(bit1(pls)))))),aa(A,A,times_times(A,aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),X)),Y)) ) ) ).

%----Arities (44)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Osemiring__0,axiom,
    semiring_0(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring,axiom,
    semiring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (5)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(complex,complex,aa(complex,fun(complex,complex),plus_plus(complex),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,times_times(nat,number_number_of(nat,bit0(bit1(pls)))))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,times_times(nat,i),times_times(nat,number_number_of(nat,bit0(bit1(pls))))))),ord_atLeastLessThan(nat,zero_zero(nat),m))),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat)))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,times_times(nat,i),combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat))))),ord_atLeastLessThan(nat,zero_zero(nat),m))) = aa(complex,complex,aa(complex,fun(complex,complex),plus_plus(complex),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,times_times(nat,number_number_of(nat,bit0(bit1(pls)))))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(m)),times_times(nat,i))),ord_atLeastLessThan(nat,zero_zero(nat),m))),aa(complex,complex,times_times(complex,aa(nat,complex,power_power(complex,aa(complex,complex,aa(complex,fun(complex,complex),inverse_divide(complex),one_one(complex)),fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m)))),i)),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,inverse_divide(complex),combb(nat,complex,nat,a,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat)))),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(m)),times_times(nat,i))),ord_atLeastLessThan(nat,zero_zero(nat),m)))) ).

%------------------------------------------------------------------------------
