%------------------------------------------------------------------------------
% File     : SWV653_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 326
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_326 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  163 (  46 unt;  39 typ;   0 def)
%            Number of atoms       :  260 (  71 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  163 (  27   ~;  13   |;  17   &)
%                                         (  36 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :   14 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   20 (  14   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-2 aty)
%            Number of functors    :   22 (  22 usr;   7 con; 0-5 aty)
%            Number of variables   :  239 ( 210   !;   0   ?; 239   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: fun(nat,nat) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (99)
tff(fact_0_mbound,axiom,
    pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),m)) ).

tff(fact_1_ibound,axiom,
    pp(aa(nat,bool,ord_less_eq(nat,m),i)) ).

tff(fact_2_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),M))),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),J))) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),J)) ) ).

tff(fact_3_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W1: int] : ( aa(nat,B,power_power(B,number_number_of(B,W1)),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,W1)),number_number_of(B,W1)) ) ) ).

tff(fact_4_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_5_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_6_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W1: int,V: int] : ( aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,bit0(W1))) = aa(B,B,aa(B,fun(B,B),times_times(B),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W1))),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W1))) ) ) ).

tff(fact_7_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W: int,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,W)) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( number_number_of(nat,W) != zero_zero(nat) ) ) ) ) ).

tff(fact_8_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_9_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X2: A] : ( aa(nat,A,power_power(A,X2),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),X2),aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X2),N)),aa(nat,A,power_power(A,X2),N))) ) ) ).

tff(fact_10_mult__eq__1__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( Ma = aa(nat,nat,suc,zero_zero(nat)) )
        & ( N1 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_11_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_12_power__Suc,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,N)) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(nat,A,power_power(A,A1),N)) ) ) ).

tff(fact_13_power__0__Suc,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] : ( aa(nat,A,power_power(A,zero_zero(A)),aa(nat,nat,suc,N)) = zero_zero(A) ) ) ).

tff(fact_14_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [N1: nat,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),N1) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( N1 != zero_zero(nat) ) ) ) ) ).

tff(fact_15_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( aa(nat,nat,suc,Nat) = aa(nat,nat,suc,Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_16_nat__power__eq__Suc__0__iff,axiom,
    ! [Ma: nat,X3: nat] :
      ( ( aa(nat,nat,power_power(nat,X3),Ma) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( X3 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_17_power__Suc__0,axiom,
    ! [N: nat] : ( aa(nat,nat,power_power(nat,aa(nat,nat,suc,zero_zero(nat))),N) = aa(nat,nat,suc,zero_zero(nat)) ) ).

tff(fact_18_nat__zero__less__power__iff,axiom,
    ! [N1: nat,X3: nat] :
      ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),aa(nat,nat,power_power(nat,X3),N1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),X3))
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_19_less__zeroE,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_20_less__nat__zero__code,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_21_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),N1)) ) ).

tff(fact_22_Suc__mono,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,M)),aa(nat,nat,suc,N))) ) ).

tff(fact_23_Suc__less__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,Ma)),aa(nat,nat,suc,N1)))
    <=> pp(aa(nat,bool,ord_less(nat,Ma),N1)) ) ).

tff(fact_24_lessI,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less(nat,N),aa(nat,nat,suc,N))) ).

tff(fact_25_le__0__eq,axiom,
    ! [N1: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,N1),zero_zero(nat)))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_26_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,zero_zero(nat)),N)) ).

tff(fact_27_le0,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,zero_zero(nat)),N)) ).

tff(fact_28_mult__cancel2,axiom,
    ! [N1: nat,K1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),K1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N1),K1) )
    <=> ( ( Ma = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_29_mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),Ma) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),N1) )
    <=> ( ( Ma = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_30_mult__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_31_mult__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_32_mult__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_33_Suc__le__mono,axiom,
    ! [Ma: nat,N1: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,N1)),aa(nat,nat,suc,Ma)))
    <=> pp(aa(nat,bool,ord_less_eq(nat,N1),Ma)) ) ).

tff(fact_34_less__Suc0,axiom,
    ! [N1: nat] :
      ( pp(aa(nat,bool,ord_less(nat,N1),aa(nat,nat,suc,zero_zero(nat))))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_35_zero__less__Suc,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),aa(nat,nat,suc,N))) ).

tff(fact_36_zero__less__power__nat__eq__number__of,axiom,
    ! [W: int,X3: nat] :
      ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),aa(nat,nat,power_power(nat,X3),number_number_of(nat,W))))
    <=> ( ( number_number_of(nat,W) = zero_zero(nat) )
        | pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),X3)) ) ) ).

tff(fact_37_mult__less__cancel2,axiom,
    ! [N1: nat,K1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),K1)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N1),K1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),K1))
        & pp(aa(nat,bool,ord_less(nat,Ma),N1)) ) ) ).

tff(fact_38_mult__less__cancel1,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),Ma)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),N1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),K1))
        & pp(aa(nat,bool,ord_less(nat,Ma),N1)) ) ) ).

tff(fact_39_nat__0__less__mult__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),Ma))
        & pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),N1)) ) ) ).

tff(fact_40_one__le__mult__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,zero_zero(nat))),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1)))
    <=> ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,zero_zero(nat))),Ma))
        & pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,zero_zero(nat))),N1)) ) ) ).

tff(fact_41_mult__le__cancel2,axiom,
    ! [N1: nat,K1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),K1)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N1),K1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),K1))
       => pp(aa(nat,bool,ord_less_eq(nat,Ma),N1)) ) ) ).

tff(fact_42_mult__le__cancel1,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),Ma)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),N1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),K1))
       => pp(aa(nat,bool,ord_less_eq(nat,Ma),N1)) ) ) ).

tff(fact_43_zero__less__power2,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( pp(aa(A,bool,ord_less(A,zero_zero(A)),aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls))))))
        <=> ( Aa != zero_zero(A) ) ) ) ).

tff(fact_44_less__not__refl,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),N)) ).

tff(fact_45_le__refl,axiom,
    ! [N: nat] : pp(aa(nat,bool,ord_less_eq(nat,N),N)) ).

tff(fact_46_nat__neq__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( Ma != N1 )
    <=> ( pp(aa(nat,bool,ord_less(nat,Ma),N1))
        | pp(aa(nat,bool,ord_less(nat,N1),Ma)) ) ) ).

tff(fact_47_zero__less__power__nat__eq,axiom,
    ! [N1: nat,X3: nat] :
      ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),aa(nat,nat,power_power(nat,X3),N1)))
    <=> ( ( N1 = zero_zero(nat) )
        | pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),X3)) ) ) ).

tff(fact_48_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
      | pp(aa(nat,bool,ord_less_eq(nat,N),M)) ) ).

tff(fact_49_less__eq__Suc__le,axiom,
    ! [Ma: nat,N1: nat] :
      ( pp(aa(nat,bool,ord_less(nat,N1),Ma))
    <=> pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,N1)),Ma)) ) ).

tff(fact_50_nat__less__le,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,Ma),N1))
    <=> ( pp(aa(nat,bool,ord_less_eq(nat,Ma),N1))
        & ( Ma != N1 ) ) ) ).

tff(fact_51_le__eq__less__or__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,Ma),N1))
    <=> ( pp(aa(nat,bool,ord_less(nat,Ma),N1))
        | ( Ma = N1 ) ) ) ).

tff(fact_52_less__Suc__eq__le,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,Ma),aa(nat,nat,suc,N1)))
    <=> pp(aa(nat,bool,ord_less_eq(nat,Ma),N1)) ) ).

tff(fact_53_Suc__le__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,Ma)),N1))
    <=> pp(aa(nat,bool,ord_less(nat,Ma),N1)) ) ).

tff(fact_54_linorder__neqE__nat,axiom,
    ! [Y: nat,X2: nat] :
      ( ( X2 != Y )
     => ( ~ pp(aa(nat,bool,ord_less(nat,X2),Y))
       => pp(aa(nat,bool,ord_less(nat,Y),X2)) ) ) ).

tff(fact_55_nat__power__less__imp__less,axiom,
    ! [N: nat,M: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),I))
     => ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,power_power(nat,I),M)),aa(nat,nat,power_power(nat,I),N)))
       => pp(aa(nat,bool,ord_less(nat,M),N)) ) ) ).

tff(fact_56_less__irrefl__nat,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),N)) ).

tff(fact_57_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( pp(aa(nat,bool,ord_less(nat,N),M))
     => ( M != N ) ) ).

tff(fact_58_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( pp(aa(nat,bool,ord_less(nat,S),T))
     => ( S != T ) ) ).

tff(fact_59_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

tff(fact_60_less__imp__le__nat,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

tff(fact_61_le__imp__less__Suc,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
     => pp(aa(nat,bool,ord_less(nat,M),aa(nat,nat,suc,N))) ) ).

tff(fact_62_Suc__leI,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,M)),N)) ) ).

tff(fact_63_le__less__Suc__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,Ma),N1))
     => ( pp(aa(nat,bool,ord_less(nat,N1),aa(nat,nat,suc,Ma)))
      <=> ( N1 = Ma ) ) ) ).

tff(fact_64_le__neq__implies__less,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
     => ( ( M != N )
       => pp(aa(nat,bool,ord_less(nat,M),N)) ) ) ).

tff(fact_65_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,I),J))
     => ( pp(aa(nat,bool,ord_less_eq(nat,J),K))
       => pp(aa(nat,bool,ord_less_eq(nat,I),K)) ) ) ).

tff(fact_66_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
     => ( pp(aa(nat,bool,ord_less_eq(nat,N),M))
       => ( M = N ) ) ) ).

tff(fact_67_Suc__le__lessD,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,M)),N))
     => pp(aa(nat,bool,ord_less(nat,M),N)) ) ).

tff(fact_68_less__or__eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( pp(aa(nat,bool,ord_less(nat,M),N))
        | ( M = N ) )
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

tff(fact_69_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,Ma: nat] :
      ( ( pp(aa(nat,bool,ord_less(nat,Ma),N1))
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),Ma)) )
     => ( ( ( Ma = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),Ma)) )
       => ( ( pp(aa(nat,bool,ord_less(nat,N1),Ma))
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),Ma)) ) ) ) ).

tff(fact_70_less__eq__Suc__le__raw,axiom,
    ! [X1: nat] : ( ord_less(nat,X1) = ord_less_eq(nat,aa(nat,nat,suc,X1)) ) ).

tff(fact_71_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),N)) ) ).

tff(fact_72_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => ( N != zero_zero(nat) ) ) ).

tff(fact_73_not__less0,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less(nat,N),zero_zero(nat))) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_Suc__less__SucD,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,M)),aa(nat,nat,suc,N)))
     => pp(aa(nat,bool,ord_less(nat,M),N)) ) ).

tff(fact_76_Suc__lessD,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,M)),N))
     => pp(aa(nat,bool,ord_less(nat,M),N)) ) ).

tff(fact_77_less__SucE,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),aa(nat,nat,suc,N)))
     => ( ~ pp(aa(nat,bool,ord_less(nat,M),N))
       => ( M = N ) ) ) ).

tff(fact_78_less__trans__Suc,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less(nat,I),J))
     => ( pp(aa(nat,bool,ord_less(nat,J),K))
       => pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,I)),K)) ) ) ).

tff(fact_79_Suc__lessI,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => ( ( aa(nat,nat,suc,M) != N )
       => pp(aa(nat,bool,ord_less(nat,aa(nat,nat,suc,M)),N)) ) ) ).

tff(fact_80_less__SucI,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less(nat,M),N))
     => pp(aa(nat,bool,ord_less(nat,M),aa(nat,nat,suc,N))) ) ).

tff(fact_81_less__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ~ pp(aa(nat,bool,ord_less(nat,N),M))
     => ( pp(aa(nat,bool,ord_less(nat,N),aa(nat,nat,suc,M)))
       => ( M = N ) ) ) ).

tff(fact_82_not__less__less__Suc__eq,axiom,
    ! [Ma: nat,N1: nat] :
      ( ~ pp(aa(nat,bool,ord_less(nat,N1),Ma))
     => ( pp(aa(nat,bool,ord_less(nat,N1),aa(nat,nat,suc,Ma)))
      <=> ( N1 = Ma ) ) ) ).

tff(fact_83_less__Suc__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less(nat,Ma),aa(nat,nat,suc,N1)))
    <=> ( pp(aa(nat,bool,ord_less(nat,Ma),N1))
        | ( Ma = N1 ) ) ) ).

tff(fact_84_not__less__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( ~ pp(aa(nat,bool,ord_less(nat,Ma),N1))
    <=> pp(aa(nat,bool,ord_less(nat,N1),aa(nat,nat,suc,Ma))) ) ).

tff(fact_85_Suc__leD,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,M)),N))
     => pp(aa(nat,bool,ord_less_eq(nat,M),N)) ) ).

tff(fact_86_le__SucE,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),aa(nat,nat,suc,N)))
     => ( ~ pp(aa(nat,bool,ord_less_eq(nat,M),N))
       => ( M = aa(nat,nat,suc,N) ) ) ) ).

tff(fact_87_le__SucI,axiom,
    ! [N: nat,M: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,M),N))
     => pp(aa(nat,bool,ord_less_eq(nat,M),aa(nat,nat,suc,N))) ) ).

tff(fact_88_le__Suc__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,Ma),aa(nat,nat,suc,N1)))
    <=> ( pp(aa(nat,bool,ord_less_eq(nat,Ma),N1))
        | ( Ma = aa(nat,nat,suc,N1) ) ) ) ).

tff(fact_89_not__less__eq__eq,axiom,
    ! [N1: nat,Ma: nat] :
      ( ~ pp(aa(nat,bool,ord_less_eq(nat,Ma),N1))
    <=> pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,N1)),Ma)) ) ).

tff(fact_90_Suc__n__not__le__n,axiom,
    ! [N: nat] : ~ pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,N)),N)) ).

tff(fact_91_mult__le__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,I),J))
     => ( pp(aa(nat,bool,ord_less_eq(nat,K),L))
       => pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),J),L))) ) ) ).

tff(fact_92_mult__le__mono2,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,I),J))
     => pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),I)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),J))) ) ).

tff(fact_93_mult__le__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,I),J))
     => pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),J),K))) ) ).

tff(fact_94_le__cube,axiom,
    ! [M: nat] : pp(aa(nat,bool,ord_less_eq(nat,M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),M)))) ).

tff(fact_95_le__square,axiom,
    ! [M: nat] : pp(aa(nat,bool,ord_less_eq(nat,M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),M))) ).

tff(fact_96_power__less__imp__less__base,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [B1: A,N: nat,A1: A] :
          ( pp(aa(A,bool,ord_less(A,aa(nat,A,power_power(A,A1),N)),aa(nat,A,power_power(A,B1),N)))
         => ( pp(aa(A,bool,ord_less_eq(A,zero_zero(A)),B1))
           => pp(aa(A,bool,ord_less(A,A1),B1)) ) ) ) ).

tff(fact_97_nat__one__le__power,axiom,
    ! [N: nat,I: nat] :
      ( pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,zero_zero(nat))),I))
     => pp(aa(nat,bool,ord_less_eq(nat,aa(nat,nat,suc,zero_zero(nat))),aa(nat,nat,power_power(nat,I),N))) ) ).

tff(fact_98_power__strict__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B1: A,A1: A] :
          ( pp(aa(A,bool,ord_less(A,A1),B1))
         => ( pp(aa(A,bool,ord_less_eq(A,zero_zero(A)),A1))
           => ( pp(aa(nat,bool,ord_less(nat,zero_zero(nat)),N))
             => pp(aa(A,bool,ord_less(A,aa(nat,A,power_power(A,A1),N)),aa(nat,A,power_power(A,B1),N))) ) ) ) ) ).

%----Arities (20)
tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),combb(complex,complex,nat,aa(complex,fun(complex,complex),times_times(complex),aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),i)),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(m)),aa(nat,fun(nat,nat),times_times(nat),i)))),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls))))))),ord_atLeastLessThan(nat,zero_zero(nat),m)) = big_co1399186613setsum(nat,complex,combb(complex,complex,nat,aa(complex,fun(complex,complex),times_times(complex),aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),i)),combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),power_power(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(m)),i))),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))))))),ord_atLeastLessThan(nat,zero_zero(nat),m)) ).

%------------------------------------------------------------------------------
