%------------------------------------------------------------------------------
% File     : SWV645_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 307
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_307 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  174 (  76 unt;  39 typ;   0 def)
%            Number of atoms       :  214 ( 108 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   84 (   5   ~;   0   |;  12   &)
%                                         (  17 <=>;  50  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    7 (   3 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  14   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :   20 (  20 usr;   6 con; 0-5 aty)
%            Number of variables   :  243 ( 215   !;   0   ?; 243   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:50
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_ODFT,type,
    fFT_Mirabelle_DFT: ( nat * fun(nat,complex) * nat ) > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (97)
tff(fact_0_ibound,axiom,
    ord_less_eq(nat,m,i) ).

tff(fact_1_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),M)),aa(nat,nat,times_times(nat,I),aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),J))) = power_power(complex,fFT_Mirabelle_root(M),aa(nat,nat,times_times(nat,I),J)) ) ).

tff(fact_2_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( power_power(B,number_number_of(B,W),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,times_times(B,number_number_of(B,W)),number_number_of(B,W)) ) ) ).

tff(fact_3_nat__1__add__1,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),one_one(nat)),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_4_one__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,one_one(A),number_number_of(nat,bit0(bit1(pls)))) = one_one(A) ) ) ).

tff(fact_5_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_6_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int,V: int] : ( power_power(B,number_number_of(B,V),number_number_of(nat,bit0(W))) = aa(B,B,times_times(B,power_power(B,number_number_of(B,V),number_number_of(nat,W))),power_power(B,number_number_of(B,V),number_number_of(nat,W))) ) ) ).

tff(fact_7_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(pls)),W)) ) ) ).

tff(fact_8_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),one_one(A)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),bit1(pls))) ) ) ).

tff(fact_9_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_10_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_11_power2__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Y: A,X: A] : ( power_power(A,minus_minus(A,X,Y),number_number_of(nat,bit0(bit1(pls)))) = minus_minus(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),power_power(A,X,number_number_of(nat,bit0(bit1(pls))))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls))))),aa(A,A,times_times(A,aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),X)),Y)) ) ) ).

tff(fact_12_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y: A,X: A] : ( power_power(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),power_power(A,X,number_number_of(nat,bit0(bit1(pls))))),power_power(A,Y,number_number_of(nat,bit0(bit1(pls)))))),aa(A,A,times_times(A,aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),X)),Y)) ) ) ).

tff(fact_13_right__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [C2: B,B2: B,V: int] : ( aa(B,B,times_times(B,number_number_of(B,V)),minus_minus(B,B2,C2)) = minus_minus(B,aa(B,B,times_times(B,number_number_of(B,V)),B2),aa(B,B,times_times(B,number_number_of(B,V)),C2)) ) ) ).

tff(fact_14_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X1: int] :
          ( ( number_number_of(A,X1) = number_number_of(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_15_rel__simps_I51_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit1(K) = bit1(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_16_mult__Pls,axiom,
    ! [W: int] : ( aa(int,int,times_times(int,pls),W) = pls ) ).

tff(fact_17_diff__bin__simps_I7_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit0(K1),bit0(L)) = bit0(minus_minus(int,K1,L)) ) ).

tff(fact_18_mult__Bit0,axiom,
    ! [L: int,K1: int] : ( aa(int,int,times_times(int,bit0(K1)),L) = bit0(aa(int,int,times_times(int,K1),L)) ) ).

tff(fact_19_rel__simps_I48_J,axiom,
    ! [L1: int,K: int] :
      ( ( bit0(K) = bit0(L1) )
    <=> ( K = L1 ) ) ).

tff(fact_20_le__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X1: int] :
          ( ord_less_eq(A,number_number_of(A,X1),number_number_of(A,Y1))
        <=> ord_less_eq(int,X1,Y1) ) ) ).

tff(fact_21_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),aa(A,A,times_times(A,number_number_of(A,W)),Z)) = aa(A,A,times_times(A,number_number_of(A,aa(int,int,times_times(int,V),W))),Z) ) ) ).

tff(fact_22_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,times_times(int,V),W)) ) ) ).

tff(fact_23_rel__simps_I46_J,axiom,
    ! [K1: int] : ( bit1(K1) != pls ) ).

tff(fact_24_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_25_diff__bin__simps_I10_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit1(K1),bit1(L)) = bit0(minus_minus(int,K1,L)) ) ).

tff(fact_26_diff__bin__simps_I9_J,axiom,
    ! [L: int,K1: int] : ( minus_minus(int,bit1(K1),bit0(L)) = bit1(minus_minus(int,K1,L)) ) ).

tff(fact_27_rel__simps_I50_J,axiom,
    ! [L: int,K1: int] : ( bit1(K1) != bit0(L) ) ).

tff(fact_28_rel__simps_I49_J,axiom,
    ! [L: int,K1: int] : ( bit0(K1) != bit1(L) ) ).

tff(fact_29_diff__bin__simps_I3_J,axiom,
    ! [L: int] : ( minus_minus(int,pls,bit0(L)) = bit0(minus_minus(int,pls,L)) ) ).

tff(fact_30_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_31_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_32_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_33_add__Bit0__Bit0,axiom,
    ! [L: int,K1: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K1)),bit0(L)) = bit0(aa(int,int,aa(int,fun(int,int),plus_plus(int),K1),L)) ) ).

tff(fact_34_root1,axiom,
    fFT_Mirabelle_root(one_one(nat)) = one_one(complex) ).

tff(fact_35_left__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [V: int,B2: B,A1: B] : ( aa(B,B,times_times(B,aa(B,B,aa(B,fun(B,B),plus_plus(B),A1),B2)),number_number_of(B,V)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,times_times(B,A1),number_number_of(B,V))),aa(B,B,times_times(B,B2),number_number_of(B,V))) ) ) ).

tff(fact_36_right__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [C2: B,B2: B,V: int] : ( aa(B,B,times_times(B,number_number_of(B,V)),aa(B,B,aa(B,fun(B,B),plus_plus(B),B2),C2)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,times_times(B,number_number_of(B,V)),B2)),aa(B,B,times_times(B,number_number_of(B,V)),C2)) ) ) ).

tff(fact_37_left__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [V: int,B2: B,A1: B] : ( aa(B,B,times_times(B,minus_minus(B,A1,B2)),number_number_of(B,V)) = minus_minus(B,aa(B,B,times_times(B,A1),number_number_of(B,V)),aa(B,B,times_times(B,B2),number_number_of(B,V))) ) ) ).

tff(fact_38_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,W)),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W))),Z) ) ) ).

tff(fact_39_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ) ).

tff(fact_40_mult__Bit1,axiom,
    ! [L: int,K1: int] : ( aa(int,int,times_times(int,bit1(K1)),L) = aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(aa(int,int,times_times(int,K1),L))),L) ) ).

tff(fact_41_add__Bit1__Bit0,axiom,
    ! [L: int,K1: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(K1)),bit0(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K1),L)) ) ).

tff(fact_42_add__Bit0__Bit1,axiom,
    ! [L: int,K1: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K1)),bit1(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K1),L)) ) ).

tff(fact_43_le__special_I4_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X1: int] :
          ( ord_less_eq(A,number_number_of(A,X1),one_one(A))
        <=> ord_less_eq(int,X1,bit1(pls)) ) ) ).

tff(fact_44_le__special_I2_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int] :
          ( ord_less_eq(A,one_one(A),number_number_of(A,Y1))
        <=> ord_less_eq(int,bit1(pls),Y1) ) ) ).

tff(fact_45_Bit1__def,axiom,
    ! [K1: int] : ( bit1(K1) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),K1)),K1) ) ).

tff(fact_46_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( aa(int,int,times_times(int,W),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,W),Z1)),aa(int,int,times_times(int,W),Z2)) ) ).

tff(fact_47_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),number_number_of(int,V)),number_number_of(int,W)) = number_number_of(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ).

tff(fact_48_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( aa(int,int,times_times(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)),W) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,times_times(int,Z1),W)),aa(int,int,times_times(int,Z2),W)) ) ).

tff(fact_49_diff__bin__simps_I1_J,axiom,
    ! [K1: int] : ( minus_minus(int,K1,pls) = K1 ) ).

tff(fact_50_add__Pls__right,axiom,
    ! [K1: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),K1),pls) = K1 ) ).

tff(fact_51_add__Pls,axiom,
    ! [K1: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),pls),K1) = K1 ) ).

tff(fact_52_Bit0__def,axiom,
    ! [K1: int] : ( bit0(K1) = aa(int,int,aa(int,fun(int,int),plus_plus(int),K1),K1) ) ).

tff(fact_53_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X: int] : ( power_power(int,power_power(int,X,Y),Z) = power_power(int,X,aa(nat,nat,times_times(nat,Y),Z)) ) ).

tff(fact_54_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_55_zpower__number__of__even,axiom,
    ! [W: int,Z: int] : ( power_power(int,Z,number_number_of(nat,bit0(W))) = aa(int,int,times_times(int,power_power(int,Z,number_number_of(nat,W))),power_power(int,Z,number_number_of(nat,W))) ) ).

tff(fact_56_root__unity,axiom,
    ! [N1: nat] : ( power_power(complex,fFT_Mirabelle_root(N1),N1) = one_one(complex) ) ).

tff(fact_57_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X1: A,W1: int] :
          ( ( number_number_of(A,W1) = X1 )
        <=> ( X1 = number_number_of(A,W1) ) ) ) ).

tff(fact_58_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,times_times(int,V),W)) = aa(A,A,times_times(A,number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_59_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_60_number__of__diff,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,minus_minus(int,V,W)) = minus_minus(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

tff(fact_61_add__number__of__diff1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [C2: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),minus_minus(A,number_number_of(A,W),C2)) = minus_minus(A,number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)),C2) ) ) ).

tff(fact_62_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,pls)),A1) = A1 ) ) ).

tff(fact_63_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),number_number_of(A,pls)) = A1 ) ) ).

tff(fact_64_nat__number__of__Bit0,axiom,
    ! [W: int] : ( number_number_of(nat,bit0(W)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),number_number_of(nat,W)),number_number_of(nat,W)) ) ).

tff(fact_65_DFT__lower,axiom,
    ! [Ia: nat,Aa: fun(nat,complex),Ma: nat] : ( fFT_Mirabelle_DFT(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),Ma),Aa,Ia) = aa(complex,complex,aa(complex,fun(complex,complex),plus_plus(complex),fFT_Mirabelle_DFT(Ma,combb(nat,complex,nat,Aa,times_times(nat,number_number_of(nat,bit0(bit1(pls))))),Ia)),aa(complex,complex,times_times(complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),Ma)),Ia)),fFT_Mirabelle_DFT(Ma,combb(nat,complex,nat,Aa,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat))),Ia))) ) ).

tff(fact_66_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit1(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_67_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,number_number_of(A,bit1(pls))),A1) = A1 ) ) ).

tff(fact_68_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,times_times(A,A1),number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_69_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_70_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

tff(fact_71_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_72_power__number__of__even,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [W: int,Z: A] : ( power_power(A,Z,number_number_of(nat,bit0(W))) = aa(A,A,times_times(A,power_power(A,Z,number_number_of(nat,W))),power_power(A,Z,number_number_of(nat,W))) ) ) ).

tff(fact_73_double__number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,times_times(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),number_number_of(A,W)) = number_number_of(A,bit0(W)) ) ) ).

tff(fact_74_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = aa(A,A,times_times(A,aa(A,A,times_times(A,A1),A1)),A1) ) ) ).

tff(fact_75_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_76_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_77_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_78_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,times_times(A,Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_79_semiring__one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_80_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,times_times(A,A1),A1) ) ) ).

tff(fact_81_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N1: nat,A1: A] : ( power_power(A,A1,aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N1)) = power_power(A,power_power(A,A1,N1),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_82_nat__mult__2,axiom,
    ! [Z: nat] : ( aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),Z) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_83_nat__mult__2__right,axiom,
    ! [Z: nat] : ( aa(nat,nat,times_times(nat,Z),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_84_diff__diff__right,axiom,
    ! [I: nat,J: nat,K1: nat] :
      ( ord_less_eq(nat,K1,J)
     => ( minus_minus(nat,I,minus_minus(nat,J,K1)) = minus_minus(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),I),K1),J) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N1: nat,X: A] : ( power_power(A,X,aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),N1)) = aa(A,A,times_times(A,power_power(A,X,N1)),power_power(A,X,N1)) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( aa(A,A,times_times(A,X),X) = power_power(A,X,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_87_nat__mult__eq__1__iff,axiom,
    ! [N: nat,Ma: nat] :
      ( ( aa(nat,nat,times_times(nat,Ma),N) = one_one(nat) )
    <=> ( ( Ma = one_one(nat) )
        & ( N = one_one(nat) ) ) ) ).

tff(fact_88_nat__1__eq__mult__iff,axiom,
    ! [N: nat,Ma: nat] :
      ( ( one_one(nat) = aa(nat,nat,times_times(nat,Ma),N) )
    <=> ( ( Ma = one_one(nat) )
        & ( N = one_one(nat) ) ) ) ).

tff(fact_89_diff__diff__left,axiom,
    ! [K1: nat,J: nat,I: nat] : ( minus_minus(nat,minus_minus(nat,I,J),K1) = minus_minus(nat,I,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),J),K1)) ) ).

tff(fact_90_nat__add__left__cancel__le,axiom,
    ! [N: nat,Ma: nat,K: nat] :
      ( ord_less_eq(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),Ma),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),N))
    <=> ord_less_eq(nat,Ma,N) ) ).

tff(fact_91_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N1: nat] : ( power_power(A,one_one(A),N1) = one_one(A) ) ) ).

tff(fact_92_add__le__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,Aa: A,C1: A] :
          ( ord_less_eq(A,aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),Aa),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),B1))
        <=> ord_less_eq(A,Aa,B1) ) ) ).

tff(fact_93_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,Aa: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Aa),C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_94_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),Aa) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),Aa) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_95_nat__add__left__cancel,axiom,
    ! [N: nat,Ma: nat,K: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),Ma) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),N) )
    <=> ( Ma = N ) ) ).

tff(fact_96_nat__add__right__cancel,axiom,
    ! [N: nat,K: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Ma),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K) )
    <=> ( Ma = N ) ) ).

%----Arities (33)
tff(arity_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring,axiom,
    semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring,axiom,
    ring(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    fFT_Mirabelle_DFT(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m),a,i) = minus_minus(complex,fFT_Mirabelle_DFT(m,combb(nat,complex,nat,a,times_times(nat,number_number_of(nat,bit0(bit1(pls))))),minus_minus(nat,i,m)),aa(complex,complex,times_times(complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,times_times(nat,number_number_of(nat,bit0(bit1(pls)))),m)),minus_minus(nat,i,m))),fFT_Mirabelle_DFT(m,combb(nat,complex,nat,a,combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),times_times(nat,number_number_of(nat,bit0(bit1(pls))))),one_one(nat))),minus_minus(nat,i,m)))) ).

%------------------------------------------------------------------------------
