%------------------------------------------------------------------------------
% File     : SWV641_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 294
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_294 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  179 (  80 unt;  40 typ;   0 def)
%            Number of atoms       :  227 ( 139 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  105 (  17   ~;   6   |;  15   &)
%                                         (  17 <=>;  50  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   3 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   22 (  14   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-2 aty)
%            Number of functors    :   22 (  22 usr;   7 con; 0-5 aty)
%            Number of variables   :  282 ( 253   !;   0   ?; 282   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:18:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_ODFT,type,
    fFT_Mirabelle_DFT: ( nat * fun(nat,complex) * nat ) > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > fun(A,A) ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: fun(nat,nat) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (99)
tff(fact_0_root__cancel1,axiom,
    ! [J: nat,I: nat,M: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),M))),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),J))) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),I),J)) ) ).

tff(fact_1_power2__eq__square__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int] : ( aa(nat,B,power_power(B,number_number_of(B,W)),number_number_of(nat,bit0(bit1(pls)))) = aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,W)),number_number_of(B,W)) ) ) ).

tff(fact_2_add__2__eq__Suc_H,axiom,
    ! [N: nat] : ( aa(nat,nat,plus_plus(nat,N),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,suc,aa(nat,nat,suc,N)) ) ).

tff(fact_3_add__2__eq__Suc,axiom,
    ! [N: nat] : ( aa(nat,nat,plus_plus(nat,number_number_of(nat,bit0(bit1(pls)))),N) = aa(nat,nat,suc,aa(nat,nat,suc,N)) ) ).

tff(fact_4_zero__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( aa(nat,A,power_power(A,zero_zero(A)),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) ) ) ).

tff(fact_5_zero__eq__power2,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,bit0(bit1(pls)))) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_6_DFT__def,axiom,
    ! [Aa: fun(nat,complex),N1: nat,X2: nat] : ( fFT_Mirabelle_DFT(N1,Aa,X2) = big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(N1)),aa(nat,fun(nat,nat),times_times(nat),X2))),Aa),ord_atLeastLessThan(nat,zero_zero(nat),N1)) ) ).

tff(fact_7_power__number__of__even__number__of,axiom,
    ! [B: $tType] :
      ( ( monoid_mult(B)
        & number(B) )
     => ! [W: int,V: int] : ( aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,bit0(W))) = aa(B,B,aa(B,fun(B,B),times_times(B),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))),aa(nat,B,power_power(B,number_number_of(B,V)),number_number_of(nat,W))) ) ) ).

tff(fact_8_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,Aa: A] :
          ( ( aa(nat,A,power_power(A,Aa),number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( Aa = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_9_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_10_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X: A] : ( aa(nat,A,power_power(A,X),aa(nat,nat,suc,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N))) = aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X),N)),aa(nat,A,power_power(A,X),N))) ) ) ).

tff(fact_11_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y1: A,X: A] : ( aa(nat,A,power_power(A,aa(A,A,plus_plus(A,X),Y1)),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls))))),aa(nat,A,power_power(A,Y1),number_number_of(nat,bit0(bit1(pls)))))),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,bit0(bit1(pls)))),X)),Y1)) ) ) ).

tff(fact_12_mult__Suc__right,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,suc,N)) = aa(nat,nat,plus_plus(nat,M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)) ) ).

tff(fact_13_nat_Oinject,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( aa(nat,nat,suc,Nat2) = aa(nat,nat,suc,Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_14_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,Ma: nat] :
      ( ( aa(nat,nat,plus_plus(nat,Ma),K1) = aa(nat,nat,plus_plus(nat,N1),K1) )
    <=> ( Ma = N1 ) ) ).

tff(fact_15_nat__add__left__cancel,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( ( aa(nat,nat,plus_plus(nat,K1),Ma) = aa(nat,nat,plus_plus(nat,K1),N1) )
    <=> ( Ma = N1 ) ) ).

tff(fact_16_add__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,plus_plus(nat,Ma),N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_17_mult__cancel2,axiom,
    ! [N1: nat,K1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),K1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N1),K1) )
    <=> ( ( Ma = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_18_mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),Ma) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),N1) )
    <=> ( ( Ma = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_19_mult__is__0,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1) = zero_zero(nat) )
    <=> ( ( Ma = zero_zero(nat) )
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_20_mult__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_21_mult__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_22_add__Suc,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,plus_plus(nat,aa(nat,nat,suc,M)),N) = aa(nat,nat,suc,aa(nat,nat,plus_plus(nat,M),N)) ) ).

tff(fact_23_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,plus_plus(nat,M),aa(nat,nat,suc,N)) = aa(nat,nat,suc,aa(nat,nat,plus_plus(nat,M),N)) ) ).

tff(fact_24_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_25_mult__eq__1__iff,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Ma),N1) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( Ma = aa(nat,nat,suc,zero_zero(nat)) )
        & ( N1 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_26_mult__Suc,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,suc,M)),N) = aa(nat,nat,plus_plus(nat,N),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)) ) ).

tff(fact_27_zpower__number__of__even,axiom,
    ! [W: int,Z: int] : ( aa(nat,int,power_power(int,Z),number_number_of(nat,bit0(W))) = aa(int,int,aa(int,fun(int,int),times_times(int),aa(nat,int,power_power(int,Z),number_number_of(nat,W))),aa(nat,int,power_power(int,Z),number_number_of(nat,W))) ) ).

tff(fact_28_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_29_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Ry)) ) ) ).

tff(fact_30_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Ry)) ) ) ).

tff(fact_31_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry))) ) ) ).

tff(fact_32_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ly) ) ) ).

tff(fact_33_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Rx)) ) ) ).

tff(fact_34_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ry) ) ) ).

tff(fact_35_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ry)) ) ) ).

tff(fact_36_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B1) = aa(A,A,aa(A,fun(A,A),times_times(A),B1),A1) ) ) ).

tff(fact_37_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),aa(A,A,plus_plus(A,B1),D)) ) ) ).

tff(fact_38_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),C1) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),B1) ) ) ).

tff(fact_39_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),B1)),C1) = aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,B1),C1)) ) ) ).

tff(fact_40_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,aa(A,A,plus_plus(A,A1),C1)),D) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),aa(A,A,plus_plus(A,C1),D)) = aa(A,A,plus_plus(A,C1),aa(A,A,plus_plus(A,A1),D)) ) ) ).

tff(fact_42_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,plus_plus(A,A1),C1) = aa(A,A,plus_plus(A,C1),A1) ) ) ).

tff(fact_43_Suc__inject,axiom,
    ! [Y1: nat,X: nat] :
      ( ( aa(nat,nat,suc,X) = aa(nat,nat,suc,Y1) )
     => ( X = Y1 ) ) ).

tff(fact_44_Suc__n__not__n,axiom,
    ! [N: nat] : ( aa(nat,nat,suc,N) != N ) ).

tff(fact_45_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != aa(nat,nat,suc,N) ) ).

tff(fact_46_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,plus_plus(nat,aa(nat,nat,plus_plus(nat,M),N)),K) = aa(nat,nat,plus_plus(nat,M),aa(nat,nat,plus_plus(nat,N),K)) ) ).

tff(fact_47_nat__add__left__commute,axiom,
    ! [Z: nat,Y1: nat,X: nat] : ( aa(nat,nat,plus_plus(nat,X),aa(nat,nat,plus_plus(nat,Y1),Z)) = aa(nat,nat,plus_plus(nat,Y1),aa(nat,nat,plus_plus(nat,X),Z)) ) ).

tff(fact_48_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,plus_plus(nat,M),N) = aa(nat,nat,plus_plus(nat,N),M) ) ).

tff(fact_49_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_50_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),M) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I9_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),zero_zero(A)),A1) = zero_zero(A) ) ) ).

tff(fact_53_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Aa: A,B2: A] :
          ( ( B2 = aa(A,A,plus_plus(A,B2),Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_54_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,plus_plus(A,A1),zero_zero(A)) = A1 ) ) ).

tff(fact_55_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,plus_plus(A,zero_zero(A)),A1) = A1 ) ) ).

tff(fact_56_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Z1: A,X1: A,Y: A,W1: A] :
          ( ( aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),W1),Y)),aa(A,A,aa(A,fun(A,A),times_times(A),X1),Z1)) = aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),W1),Z1)),aa(A,A,aa(A,fun(A,A),times_times(A),X1),Y)) )
        <=> ( ( W1 = X1 )
            | ( Y = Z1 ) ) ) ) ).

tff(fact_57_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,M: A,A1: A] : ( aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),A1),M)),aa(A,A,aa(A,fun(A,A),times_times(A),B1),M)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,plus_plus(A,A1),B1)),M) ) ) ).

tff(fact_58_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,plus_plus(A,A1),B1)),C1) = aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),A1),C1)),aa(A,A,aa(A,fun(A,A),times_times(A),B1),C1)) ) ) ).

tff(fact_59_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D1: A,C2: A,B2: A,Aa: A] :
          ( ( ( Aa != B2 )
            & ( C2 != D1 ) )
        <=> ( aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),C2)),aa(A,A,aa(A,fun(A,A),times_times(A),B2),D1)) != aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),Aa),D1)),aa(A,A,aa(A,fun(A,A),times_times(A),B2),C2)) ) ) ) ).

tff(fact_60_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z: A,Y1: A,X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(A,A,plus_plus(A,Y1),Z)) = aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X),Y1)),aa(A,A,aa(A,fun(A,A),times_times(A),X),Z)) ) ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,Y1: A,X: A] : ( aa(nat,A,power_power(A,aa(A,A,aa(A,fun(A,A),times_times(A),X),Y1)),Q1) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X),Q1)),aa(nat,A,power_power(A,Y1),Q1)) ) ) ).

tff(fact_62_Suc__neq__Zero,axiom,
    ! [M: nat] : ( aa(nat,nat,suc,M) != zero_zero(nat) ) ).

tff(fact_63_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M) ) ).

tff(fact_64_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( aa(nat,nat,suc,Nat1) != zero_zero(nat) ) ).

tff(fact_65_Suc__not__Zero,axiom,
    ! [M: nat] : ( aa(nat,nat,suc,M) != zero_zero(nat) ) ).

tff(fact_66_nat_Osimps_I2_J,axiom,
    ! [Nat: nat] : ( zero_zero(nat) != aa(nat,nat,suc,Nat) ) ).

tff(fact_67_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M) ) ).

tff(fact_68_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,plus_plus(nat,M),N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_69_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,plus_plus(nat,M),zero_zero(nat)) = M ) ).

tff(fact_70_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,plus_plus(nat,zero_zero(nat)),N) = N ) ).

tff(fact_71_add__Suc__shift,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,plus_plus(nat,aa(nat,nat,suc,M)),N) = aa(nat,nat,plus_plus(nat,M),aa(nat,nat,suc,N)) ) ).

tff(fact_72_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,P1: nat,X: A] : ( aa(nat,A,power_power(A,aa(nat,A,power_power(A,X),P1)),Q1) = aa(nat,A,power_power(A,X),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),P1),Q1)) ) ) ).

tff(fact_73_Suc__mult__cancel1,axiom,
    ! [N1: nat,Ma: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,suc,K1)),Ma) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,suc,K1)),N1) )
    <=> ( Ma = N1 ) ) ).

tff(fact_74_add__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,plus_plus(nat,M),N)),K) = aa(nat,nat,plus_plus(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_75_add__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,plus_plus(nat,M),N)) = aa(nat,nat,plus_plus(nat,aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_76_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C1: A,B1: A,A1: A,R1: A] :
          ( ( R1 != zero_zero(A) )
         => ( ( ( A1 = B1 )
              & ( C1 != D ) )
           => ( aa(A,A,plus_plus(A,A1),aa(A,A,aa(A,fun(A,A),times_times(A),R1),C1)) != aa(A,A,plus_plus(A,B1),aa(A,A,aa(A,fun(A,A),times_times(A),R1),D)) ) ) ) ) ).

tff(fact_77_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y: A,X1: A] :
          ( ( aa(A,A,plus_plus(A,aa(A,A,aa(A,fun(A,A),times_times(A),X1),X1)),aa(A,A,aa(A,fun(A,A),times_times(A),Y),Y)) = zero_zero(A) )
        <=> ( ( X1 = zero_zero(A) )
            & ( Y = zero_zero(A) ) ) ) ) ).

tff(fact_78_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I28_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X),Q1)),X) = aa(nat,A,power_power(A,X),aa(nat,nat,suc,Q1)) ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I27_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(nat,A,power_power(A,X),Q1)) = aa(nat,A,power_power(A,X),aa(nat,nat,suc,Q1)) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I35_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,X: A] : ( aa(nat,A,power_power(A,X),aa(nat,nat,suc,Q1)) = aa(A,A,aa(A,fun(A,A),times_times(A),X),aa(nat,A,power_power(A,X),Q1)) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I26_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q1: nat,P1: nat,X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,X),P1)),aa(nat,A,power_power(A,X),Q1)) = aa(nat,A,power_power(A,X),aa(nat,nat,plus_plus(nat,P1),Q1)) ) ) ).

tff(fact_83_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_84_add__is__1,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,plus_plus(nat,Ma),N1) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( ( Ma = aa(nat,nat,suc,zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( Ma = zero_zero(nat) )
          & ( N1 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ) ).

tff(fact_85_one__is__add,axiom,
    ! [N1: nat,Ma: nat] :
      ( ( aa(nat,nat,suc,zero_zero(nat)) = aa(nat,nat,plus_plus(nat,Ma),N1) )
    <=> ( ( ( Ma = aa(nat,nat,suc,zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( Ma = zero_zero(nat) )
          & ( N1 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ) ).

tff(fact_86_nat__number__of__Bit0,axiom,
    ! [W: int] : ( number_number_of(nat,bit0(W)) = aa(nat,nat,plus_plus(nat,number_number_of(nat,W)),number_number_of(nat,W)) ) ).

tff(fact_87_power__number__of__even,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [W: int,Z: A] : ( aa(nat,A,power_power(A,Z),number_number_of(nat,bit0(W))) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(nat,A,power_power(A,Z),number_number_of(nat,W))),aa(nat,A,power_power(A,Z),number_number_of(nat,W))) ) ) ).

tff(fact_88_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit1(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),A1)),A1) ) ) ).

tff(fact_89_numeral__3__eq__3,axiom,
    number_number_of(nat,bit1(bit1(pls))) = aa(nat,nat,suc,aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat)))) ).

tff(fact_90_numeral__1__eq__Suc__0,axiom,
    number_number_of(nat,bit1(pls)) = aa(nat,nat,suc,zero_zero(nat)) ).

tff(fact_91_Suc3__eq__add__3,axiom,
    ! [N: nat] : ( aa(nat,nat,suc,aa(nat,nat,suc,aa(nat,nat,suc,N))) = aa(nat,nat,plus_plus(nat,number_number_of(nat,bit1(bit1(pls)))),N) ) ).

tff(fact_92_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( aa(nat,A,power_power(A,A1),number_number_of(nat,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),A1) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),X),X) = aa(nat,A,power_power(A,X),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_94_numeral__2__eq__2,axiom,
    number_number_of(nat,bit0(bit1(pls))) = aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))) ).

tff(fact_95_semiring__norm_I115_J,axiom,
    aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_96_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( aa(nat,A,power_power(A,A1),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),N)) = aa(nat,A,power_power(A,aa(nat,A,power_power(A,A1),N)),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_97_nat__mult__2,axiom,
    ! [Z: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),Z) = aa(nat,nat,plus_plus(nat,Z),Z) ) ).

tff(fact_98_nat__mult__2__right,axiom,
    ! [Z: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Z),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,plus_plus(nat,Z),Z) ) ).

%----Arities (35)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Complex_Ocomplex___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),combb(nat,nat,nat,plus_plus(nat,i),combb(nat,nat,nat,aa(nat,fun(nat,nat),times_times(nat),i),aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))))))),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls))))))),ord_atLeastLessThan(nat,zero_zero(nat),m)) = aa(complex,complex,aa(complex,fun(complex,complex),times_times(complex),aa(nat,complex,power_power(complex,fFT_Mirabelle_root(aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),m))),i)),big_co1399186613setsum(nat,complex,combs(nat,complex,complex,combb(complex,fun(complex,complex),nat,times_times(complex),combb(nat,complex,nat,power_power(complex,fFT_Mirabelle_root(m)),aa(nat,fun(nat,nat),times_times(nat),i))),combb(nat,complex,nat,a,combb(nat,nat,nat,suc,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls))))))),ord_atLeastLessThan(nat,zero_zero(nat),m))) ).

%------------------------------------------------------------------------------
