%------------------------------------------------------------------------------
% File     : SWV637_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 273
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_273 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  194 ( 100 unt;  42 typ;   0 def)
%            Number of atoms       :  222 ( 131 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   86 (  16   ~;   0   |;   7   &)
%                                         (  22 <=>;  41  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   3 avg)
%            Maximal term depth    :    9 (   1 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   20 (  13   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-2 aty)
%            Number of functors    :   22 (  22 usr;   6 con; 0-4 aty)
%            Number of variables   :  215 ( 184   !;   6   ?; 215   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_Code__Numeral_Ocode__numeral,type,
    code_code_numeral: $tType ).

tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Quickcheck__Narrowing_Ocode__int,type,
    quickcheck_code_int: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Code__Numeral_Ocode__numeral_Ocode__numeral__size,type,
    code_c271388182l_size: code_code_numeral > nat ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_ODFT,type,
    fFT_Mirabelle_DFT: ( nat * fun(nat,complex) ) > fun(nat,complex) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : fun(int,A) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Quickcheck__Narrowing_Oof__int,type,
    quickcheck_of_int: fun(int,quickcheck_code_int) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ATP_058x__0,type,
    aTP_x_0: list(complex) ).

tff(sy_v_a,type,
    a: fun(nat,complex) ).

%----Relevant facts (96)
tff(fact_0_nat__numeral__1__eq__1,axiom,
    aa(int,nat,number_number_of(nat),bit1(pls)) = one_one(nat) ).

tff(fact_1_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(int,A,number_number_of(A),bit1(pls)) = one_one(A) ) ) ).

tff(fact_2_nat__number__of__Pls,axiom,
    aa(int,nat,number_number_of(nat),pls) = zero_zero(nat) ).

tff(fact_3_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(int,A,number_number_of(A),pls) = zero_zero(A) ) ) ).

tff(fact_4_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_5_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_6_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_7_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X2: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X2,Xs)) = cons(A,aa(B,A,F,X2),map(B,A,F,Xs)) ) ).

tff(fact_8_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_9_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_10_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_11_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y2: int,X2: int] :
          ( ( aa(int,A,number_number_of(A),X2) = aa(int,A,number_number_of(A),Y2) )
        <=> ( X2 = Y2 ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A4,List3) )
    <=> ( ( Aa = A4 )
        & ( List2 = List3 ) ) ) ).

tff(fact_16_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_17_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_18_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_19_zero__is__num__zero,axiom,
    zero_zero(int) = aa(int,int,number_number_of(int),pls) ).

tff(fact_20_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_21_one__is__num__one,axiom,
    one_one(int) = aa(int,int,number_number_of(int),bit1(pls)) ).

tff(fact_22_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X2: A,W1: int] :
          ( ( aa(int,A,number_number_of(A),W1) = X2 )
        <=> ( X2 = aa(int,A,number_number_of(A),W1) ) ) ) ).

tff(fact_23_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_24_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_25_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( cons(A,A3,List1) != nil(A) ) ).

tff(fact_26_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( nil(A) != cons(A,A3,List1) ) ).

tff(fact_27_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(int,A,number_number_of(A),pls) = zero_zero(A) ) ) ).

tff(fact_28_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = aa(int,A,number_number_of(A),pls) ) ) ).

tff(fact_29_semiring__norm_I113_J,axiom,
    zero_zero(nat) = aa(int,nat,number_number_of(nat),pls) ).

tff(fact_30_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(int,A,number_number_of(A),bit1(pls)) = one_one(A) ) ) ).

tff(fact_31_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = aa(int,A,number_number_of(A),bit1(pls)) ) ) ).

tff(fact_32_Numeral1__eq1__nat,axiom,
    one_one(nat) = aa(int,nat,number_number_of(nat),bit1(pls)) ).

tff(fact_33_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y2: A,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = cons(A,Y2,Ys1) )
    <=> ? [Z1: B,Zs: list(B)] :
          ( ( Xs = cons(B,Z1,Zs) )
          & ( aa(B,A,F,Z1) = Y2 )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_34_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun(B,A),Xs: list(A),X2: A] :
      ( ( cons(A,X2,Xs) = map(B,A,F,Ys1) )
    <=> ? [Z1: B,Zs: list(B)] :
          ( ( Ys1 = cons(B,Z1,Zs) )
          & ( X2 = aa(B,A,F,Z1) )
          & ( Xs = map(B,A,F,Zs) ) ) ) ).

tff(fact_35_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != cons(A,A2,List) ) ) ).

tff(fact_36_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y1: A,Ys: list(A)] : ( Xs = cons(A,Y1,Ys) ) ) ).

tff(fact_37_one__code__int__code,axiom,
    one_one(quickcheck_code_int) = aa(int,quickcheck_code_int,number_number_of(quickcheck_code_int),bit1(pls)) ).

tff(fact_38_one__code__numeral__code,axiom,
    one_one(code_code_numeral) = aa(int,code_code_numeral,number_number_of(code_code_numeral),bit1(pls)) ).

tff(fact_39_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_40_number__of__is__id,axiom,
    ! [K: int] : ( aa(int,int,number_number_of(int),K) = K ) ).

tff(fact_41_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_42_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_43_zero__code__int__code,axiom,
    zero_zero(quickcheck_code_int) = aa(int,quickcheck_code_int,number_number_of(quickcheck_code_int),pls) ).

tff(fact_44_zero__code__numeral__code,axiom,
    zero_zero(code_code_numeral) = aa(int,code_code_numeral,number_number_of(code_code_numeral),pls) ).

tff(fact_45_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_46_code__numeral_Osize_I1_J,axiom,
    code_c271388182l_size(zero_zero(code_code_numeral)) = zero_zero(nat) ).

tff(fact_47_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_48_nat__1__add__1,axiom,
    plus_plus(nat,one_one(nat),one_one(nat)) = aa(int,nat,number_number_of(nat),bit0(bit1(pls))) ).

tff(fact_49_one__code__int__def,axiom,
    one_one(quickcheck_code_int) = aa(int,quickcheck_code_int,quickcheck_of_int,one_one(int)) ).

tff(fact_50_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B2: A] :
          ( ( plus_plus(A,B2,Aa) = plus_plus(A,C1,Aa) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_51_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,Aa: A] :
          ( ( plus_plus(A,Aa,B2) = plus_plus(A,Aa,C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_52_Quickcheck__Narrowing_Oof__int__inject,axiom,
    ! [M1: int,N1: int] :
      ( ( aa(int,quickcheck_code_int,quickcheck_of_int,N1) = aa(int,quickcheck_code_int,quickcheck_of_int,M1) )
    <=> ( N1 = M1 ) ) ).

tff(fact_53_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( plus_plus(A,Aa,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_54_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_55_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( plus_plus(A,aa(int,A,number_number_of(A),V),aa(int,A,number_number_of(A),W)) = aa(int,A,number_number_of(A),plus_plus(int,V,W)) ) ) ).

tff(fact_56_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( plus_plus(A,aa(int,A,number_number_of(A),V),plus_plus(A,aa(int,A,number_number_of(A),W),Z)) = plus_plus(A,aa(int,A,number_number_of(A),plus_plus(int,V,W)),Z) ) ) ).

tff(fact_57_zero__code__int__def,axiom,
    zero_zero(quickcheck_code_int) = aa(int,quickcheck_code_int,quickcheck_of_int,zero_zero(int)) ).

tff(fact_58_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( plus_plus(A,aa(int,A,number_number_of(A),V),one_one(A)) = aa(int,A,number_number_of(A),plus_plus(int,V,bit1(pls))) ) ) ).

tff(fact_59_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( plus_plus(A,one_one(A),aa(int,A,number_number_of(A),W)) = aa(int,A,number_number_of(A),plus_plus(int,bit1(pls),W)) ) ) ).

tff(fact_60_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( plus_plus(A,one_one(A),one_one(A)) = aa(int,A,number_number_of(A),bit0(bit1(pls))) ) ) ).

tff(fact_61_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(int,A,number_number_of(A),plus_plus(int,V,W)) = plus_plus(A,aa(int,A,number_number_of(A),V),aa(int,A,number_number_of(A),W)) ) ) ).

tff(fact_62_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_63_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_64_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_65_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_66_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B1: A] :
          ( ( plus_plus(A,B1,A1) = plus_plus(A,C,A1) )
         => ( B1 = C ) ) ) ).

tff(fact_67_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_68_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( plus_plus(A,A1,B1) = plus_plus(A,A1,C) )
         => ( B1 = C ) ) ) ).

tff(fact_69_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B1: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B1),C) = plus_plus(A,A1,plus_plus(A,B1,C)) ) ) ).

tff(fact_70_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,aa(int,A,number_number_of(A),pls),A1) = A1 ) ) ).

tff(fact_71_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_72_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,A1,aa(int,A,number_number_of(A),pls)) = A1 ) ) ).

tff(fact_73_number__of__code__int__def,axiom,
    number_number_of(quickcheck_code_int) = quickcheck_of_int ).

tff(fact_74_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(int,A,number_number_of(A),bit0(W)) = plus_plus(A,plus_plus(A,zero_zero(A),aa(int,A,number_number_of(A),W)),aa(int,A,number_number_of(A),W)) ) ) ).

tff(fact_75_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(int,A,number_number_of(A),bit1(W)) = plus_plus(A,plus_plus(A,one_one(A),aa(int,A,number_number_of(A),W)),aa(int,A,number_number_of(A),W)) ) ) ).

tff(fact_76_semiring__one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( plus_plus(A,one_one(A),one_one(A)) = aa(int,A,number_number_of(A),bit0(bit1(pls))) ) ) ).

tff(fact_77_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_78_code__numeral_Osize_I3_J,axiom,
    size_size(code_code_numeral,zero_zero(code_code_numeral)) = zero_zero(nat) ).

tff(fact_79_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_80_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,N1,K1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_81_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit0(L)) = bit0(plus_plus(int,K,L)) ) ).

tff(fact_82_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit1(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_83_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit1(K),bit0(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_84_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( plus_plus(int,aa(int,int,number_number_of(int),V),aa(int,int,number_number_of(int),W)) = aa(int,int,number_number_of(int),plus_plus(int,V,W)) ) ).

tff(fact_85_add__Pls,axiom,
    ! [K: int] : ( plus_plus(int,pls,K) = K ) ).

tff(fact_86_add__Pls__right,axiom,
    ! [K: int] : ( plus_plus(int,K,pls) = K ) ).

tff(fact_87_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = plus_plus(int,K,K) ) ).

tff(fact_88_Bit1__def,axiom,
    ! [K: int] : ( bit1(K) = plus_plus(int,plus_plus(int,one_one(int),K),K) ) ).

tff(fact_89_odd__nonzero,axiom,
    ! [Z: int] : ( plus_plus(int,plus_plus(int,one_one(int),Z),Z) != zero_zero(int) ) ).

tff(fact_90_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_91_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_92_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_93_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( plus_plus(nat,zero_zero(nat),N) = N ) ).

tff(fact_94_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_95_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = M )
     => ( N = zero_zero(nat) ) ) ).

%----Arities (53)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__add,axiom,
    monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Rings_Ozero__neq__one,axiom,
    zero_neq_one(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Omonoid__add,axiom,
    monoid_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ozero,axiom,
    zero(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Int_Onumber,axiom,
    number(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oone,axiom,
    one(code_code_numeral) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Rings_Ozero__neq__one,axiom,
    zero_neq_one(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Omonoid__add,axiom,
    monoid_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ozero,axiom,
    zero(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Int_Onumber,axiom,
    number(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Oone,axiom,
    one(quickcheck_code_int) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    map(nat,complex,fFT_Mirabelle_DFT(aa(int,nat,number_number_of(nat),bit0(bit0(bit1(pls)))),a),cons(nat,zero_zero(nat),cons(nat,one_one(nat),cons(nat,aa(int,nat,number_number_of(nat),bit0(bit1(pls))),cons(nat,aa(int,nat,number_number_of(nat),bit1(bit1(pls))),nil(nat)))))) = aTP_x_0 ).

%------------------------------------------------------------------------------
