%------------------------------------------------------------------------------
% File     : SWV633_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 240
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_240 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  190 (  77 unt;  39 typ;   0 def)
%            Number of atoms       :  238 ( 112 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   95 (   8   ~;   2   |;   5   &)
%                                         (  10 <=>;  70  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :    7 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   17 (  12   >;   5   *;   0   +;   0  <<)
%            Number of predicates  :   17 (  16 usr;   0 prp; 1-2 aty)
%            Number of functors    :   18 (  18 usr;   7 con; 0-4 aty)
%            Number of variables   :  294 ( 272   !;   0   ?; 294   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Oii,type,
    ii: complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_j,type,
    j: nat ).

tff(sy_v_m,type,
    m: nat ).

%----Relevant facts (97)
tff(fact_0_power2__eq__square__number__of,axiom,
    ! [B2: $tType] :
      ( ( monoid_mult(B2)
        & number(B2) )
     => ! [W1: int] : ( power_power(B2,number_number_of(B2,W1),number_number_of(nat,bit0(bit1(pls)))) = times_times(B2,number_number_of(B2,W1),number_number_of(B2,W1)) ) ) ).

tff(fact_1_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X1,N),power_power(A,X1,N)) ) ) ).

tff(fact_2_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_3_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_4_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_5_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_6_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_7_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_8_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_9_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_10_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_11_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_15_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_16_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_17_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z) ) ) ).

tff(fact_18_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_19_zpower__zpower,axiom,
    ! [Z: nat,Y1: nat,X1: int] : ( power_power(int,power_power(int,X1,Y1),Z) = power_power(int,X1,times_times(nat,Y1,Z)) ) ).

tff(fact_20_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_21_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_22_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_23_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_24_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_25_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_26_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_27_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_28_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W: int] :
          ( ( number_number_of(A,W) = X )
        <=> ( X = number_number_of(A,W) ) ) ) ).

tff(fact_29_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_30_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y1: A,X1: A] : ( power_power(A,times_times(A,X1,Y1),Q) = times_times(A,power_power(A,X1,Q),power_power(A,Y1,Q)) ) ) ).

tff(fact_31_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X1: A] : ( power_power(A,power_power(A,X1,P),Q) = power_power(A,X1,times_times(nat,P,Q)) ) ) ).

tff(fact_32_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_33_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_34_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_35_four__x__squared,axiom,
    ! [X1: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X1,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X1),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_36_root4,axiom,
    fFT_Mirabelle_root(number_number_of(nat,bit0(bit0(bit1(pls))))) = ii ).

tff(fact_37_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,times_times(A,A1,B)) = times_times(A,A1,B) ) ) ).

tff(fact_38_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),N))) = times_times(A,X1,times_times(A,power_power(A,X1,N),power_power(A,X1,N))) ) ) ).

tff(fact_39_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),N))) = times_times(A,A1,power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_40_power__mult,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M: nat,A1: A] : ( power_power(A,A1,times_times(nat,M,N)) = power_power(A,power_power(A,A1,M),N) ) ) ).

tff(fact_41_ring__1__class_Opower__minus__even,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [N: nat,A1: A] : ( power_power(A,uminus_uminus(A,A1),times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) ) ) ).

tff(fact_42_power2__sum,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Y1: A,X1: A] : ( power_power(A,plus_plus(A,X1,Y1),number_number_of(nat,bit0(bit1(pls)))) = plus_plus(A,plus_plus(A,power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))),power_power(A,Y1,number_number_of(nat,bit0(bit1(pls))))),times_times(A,times_times(A,number_number_of(A,bit0(bit1(pls))),X1),Y1)) ) ) ).

tff(fact_43_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,times_times(A,A1,B),N) = times_times(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_44_minus__Pls,axiom,
    uminus_uminus(int,pls) = pls ).

tff(fact_45_minus__Bit0,axiom,
    ! [K: int] : ( uminus_uminus(int,bit0(K)) = bit0(uminus_uminus(int,K)) ) ).

tff(fact_46_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit0(L)) = bit0(plus_plus(int,K,L)) ) ).

tff(fact_47_compl__eq__compl__iff,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [Y: A,X: A] :
          ( ( uminus_uminus(A,X) = uminus_uminus(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_48_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( plus_plus(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,plus_plus(int,V,W1)) ) ) ).

tff(fact_49_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( plus_plus(A,number_number_of(A,V),plus_plus(A,number_number_of(A,W1),Z)) = plus_plus(A,number_number_of(A,plus_plus(int,V,W1)),Z) ) ) ).

tff(fact_50_arith__simps_I30_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int] : ( uminus_uminus(A,number_number_of(A,W1)) = number_number_of(A,uminus_uminus(int,W1)) ) ) ).

tff(fact_51_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit0(K),bit1(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_52_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( plus_plus(int,bit1(K),bit0(L)) = bit1(plus_plus(int,K,L)) ) ).

tff(fact_53_right__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [C: B2,B: B2,V: int] : ( times_times(B2,number_number_of(B2,V),plus_plus(B2,B,C)) = plus_plus(B2,times_times(B2,number_number_of(B2,V),B),times_times(B2,number_number_of(B2,V),C)) ) ) ).

tff(fact_54_left__distrib__number__of,axiom,
    ! [B2: $tType] :
      ( ( number(B2)
        & semiring(B2) )
     => ! [V: int,B: B2,A1: B2] : ( times_times(B2,plus_plus(B2,A1,B),number_number_of(B2,V)) = plus_plus(B2,times_times(B2,A1,number_number_of(B2,V)),times_times(B2,B,number_number_of(B2,V))) ) ) ).

tff(fact_55_minus__number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int] : ( times_times(A,uminus_uminus(A,number_number_of(A,W1)),Z) = times_times(A,number_number_of(A,uminus_uminus(int,W1)),Z) ) ) ).

tff(fact_56_power__Suc,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,suc(N)) = times_times(A,A1,power_power(A,A1,N)) ) ) ).

tff(fact_57_mult__Bit1,axiom,
    ! [L: int,K: int] : ( times_times(int,bit1(K),L) = plus_plus(int,bit0(times_times(int,K,L)),L) ) ).

tff(fact_58_add__2__eq__Suc_H,axiom,
    ! [N: nat] : ( plus_plus(nat,N,number_number_of(nat,bit0(bit1(pls)))) = suc(suc(N)) ) ).

tff(fact_59_add__2__eq__Suc,axiom,
    ! [N: nat] : ( plus_plus(nat,number_number_of(nat,bit0(bit1(pls))),N) = suc(suc(N)) ) ).

tff(fact_60_power2__minus,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [A1: A] : ( power_power(A,uminus_uminus(A,A1),number_number_of(nat,bit0(bit1(pls)))) = power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_61_number__of__minus,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int] : ( number_number_of(A,uminus_uminus(int,W1)) = uminus_uminus(A,number_number_of(A,W1)) ) ) ).

tff(fact_62_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,plus_plus(int,V,W1)) = plus_plus(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_63_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_64_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,C,plus_plus(A,A1,D1)) ) ) ).

tff(fact_65_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),D1) ) ) ).

tff(fact_66_int__distrib_I2_J,axiom,
    ! [Z2: int,Z11: int,W1: int] : ( times_times(int,W1,plus_plus(int,Z11,Z2)) = plus_plus(int,times_times(int,W1,Z11),times_times(int,W1,Z2)) ) ).

tff(fact_67_times__numeral__code_I5_J,axiom,
    ! [W1: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W1)) = number_number_of(int,times_times(int,V,W1)) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,plus_plus(A,A1,C),B) ) ) ).

tff(fact_70_int__distrib_I1_J,axiom,
    ! [W1: int,Z2: int,Z11: int] : ( times_times(int,plus_plus(int,Z11,Z2),W1) = plus_plus(int,times_times(int,Z11,W1),times_times(int,Z2,W1)) ) ).

tff(fact_71_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),plus_plus(A,C,D1)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B,D1)) ) ) ).

tff(fact_72_ext,axiom,
    ! [B2: $tType,A: $tType,G: fun(A,B2),F: fun(A,B2)] :
      ( ! [X3: A] : ( aa(A,B2,F,X3) = aa(A,B2,G,X3) )
     => ( F = G ) ) ).

tff(fact_73_uminus__apply,axiom,
    ! [A: $tType,B2: $tType] :
      ( uminus(A)
     => ! [X: B2,A3: fun(B2,A)] : ( aa(B2,A,uminus_uminus(fun(B2,A),A3),X) = uminus_uminus(A,aa(B2,A,A3,X)) ) ) ).

tff(fact_74_double__compl,axiom,
    ! [A: $tType] :
      ( boolean_algebra(A)
     => ! [X1: A] : ( uminus_uminus(A,uminus_uminus(A,X1)) = X1 ) ) ).

tff(fact_75_fun__Compl__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( uminus(B2)
     => ! [A3: fun(A,B2),X2: A] : ( aa(A,B2,uminus_uminus(fun(A,B2),A3),X2) = uminus_uminus(B2,aa(A,B2,A3,X2)) ) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I34_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Z: A,Y1: A,X1: A] : ( times_times(A,X1,plus_plus(A,Y1,Z)) = plus_plus(A,times_times(A,X1,Y1),times_times(A,X1,Z)) ) ) ).

tff(fact_77_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C1: A,B1: A,A2: A] :
          ( ( ( A2 != B1 )
            & ( C1 != D ) )
        <=> ( plus_plus(A,times_times(A,A2,C1),times_times(A,B1,D)) != plus_plus(A,times_times(A,A2,D),times_times(A,B1,C1)) ) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I8_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,plus_plus(A,A1,B),C) = plus_plus(A,times_times(A,A1,C),times_times(A,B,C)) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I1_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,M: A,A1: A] : ( plus_plus(A,times_times(A,A1,M),times_times(A,B,M)) = times_times(A,plus_plus(A,A1,B),M) ) ) ).

tff(fact_80_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [Z1: A,X: A,Y: A,W: A] :
          ( ( plus_plus(A,times_times(A,W,Y),times_times(A,X,Z1)) = plus_plus(A,times_times(A,W,Z1),times_times(A,X,Y)) )
        <=> ( ( W = X )
            | ( Y = Z1 ) ) ) ) ).

tff(fact_81_add__Pls,axiom,
    ! [K: int] : ( plus_plus(int,pls,K) = K ) ).

tff(fact_82_add__Pls__right,axiom,
    ! [K: int] : ( plus_plus(int,K,pls) = K ) ).

tff(fact_83_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = plus_plus(int,K,K) ) ).

tff(fact_84_power__Suc2,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,suc(N)) = times_times(A,power_power(A,A1,N),A1) ) ) ).

tff(fact_85_power__add,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M: nat,A1: A] : ( power_power(A,A1,plus_plus(nat,M,N)) = times_times(A,power_power(A,A1,M),power_power(A,A1,N)) ) ) ).

tff(fact_86_Suc3__eq__add__3,axiom,
    ! [N: nat] : ( suc(suc(suc(N))) = plus_plus(nat,number_number_of(nat,bit1(bit1(pls))),N) ) ).

tff(fact_87_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,A1,number_number_of(A,pls)) = A1 ) ) ).

tff(fact_88_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( plus_plus(A,number_number_of(A,pls),A1) = A1 ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I35_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( power_power(A,X1,suc(Q)) = times_times(A,X1,power_power(A,X1,Q)) ) ) ).

tff(fact_90_comm__semiring__1__class_Onormalizing__semiring__rules_I27_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( times_times(A,X1,power_power(A,X1,Q)) = power_power(A,X1,suc(Q)) ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I28_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( times_times(A,power_power(A,X1,Q),X1) = power_power(A,X1,suc(Q)) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I26_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X1: A] : ( times_times(A,power_power(A,X1,P),power_power(A,X1,Q)) = power_power(A,X1,plus_plus(nat,P,Q)) ) ) ).

tff(fact_93_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( times_times(A,A1,A1) = A1 ) ) ).

tff(fact_94_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = X1 ) ) ).

tff(fact_95_power2__eq__iff,axiom,
    ! [A: $tType] :
      ( idom(A)
     => ! [Y: A,X: A] :
          ( ( power_power(A,X,number_number_of(nat,bit0(bit1(pls)))) = power_power(A,Y,number_number_of(nat,bit0(bit1(pls)))) )
        <=> ( ( X = Y )
            | ( X = uminus_uminus(A,Y) ) ) ) ) ).

tff(fact_96_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( times_times(A,Z,number_number_of(A,bit0(bit1(pls)))) = plus_plus(A,Z,Z) ) ) ).

%----Arities (51)
tff(arity_fun___Lattices_Oboolean__algebra,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( boolean_algebra(T_2)
     => boolean_algebra(fun(T_1,T_2)) ) ).

tff(arity_fun___Groups_Ouminus,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( uminus(T_2)
     => uminus(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Groups_Ouminus,axiom,
    uminus(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Rings_Oidom,axiom,
    idom(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_HOL_Obool___Lattices_Oboolean__algebra,axiom,
    boolean_algebra(bool) ).

tff(arity_HOL_Obool___Groups_Ouminus,axiom,
    uminus(bool) ).

tff(arity_RealDef_Oreal___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring,axiom,
    semiring(real) ).

tff(arity_RealDef_Oreal___Groups_Ouminus,axiom,
    uminus(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__1,axiom,
    ring_1(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Rings_Oidom,axiom,
    idom(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

tff(arity_Complex_Ocomplex___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring,axiom,
    semiring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ouminus,axiom,
    uminus(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1,axiom,
    ring_1(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oidom,axiom,
    idom(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    power_power(complex,fFT_Mirabelle_root(times_times(nat,number_number_of(nat,bit0(bit1(pls))),m)),times_times(nat,i,times_times(nat,number_number_of(nat,bit0(bit1(pls))),j))) = power_power(complex,fFT_Mirabelle_root(times_times(nat,number_number_of(nat,bit0(bit1(pls))),m)),times_times(nat,number_number_of(nat,bit0(bit1(pls))),times_times(nat,i,j))) ).

%------------------------------------------------------------------------------
