%------------------------------------------------------------------------------
% File     : SWV629_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 223
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_223 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  205 (  86 unt;  48 typ;   0 def)
%            Number of atoms       :  306 ( 107 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  171 (  22   ~;   4   |;  26   &)
%                                         (  25 <=>;  94  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   3 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  15   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   30 (  29 usr;   0 prp; 1-4 aty)
%            Number of functors    :   15 (  15 usr;   3 con; 0-4 aty)
%            Number of variables   :  249 ( 206   !;   3   ?; 249   :)
%                                         (  40  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:08
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra__1,type,
    real_n2089651433ebra_1: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocnj,type,
    cnj: complex > complex ).

tff(sy_c_Complex_Oii,type,
    ii: complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_Osemiring__1__class_ONats,type,
    semiring_1_Nats: 
      !>[A: $tType] : fun(A,bool) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat__Transfer_Otransfer__morphism,type,
    nat_tr1645093318rphism: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,A) * fun(B1,bool) ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_RealVector_Ovector__space,type,
    vector_space: 
      !>[A: $tType,B1: $tType] : ( fun(A,fun(B1,B1)) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

%----Relevant facts (97)
tff(fact_0_root0,axiom,
    fFT_Mirabelle_root(zero_zero(nat)) = one_one(complex) ).

tff(fact_1_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_2_root__unity,axiom,
    ! [N: nat] : ( power_power(complex,fFT_Mirabelle_root(N),N) = one_one(complex) ) ).

tff(fact_3_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_4_of__nat__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,one_one(nat)) = one_one(A) ) ) ).

tff(fact_5_complex__i__not__one,axiom,
    ii != one_one(complex) ).

tff(fact_6_complex__cnj__one,axiom,
    cnj(one_one(complex)) = one_one(complex) ).

tff(fact_7_Nats__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => member(A,one_one(A),semiring_1_Nats(A)) ) ).

tff(fact_8_not__iszero__1,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ~ iszero(A,one_one(A)) ) ).

tff(fact_9_sgn__one,axiom,
    ! [A: $tType] :
      ( real_n2089651433ebra_1(A)
     => ( sgn_sgn(A,one_one(A)) = one_one(A) ) ) ).

tff(fact_10_vector__space_Oscale__one,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [X2: B1,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( aa(B1,B1,aa(A,fun(B1,B1),Scale,one_one(A)),X2) = X2 ) ) ) ).

tff(fact_11_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,M2: nat] :
          ( ( semiring_1_of_nat(A,M2) = semiring_1_of_nat(A,N1) )
        <=> ( M2 = N1 ) ) ) ).

tff(fact_12_complex__cnj__of__nat,axiom,
    ! [N: nat] : ( cnj(semiring_1_of_nat(complex,N)) = semiring_1_of_nat(complex,N) ) ).

tff(fact_13_complex__cnj__cancel__iff,axiom,
    ! [Y1: complex,X2: complex] :
      ( ( cnj(X2) = cnj(Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_14_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_15_sgn__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_16_complex__cnj__zero,axiom,
    cnj(zero_zero(complex)) = zero_zero(complex) ).

tff(fact_17_complex__cnj__zero__iff,axiom,
    ! [Z1: complex] :
      ( ( cnj(Z1) = zero_zero(complex) )
    <=> ( Z1 = zero_zero(complex) ) ) ).

tff(fact_18_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_19_iszero__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => iszero(A,zero_zero(A)) ) ).

tff(fact_20_complex__i__not__zero,axiom,
    ii != zero_zero(complex) ).

tff(fact_21_Nats__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => member(A,zero_zero(A),semiring_1_Nats(A)) ) ).

tff(fact_22_int__1,axiom,
    semiring_1_of_nat(int,one_one(nat)) = one_one(int) ).

tff(fact_23_of__nat__in__Nats,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N1: nat] : member(A,semiring_1_of_nat(A,N1),semiring_1_Nats(A)) ) ).

tff(fact_24_iszero__def,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Z1: A] :
          ( iszero(A,Z1)
        <=> ( Z1 = zero_zero(A) ) ) ) ).

tff(fact_25_complex__cnj__cnj,axiom,
    ! [Z: complex] : ( cnj(cnj(Z)) = Z ) ).

tff(fact_26_complex__cnj__power,axiom,
    ! [N: nat,X: complex] : ( cnj(power_power(complex,X,N)) = power_power(complex,cnj(X),N) ) ).

tff(fact_27_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_28_sgn__zero__iff,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ! [X2: A] :
          ( ( sgn_sgn(A,X2) = zero_zero(A) )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_29_vector__space_Oscale__eq__0__iff,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [X2: B1,A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2) = zero_zero(B1) )
          <=> ( ( A3 = zero_zero(A) )
              | ( X2 = zero_zero(B1) ) ) ) ) ) ).

tff(fact_30_vector__space_Oscale__cancel__left,axiom,
    ! [B1: $tType,A: $tType] :
      ( ( field(A)
        & ab_group_add(B1) )
     => ! [Y1: B1,X2: B1,A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2) = aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),Y1) )
          <=> ( ( X2 = Y1 )
              | ( A3 = zero_zero(A) ) ) ) ) ) ).

tff(fact_31_vector__space_Oscale__cancel__right,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [B2: A,X2: B1,A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2) = aa(B1,B1,aa(A,fun(B1,B1),Scale,B2),X2) )
          <=> ( ( A3 = B2 )
              | ( X2 = zero_zero(B1) ) ) ) ) ) ).

tff(fact_32_vector__space_Oscale__zero__left,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [X2: B1,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( aa(B1,B1,aa(A,fun(B1,B1),Scale,zero_zero(A)),X2) = zero_zero(B1) ) ) ) ).

tff(fact_33_vector__space_Oscale__zero__right,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),zero_zero(B1)) = zero_zero(B1) ) ) ) ).

tff(fact_34_vector__space_Oscale__left__commute,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [X2: B1,B2: A,A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),aa(B1,B1,aa(A,fun(B1,B1),Scale,B2),X2)) = aa(B1,B1,aa(A,fun(B1,B1),Scale,B2),aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2)) ) ) ) ).

tff(fact_35_vector__space_Oscale__left__imp__eq,axiom,
    ! [A: $tType,B1: $tType] :
      ( ( ab_group_add(B1)
        & field(A) )
     => ! [Y1: B1,X2: B1,A3: A,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( ( A3 != zero_zero(A) )
           => ( ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2) = aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),Y1) )
             => ( X2 = Y1 ) ) ) ) ) ).

tff(fact_36_vector__space_Oscale__right__imp__eq,axiom,
    ! [B1: $tType,A: $tType] :
      ( ( field(A)
        & ab_group_add(B1) )
     => ! [B2: A,A3: A,X2: B1,Scale: fun(A,fun(B1,B1))] :
          ( vector_space(A,B1,Scale)
         => ( ( X2 != zero_zero(B1) )
           => ( ( aa(B1,B1,aa(A,fun(B1,B1),Scale,A3),X2) = aa(B1,B1,aa(A,fun(B1,B1),Scale,B2),X2) )
             => ( A3 = B2 ) ) ) ) ) ).

tff(fact_37_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A1: A] : ( power_power(A,A1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_38_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [N1: nat,A3: A] :
          ( ( power_power(A,A3,N1) = zero_zero(A) )
        <=> ( ( A3 = zero_zero(A) )
            & ( N1 != zero_zero(nat) ) ) ) ) ).

tff(fact_39_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_40_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = zero_zero(A) ) ) ) ) ).

tff(fact_41_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( power_power(A,X,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_42_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( sgn_sgn(A,sgn_sgn(A,A1)) = sgn_sgn(A,A1) ) ) ).

tff(fact_43_Nats__induct,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [P1: fun(A,bool),X2: A] :
          ( member(A,X2,semiring_1_Nats(A))
         => ( ! [N2: nat] : pp(aa(A,bool,P1,semiring_1_of_nat(A,N2)))
           => pp(aa(A,bool,P1,X2)) ) ) ) ).

tff(fact_44_Nats__cases,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [X2: A] :
          ( member(A,X2,semiring_1_Nats(A))
         => ~ ! [N2: nat] : ( X2 != semiring_1_of_nat(A,N2) ) ) ) ).

tff(fact_45_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A3: A] :
          ( ( sgn_sgn(A,A3) = zero_zero(A) )
        <=> ( A3 = zero_zero(A) ) ) ) ).

tff(fact_46_int__power,axiom,
    ! [N: nat,M1: nat] : ( semiring_1_of_nat(int,power_power(nat,M1,N)) = power_power(int,semiring_1_of_nat(int,M1),N) ) ).

tff(fact_47_zpower__int,axiom,
    ! [N: nat,M1: nat] : ( power_power(int,semiring_1_of_nat(int,M1),N) = semiring_1_of_nat(int,power_power(nat,M1,N)) ) ).

tff(fact_48_int__int__eq,axiom,
    ! [N1: nat,M2: nat] :
      ( ( semiring_1_of_nat(int,M2) = semiring_1_of_nat(int,N1) )
    <=> ( M2 = N1 ) ) ).

tff(fact_49_int__eq__0__conv,axiom,
    ! [N1: nat] :
      ( ( semiring_1_of_nat(int,N1) = zero_zero(int) )
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_50_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_51_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_52_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_53_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_54_of__nat__power,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N: nat,M1: nat] : ( semiring_1_of_nat(A,power_power(nat,M1,N)) = power_power(A,semiring_1_of_nat(A,M1),N) ) ) ).

tff(fact_55_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,one_one(nat)) = A1 ) ) ).

tff(fact_56_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( power_power(A,X,one_one(nat)) = X ) ) ).

tff(fact_57_transfer__int__nat__numerals_I2_J,axiom,
    one_one(int) = semiring_1_of_nat(int,one_one(nat)) ).

tff(fact_58_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_59_Nat__Transfer_Otransfer__int__nat__functions_I4_J,axiom,
    ! [N: nat,X: nat] : ( power_power(int,semiring_1_of_nat(int,X),N) = semiring_1_of_nat(int,power_power(nat,X,N)) ) ).

tff(fact_60_Nat__Transfer_Otransfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X2: nat] :
      ( ( semiring_1_of_nat(int,X2) = semiring_1_of_nat(int,Y1) )
    <=> ( X2 = Y1 ) ) ).

tff(fact_61_int__if__cong,axiom,
    ! [Y1: nat,X2: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X2) = semiring_1_of_nat(int,if(nat,P1,X2,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X2,Y1)) ) ) ) ).

tff(fact_62_power__0__left__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [W: int] :
          ( ( ( number_number_of(nat,W) = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),number_number_of(nat,W)) = one_one(A) ) )
          & ( ( number_number_of(nat,W) != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),number_number_of(nat,W)) = zero_zero(A) ) ) ) ) ).

tff(fact_63_int__le__0__conv,axiom,
    ! [N1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,N1),zero_zero(int))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_64_transfer__morphismI,axiom,
    ! [B1: $tType,A: $tType,A2: fun(A,bool),F: fun(A,B1)] : nat_tr1645093318rphism(A,B1,F,A2) ).

tff(fact_65_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X2: int] :
          ( ( number_number_of(A,X2) = number_number_of(A,Y1) )
        <=> ( X2 = Y1 ) ) ) ).

tff(fact_66_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M2: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,M2),semiring_1_of_nat(A,N1))
        <=> ord_less_eq(nat,M2,N1) ) ) ).

tff(fact_67_le__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X2: int] :
          ( ord_less_eq(A,number_number_of(A,X2),number_number_of(A,Y1))
        <=> ord_less_eq(int,X2,Y1) ) ) ).

tff(fact_68_power__eq__0__iff__number__of,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [W1: int,A3: A] :
          ( ( power_power(A,A3,number_number_of(nat,W1)) = zero_zero(A) )
        <=> ( ( A3 = zero_zero(A) )
            & ( number_number_of(nat,W1) != zero_zero(nat) ) ) ) ) ).

tff(fact_69_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_70_power__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N3: nat,N: nat] :
          ( ord_less_eq(nat,N,N3)
         => ( ord_less_eq(A,one_one(A),A1)
           => ord_less_eq(A,power_power(A,A1,N),power_power(A,A1,N3)) ) ) ) ).

tff(fact_71_transfer__morphism__def,axiom,
    ! [B1: $tType,A: $tType,A2: fun(A,bool),F: fun(A,B1)] : nat_tr1645093318rphism(A,B1,F,A2) ).

tff(fact_72_mem__def,axiom,
    ! [A: $tType,A2: fun(A,bool),X2: A] :
      ( member(A,X2,A2)
    <=> pp(aa(A,bool,A2,X2)) ) ).

tff(fact_73_power__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N3: nat,N: nat] :
          ( ord_less_eq(nat,N,N3)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ( ord_less_eq(A,A1,one_one(A))
             => ord_less_eq(A,power_power(A,A1,N3),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_74_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X2: A,W1: int] :
          ( ( number_number_of(A,W1) = X2 )
        <=> ( X2 = number_number_of(A,W1) ) ) ) ).

tff(fact_75_zero__le__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less_eq(A,zero_zero(A),one_one(A)) ) ).

tff(fact_76_not__one__le__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less_eq(A,one_one(A),zero_zero(A)) ) ).

tff(fact_77_power__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B: A,A1: A] :
          ( ord_less_eq(A,A1,B)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ord_less_eq(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ).

tff(fact_78_zero__le__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ord_less_eq(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_79_number__of__int,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [N: nat] : ( number_number_of(A,semiring_1_of_nat(int,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_80_one__le__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less_eq(A,one_one(A),A1)
         => ord_less_eq(A,one_one(A),power_power(A,A1,N)) ) ) ).

tff(fact_81_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N)) ) ).

tff(fact_82_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M1)) ) ).

tff(fact_83_Nat__Transfer_Otransfer__nat__int__function__closures_I6_J,axiom,
    ord_less_eq(int,zero_zero(int),one_one(int)) ).

tff(fact_84_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ! [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
         => pp(aa(int,bool,P1,X1)) )
    <=> ! [X1: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X1))) ) ).

tff(fact_85_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ? [X1: int] :
          ( ord_less_eq(int,zero_zero(int),X1)
          & pp(aa(int,bool,P1,X1)) )
    <=> ? [X1: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X1))) ) ).

tff(fact_86_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z)) ).

tff(fact_87_zero__zle__int,axiom,
    ! [N: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N)) ).

tff(fact_88_Nat__Transfer_Otransfer__nat__int__function__closures_I4_J,axiom,
    ! [N: nat,X: int] :
      ( ord_less_eq(int,zero_zero(int),X)
     => ord_less_eq(int,zero_zero(int),power_power(int,X,N)) ) ).

tff(fact_89_of__nat__number__of__lemma,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [V: int] :
          ( ( ord_less_eq(int,zero_zero(int),number_number_of(int,V))
           => ( semiring_1_of_nat(A,number_number_of(nat,V)) = number_number_of(A,V) ) )
          & ( ~ ord_less_eq(int,zero_zero(int),number_number_of(int,V))
           => ( semiring_1_of_nat(A,number_number_of(nat,V)) = zero_zero(A) ) ) ) ) ).

tff(fact_90_zero__le__imp__eq__int,axiom,
    ! [K: int] :
      ( ord_less_eq(int,zero_zero(int),K)
     => ? [N2: nat] : ( K = semiring_1_of_nat(int,N2) ) ) ).

tff(fact_91_nonneg__eq__int,axiom,
    ! [Z: int] :
      ( ord_less_eq(int,zero_zero(int),Z)
     => ~ ! [M: nat] : ( Z != semiring_1_of_nat(int,M) ) ) ).

tff(fact_92_complex__cnj__number__of,axiom,
    ! [W: int] : ( cnj(number_number_of(complex,W)) = number_number_of(complex,W) ) ).

tff(fact_93_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_94_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_95_le__0__eq,axiom,
    ! [N1: nat] :
      ( ord_less_eq(nat,N1,zero_zero(nat))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_96_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

%----Arities (54)
tff(arity_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Groups_Oab__group__add,axiom,
    ab_group_add(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Osemiring__0,axiom,
    semiring_0(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Nat_Osemiring__char__0,axiom,
    semiring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__group__add,axiom,
    ab_group_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    fFT_Mirabelle_root(one_one(nat)) = one_one(complex) ).

%------------------------------------------------------------------------------
