%------------------------------------------------------------------------------
% File     : SWV625_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 208
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_208 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  156 (  73 unt;  34 typ;   0 def)
%            Number of atoms       :  253 (  92 equ)
%            Maximal formula atoms :   10 (   1 avg)
%            Number of connectives :  157 (  26   ~;   1   |;  31   &)
%                                         (  23 <=>;  76  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   3 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   16 (  13   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   19 (  19 usr;   6 con; 0-3 aty)
%            Number of variables   :  143 ( 127   !;   0   ?; 143   :)
%                                         (  16  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real1: $tType ).

%----Explicit typings (29)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocis,type,
    cis: real1 > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_RealDef_Oreal,type,
    real: 
      !>[A: $tType] : ( A > real1 ) ).

tff(sy_c_Transcendental_Ocos,type,
    cos: real1 > real1 ).

tff(sy_c_Transcendental_Opi,type,
    pi: real1 ).

tff(sy_c_Transcendental_Osin,type,
    sin: real1 > real1 ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_k,type,
    k: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (98)
tff(fact_0_realk,axiom,
    ord_less(real1,inverse_divide(real1,times_times(real1,real(nat,k),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)),real(nat,n)),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) ).

tff(fact_1_real0,axiom,
    ord_less(real1,zero_zero(real1),inverse_divide(real1,times_times(real1,real(nat,k),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)),real(nat,n))) ).

tff(fact_2_sin__cos__between__zero__two__pi,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi))
       => ( ( sin(X) != zero_zero(real1) )
          | ( cos(X) != one_one(real1) ) ) ) ) ).

tff(fact_3_assms_I2_J,axiom,
    ord_less(nat,k,n) ).

tff(fact_4_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_5_minus__number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int] : ( times_times(A,uminus_uminus(A,number_number_of(A,W1)),Z) = times_times(A,number_number_of(A,uminus_uminus(int,W1)),Z) ) ) ).

tff(fact_6_pi__half__neq__two,axiom,
    inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))) != number_number_of(real1,bit0(bit1(pls))) ).

tff(fact_7_eq__divide__2__times__iff,axiom,
    ! [Z1: real1,Y: real1,X1: real1] :
      ( ( X1 = inverse_divide(real1,Y,times_times(real1,number_number_of(real1,bit0(bit1(pls))),Z1)) )
    <=> ( times_times(real1,number_number_of(real1,bit0(bit1(pls))),X1) = inverse_divide(real1,Y,Z1) ) ) ).

tff(fact_8_FFT__Mirabelle__uutasbvzez_Oroot__def,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) = cis(inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,N))) ) ).

tff(fact_9_real__divide__square__eq,axiom,
    ! [A1: real1,R1: real1] : ( inverse_divide(real1,times_times(real1,R1,A1),times_times(real1,R1,R1)) = inverse_divide(real1,A1,R1) ) ).

tff(fact_10_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_11_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_12_rel__simps_I44_J,axiom,
    ! [Ka: int] :
      ( ( bit0(Ka) = pls )
    <=> ( Ka = pls ) ) ).

tff(fact_13_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_14_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_15_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_16_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y: int,X1: int] :
          ( ( number_number_of(A,X1) = number_number_of(A,Y) )
        <=> ( X1 = Y ) ) ) ).

tff(fact_17_rel__simps_I51_J,axiom,
    ! [L: int,Ka: int] :
      ( ( bit1(Ka) = bit1(L) )
    <=> ( Ka = L ) ) ).

tff(fact_18_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_19_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit0(K),L1) = bit0(times_times(int,K,L1)) ) ).

tff(fact_20_rel__simps_I48_J,axiom,
    ! [L: int,Ka: int] :
      ( ( bit0(Ka) = bit0(L) )
    <=> ( Ka = L ) ) ).

tff(fact_21_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int,X1: int] :
          ( ord_less(A,number_number_of(A,X1),number_number_of(A,Y))
        <=> ord_less(int,X1,Y) ) ) ).

tff(fact_22_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z) ) ) ).

tff(fact_23_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_24_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_25_minus__Pls,axiom,
    uminus_uminus(int,pls) = pls ).

tff(fact_26_minus__Bit0,axiom,
    ! [K: int] : ( uminus_uminus(int,bit0(K)) = bit0(uminus_uminus(int,K)) ) ).

tff(fact_27_sin__zero,axiom,
    sin(zero_zero(real1)) = zero_zero(real1) ).

tff(fact_28_cos__minus,axiom,
    ! [X: real1] : ( cos(uminus_uminus(real1,X)) = cos(X) ) ).

tff(fact_29_sin__minus,axiom,
    ! [X: real1] : ( sin(uminus_uminus(real1,X)) = uminus_uminus(real1,sin(X)) ) ).

tff(fact_30_assms_I1_J,axiom,
    ord_less(nat,zero_zero(nat),k) ).

tff(fact_31_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_32_not__real__square__gt__zero,axiom,
    ! [X1: real1] :
      ( ~ ord_less(real1,zero_zero(real1),times_times(real1,X1,X1))
    <=> ( X1 = zero_zero(real1) ) ) ).

tff(fact_33_arith__simps_I30_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int] : ( uminus_uminus(A,number_number_of(A,W1)) = number_number_of(A,uminus_uminus(int,W1)) ) ) ).

tff(fact_34_cos__zero,axiom,
    cos(zero_zero(real1)) = one_one(real1) ).

tff(fact_35_sin__pi,axiom,
    sin(pi) = zero_zero(real1) ).

tff(fact_36_less__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X1: int] :
          ( ord_less(A,number_number_of(A,X1),zero_zero(A))
        <=> ord_less(int,X1,pls) ) ) ).

tff(fact_37_less__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int] :
          ( ord_less(A,zero_zero(A),number_number_of(A,Y))
        <=> ord_less(int,pls,Y) ) ) ).

tff(fact_38_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [A2: A,W: int,B: A] :
          ( ( inverse_divide(A,B,number_number_of(A,W)) = A2 )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( B = times_times(A,A2,number_number_of(A,W)) ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_39_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,B: A,A2: A] :
          ( ( A2 = inverse_divide(A,B,number_number_of(A,W)) )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( times_times(A,A2,number_number_of(A,W)) = B ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_40__096_091_124_Ak_A_060_An_059_A0_A_060_A2_A_K_Api_A_P_Areal_An_A_124_093_A_061_061_062_Areal_Ak_A_K_A_I2_A_K_Api_J_A_P_Areal_An_A_060_A2_A_K_Api_096,axiom,
    ( ord_less(nat,k,n)
   => ( ord_less(real1,zero_zero(real1),inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,n)))
     => ord_less(real1,inverse_divide(real1,times_times(real1,real(nat,k),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)),real(nat,n)),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) ) ) ).

tff(fact_41_divide__less__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [A2: A,W: int,B: A] :
          ( ord_less(A,inverse_divide(A,B,number_number_of(A,W)),A2)
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less(A,B,times_times(A,A2,number_number_of(A,W))) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,times_times(A,A2,number_number_of(A,W)),B) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,zero_zero(A),A2) ) ) ) ) ) ) ).

tff(fact_42_less__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,B: A,A2: A] :
          ( ord_less(A,A2,inverse_divide(A,B,number_number_of(A,W)))
        <=> ( ( ord_less(A,zero_zero(A),number_number_of(A,W))
             => ord_less(A,times_times(A,A2,number_number_of(A,W)),B) )
            & ( ~ ord_less(A,zero_zero(A),number_number_of(A,W))
             => ( ( ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,B,times_times(A,A2,number_number_of(A,W))) )
                & ( ~ ord_less(A,number_number_of(A,W),zero_zero(A))
                 => ord_less(A,A2,zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_43_less__special_I4_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [X1: int] :
          ( ord_less(A,number_number_of(A,X1),one_one(A))
        <=> ord_less(int,X1,bit1(pls)) ) ) ).

tff(fact_44_less__special_I2_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int] :
          ( ord_less(A,one_one(A),number_number_of(A,Y))
        <=> ord_less(int,bit1(pls),Y) ) ) ).

tff(fact_45_sin__npi,axiom,
    ! [N: nat] : ( sin(times_times(real1,real(nat,N),pi)) = zero_zero(real1) ) ).

tff(fact_46_sin__npi2,axiom,
    ! [N: nat] : ( sin(times_times(real1,pi,real(nat,N))) = zero_zero(real1) ) ).

tff(fact_47_sin__double,axiom,
    ! [X: real1] : ( sin(times_times(real1,number_number_of(real1,bit0(bit1(pls))),X)) = times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),sin(X)),cos(X)) ) ).

tff(fact_48_cos__pi__half,axiom,
    cos(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) = zero_zero(real1) ).

tff(fact_49_sin__two__pi,axiom,
    sin(times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) = zero_zero(real1) ).

tff(fact_50_cos__two__pi,axiom,
    cos(times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) = one_one(real1) ).

tff(fact_51_sin__pi__half,axiom,
    sin(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) = one_one(real1) ).

tff(fact_52_cos__3over2__pi,axiom,
    cos(times_times(real1,inverse_divide(real1,number_number_of(real1,bit1(bit1(pls))),number_number_of(real1,bit0(bit1(pls)))),pi)) = zero_zero(real1) ).

tff(fact_53_sin__2npi,axiom,
    ! [N: nat] : ( sin(times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),real(nat,N)),pi)) = zero_zero(real1) ) ).

tff(fact_54_cos__2npi,axiom,
    ! [N: nat] : ( cos(times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),real(nat,N)),pi)) = one_one(real1) ) ).

tff(fact_55_sin__3over2__pi,axiom,
    sin(times_times(real1,inverse_divide(real1,number_number_of(real1,bit1(bit1(pls))),number_number_of(real1,bit0(bit1(pls)))),pi)) = uminus_uminus(real1,one_one(real1)) ).

tff(fact_56_minus__numeral__code_I5_J,axiom,
    ! [W1: int] : ( uminus_uminus(int,number_number_of(int,W1)) = number_number_of(int,uminus_uminus(int,W1)) ) ).

tff(fact_57_cos__one__sin__zero,axiom,
    ! [X: real1] :
      ( ( cos(X) = one_one(real1) )
     => ( sin(X) = zero_zero(real1) ) ) ).

tff(fact_58_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_59_sin__gt__zero__pi,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,pi)
       => ord_less(real1,zero_zero(real1),sin(X)) ) ) ).

tff(fact_60_pi__gt__zero,axiom,
    ord_less(real1,zero_zero(real1),pi) ).

tff(fact_61_pi__not__less__zero,axiom,
    ~ ord_less(real1,pi,zero_zero(real1)) ).

tff(fact_62_pi__neq__zero,axiom,
    pi != zero_zero(real1) ).

tff(fact_63_fact__lemma,axiom,
    ! [N: nat] : ( times_times(real1,real(nat,N),number_number_of(real1,bit0(bit0(bit1(pls))))) = real(nat,times_times(nat,number_number_of(nat,bit0(bit0(bit1(pls)))),N)) ) ).

tff(fact_64_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X1: A,W: int] :
          ( ( number_number_of(A,W) = X1 )
        <=> ( X1 = number_number_of(A,W) ) ) ) ).

tff(fact_65_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_66_divide__less__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [W: int,C: A,B: A] :
          ( ord_less(A,inverse_divide(A,B,C),number_number_of(A,W))
        <=> ( ( ord_less(A,zero_zero(A),C)
             => ord_less(A,B,times_times(A,number_number_of(A,W),C)) )
            & ( ~ ord_less(A,zero_zero(A),C)
             => ( ( ord_less(A,C,zero_zero(A))
                 => ord_less(A,times_times(A,number_number_of(A,W),C),B) )
                & ( ~ ord_less(A,C,zero_zero(A))
                 => ord_less(A,zero_zero(A),number_number_of(A,W)) ) ) ) ) ) ) ).

tff(fact_67_less__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number(A) )
     => ! [C: A,B: A,W: int] :
          ( ord_less(A,number_number_of(A,W),inverse_divide(A,B,C))
        <=> ( ( ord_less(A,zero_zero(A),C)
             => ord_less(A,times_times(A,number_number_of(A,W),C),B) )
            & ( ~ ord_less(A,zero_zero(A),C)
             => ( ( ord_less(A,C,zero_zero(A))
                 => ord_less(A,B,times_times(A,number_number_of(A,W),C)) )
                & ( ~ ord_less(A,C,zero_zero(A))
                 => ord_less(A,number_number_of(A,W),zero_zero(A)) ) ) ) ) ) ) ).

tff(fact_68_sin__gt__zero,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,number_number_of(real1,bit0(bit1(pls))))
       => ord_less(real1,zero_zero(real1),sin(X)) ) ) ).

tff(fact_69_cos__two__less__zero,axiom,
    ord_less(real1,cos(number_number_of(real1,bit0(bit1(pls)))),zero_zero(real1)) ).

tff(fact_70_cos__double__less__one,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,number_number_of(real1,bit0(bit1(pls))))
       => ord_less(real1,cos(times_times(real1,number_number_of(real1,bit0(bit1(pls))),X)),one_one(real1)) ) ) ).

tff(fact_71_cos__two__neq__zero,axiom,
    cos(number_number_of(real1,bit0(bit1(pls)))) != zero_zero(real1) ).

tff(fact_72_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,C: A,B: A] :
          ( ( inverse_divide(A,B,C) = number_number_of(A,W) )
        <=> ( ( ( C != zero_zero(A) )
             => ( B = times_times(A,number_number_of(A,W),C) ) )
            & ( ( C = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_73_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C: A,B: A,W: int] :
          ( ( number_number_of(A,W) = inverse_divide(A,B,C) )
        <=> ( ( ( C != zero_zero(A) )
             => ( times_times(A,number_number_of(A,W),C) = B ) )
            & ( ( C = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_74_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_75_sin__gt__zero2,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))))
       => ord_less(real1,zero_zero(real1),sin(X)) ) ) ).

tff(fact_76_cos__gt__zero,axiom,
    ! [X: real1] :
      ( ord_less(real1,zero_zero(real1),X)
     => ( ord_less(real1,X,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))))
       => ord_less(real1,zero_zero(real1),cos(X)) ) ) ).

tff(fact_77_half__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number_ring(A) )
     => ! [R1: A] :
          ( ord_less(A,zero_zero(A),R1)
         => ord_less(A,zero_zero(A),inverse_divide(A,R1,number_number_of(A,bit0(bit1(pls))))) ) ) ).

tff(fact_78_half__gt__zero__iff,axiom,
    ! [A: $tType] :
      ( ( linord1117847801e_zero(A)
        & number_ring(A) )
     => ! [R: A] :
          ( ord_less(A,zero_zero(A),inverse_divide(A,R,number_number_of(A,bit0(bit1(pls)))))
        <=> ord_less(A,zero_zero(A),R) ) ) ).

tff(fact_79_sin__less__zero,axiom,
    ! [X: real1] :
      ( ord_less(real1,inverse_divide(real1,uminus_uminus(real1,pi),number_number_of(real1,bit0(bit1(pls)))),X)
     => ( ord_less(real1,X,zero_zero(real1))
       => ord_less(real1,sin(X),zero_zero(real1)) ) ) ).

tff(fact_80_cos__gt__zero__pi,axiom,
    ! [X: real1] :
      ( ord_less(real1,uminus_uminus(real1,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))),X)
     => ( ord_less(real1,X,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))))
       => ord_less(real1,zero_zero(real1),cos(X)) ) ) ).

tff(fact_81_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_82_number__of__minus,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int] : ( number_number_of(A,uminus_uminus(int,W1)) = uminus_uminus(A,number_number_of(A,W1)) ) ) ).

tff(fact_83_sin__30,axiom,
    sin(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(bit1(pls)))))) = inverse_divide(real1,one_one(real1),number_number_of(real1,bit0(bit1(pls)))) ).

tff(fact_84_cos__60,axiom,
    cos(inverse_divide(real1,pi,number_number_of(real1,bit1(bit1(pls))))) = inverse_divide(real1,one_one(real1),number_number_of(real1,bit0(bit1(pls)))) ).

tff(fact_85_pi__half__gt__zero,axiom,
    ord_less(real1,zero_zero(real1),inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) ).

tff(fact_86_minus__pi__half__less__zero,axiom,
    ord_less(real1,uminus_uminus(real1,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))),zero_zero(real1)) ).

tff(fact_87_pi__less__4,axiom,
    ord_less(real1,pi,number_number_of(real1,bit0(bit0(bit1(pls))))) ).

tff(fact_88_pi__half__less__two,axiom,
    ord_less(real1,inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))),number_number_of(real1,bit0(bit1(pls)))) ).

tff(fact_89_pi__half__neq__zero,axiom,
    inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))) != zero_zero(real1) ).

tff(fact_90_m2pi__less__pi,axiom,
    ord_less(real1,uminus_uminus(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)),pi) ).

tff(fact_91_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_92_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_93_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_94_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X: A] : ( inverse_divide(A,X,number_number_of(A,bit1(pls))) = X ) ) ).

tff(fact_95_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A1: A] : ( inverse_divide(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_96_real__of__nat__less__number__of__iff,axiom,
    ! [W: int,Na: nat] :
      ( ord_less(real1,real(nat,Na),number_number_of(real1,W))
    <=> ord_less(nat,Na,number_number_of(nat,W)) ) ).

tff(fact_97_cis__zero,axiom,
    cis(zero_zero(real1)) = one_one(complex) ).

%----Arities (21)
tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field__inverse__zero,axiom,
    linord1117847801e_zero(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real1) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real1) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real1) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    cis(uminus_uminus(real1,inverse_divide(real1,times_times(real1,real(nat,k),times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)),real(nat,n)))) != one_one(complex) ).

%------------------------------------------------------------------------------
