%------------------------------------------------------------------------------
% File     : SWV621_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 203
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_203 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  211 (  77 unt;  51 typ;   0 def)
%            Number of atoms       :  353 ( 102 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  224 (  31   ~;   6   |;  20   &)
%                                         (  24 <=>; 143  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   23 (  14   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :   29 (  28 usr;   0 prp; 1-3 aty)
%            Number of functors    :   19 (  19 usr;   4 con; 0-5 aty)
%            Number of variables   :  328 ( 275   !;   4   ?; 328   :)
%                                         (  49  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_k,type,
    k: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (98)
tff(fact_0_assms_I1_J,axiom,
    ord_less(nat,zero_zero(nat),k) ).

tff(fact_1_assms_I2_J,axiom,
    ord_less(nat,k,n) ).

tff(fact_2_root__unity,axiom,
    ! [N: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N)),N) = one_one(complex) ) ).

tff(fact_3_geometric__sum,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [Na: nat,X1: A] :
          ( ( X1 != one_one(A) )
         => ( aa(fun(nat,bool),A,aa(fun(nat,A),fun(fun(nat,bool),A),big_co1399186613setsum(nat,A),power_power(A,X1)),ord_atLeastLessThan(nat,zero_zero(nat),Na)) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(nat,A,power_power(A,X1),Na)),one_one(A))),aa(A,A,aa(A,fun(A,A),minus_minus(A),X1),one_one(A))) ) ) ) ).

tff(fact_4_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A2: A] : ( aa(nat,A,power_power(A,A2),zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_5_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A2: A] :
          ( ( ( A2 = zero_zero(A) )
           => ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),A2) = zero_zero(A) ) )
          & ( ( A2 != zero_zero(A) )
           => ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),A2) = one_one(A) ) ) ) ) ).

tff(fact_6_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A1: A] :
          ( ( aa(nat,A,power_power(A,A1),Na) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_7_setsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: fun(B,bool)] : ( aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),combk(A,B,zero_zero(A))),A3) = zero_zero(A) ) ) ).

tff(fact_8_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( aa(nat,A,power_power(A,one_one(A)),N) = one_one(A) ) ) ).

tff(fact_9_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),zero_zero(A)),A2) = zero_zero(A) ) ) ).

tff(fact_10_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_11_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),A2) = zero_zero(A) ) ) ).

tff(fact_12_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),N) = zero_zero(A) ) ) ) ) ).

tff(fact_13_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A2: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),one_one(A)),aa(nat,A,power_power(A,A2),N)) = aa(nat,A,power_power(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),one_one(A)),A2)),N) ) ) ).

tff(fact_14_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X2: A] : ( aa(nat,A,power_power(A,X2),zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_15_nat__zero__less__power__iff,axiom,
    ! [Na: nat,X1: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X1),Na))
    <=> ( ord_less(nat,zero_zero(nat),X1)
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_16_nat__power__less__imp__less,axiom,
    ! [N: nat,M: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,aa(nat,nat,power_power(nat,I),M),aa(nat,nat,power_power(nat,I),N))
       => ord_less(nat,M,N) ) ) ).

tff(fact_17_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D1: A,C2: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D1) )
         => ( ord_less(A,A1,B1)
          <=> ord_less(A,C2,D1) ) ) ) ).

tff(fact_18_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X2: A] : ( aa(nat,A,power_power(A,X2),one_one(nat)) = X2 ) ) ).

tff(fact_19_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( aa(nat,A,power_power(A,A2),one_one(nat)) = A2 ) ) ).

tff(fact_20_atLeastLessThan__inj_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D1: A,C2: A,B1: A,A1: A] :
          ( ( ord_atLeastLessThan(A,A1,B1) = ord_atLeastLessThan(A,C2,D1) )
         => ( ord_less(A,A1,B1)
           => ( ord_less(A,C2,D1)
             => ( B1 = D1 ) ) ) ) ) ).

tff(fact_21_atLeastLessThan__inj_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D1: A,C2: A,B1: A,A1: A] :
          ( ( ord_atLeastLessThan(A,A1,B1) = ord_atLeastLessThan(A,C2,D1) )
         => ( ord_less(A,A1,B1)
           => ( ord_less(A,C2,D1)
             => ( A1 = C2 ) ) ) ) ) ).

tff(fact_22_atLeastLessThan__eq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D1: A,C2: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,C2,D1)
           => ( ( ord_atLeastLessThan(A,A1,B1) = ord_atLeastLessThan(A,C2,D1) )
            <=> ( ( A1 = C2 )
                & ( B1 = D1 ) ) ) ) ) ) ).

tff(fact_23_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A2: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,one_one(A),A2)
           => ord_less(A,aa(nat,A,power_power(A,A2),N),aa(nat,A,power_power(A,A2),N1)) ) ) ) ).

tff(fact_24_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ord_less(A,aa(nat,A,power_power(A,A2),M),aa(nat,A,power_power(A,A2),N))
           => ord_less(nat,M,N) ) ) ) ).

tff(fact_25_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y2: nat,X1: nat,B1: A] :
          ( ord_less(A,one_one(A),B1)
         => ( ord_less(A,aa(nat,A,power_power(A,B1),X1),aa(nat,A,power_power(A,B1),Y2))
          <=> ord_less(nat,X1,Y2) ) ) ) ).

tff(fact_26_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A2: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,zero_zero(A),A2)
           => ( ord_less(A,A2,one_one(A))
             => ord_less(A,aa(nat,A,power_power(A,A2),N1),aa(nat,A,power_power(A,A2),N)) ) ) ) ) ).

tff(fact_27_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),aa(nat,A,power_power(A,A2),N)) ) ) ) ).

tff(fact_28_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,B1)
        <=> ord_less(A,aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1),zero_zero(A)) ) ) ).

tff(fact_29_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ord_less(A,zero_zero(A),aa(nat,A,power_power(A,A2),N)) ) ) ).

tff(fact_30_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ord_less(A,B2,A2)
         => ( ord_less(A,C1,zero_zero(A))
           => ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),C1),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C1)) ) ) ) ).

tff(fact_31_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),C1),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C1)) ) ) ) ).

tff(fact_32_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,zero_zero(A))
         => ( ord_less(A,Y1,zero_zero(A))
           => ord_less(A,zero_zero(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),X2),Y1)) ) ) ) ).

tff(fact_33_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,X2,zero_zero(A))
         => ( ord_less(A,zero_zero(A),Y1)
           => ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),X2),Y1),zero_zero(A)) ) ) ) ).

tff(fact_34_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,zero_zero(A),X2)
         => ( ord_less(A,Y1,zero_zero(A))
           => ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),X2),Y1),zero_zero(A)) ) ) ) ).

tff(fact_35_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y1: A,X2: A] :
          ( ord_less(A,zero_zero(A),X2)
         => ( ord_less(A,zero_zero(A),Y1)
           => ord_less(A,zero_zero(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),X2),Y1)) ) ) ) ).

tff(fact_36_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,C2: A,A1: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),C2),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B1),C2))
        <=> ( ( ord_less(A,zero_zero(A),C2)
             => ord_less(A,A1,B1) )
            & ( ord_less(A,C2,zero_zero(A))
             => ord_less(A,B1,A1) )
            & ( C2 != zero_zero(A) ) ) ) ) ).

tff(fact_37_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),B1),zero_zero(A))
        <=> ( ( ord_less(A,zero_zero(A),A1)
              & ord_less(A,B1,zero_zero(A)) )
            | ( ord_less(A,A1,zero_zero(A))
              & ord_less(A,zero_zero(A),B1) ) ) ) ) ).

tff(fact_38_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,zero_zero(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),B1))
        <=> ( ( ord_less(A,zero_zero(A),A1)
              & ord_less(A,zero_zero(A),B1) )
            | ( ord_less(A,A1,zero_zero(A))
              & ord_less(A,B1,zero_zero(A)) ) ) ) ) ).

tff(fact_39_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ( aa(nat,A,power_power(A,A1),M1) = aa(nat,A,power_power(A,A1),Na) )
          <=> ( M1 = Na ) ) ) ) ).

tff(fact_40_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_41_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_42_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_43_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D1: A,C2: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D1) )
         => ( ( A1 = B1 )
          <=> ( C2 = D1 ) ) ) ) ).

tff(fact_44_root__summation,axiom,
    ! [Na: nat,Ka: nat] :
      ( ord_less(nat,zero_zero(nat),Ka)
     => ( ord_less(nat,Ka,Na)
       => ( aa(fun(nat,bool),complex,aa(fun(nat,complex),fun(fun(nat,bool),complex),big_co1399186613setsum(nat,complex),power_power(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(Na)),Ka))),ord_atLeastLessThan(nat,zero_zero(nat),Na)) = zero_zero(complex) ) ) ) ).

tff(fact_45_setsum__commute,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( comm_monoid_add(A)
     => ! [A3: fun(B,bool),B3: fun(C,bool),F: fun(B,fun(C,A))] : ( aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),aa(fun(C,bool),fun(B,A),combc(B,fun(C,bool),A,combb(fun(C,A),fun(fun(C,bool),A),B,big_co1399186613setsum(C,A),F)),B3)),A3) = aa(fun(C,bool),A,aa(fun(C,A),fun(fun(C,bool),A),big_co1399186613setsum(C,A),aa(fun(B,bool),fun(C,A),combc(C,fun(B,bool),A,combb(fun(B,A),fun(fun(B,bool),A),C,big_co1399186613setsum(B,A),combc(B,C,A,F))),A3)),B3) ) ) ).

tff(fact_46_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) )
        <=> ( A1 = B1 ) ) ) ).

tff(fact_47_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( A1 = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B1) = zero_zero(A) ) ) ) ).

tff(fact_48_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_49_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( aa(nat,A,power_power(A,A2),N) != zero_zero(A) ) ) ) ).

tff(fact_50_divide__1,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),one_one(A)) = A2 ) ) ).

tff(fact_51_diff__divide__distrib,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B2)),C1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),C1)),aa(A,A,aa(A,fun(A,A),inverse_divide(A),B2),C1)) ) ) ).

tff(fact_52_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B2: A,A2: A] : ( aa(nat,A,power_power(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),B2)),N) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(nat,A,power_power(A,A2),N)),aa(nat,A,power_power(A,B2),N)) ) ) ).

tff(fact_53_setsum__subtractf,axiom,
    ! [A: $tType,B: $tType] :
      ( ab_group_add(A)
     => ! [A3: fun(B,bool),G: fun(B,A),F: fun(B,A)] : ( aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),combs(B,A,A,combb(A,fun(A,A),B,minus_minus(A),F),G)),A3) = aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),F),A3)),aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),G),A3)) ) ) ).

tff(fact_54_setsum__divide__distrib,axiom,
    ! [A: $tType,B: $tType] :
      ( field(A)
     => ! [R2: A,A3: fun(B,bool),F: fun(B,A)] : ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),F),A3)),R2) = aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),aa(A,fun(B,A),combc(B,A,A,combb(A,fun(A,A),B,inverse_divide(A),F)),R2)),A3) ) ) ).

tff(fact_55_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A,B1: A] :
          ( ( B1 != zero_zero(A) )
         => ( ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A1),B1) = one_one(A) )
          <=> ( A1 = B1 ) ) ) ) ).

tff(fact_56_divide__self,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),A2) = one_one(A) ) ) ) ).

tff(fact_57_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A2: A,B2: A] :
          ( ( B2 != zero_zero(A) )
         => ( aa(nat,A,power_power(A,aa(A,A,aa(A,fun(A,A),inverse_divide(A),A2),B2)),N) = aa(A,A,aa(A,fun(A,A),inverse_divide(A),aa(nat,A,power_power(A,A2),N)),aa(nat,A,power_power(A,B2),N)) ) ) ) ).

tff(fact_58_zero__less__diff,axiom,
    ! [M1: nat,Na: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),Na),M1))
    <=> ord_less(nat,M1,Na) ) ).

tff(fact_59_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_60_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_61_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_62_all__nat__less__eq,axiom,
    ! [P1: fun(nat,bool),Na: nat] :
      ( ! [M2: nat] :
          ( ord_less(nat,M2,Na)
         => pp(aa(nat,bool,P1,M2)) )
    <=> ! [X3: nat] :
          ( member(nat,X3,ord_atLeastLessThan(nat,zero_zero(nat),Na))
         => pp(aa(nat,bool,P1,X3)) ) ) ).

tff(fact_63_ex__nat__less__eq,axiom,
    ! [P1: fun(nat,bool),Na: nat] :
      ( ? [M2: nat] :
          ( ord_less(nat,M2,Na)
          & pp(aa(nat,bool,P1,M2)) )
    <=> ? [X3: nat] :
          ( member(nat,X3,ord_atLeastLessThan(nat,zero_zero(nat),Na))
          & pp(aa(nat,bool,P1,X3)) ) ) ).

tff(fact_64_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_65_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_66_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_67_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_68_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),J)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),I),K)),J) ) ).

tff(fact_69_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X2: A] :
          ( ( X2 != Y1 )
         => ( ~ ord_less(A,X2,Y1)
           => ord_less(A,Y1,X2) ) ) ) ).

tff(fact_70_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_71_diffs0__imp__equal,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),M) = zero_zero(nat) )
       => ( M = N ) ) ) ).

tff(fact_72_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( ord_less(nat,M1,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( ord_less(nat,Na,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_73_diff__less__mono2,axiom,
    ! [L: nat,N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( ord_less(nat,M,L)
       => ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),N),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),L),M)) ) ) ).

tff(fact_74_less__imp__diff__less,axiom,
    ! [N: nat,K: nat,J: nat] :
      ( ord_less(nat,J,K)
     => ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),J),N),K) ) ).

tff(fact_75_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_76_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_77_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_78_linorder__neqE__nat,axiom,
    ! [Y1: nat,X2: nat] :
      ( ( X2 != Y1 )
     => ( ~ ord_less(nat,X2,Y1)
       => ord_less(nat,Y1,X2) ) ) ).

tff(fact_79_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( ord_less(nat,M1,Na)
        | ord_less(nat,Na,M1) ) ) ).

tff(fact_80_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_81_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_82_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_83_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_84_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_85_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_86_diff__less,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,zero_zero(nat),N)
     => ( ord_less(nat,zero_zero(nat),M)
       => ord_less(nat,aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N),M) ) ) ).

tff(fact_87_zero__less__power__nat__eq,axiom,
    ! [Na: nat,X1: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X1),Na))
    <=> ( ( Na = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X1) ) ) ).

tff(fact_88_sumr__geometric,axiom,
    ! [Na: nat,X1: real] :
      ( ( X1 != one_one(real) )
     => ( aa(fun(nat,bool),real,aa(fun(nat,real),fun(fun(nat,bool),real),big_co1399186613setsum(nat,real),power_power(real,X1)),ord_atLeastLessThan(nat,zero_zero(nat),Na)) = aa(real,real,aa(real,fun(real,real),inverse_divide(real),aa(real,real,aa(real,fun(real,real),minus_minus(real),aa(nat,real,power_power(real,X1),Na)),one_one(real))),aa(real,real,aa(real,fun(real,real),minus_minus(real),X1),one_one(real))) ) ) ).

tff(fact_89_setsum__0_H,axiom,
    ! [A: $tType,B: $tType] :
      ( comm_monoid_add(B)
     => ! [F: fun(A,B),A3: fun(A,bool)] :
          ( ! [X: A] :
              ( member(A,X,A3)
             => ( aa(A,B,F,X) = zero_zero(B) ) )
         => ( aa(fun(A,bool),B,aa(fun(A,B),fun(fun(A,bool),B),big_co1399186613setsum(A,B),F),A3) = zero_zero(B) ) ) ) ).

tff(fact_90_realpow__pos__nth,axiom,
    ! [A2: real,N: nat] :
      ( ord_less(nat,zero_zero(nat),N)
     => ( ord_less(real,zero_zero(real),A2)
       => ? [R1: real] :
            ( ord_less(real,zero_zero(real),R1)
            & ( aa(nat,real,power_power(real,R1),N) = A2 ) ) ) ) ).

tff(fact_91_realpow__pos__nth__unique,axiom,
    ! [A2: real,N: nat] :
      ( ord_less(nat,zero_zero(nat),N)
     => ( ord_less(real,zero_zero(real),A2)
       => ? [X: real] :
            ( ord_less(real,zero_zero(real),X)
            & ( aa(nat,real,power_power(real,X),N) = A2 )
            & ! [Y: real] :
                ( ( ord_less(real,zero_zero(real),Y)
                  & ( aa(nat,real,power_power(real,Y),N) = A2 ) )
               => ( Y = X ) ) ) ) ) ).

tff(fact_92_root__cancel,axiom,
    ! [K: nat,N: nat,D: nat] :
      ( ord_less(nat,zero_zero(nat),D)
     => ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(times_times(nat,D,N))),times_times(nat,D,K)) = aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N)),K) ) ) ).

tff(fact_93_power__strict__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ord_less_eq(A,zero_zero(A),A2)
           => ( ord_less(nat,zero_zero(nat),N)
             => ord_less(A,aa(nat,A,power_power(A,A2),N),aa(nat,A,power_power(A,B2),N)) ) ) ) ) ).

tff(fact_94_le__0__eq,axiom,
    ! [Na: nat] :
      ( ord_less_eq(nat,Na,zero_zero(nat))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_95_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_96_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_97_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A1: A] :
          ( ( times_times(A,A1,B1) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

%----Arities (55)
tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field__inverse__zero,axiom,
    linord1117847801e_zero(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semidom,axiom,
    linordered_semidom(real) ).

tff(arity_RealDef_Oreal___Fields_Olinordered__field,axiom,
    linordered_field(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring,axiom,
    division_ring(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__group__add,axiom,
    ab_group_add(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Orderings_Olinorder,axiom,
    linorder(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__0,axiom,
    semiring_0(real) ).

tff(arity_RealDef_Oreal___Groups_Ogroup__add,axiom,
    group_add(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__group__add,axiom,
    ab_group_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ogroup__add,axiom,
    group_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(fun(nat,bool),complex,aa(fun(nat,complex),fun(fun(nat,bool),complex),big_co1399186613setsum(nat,complex),power_power(complex,aa(nat,complex,power_power(complex,aa(complex,complex,aa(complex,fun(complex,complex),inverse_divide(complex),one_one(complex)),fFT_Mirabelle_root(n))),k))),ord_atLeastLessThan(nat,zero_zero(nat),n)) = aa(complex,complex,aa(complex,fun(complex,complex),inverse_divide(complex),aa(complex,complex,aa(complex,fun(complex,complex),minus_minus(complex),aa(nat,complex,power_power(complex,aa(nat,complex,power_power(complex,aa(complex,complex,aa(complex,fun(complex,complex),inverse_divide(complex),one_one(complex)),fFT_Mirabelle_root(n))),k)),n)),one_one(complex))),aa(complex,complex,aa(complex,fun(complex,complex),minus_minus(complex),aa(nat,complex,power_power(complex,aa(complex,complex,aa(complex,fun(complex,complex),inverse_divide(complex),one_one(complex)),fFT_Mirabelle_root(n))),k)),one_one(complex))) ).

%------------------------------------------------------------------------------
