%------------------------------------------------------------------------------
% File     : SWV617_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 185
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_185 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  167 (  47 unt;  40 typ;   0 def)
%            Number of atoms       :  300 (  98 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  202 (  29   ~;   9   |;  16   &)
%                                         (  30 <=>; 118  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   18 (  10   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   25 (  24 usr;   0 prp; 1-3 aty)
%            Number of functors    :   13 (  13 usr;   4 con; 0-4 aty)
%            Number of variables   :  259 ( 228   !;   0   ?; 259   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:37
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_k,type,
    k: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (98)
tff(fact_0__096_I_IFFT__Mirabelle__uutasbvzez_Oroot_An_A_094_Ak_J_A_094_An_A_N_A1_J_A_P_IFFT__Mirabelle__uutasbvzez_Oroot_An_A_094_Ak_A_N_A1_J_A_061_I_IFFT__Mirabelle__uutasbvzez_Oroot_An_A_094_An_J_A_094_Ak_A_N_A1_J_A_P_IFFT__Mirabelle__uutasbvzez_Oroot_An_A_094_Ak_A_N_A1_J_096,axiom,
    inverse_divide(complex,minus_minus(complex,power_power(complex,power_power(complex,fFT_Mirabelle_root(n),k),n),one_one(complex)),minus_minus(complex,power_power(complex,fFT_Mirabelle_root(n),k),one_one(complex))) = inverse_divide(complex,minus_minus(complex,power_power(complex,power_power(complex,fFT_Mirabelle_root(n),n),k),one_one(complex)),minus_minus(complex,power_power(complex,fFT_Mirabelle_root(n),k),one_one(complex))) ).

tff(fact_1_assms_I2_J,axiom,
    ord_less(nat,k,n) ).

tff(fact_2_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_3_root__unity,axiom,
    ! [N: nat] : ( power_power(complex,fFT_Mirabelle_root(N),N) = one_one(complex) ) ).

tff(fact_4_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] :
          ( ( ( A1 = zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = zero_zero(A) ) )
          & ( ( A1 != zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ) ).

tff(fact_5_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_6_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_7_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( inverse_divide(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_8_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A2: A] :
          ( ( power_power(A,A2,Na) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_9_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_10_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A1: A] : ( inverse_divide(A,one_one(A),power_power(A,A1,N)) = power_power(A,inverse_divide(A,one_one(A),A1),N) ) ) ).

tff(fact_11_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A1: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ).

tff(fact_12_divide__self,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ).

tff(fact_13_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A,B1: A] :
          ( ( B1 != zero_zero(A) )
         => ( ( inverse_divide(A,A2,B1) = one_one(A) )
          <=> ( A2 = B1 ) ) ) ) ).

tff(fact_14_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = zero_zero(A) ) ) ) ) ).

tff(fact_15_assms_I1_J,axiom,
    ord_less(nat,zero_zero(nat),k) ).

tff(fact_16_nat__zero__less__power__iff,axiom,
    ! [Na: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Na))
    <=> ( ord_less(nat,zero_zero(nat),X)
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_17_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A1: A] : ( power_power(A,A1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_18_nat__power__less__imp__less,axiom,
    ! [N: nat,M1: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,power_power(nat,I,M1),power_power(nat,I,N))
       => ord_less(nat,M1,N) ) ) ).

tff(fact_19_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),power_power(A,A1,N)) ) ) ) ).

tff(fact_20_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D1: A,C1: A,B1: A,A2: A] :
          ( ( minus_minus(A,A2,B1) = minus_minus(A,C1,D1) )
         => ( ord_less(A,A2,B1)
          <=> ord_less(A,C1,D1) ) ) ) ).

tff(fact_21_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,one_one(nat)) = A1 ) ) ).

tff(fact_22_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,one_one(A),A1)
           => ord_less(A,power_power(A,A1,N),power_power(A,A1,N1)) ) ) ) ).

tff(fact_23_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M1: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(A,power_power(A,A1,M1),power_power(A,A1,N))
           => ord_less(nat,M1,N) ) ) ) ).

tff(fact_24_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: nat,X: nat,B1: A] :
          ( ord_less(A,one_one(A),B1)
         => ( ord_less(A,power_power(A,B1,X),power_power(A,B1,Y1))
          <=> ord_less(nat,X,Y1) ) ) ) ).

tff(fact_25_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,zero_zero(A),A1)
           => ( ord_less(A,A1,one_one(A))
             => ord_less(A,power_power(A,A1,N1),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_26_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,A2,B1)
        <=> ord_less(A,minus_minus(A,A2,B1),zero_zero(A)) ) ) ).

tff(fact_27_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ord_less(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_28_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C: A,A1: A,B: A] :
          ( ord_less(A,B,A1)
         => ( ord_less(A,C,zero_zero(A))
           => ord_less(A,inverse_divide(A,A1,C),inverse_divide(A,B,C)) ) ) ) ).

tff(fact_29_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,inverse_divide(A,A1,C),inverse_divide(A,B,C)) ) ) ) ).

tff(fact_30_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,X1,zero_zero(A))
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,zero_zero(A),inverse_divide(A,X1,Y)) ) ) ) ).

tff(fact_31_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,X1,zero_zero(A))
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,inverse_divide(A,X1,Y),zero_zero(A)) ) ) ) ).

tff(fact_32_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,zero_zero(A),X1)
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,inverse_divide(A,X1,Y),zero_zero(A)) ) ) ) ).

tff(fact_33_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X1: A] :
          ( ord_less(A,zero_zero(A),X1)
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,zero_zero(A),inverse_divide(A,X1,Y)) ) ) ) ).

tff(fact_34_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,C1),inverse_divide(A,B1,C1))
        <=> ( ( ord_less(A,zero_zero(A),C1)
             => ord_less(A,A2,B1) )
            & ( ord_less(A,C1,zero_zero(A))
             => ord_less(A,B1,A2) )
            & ( C1 != zero_zero(A) ) ) ) ) ).

tff(fact_35_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,B1),zero_zero(A))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,B1,zero_zero(A)) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,zero_zero(A),B1) ) ) ) ) ).

tff(fact_36_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B1: A,A2: A] :
          ( ord_less(A,zero_zero(A),inverse_divide(A,A2,B1))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,zero_zero(A),B1) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,B1,zero_zero(A)) ) ) ) ) ).

tff(fact_37_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ( power_power(A,A2,M) = power_power(A,A2,Na) )
          <=> ( M = Na ) ) ) ) ).

tff(fact_38_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_39_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_40_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D1: A,C1: A,B1: A,A2: A] :
          ( ( minus_minus(A,A2,B1) = minus_minus(A,C1,D1) )
         => ( ( A2 = B1 )
          <=> ( C1 = D1 ) ) ) ) ).

tff(fact_41_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A2: A] :
          ( ( minus_minus(A,A2,B1) = zero_zero(A) )
        <=> ( A2 = B1 ) ) ) ).

tff(fact_42_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A2: A] :
          ( ( A2 = B1 )
        <=> ( minus_minus(A,A2,B1) = zero_zero(A) ) ) ) ).

tff(fact_43_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_44_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_45_divide__1,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_46_diff__divide__distrib,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C: A,B: A,A1: A] : ( inverse_divide(A,minus_minus(A,A1,B),C) = minus_minus(A,inverse_divide(A,A1,C),inverse_divide(A,B,C)) ) ) ).

tff(fact_47_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B: A,A1: A] : ( power_power(A,inverse_divide(A,A1,B),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ).

tff(fact_48_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_49_zero__less__diff,axiom,
    ! [M: nat,Na: nat] :
      ( ord_less(nat,zero_zero(nat),minus_minus(nat,Na,M))
    <=> ord_less(nat,M,Na) ) ).

tff(fact_50_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_51_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( power_power(A,X1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_53_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_54_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_55_diff__0__eq__0,axiom,
    ! [N: nat] : ( minus_minus(nat,zero_zero(nat),N) = zero_zero(nat) ) ).

tff(fact_56_diff__self__eq__0,axiom,
    ! [M1: nat] : ( minus_minus(nat,M1,M1) = zero_zero(nat) ) ).

tff(fact_57_diff__commute,axiom,
    ! [K: nat,J: nat,I: nat] : ( minus_minus(nat,minus_minus(nat,I,J),K) = minus_minus(nat,minus_minus(nat,I,K),J) ) ).

tff(fact_58_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X1: A] :
          ( ( X1 != Y )
         => ( ~ ord_less(A,X1,Y)
           => ord_less(A,Y,X1) ) ) ) ).

tff(fact_59_diffs0__imp__equal,axiom,
    ! [N: nat,M1: nat] :
      ( ( minus_minus(nat,M1,N) = zero_zero(nat) )
     => ( ( minus_minus(nat,N,M1) = zero_zero(nat) )
       => ( M1 = N ) ) ) ).

tff(fact_60_minus__nat_Odiff__0,axiom,
    ! [M1: nat] : ( minus_minus(nat,M1,zero_zero(nat)) = M1 ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( power_power(A,X1,one_one(nat)) = X1 ) ) ).

tff(fact_62_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),Na: nat,M: nat] :
      ( ( ord_less(nat,M,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
     => ( ( ( M = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
       => ( ( ord_less(nat,Na,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) ) ) ) ).

tff(fact_63_diff__less__mono2,axiom,
    ! [L: nat,N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ( ord_less(nat,M1,L)
       => ord_less(nat,minus_minus(nat,L,N),minus_minus(nat,L,M1)) ) ) ).

tff(fact_64_less__imp__diff__less,axiom,
    ! [N: nat,K: nat,J: nat] :
      ( ord_less(nat,J,K)
     => ord_less(nat,minus_minus(nat,J,N),K) ) ).

tff(fact_65_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_66_less__not__refl2,axiom,
    ! [M1: nat,N: nat] :
      ( ord_less(nat,N,M1)
     => ( M1 != N ) ) ).

tff(fact_67_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_68_linorder__neqE__nat,axiom,
    ! [Y: nat,X1: nat] :
      ( ( X1 != Y )
     => ( ~ ord_less(nat,X1,Y)
       => ord_less(nat,Y,X1) ) ) ).

tff(fact_69_nat__neq__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( M != Na )
    <=> ( ord_less(nat,M,Na)
        | ord_less(nat,Na,M) ) ) ).

tff(fact_70_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_71_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_72_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_73_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_74_gr__implies__not0,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_75_diff__less,axiom,
    ! [M1: nat,N: nat] :
      ( ord_less(nat,zero_zero(nat),N)
     => ( ord_less(nat,zero_zero(nat),M1)
       => ord_less(nat,minus_minus(nat,M1,N),M1) ) ) ).

tff(fact_76_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_77_zero__less__power__nat__eq,axiom,
    ! [Na: nat,X: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X,Na))
    <=> ( ( Na = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X) ) ) ).

tff(fact_78_power__strict__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ( ord_less(nat,zero_zero(nat),N)
             => ord_less(A,power_power(A,A1,N),power_power(A,B,N)) ) ) ) ) ).

tff(fact_79_root__cancel,axiom,
    ! [K: nat,N: nat,D: nat] :
      ( ord_less(nat,zero_zero(nat),D)
     => ( power_power(complex,fFT_Mirabelle_root(times_times(nat,D,N)),times_times(nat,D,K)) = power_power(complex,fFT_Mirabelle_root(N),K) ) ) ).

tff(fact_80_le__0__eq,axiom,
    ! [Na: nat] :
      ( ord_less_eq(nat,Na,zero_zero(nat))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_81_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_82_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_83_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_84_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_85_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A2: A] :
          ( ( times_times(A,A2,B1) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_86_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,A1,inverse_divide(A,B,C)) = inverse_divide(A,times_times(A,A1,B),C) ) ) ).

tff(fact_87_mult__cancel2,axiom,
    ! [Na: nat,Ka: nat,M: nat] :
      ( ( times_times(nat,M,Ka) = times_times(nat,Na,Ka) )
    <=> ( ( M = Na )
        | ( Ka = zero_zero(nat) ) ) ) ).

tff(fact_88_mult__cancel1,axiom,
    ! [Na: nat,M: nat,Ka: nat] :
      ( ( times_times(nat,Ka,M) = times_times(nat,Ka,Na) )
    <=> ( ( M = Na )
        | ( Ka = zero_zero(nat) ) ) ) ).

tff(fact_89_mult__is__0,axiom,
    ! [Na: nat,M: nat] :
      ( ( times_times(nat,M,Na) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_90_mult__0__right,axiom,
    ! [M1: nat] : ( times_times(nat,M1,zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_91_mult__0,axiom,
    ! [N: nat] : ( times_times(nat,zero_zero(nat),N) = zero_zero(nat) ) ).

tff(fact_92_diff__is__0__eq,axiom,
    ! [Na: nat,M: nat] :
      ( ( minus_minus(nat,M,Na) = zero_zero(nat) )
    <=> ord_less_eq(nat,M,Na) ) ).

tff(fact_93_nat__1__eq__mult__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( one_one(nat) = times_times(nat,M,Na) )
    <=> ( ( M = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_94_nat__mult__eq__1__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( times_times(nat,M,Na) = one_one(nat) )
    <=> ( ( M = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_95_mult__le__cancel2,axiom,
    ! [Na: nat,Ka: nat,M: nat] :
      ( ord_less_eq(nat,times_times(nat,M,Ka),times_times(nat,Na,Ka))
    <=> ( ord_less(nat,zero_zero(nat),Ka)
       => ord_less_eq(nat,M,Na) ) ) ).

tff(fact_96_mult__le__cancel1,axiom,
    ! [Na: nat,M: nat,Ka: nat] :
      ( ord_less_eq(nat,times_times(nat,Ka,M),times_times(nat,Ka,Na))
    <=> ( ord_less(nat,zero_zero(nat),Ka)
       => ord_less_eq(nat,M,Na) ) ) ).

tff(fact_97_nat__0__less__mult__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ord_less(nat,zero_zero(nat),times_times(nat,M,Na))
    <=> ( ord_less(nat,zero_zero(nat),M)
        & ord_less(nat,zero_zero(nat),Na) ) ) ).

%----Arities (26)
tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ogroup__add,axiom,
    group_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    inverse_divide(complex,minus_minus(complex,power_power(complex,power_power(complex,fFT_Mirabelle_root(n),n),k),one_one(complex)),minus_minus(complex,power_power(complex,fFT_Mirabelle_root(n),k),one_one(complex))) = zero_zero(complex) ).

%------------------------------------------------------------------------------
