%------------------------------------------------------------------------------
% File     : SWV613_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 177
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_177 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  161 (  46 unt;  36 typ;   0 def)
%            Number of atoms       :  335 (  69 equ)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives :  239 (  29   ~;   9   |;  19   &)
%                                         (  21 <=>; 161  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   15 (   9   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-3 aty)
%            Number of functors    :   13 (  13 usr;   5 con; 0-4 aty)
%            Number of variables   :  268 ( 243   !;   0   ?; 268   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Olinordered__field__inverse__zero,type,
    linord1117847801e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocnj,type,
    cnj: complex > complex ).

tff(sy_c_Complex_Oii,type,
    ii: complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_k,type,
    k: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (98)
tff(fact_0_assms_I2_J,axiom,
    ord_less(nat,k,n) ).

tff(fact_1_root__unity,axiom,
    ! [N: nat] : ( power_power(complex,fFT_Mirabelle_root(N),N) = one_one(complex) ) ).

tff(fact_2_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_3_assms_I1_J,axiom,
    ord_less(nat,zero_zero(nat),k) ).

tff(fact_4_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_5_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_6_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A1: A] : ( power_power(A,A1,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_7_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( power_power(A,X,zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_8_one__le__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less_eq(A,one_one(A),A1)
         => ord_less_eq(A,one_one(A),power_power(A,A1,N)) ) ) ).

tff(fact_9_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ( power_power(A,A2,M1) = power_power(A,A2,Na) )
          <=> ( M1 = Na ) ) ) ) ).

tff(fact_10_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A1: A] : ( inverse_divide(A,one_one(A),power_power(A,A1,N)) = power_power(A,inverse_divide(A,one_one(A),A1),N) ) ) ).

tff(fact_11_complex__i__not__one,axiom,
    ii != one_one(complex) ).

tff(fact_12_complex__cnj__one,axiom,
    cnj(one_one(complex)) = one_one(complex) ).

tff(fact_13_complex__cnj__cancel__iff,axiom,
    ! [Y1: complex,X1: complex] :
      ( ( cnj(X1) = cnj(Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_14_nat__zero__less__power__iff,axiom,
    ! [Na: nat,X1: nat] :
      ( ord_less(nat,zero_zero(nat),power_power(nat,X1,Na))
    <=> ( ord_less(nat,zero_zero(nat),X1)
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_15_complex__cnj__zero,axiom,
    cnj(zero_zero(complex)) = zero_zero(complex) ).

tff(fact_16_complex__cnj__zero__iff,axiom,
    ! [Z1: complex] :
      ( ( cnj(Z1) = zero_zero(complex) )
    <=> ( Z1 = zero_zero(complex) ) ) ).

tff(fact_17_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A2: A] :
          ( ( power_power(A,A2,Na) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_18_complex__i__not__zero,axiom,
    ii != zero_zero(complex) ).

tff(fact_19_complex__cnj__cnj,axiom,
    ! [Z: complex] : ( cnj(cnj(Z)) = Z ) ).

tff(fact_20_complex__cnj__divide,axiom,
    ! [Y: complex,X: complex] : ( cnj(inverse_divide(complex,X,Y)) = inverse_divide(complex,cnj(X),cnj(Y)) ) ).

tff(fact_21_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_22_nonzero__power__divide,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [N: nat,A1: A,B1: A] :
          ( ( B1 != zero_zero(A) )
         => ( power_power(A,inverse_divide(A,A1,B1),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B1,N)) ) ) ) ).

tff(fact_23_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ord_less(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_24_zero__le__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ord_less_eq(A,zero_zero(A),power_power(A,A1,N)) ) ) ).

tff(fact_25_nat__power__less__imp__less,axiom,
    ! [N: nat,M: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,power_power(nat,I,M),power_power(nat,I,N))
       => ord_less(nat,M,N) ) ) ).

tff(fact_26_power__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ord_less_eq(A,power_power(A,A1,N),power_power(A,B1,N)) ) ) ) ).

tff(fact_27_power__strict__mono,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ( ord_less(nat,zero_zero(nat),N)
             => ord_less(A,power_power(A,A1,N),power_power(A,B1,N)) ) ) ) ) ).

tff(fact_28_power__less__imp__less__base,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [B1: A,N: nat,A1: A] :
          ( ord_less(A,power_power(A,A1,N),power_power(A,B1,N))
         => ( ord_less_eq(A,zero_zero(A),B1)
           => ord_less(A,A1,B1) ) ) ) ).

tff(fact_29_power__eq__imp__eq__base,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [B1: A,N: nat,A1: A] :
          ( ( power_power(A,A1,N) = power_power(A,B1,N) )
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ( ord_less_eq(A,zero_zero(A),B1)
             => ( ord_less(nat,zero_zero(nat),N)
               => ( A1 = B1 ) ) ) ) ) ) ).

tff(fact_30_power__le__imp__le__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less_eq(A,power_power(A,A1,M),power_power(A,A1,N))
           => ord_less_eq(nat,M,N) ) ) ) ).

tff(fact_31_power__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: nat,X1: nat,B: A] :
          ( ord_less(A,one_one(A),B)
         => ( ord_less_eq(A,power_power(A,B,X1),power_power(A,B,Y1))
          <=> ord_less_eq(nat,X1,Y1) ) ) ) ).

tff(fact_32_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,zero_zero(A),A1)
           => ( ord_less(A,A1,one_one(A))
             => ord_less(A,power_power(A,A1,N1),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_33_power__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less_eq(nat,N,N1)
         => ( ord_less_eq(A,zero_zero(A),A1)
           => ( ord_less_eq(A,A1,one_one(A))
             => ord_less_eq(A,power_power(A,A1,N1),power_power(A,A1,N)) ) ) ) ) ).

tff(fact_34_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),power_power(A,A1,N)) ) ) ) ).

tff(fact_35_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B1: A,A1: A] : ( power_power(A,inverse_divide(A,A1,B1),N) = inverse_divide(A,power_power(A,A1,N),power_power(A,B1,N)) ) ) ).

tff(fact_36_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( power_power(A,X,one_one(nat)) = X ) ) ).

tff(fact_37_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,one_one(nat)) = A1 ) ) ).

tff(fact_38_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( power_power(A,A1,N) != zero_zero(A) ) ) ) ).

tff(fact_39_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less(nat,N,N1)
         => ( ord_less(A,one_one(A),A1)
           => ord_less(A,power_power(A,A1,N),power_power(A,A1,N1)) ) ) ) ).

tff(fact_40_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat,A1: A] :
          ( ord_less(A,one_one(A),A1)
         => ( ord_less(A,power_power(A,A1,M),power_power(A,A1,N))
           => ord_less(nat,M,N) ) ) ) ).

tff(fact_41_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: nat,X1: nat,B: A] :
          ( ord_less(A,one_one(A),B)
         => ( ord_less(A,power_power(A,B,X1),power_power(A,B,Y1))
          <=> ord_less(nat,X1,Y1) ) ) ) ).

tff(fact_42_power__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A,N1: nat,N: nat] :
          ( ord_less_eq(nat,N,N1)
         => ( ord_less_eq(A,one_one(A),A1)
           => ord_less_eq(A,power_power(A,A1,N),power_power(A,A1,N1)) ) ) ) ).

tff(fact_43_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( power_power(A,zero_zero(A),N) = zero_zero(A) ) ) ) ) ).

tff(fact_44_complex__cnj__power,axiom,
    ! [N: nat,X: complex] : ( cnj(power_power(complex,X,N)) = power_power(complex,cnj(X),N) ) ).

tff(fact_45_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] :
          ( ( ( A1 = zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = zero_zero(A) ) )
          & ( ( A1 != zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ) ).

tff(fact_46_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_47_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_48_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_49_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_50_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( inverse_divide(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_51_divide__le__cancel,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,C: A,A2: A] :
          ( ord_less_eq(A,inverse_divide(A,A2,C),inverse_divide(A,B,C))
        <=> ( ( ord_less(A,zero_zero(A),C)
             => ord_less_eq(A,A2,B) )
            & ( ord_less(A,C,zero_zero(A))
             => ord_less_eq(A,B,A2) ) ) ) ) ).

tff(fact_52_divide__nonneg__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,zero_zero(A),X)
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less_eq(A,zero_zero(A),inverse_divide(A,X,Y)) ) ) ) ).

tff(fact_53_divide__nonneg__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,zero_zero(A),X)
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less_eq(A,inverse_divide(A,X,Y),zero_zero(A)) ) ) ) ).

tff(fact_54_le__0__eq,axiom,
    ! [Na: nat] :
      ( ord_less_eq(nat,Na,zero_zero(nat))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_55_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_56_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_57_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_58_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

tff(fact_59_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_60_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_61_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_62_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( ord_less(nat,M1,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M1)) )
       => ( ( ord_less(nat,Na,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M1)) ) ) ) ).

tff(fact_63_less__or__eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
        | ( M = N ) )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_64_le__neq__implies__less,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ( M != N )
       => ord_less(nat,M,N) ) ) ).

tff(fact_65_less__imp__le__nat,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less_eq(nat,M,N) ) ).

tff(fact_66_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_67_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_68_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_69_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_70_le__eq__less__or__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less_eq(nat,M1,Na)
    <=> ( ord_less(nat,M1,Na)
        | ( M1 = Na ) ) ) ).

tff(fact_71_nat__less__le,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,M1,Na)
    <=> ( ord_less_eq(nat,M1,Na)
        & ( M1 != Na ) ) ) ).

tff(fact_72_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( ord_less(nat,M1,Na)
        | ord_less(nat,Na,M1) ) ) ).

tff(fact_73_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_74_divide__1,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,A1,one_one(A)) = A1 ) ) ).

tff(fact_75_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_76_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_77_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_78_divide__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less_eq(A,C1,zero_zero(A))
           => ord_less_eq(A,inverse_divide(A,B1,C1),inverse_divide(A,A1,C1)) ) ) ) ).

tff(fact_79_divide__right__mono,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ord_less_eq(A,zero_zero(A),C1)
           => ord_less_eq(A,inverse_divide(A,A1,C1),inverse_divide(A,B1,C1)) ) ) ) ).

tff(fact_80_divide__le__0__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,A2: A] :
          ( ord_less_eq(A,inverse_divide(A,A2,B),zero_zero(A))
        <=> ( ( ord_less_eq(A,zero_zero(A),A2)
              & ord_less_eq(A,B,zero_zero(A)) )
            | ( ord_less_eq(A,A2,zero_zero(A))
              & ord_less_eq(A,zero_zero(A),B) ) ) ) ) ).

tff(fact_81_zero__le__divide__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,A2: A] :
          ( ord_less_eq(A,zero_zero(A),inverse_divide(A,A2,B))
        <=> ( ( ord_less_eq(A,zero_zero(A),A2)
              & ord_less_eq(A,zero_zero(A),B) )
            | ( ord_less_eq(A,A2,zero_zero(A))
              & ord_less_eq(A,B,zero_zero(A)) ) ) ) ) ).

tff(fact_82_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,A1: A,B1: A] :
          ( ord_less(A,B1,A1)
         => ( ord_less(A,C1,zero_zero(A))
           => ord_less(A,inverse_divide(A,A1,C1),inverse_divide(A,B1,C1)) ) ) ) ).

tff(fact_83_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [C1: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,zero_zero(A),C1)
           => ord_less(A,inverse_divide(A,A1,C1),inverse_divide(A,B1,C1)) ) ) ) ).

tff(fact_84_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,zero_zero(A))
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,zero_zero(A),inverse_divide(A,X,Y)) ) ) ) ).

tff(fact_85_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,zero_zero(A))
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,inverse_divide(A,X,Y),zero_zero(A)) ) ) ) ).

tff(fact_86_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,zero_zero(A),X)
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less(A,inverse_divide(A,X,Y),zero_zero(A)) ) ) ) ).

tff(fact_87_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,zero_zero(A),X)
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less(A,zero_zero(A),inverse_divide(A,X,Y)) ) ) ) ).

tff(fact_88_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,C: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,C),inverse_divide(A,B,C))
        <=> ( ( ord_less(A,zero_zero(A),C)
             => ord_less(A,A2,B) )
            & ( ord_less(A,C,zero_zero(A))
             => ord_less(A,B,A2) )
            & ( C != zero_zero(A) ) ) ) ) ).

tff(fact_89_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,A2: A] :
          ( ord_less(A,inverse_divide(A,A2,B),zero_zero(A))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,B,zero_zero(A)) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,zero_zero(A),B) ) ) ) ) ).

tff(fact_90_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( linord1117847801e_zero(A)
     => ! [B: A,A2: A] :
          ( ord_less(A,zero_zero(A),inverse_divide(A,A2,B))
        <=> ( ( ord_less(A,zero_zero(A),A2)
              & ord_less(A,zero_zero(A),B) )
            | ( ord_less(A,A2,zero_zero(A))
              & ord_less(A,B,zero_zero(A)) ) ) ) ) ).

tff(fact_91_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A,B: A] :
          ( ( B != zero_zero(A) )
         => ( ( inverse_divide(A,A2,B) = one_one(A) )
          <=> ( A2 = B ) ) ) ) ).

tff(fact_92_divide__self,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ).

tff(fact_93_divide__nonpos__neg,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,zero_zero(A))
         => ( ord_less(A,Y,zero_zero(A))
           => ord_less_eq(A,zero_zero(A),inverse_divide(A,X,Y)) ) ) ) ).

tff(fact_94_divide__nonpos__pos,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,zero_zero(A))
         => ( ord_less(A,zero_zero(A),Y)
           => ord_less_eq(A,inverse_divide(A,X,Y),zero_zero(A)) ) ) ) ).

tff(fact_95_frac__le,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Z: A,W: A,Y: A,X: A] :
          ( ord_less_eq(A,zero_zero(A),X)
         => ( ord_less_eq(A,X,Y)
           => ( ord_less(A,zero_zero(A),W)
             => ( ord_less_eq(A,W,Z)
               => ord_less_eq(A,inverse_divide(A,X,Z),inverse_divide(A,Y,W)) ) ) ) ) ) ).

tff(fact_96_frac__less,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Z: A,W: A,Y: A,X: A] :
          ( ord_less_eq(A,zero_zero(A),X)
         => ( ord_less(A,X,Y)
           => ( ord_less(A,zero_zero(A),W)
             => ( ord_less_eq(A,W,Z)
               => ord_less(A,inverse_divide(A,X,Z),inverse_divide(A,Y,W)) ) ) ) ) ) ).

tff(fact_97_frac__less2,axiom,
    ! [A: $tType] :
      ( linordered_field(A)
     => ! [Z: A,W: A,Y: A,X: A] :
          ( ord_less(A,zero_zero(A),X)
         => ( ord_less_eq(A,X,Y)
           => ( ord_less(A,zero_zero(A),W)
             => ( ord_less(A,W,Z)
               => ord_less(A,inverse_divide(A,X,Z),inverse_divide(A,Y,W)) ) ) ) ) ) ).

%----Arities (24)
tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    power_power(complex,fFT_Mirabelle_root(n),k) != one_one(complex) ).

%------------------------------------------------------------------------------
