%------------------------------------------------------------------------------
% File     : SWV609_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 165
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_165 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  174 (  58 unt;  40 typ;   0 def)
%            Number of atoms       :  287 (  98 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  200 (  47   ~;   9   |;  12   &)
%                                         (  22 <=>; 110  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   19 (  13   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   18 (  18 usr;   5 con; 0-5 aty)
%            Number of variables   :  266 ( 226   !;   7   ?; 266   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_Nat_OSuc,type,
    suc: fun(nat,nat) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > fun(nat,A) ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_k,type,
    k: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (97)
tff(fact_0_assms_I1_J,axiom,
    ord_less(nat,zero_zero(nat),k) ).

tff(fact_1_assms_I2_J,axiom,
    ord_less(nat,k,n) ).

tff(fact_2_root__nonzero,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) != zero_zero(complex) ) ).

tff(fact_3_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A3: A] :
          ( ( aa(nat,A,power_power(A,A3),Na) = zero_zero(A) )
        <=> ( ( A3 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_4_setsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: fun(B,bool)] : ( aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),combk(A,B,zero_zero(A))),A1) = zero_zero(A) ) ) ).

tff(fact_5_field__power__not__zero,axiom,
    ! [A: $tType] :
      ( ring_11004092258visors(A)
     => ! [N: nat,A2: A] :
          ( ( A2 != zero_zero(A) )
         => ( aa(nat,A,power_power(A,A2),N) != zero_zero(A) ) ) ) ).

tff(fact_6_setsum__commute,axiom,
    ! [B: $tType,A: $tType,C: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: fun(B,bool),B2: fun(C,bool),F: fun(B,fun(C,A))] : ( aa(fun(B,bool),A,aa(fun(B,A),fun(fun(B,bool),A),big_co1399186613setsum(B,A),aa(fun(C,bool),fun(B,A),combc(B,fun(C,bool),A,combb(fun(C,A),fun(fun(C,bool),A),B,big_co1399186613setsum(C,A),F)),B2)),A1) = aa(fun(C,bool),A,aa(fun(C,A),fun(fun(C,bool),A),big_co1399186613setsum(C,A),aa(fun(B,bool),fun(C,A),combc(C,fun(B,bool),A,combb(fun(B,A),fun(fun(B,bool),A),C,big_co1399186613setsum(B,A),combc(B,C,A,F))),A1)),B2) ) ) ).

tff(fact_7_setsum__0_H,axiom,
    ! [A: $tType,B: $tType] :
      ( comm_monoid_add(B)
     => ! [F: fun(A,B),A1: fun(A,bool)] :
          ( ! [X3: A] :
              ( member(A,X3,A1)
             => ( aa(A,B,F,X3) = zero_zero(B) ) )
         => ( aa(fun(A,bool),B,aa(fun(A,B),fun(fun(A,bool),B),big_co1399186613setsum(A,B),F),A1) = zero_zero(B) ) ) ) ).

tff(fact_8_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_9_root__unity,axiom,
    ! [N: nat] : ( aa(nat,complex,power_power(complex,fFT_Mirabelle_root(N)),N) = one_one(complex) ) ).

tff(fact_10_setsum__shift__lb__Suc0__0__upt,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [Ka: nat,F: fun(nat,A)] :
          ( ( aa(nat,A,F,zero_zero(nat)) = zero_zero(A) )
         => ( aa(fun(nat,bool),A,aa(fun(nat,A),fun(fun(nat,bool),A),big_co1399186613setsum(nat,A),F),ord_atLeastLessThan(nat,aa(nat,nat,suc,zero_zero(nat)),Ka)) = aa(fun(nat,bool),A,aa(fun(nat,A),fun(fun(nat,bool),A),big_co1399186613setsum(nat,A),F),ord_atLeastLessThan(nat,zero_zero(nat),Ka)) ) ) ) ).

tff(fact_11_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_12_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_13_char__size,axiom,
    ! [C2: char] : ( char_size(C2) = zero_zero(nat) ) ).

tff(fact_14_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( aa(nat,A,power_power(A,one_one(A)),N) = one_one(A) ) ) ).

tff(fact_15_power__Suc__0,axiom,
    ! [N: nat] : ( aa(nat,nat,power_power(nat,aa(nat,nat,suc,zero_zero(nat))),N) = aa(nat,nat,suc,zero_zero(nat)) ) ).

tff(fact_16_nat__power__eq__Suc__0__iff,axiom,
    ! [M2: nat,X2: nat] :
      ( ( aa(nat,nat,power_power(nat,X2),M2) = aa(nat,nat,suc,zero_zero(nat)) )
    <=> ( ( M2 = zero_zero(nat) )
        | ( X2 = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_17_nat__zero__less__power__iff,axiom,
    ! [Na: nat,X2: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X2),Na))
    <=> ( ord_less(nat,zero_zero(nat),X2)
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_18_power__0__Suc,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] : ( aa(nat,A,power_power(A,zero_zero(A)),aa(nat,nat,suc,N)) = zero_zero(A) ) ) ).

tff(fact_19_power__0,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [A2: A] : ( aa(nat,A,power_power(A,A2),zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_20_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X2: A] :
          ( ( one_one(A) = X2 )
        <=> ( X2 = one_one(A) ) ) ) ).

tff(fact_21_power__gt1,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ord_less(A,one_one(A),aa(nat,A,power_power(A,A2),aa(nat,nat,suc,N))) ) ) ).

tff(fact_22_power__inject__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M2: nat,A3: A] :
          ( ord_less(A,one_one(A),A3)
         => ( ( aa(nat,A,power_power(A,A3),M2) = aa(nat,A,power_power(A,A3),Na) )
          <=> ( M2 = Na ) ) ) ) ).

tff(fact_23_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Y1: nat,X2: nat,B1: A] :
          ( ord_less(A,one_one(A),B1)
         => ( ord_less(A,aa(nat,A,power_power(A,B1),X2),aa(nat,A,power_power(A,B1),Y1))
          <=> ord_less(nat,X2,Y1) ) ) ) ).

tff(fact_24_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M3: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ord_less(A,aa(nat,A,power_power(A,A2),M3),aa(nat,A,power_power(A,A2),N))
           => ord_less(nat,M3,N) ) ) ) ).

tff(fact_25_nat__power__less__imp__less,axiom,
    ! [N: nat,M3: nat,I: nat] :
      ( ord_less(nat,zero_zero(nat),I)
     => ( ord_less(nat,aa(nat,nat,power_power(nat,I),M3),aa(nat,nat,power_power(nat,I),N))
       => ord_less(nat,M3,N) ) ) ).

tff(fact_26_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A2: A,N3: nat,N: nat] :
          ( ord_less(nat,N,N3)
         => ( ord_less(A,one_one(A),A2)
           => ord_less(A,aa(nat,A,power_power(A,A2),N),aa(nat,A,power_power(A,A2),N3)) ) ) ) ).

tff(fact_27_power__Suc__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ( ord_less(A,A2,one_one(A))
           => ord_less(A,aa(nat,A,power_power(A,A2),aa(nat,nat,suc,N)),one_one(A)) ) ) ) ).

tff(fact_28_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A2: A,N3: nat,N: nat] :
          ( ord_less(nat,N,N3)
         => ( ord_less(A,zero_zero(A),A2)
           => ( ord_less(A,A2,one_one(A))
             => ord_less(A,aa(nat,A,power_power(A,A2),N3),aa(nat,A,power_power(A,A2),N)) ) ) ) ) ).

tff(fact_29_one__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,one_one(A),A2)
         => ( ord_less(nat,zero_zero(nat),N)
           => ord_less(A,one_one(A),aa(nat,A,power_power(A,A2),N)) ) ) ) ).

tff(fact_30_atLeastLessThan__inj_I2_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D: A,C1: A,B1: A,A3: A] :
          ( ( ord_atLeastLessThan(A,A3,B1) = ord_atLeastLessThan(A,C1,D) )
         => ( ord_less(A,A3,B1)
           => ( ord_less(A,C1,D)
             => ( B1 = D ) ) ) ) ) ).

tff(fact_31_atLeastLessThan__inj_I1_J,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D: A,C1: A,B1: A,A3: A] :
          ( ( ord_atLeastLessThan(A,A3,B1) = ord_atLeastLessThan(A,C1,D) )
         => ( ord_less(A,A3,B1)
           => ( ord_less(A,C1,D)
             => ( A3 = C1 ) ) ) ) ) ).

tff(fact_32_atLeastLessThan__eq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [D: A,C1: A,B1: A,A3: A] :
          ( ord_less(A,A3,B1)
         => ( ord_less(A,C1,D)
           => ( ( ord_atLeastLessThan(A,A3,B1) = ord_atLeastLessThan(A,C1,D) )
            <=> ( ( A3 = C1 )
                & ( B1 = D ) ) ) ) ) ) ).

tff(fact_33_zero__less__power,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,A2: A] :
          ( ord_less(A,zero_zero(A),A2)
         => ord_less(A,zero_zero(A),aa(nat,A,power_power(A,A2),N)) ) ) ).

tff(fact_34_setsum__shift__bounds__Suc__ivl,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [Na: nat,M2: nat,F: fun(nat,A)] : ( aa(fun(nat,bool),A,aa(fun(nat,A),fun(fun(nat,bool),A),big_co1399186613setsum(nat,A),F),ord_atLeastLessThan(nat,aa(nat,nat,suc,M2),aa(nat,nat,suc,Na))) = aa(fun(nat,bool),A,aa(fun(nat,A),fun(fun(nat,bool),A),big_co1399186613setsum(nat,A),combb(nat,A,nat,F,suc)),ord_atLeastLessThan(nat,M2,Na)) ) ) ).

tff(fact_35_power__0__left,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & semiring_0(A) )
     => ! [N: nat] :
          ( ( ( N = zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),N) = one_one(A) ) )
          & ( ( N != zero_zero(nat) )
           => ( aa(nat,A,power_power(A,zero_zero(A)),N) = zero_zero(A) ) ) ) ) ).

tff(fact_36_zero__less__Suc,axiom,
    ! [N: nat] : ord_less(nat,zero_zero(nat),aa(nat,nat,suc,N)) ).

tff(fact_37_less__Suc0,axiom,
    ! [Na: nat] :
      ( ord_less(nat,Na,aa(nat,nat,suc,zero_zero(nat)))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_38_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,aa(nat,nat,suc,N)) ).

tff(fact_39_Suc__less__eq,axiom,
    ! [Na: nat,M2: nat] :
      ( ord_less(nat,aa(nat,nat,suc,M2),aa(nat,nat,suc,Na))
    <=> ord_less(nat,M2,Na) ) ).

tff(fact_40_Suc__mono,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,M3,N)
     => ord_less(nat,aa(nat,nat,suc,M3),aa(nat,nat,suc,N)) ) ).

tff(fact_41_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_42_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_43_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_44_nat_Oinject,axiom,
    ! [Nat4: nat,Nat3: nat] :
      ( ( aa(nat,nat,suc,Nat3) = aa(nat,nat,suc,Nat4) )
    <=> ( Nat3 = Nat4 ) ) ).

tff(fact_45_One__nat__def,axiom,
    one_one(nat) = aa(nat,nat,suc,zero_zero(nat)) ).

tff(fact_46_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( aa(nat,A,power_power(A,A2),one_one(nat)) = A2 ) ) ).

tff(fact_47_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( aa(nat,nat,suc,X) = aa(nat,nat,suc,Y) )
     => ( X = Y ) ) ).

tff(fact_48_Suc__n__not__n,axiom,
    ! [N: nat] : ( aa(nat,nat,suc,N) != N ) ).

tff(fact_49_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != aa(nat,nat,suc,N) ) ).

tff(fact_50_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M2: nat] :
      ( ( ord_less(nat,M2,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
     => ( ( ( M2 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
       => ( ( ord_less(nat,Na,M2)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M2)) ) ) ) ).

tff(fact_51_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_52_less__not__refl2,axiom,
    ! [M3: nat,N: nat] :
      ( ord_less(nat,N,M3)
     => ( M3 != N ) ) ).

tff(fact_53_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_54_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_55_nat__neq__iff,axiom,
    ! [Na: nat,M2: nat] :
      ( ( M2 != Na )
    <=> ( ord_less(nat,M2,Na)
        | ord_less(nat,Na,M2) ) ) ).

tff(fact_56_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_57_Zero__not__Suc,axiom,
    ! [M3: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M3) ) ).

tff(fact_58_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != aa(nat,nat,suc,Nat2) ) ).

tff(fact_59_Suc__not__Zero,axiom,
    ! [M3: nat] : ( aa(nat,nat,suc,M3) != zero_zero(nat) ) ).

tff(fact_60_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( aa(nat,nat,suc,Nat1) != zero_zero(nat) ) ).

tff(fact_61_Zero__neq__Suc,axiom,
    ! [M3: nat] : ( zero_zero(nat) != aa(nat,nat,suc,M3) ) ).

tff(fact_62_Suc__neq__Zero,axiom,
    ! [M3: nat] : ( aa(nat,nat,suc,M3) != zero_zero(nat) ) ).

tff(fact_63_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_64_gr__implies__not0,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,M3,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_65_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_66_Suc__less__SucD,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,aa(nat,nat,suc,M3),aa(nat,nat,suc,N))
     => ord_less(nat,M3,N) ) ).

tff(fact_67_Suc__lessD,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,aa(nat,nat,suc,M3),N)
     => ord_less(nat,M3,N) ) ).

tff(fact_68_less__SucE,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,M3,aa(nat,nat,suc,N))
     => ( ~ ord_less(nat,M3,N)
       => ( M3 = N ) ) ) ).

tff(fact_69_less__trans__Suc,axiom,
    ! [K: nat,J2: nat,I: nat] :
      ( ord_less(nat,I,J2)
     => ( ord_less(nat,J2,K)
       => ord_less(nat,aa(nat,nat,suc,I),K) ) ) ).

tff(fact_70_Suc__lessI,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,M3,N)
     => ( ( aa(nat,nat,suc,M3) != N )
       => ord_less(nat,aa(nat,nat,suc,M3),N) ) ) ).

tff(fact_71_less__SucI,axiom,
    ! [N: nat,M3: nat] :
      ( ord_less(nat,M3,N)
     => ord_less(nat,M3,aa(nat,nat,suc,N)) ) ).

tff(fact_72_less__antisym,axiom,
    ! [M3: nat,N: nat] :
      ( ~ ord_less(nat,N,M3)
     => ( ord_less(nat,N,aa(nat,nat,suc,M3))
       => ( M3 = N ) ) ) ).

tff(fact_73_not__less__less__Suc__eq,axiom,
    ! [M2: nat,Na: nat] :
      ( ~ ord_less(nat,Na,M2)
     => ( ord_less(nat,Na,aa(nat,nat,suc,M2))
      <=> ( Na = M2 ) ) ) ).

tff(fact_74_less__Suc__eq,axiom,
    ! [Na: nat,M2: nat] :
      ( ord_less(nat,M2,aa(nat,nat,suc,Na))
    <=> ( ord_less(nat,M2,Na)
        | ( M2 = Na ) ) ) ).

tff(fact_75_not__less__eq,axiom,
    ! [Na: nat,M2: nat] :
      ( ~ ord_less(nat,M2,Na)
    <=> ord_less(nat,Na,aa(nat,nat,suc,M2)) ) ).

tff(fact_76_less__Suc__eq__0__disj,axiom,
    ! [Na: nat,M2: nat] :
      ( ord_less(nat,M2,aa(nat,nat,suc,Na))
    <=> ( ( M2 = zero_zero(nat) )
        | ? [J1: nat] :
            ( ( M2 = aa(nat,nat,suc,J1) )
            & ord_less(nat,J1,Na) ) ) ) ).

tff(fact_77_gr0__conv__Suc,axiom,
    ! [Na: nat] :
      ( ord_less(nat,zero_zero(nat),Na)
    <=> ? [M1: nat] : ( Na = aa(nat,nat,suc,M1) ) ) ).

tff(fact_78_gr0__implies__Suc,axiom,
    ! [N: nat] :
      ( ord_less(nat,zero_zero(nat),N)
     => ? [M: nat] : ( N = aa(nat,nat,suc,M) ) ) ).

tff(fact_79_setsum__SucD,axiom,
    ! [A: $tType,Na: nat,A1: fun(A,bool),F: fun(A,nat)] :
      ( ( aa(fun(A,bool),nat,aa(fun(A,nat),fun(fun(A,bool),nat),big_co1399186613setsum(A,nat),F),A1) = aa(nat,nat,suc,Na) )
     => ? [X3: A] :
          ( member(A,X3,A1)
          & ord_less(nat,zero_zero(nat),aa(A,nat,F,X3)) ) ) ).

tff(fact_80_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N2: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N1: nat] : ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,aa(nat,nat,suc,N1)))
         => ( ord_less(nat,Na,N2)
           => ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,N2)) ) ) ) ).

tff(fact_81_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M2: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N1: nat] : ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,aa(nat,nat,suc,N1)))
         => ( ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,M2))
          <=> ord_less(nat,Na,M2) ) ) ) ).

tff(fact_82_zero__less__power__nat__eq,axiom,
    ! [Na: nat,X2: nat] :
      ( ord_less(nat,zero_zero(nat),aa(nat,nat,power_power(nat,X2),Na))
    <=> ( ( Na = zero_zero(nat) )
        | ord_less(nat,zero_zero(nat),X2) ) ) ).

tff(fact_83_all__nat__less__eq,axiom,
    ! [P1: fun(nat,bool),Na: nat] :
      ( ! [M1: nat] :
          ( ord_less(nat,M1,Na)
         => pp(aa(nat,bool,P1,M1)) )
    <=> ! [X1: nat] :
          ( member(nat,X1,ord_atLeastLessThan(nat,zero_zero(nat),Na))
         => pp(aa(nat,bool,P1,X1)) ) ) ).

tff(fact_84_nat__lt__two__imp__zero__or__one,axiom,
    ! [X: nat] :
      ( ord_less(nat,X,aa(nat,nat,suc,aa(nat,nat,suc,zero_zero(nat))))
     => ( ( X = zero_zero(nat) )
        | ( X = aa(nat,nat,suc,zero_zero(nat)) ) ) ) ).

tff(fact_85_ex__nat__less__eq,axiom,
    ! [P1: fun(nat,bool),Na: nat] :
      ( ? [M1: nat] :
          ( ord_less(nat,M1,Na)
          & pp(aa(nat,bool,P1,M1)) )
    <=> ? [X1: nat] :
          ( member(nat,X1,ord_atLeastLessThan(nat,zero_zero(nat),Na))
          & pp(aa(nat,bool,P1,X1)) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I32_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( aa(nat,A,power_power(A,X),zero_zero(nat)) = one_one(A) ) ) ).

tff(fact_87_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_88_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_89_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_90_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X: A] : ( aa(nat,A,power_power(A,X),one_one(nat)) = X ) ) ).

tff(fact_92_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_93_lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,I,K)
     => ( ( K != aa(nat,nat,suc,I) )
       => ~ ! [J: nat] :
              ( ord_less(nat,I,J)
             => ( K != aa(nat,nat,suc,J) ) ) ) ) ).

tff(fact_94_Suc__lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,aa(nat,nat,suc,I),K)
     => ~ ! [J: nat] :
            ( ord_less(nat,I,J)
           => ( K != aa(nat,nat,suc,J) ) ) ) ).

tff(fact_95_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ? [M: nat] : ( N = aa(nat,nat,suc,M) ) ) ).

tff(fact_96_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y != aa(nat,nat,suc,Nat) ) ) ).

%----Arities (27)
tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_Complex_Ocomplex___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__0,axiom,
    semiring_0(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(fun(nat,bool),complex,aa(fun(nat,complex),fun(fun(nat,bool),complex),big_co1399186613setsum(nat,complex),power_power(complex,aa(nat,complex,power_power(complex,fFT_Mirabelle_root(n)),k))),ord_atLeastLessThan(nat,zero_zero(nat),n)) = zero_zero(complex) ).

%------------------------------------------------------------------------------
