%------------------------------------------------------------------------------
% File     : SWV605_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 152
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_152 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  207 ( 103 unt;  42 typ;   0 def)
%            Number of atoms       :  249 ( 119 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :   93 (   9   ~;   0   |;  13   &)
%                                         (  13 <=>;  58  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   14 (  11   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-2 aty)
%            Number of functors    :   17 (  17 usr;   5 con; 0-3 aty)
%            Number of variables   :  228 ( 202   !;   0   ?; 228   :)
%                                         (  26  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:05
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real1: $tType ).

%----Explicit typings (37)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocis,type,
    cis: real1 > complex ).

tff(sy_c_FFT__Mirabelle__uutasbvzez_Oroot,type,
    fFT_Mirabelle_root: nat > complex ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_RealDef_Oreal,type,
    real: 
      !>[A: $tType] : ( A > real1 ) ).

tff(sy_c_Transcendental_Ocos,type,
    cos: real1 > real1 ).

tff(sy_c_Transcendental_Opi,type,
    pi: real1 ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (96)
tff(fact_0_power2__eq__square__number__of,axiom,
    ! [B2: $tType] :
      ( ( monoid_mult(B2)
        & number(B2) )
     => ! [W1: int] : ( power_power(B2,number_number_of(B2,W1),number_number_of(nat,bit0(bit1(pls)))) = times_times(B2,number_number_of(B2,W1),number_number_of(B2,W1)) ) ) ).

tff(fact_1_FFT__Mirabelle__uutasbvzez_Oroot__def,axiom,
    ! [N: nat] : ( fFT_Mirabelle_root(N) = cis(inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,N))) ) ).

tff(fact_2_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_3_pi__half__neq__two,axiom,
    inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))) != number_number_of(real1,bit0(bit1(pls))) ).

tff(fact_4_eq__divide__2__times__iff,axiom,
    ! [Z1: real1,Y1: real1,X: real1] :
      ( ( X = inverse_divide(real1,Y1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),Z1)) )
    <=> ( times_times(real1,number_number_of(real1,bit0(bit1(pls))),X) = inverse_divide(real1,Y1,Z1) ) ) ).

tff(fact_5_real__divide__square__eq,axiom,
    ! [A2: real1,R: real1] : ( inverse_divide(real1,times_times(real1,R,A2),times_times(real1,R,R)) = inverse_divide(real1,A2,R) ) ).

tff(fact_6_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_7_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_8_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_9_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_10_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_11_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y1) )
        <=> ( X = Y1 ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit1(K1) = bit1(L) )
    <=> ( K1 = L ) ) ).

tff(fact_14_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_15_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit0(K),L1) = bit0(times_times(int,K,L1)) ) ).

tff(fact_16_rel__simps_I48_J,axiom,
    ! [L: int,K1: int] :
      ( ( bit0(K1) = bit0(L) )
    <=> ( K1 = L ) ) ).

tff(fact_17_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z) ) ) ).

tff(fact_18_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_19_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_20_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_21_one__power2,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( power_power(A,one_one(A),number_number_of(nat,bit0(bit1(pls)))) = one_one(A) ) ) ).

tff(fact_22_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_23_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_24_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A2: A] : ( power_power(A,A2,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A2,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_25_four__x__squared,axiom,
    ! [X1: real1] : ( times_times(real1,number_number_of(real1,bit0(bit0(bit1(pls)))),power_power(real1,X1,number_number_of(nat,bit0(bit1(pls))))) = power_power(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),X1),number_number_of(nat,bit0(bit1(pls)))) ) ).

tff(fact_26_fact__lemma,axiom,
    ! [N: nat] : ( times_times(real1,real(nat,N),number_number_of(real1,bit0(bit0(bit1(pls))))) = real(nat,times_times(nat,number_number_of(nat,bit0(bit0(bit1(pls)))),N)) ) ).

tff(fact_27_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( power_power(A,A2,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A2,A2),A2) ) ) ).

tff(fact_28_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W: int] :
          ( ( number_number_of(A,W) = X )
        <=> ( X = number_number_of(A,W) ) ) ) ).

tff(fact_29_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( power_power(A,A2,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A2,A2) ) ) ).

tff(fact_30_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_31_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( times_times(A,number_number_of(A,bit1(pls)),A2) = A2 ) ) ).

tff(fact_32_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( times_times(A,A2,number_number_of(A,bit1(pls))) = A2 ) ) ).

tff(fact_33_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_34_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

tff(fact_35_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X1: A] : ( inverse_divide(A,X1,number_number_of(A,bit1(pls))) = X1 ) ) ).

tff(fact_36_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A2: A] : ( inverse_divide(A,A2,number_number_of(A,bit1(pls))) = A2 ) ) ).

tff(fact_37_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X1,N),power_power(A,X1,N)) ) ) ).

tff(fact_38_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_39_real__of__nat__mult,axiom,
    ! [N: nat,M: nat] : ( real(nat,times_times(nat,M,N)) = times_times(real1,real(nat,M),real(nat,N)) ) ).

tff(fact_40_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C: A,B1: A,A2: A] : ( times_times(A,A2,inverse_divide(A,B1,C)) = inverse_divide(A,times_times(A,A2,B1),C) ) ) ).

tff(fact_41_power__one,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat] : ( power_power(A,one_one(A),N) = one_one(A) ) ) ).

tff(fact_42_DeMoivre,axiom,
    ! [N: nat,A2: real1] : ( power_power(complex,cis(A2),N) = cis(times_times(real1,real(nat,N),A2)) ) ).

tff(fact_43_power__one__over,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,A2: A] : ( inverse_divide(A,one_one(A),power_power(A,A2,N)) = power_power(A,inverse_divide(A,one_one(A),A2),N) ) ) ).

tff(fact_44_real__of__nat__1,axiom,
    real(nat,one_one(nat)) = one_one(real1) ).

tff(fact_45_real__of__nat__power,axiom,
    ! [N: nat,M: nat] : ( real(nat,power_power(nat,M,N)) = power_power(real1,real(nat,M),N) ) ).

tff(fact_46_real__of__nat__inject,axiom,
    ! [M1: nat,Na: nat] :
      ( ( real(nat,Na) = real(nat,M1) )
    <=> ( Na = M1 ) ) ).

tff(fact_47_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_48_times__numeral__code_I5_J,axiom,
    ! [W1: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W1)) = number_number_of(int,times_times(int,V,W1)) ) ).

tff(fact_49_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X1: int] : ( power_power(int,power_power(int,X1,Y),Z) = power_power(int,X1,times_times(nat,Y,Z)) ) ).

tff(fact_50_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B1: A,A2: A] : ( times_times(A,A2,B1) = times_times(A,B1,A2) ) ) ).

tff(fact_51_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_52_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_53_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_54_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_55_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_56_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_57_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_58_power__one__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( power_power(A,A2,one_one(nat)) = A2 ) ) ).

tff(fact_59_comm__semiring__1__class_Onormalizing__semiring__rules_I33_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( power_power(A,X1,one_one(nat)) = X1 ) ) ).

tff(fact_60_power__mult,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,M: nat,A2: A] : ( power_power(A,A2,times_times(nat,M,N)) = power_power(A,power_power(A,A2,M),N) ) ) ).

tff(fact_61_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X1: A] : ( power_power(A,power_power(A,X1,P),Q) = power_power(A,X1,times_times(nat,P,Q)) ) ) ).

tff(fact_62_power__real__of__nat,axiom,
    ! [N: nat,M: nat] : ( power_power(real1,real(nat,M),N) = real(nat,power_power(nat,M,N)) ) ).

tff(fact_63_comm__semiring__1__class_Onormalizing__semiring__rules_I11_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( times_times(A,one_one(A),A2) = A2 ) ) ).

tff(fact_64_comm__semiring__1__class_Onormalizing__semiring__rules_I12_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A2: A] : ( times_times(A,A2,one_one(A)) = A2 ) ) ).

tff(fact_65_power__commutes,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A2: A] : ( times_times(A,power_power(A,A2,N),A2) = times_times(A,A2,power_power(A,A2,N)) ) ) ).

tff(fact_66_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [N: nat,B1: A,A2: A] : ( power_power(A,times_times(A,A2,B1),N) = times_times(A,power_power(A,A2,N),power_power(A,B1,N)) ) ) ).

tff(fact_67_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y: A,X1: A] : ( power_power(A,times_times(A,X1,Y),Q) = times_times(A,power_power(A,X1,Q),power_power(A,Y,Q)) ) ) ).

tff(fact_68_times__divide__times__eq,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [W1: A,Z: A,Y: A,X1: A] : ( times_times(A,inverse_divide(A,X1,Y),inverse_divide(A,Z,W1)) = inverse_divide(A,times_times(A,X1,Z),times_times(A,Y,W1)) ) ) ).

tff(fact_69_divide__1,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A] : ( inverse_divide(A,A2,one_one(A)) = A2 ) ) ).

tff(fact_70_power__divide,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [N: nat,B1: A,A2: A] : ( power_power(A,inverse_divide(A,A2,B1),N) = inverse_divide(A,power_power(A,A2,N),power_power(A,B1,N)) ) ) ).

tff(fact_71_nat__1__eq__mult__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( one_one(nat) = times_times(nat,M1,Na) )
    <=> ( ( M1 = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_72_nat__mult__eq__1__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( times_times(nat,M1,Na) = one_one(nat) )
    <=> ( ( M1 = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_73_cos__2npi,axiom,
    ! [N: nat] : ( cos(times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),real(nat,N)),pi)) = one_one(real1) ) ).

tff(fact_74_cos__two__pi,axiom,
    cos(times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) = one_one(real1) ).

tff(fact_75_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B1: A,A2: A] : ( times_times(A,times_times(A,A2,B1),C) = times_times(A,A2,times_times(A,B1,C)) ) ) ).

tff(fact_76_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X: A] :
          ( ( one_one(A) = X )
        <=> ( X = one_one(A) ) ) ) ).

tff(fact_77_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( times_times(nat,times_times(nat,M,N),K) = times_times(nat,M,times_times(nat,N,K)) ) ).

tff(fact_78_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( times_times(nat,M,N) = times_times(nat,N,M) ) ).

tff(fact_79_cos__60,axiom,
    cos(inverse_divide(real1,pi,number_number_of(real1,bit1(bit1(pls))))) = inverse_divide(real1,one_one(real1),number_number_of(real1,bit0(bit1(pls)))) ).

tff(fact_80_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A2: A] : ( times_times(A,A2,one_one(A)) = A2 ) ) ).

tff(fact_81_mult__1__right,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( times_times(A,A2,one_one(A)) = A2 ) ) ).

tff(fact_82_mult__1,axiom,
    ! [A: $tType] :
      ( comm_monoid_mult(A)
     => ! [A2: A] : ( times_times(A,one_one(A),A2) = A2 ) ) ).

tff(fact_83_mult__1__left,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A2: A] : ( times_times(A,one_one(A),A2) = A2 ) ) ).

tff(fact_84_nat__mult__1__right,axiom,
    ! [N: nat] : ( times_times(nat,N,one_one(nat)) = N ) ).

tff(fact_85_nat__mult__1,axiom,
    ! [N: nat] : ( times_times(nat,one_one(nat),N) = N ) ).

tff(fact_86_cos__3over2__pi,axiom,
    cos(times_times(real1,inverse_divide(real1,number_number_of(real1,bit1(bit1(pls))),number_number_of(real1,bit0(bit1(pls)))),pi)) = zero_zero(real1) ).

tff(fact_87_cos__pi__half,axiom,
    cos(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) = zero_zero(real1) ).

tff(fact_88_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( power(A)
        & mult_zero(A)
        & no_zero_divisors(A)
        & zero_neq_one(A) )
     => ! [Na: nat,A1: A] :
          ( ( power_power(A,A1,Na) = zero_zero(A) )
        <=> ( ( A1 = zero_zero(A) )
            & ( Na != zero_zero(nat) ) ) ) ) ).

tff(fact_89_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A2: A] : ( inverse_divide(A,A2,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_90_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A] : ( inverse_divide(A,zero_zero(A),A2) = zero_zero(A) ) ) ).

tff(fact_91_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_92_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A2: A] :
          ( ( ( A2 = zero_zero(A) )
           => ( inverse_divide(A,A2,A2) = zero_zero(A) ) )
          & ( ( A2 != zero_zero(A) )
           => ( inverse_divide(A,A2,A2) = one_one(A) ) ) ) ) ).

tff(fact_93_cos__zero,axiom,
    cos(zero_zero(real1)) = one_one(real1) ).

tff(fact_94_cis__zero,axiom,
    cis(zero_zero(real1)) = one_one(complex) ).

tff(fact_95_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,B: A,A1: A] :
          ( ( A1 = inverse_divide(A,B,number_number_of(A,W)) )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( times_times(A,A1,number_number_of(A,W)) = B ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A1 = zero_zero(A) ) ) ) ) ) ).

%----Arities (66)
tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real1) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(real1) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(real1) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real1) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real1) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring,axiom,
    division_ring(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real1) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real1) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real1) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__1,axiom,
    semiring_1(real1) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real1) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real1) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real1) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real1) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real1) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ozero__neq__one,axiom,
    zero_neq_one(complex) ).

tff(arity_Complex_Ocomplex___Groups_Omonoid__mult,axiom,
    monoid_mult(complex) ).

tff(arity_Complex_Ocomplex___Rings_Osemiring__1,axiom,
    semiring_1(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Power_Opower,axiom,
    power(complex) ).

tff(arity_Complex_Ocomplex___Groups_Ozero,axiom,
    zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

tff(arity_Complex_Ocomplex___Groups_Oone,axiom,
    one(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    power_power(complex,cis(inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,n))),n) = one_one(complex) ).

%------------------------------------------------------------------------------
