%------------------------------------------------------------------------------
% File     : SWV601_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 144
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_144 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  169 (  79 unt;  36 typ;   0 def)
%            Number of atoms       :  252 ( 172 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  149 (  30   ~;   5   |;  19   &)
%                                         (  29 <=>;  66  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   16 (  13   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-2 aty)
%            Number of functors    :   19 (  19 usr;   5 con; 0-3 aty)
%            Number of variables   :  202 ( 184   !;   0   ?; 202   :)
%                                         (  18  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:57
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_Complex_Ocomplex,type,
    complex: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real1: $tType ).

%----Explicit typings (31)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Ofield__inverse__zero,type,
    field_inverse_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Fields_Odivision__ring__inverse__zero,type,
    divisi14063676e_zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Complex_Ocomplex_OComplex,type,
    complex1: ( real1 * real1 ) > complex ).

tff(sy_c_Complex_Ocomplex_Ocomplex__size,type,
    complex_size: complex > nat ).

tff(sy_c_Fields_Oinverse__class_Odivide,type,
    inverse_divide: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_RealDef_Oreal,type,
    real: 
      !>[A: $tType] : ( A > real1 ) ).

tff(sy_c_Transcendental_Ocos,type,
    cos: real1 > real1 ).

tff(sy_c_Transcendental_Opi,type,
    pi: real1 ).

tff(sy_c_Transcendental_Osin,type,
    sin: real1 > real1 ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (97)
tff(fact_0_sin__double,axiom,
    ! [X1: real1] : ( sin(times_times(real1,number_number_of(real1,bit0(bit1(pls))),X1)) = times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),sin(X1)),cos(X1)) ) ).

tff(fact_1_eq__divide__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,B1: A,A2: A] :
          ( ( A2 = inverse_divide(A,B1,number_number_of(A,W)) )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( times_times(A,A2,number_number_of(A,W)) = B1 ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_2_divide__eq__eq__number__of1,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [A2: A,W: int,B1: A] :
          ( ( inverse_divide(A,B1,number_number_of(A,W)) = A2 )
        <=> ( ( ( number_number_of(A,W) != zero_zero(A) )
             => ( B1 = times_times(A,A2,number_number_of(A,W)) ) )
            & ( ( number_number_of(A,W) = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_3_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_4_pi__half__neq__two,axiom,
    inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))) != number_number_of(real1,bit0(bit1(pls))) ).

tff(fact_5_eq__divide__2__times__iff,axiom,
    ! [Z: real1,Y: real1,X: real1] :
      ( ( X = inverse_divide(real1,Y,times_times(real1,number_number_of(real1,bit0(bit1(pls))),Z)) )
    <=> ( times_times(real1,number_number_of(real1,bit0(bit1(pls))),X) = inverse_divide(real1,Y,Z) ) ) ).

tff(fact_6_real__divide__square__eq,axiom,
    ! [A1: real1,R: real1] : ( inverse_divide(real1,times_times(real1,R,A1),times_times(real1,R,R)) = inverse_divide(real1,A1,R) ) ).

tff(fact_7_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_8_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_9_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_10_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_11_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y: int,X: int] :
          ( ( number_number_of(A,X) = number_number_of(A,Y) )
        <=> ( X = Y ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_mult__Pls,axiom,
    ! [W1: int] : ( times_times(int,pls,W1) = pls ) ).

tff(fact_15_mult__Bit0,axiom,
    ! [L: int,K: int] : ( times_times(int,bit0(K),L) = bit0(times_times(int,K,L)) ) ).

tff(fact_16_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_17_sin__zero,axiom,
    sin(zero_zero(real1)) = zero_zero(real1) ).

tff(fact_18_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z1: A,W1: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W1),Z1)) = times_times(A,number_number_of(A,times_times(int,V,W1)),Z1) ) ) ).

tff(fact_19_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W1)) = number_number_of(A,times_times(int,V,W1)) ) ) ).

tff(fact_20_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_21_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_22_sin__pi,axiom,
    sin(pi) = zero_zero(real1) ).

tff(fact_23_sin__npi,axiom,
    ! [N: nat] : ( sin(times_times(real1,real(nat,N),pi)) = zero_zero(real1) ) ).

tff(fact_24_sin__npi2,axiom,
    ! [N: nat] : ( sin(times_times(real1,pi,real(nat,N))) = zero_zero(real1) ) ).

tff(fact_25_cos__pi__half,axiom,
    cos(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) = zero_zero(real1) ).

tff(fact_26_sin__two__pi,axiom,
    sin(times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) = zero_zero(real1) ).

tff(fact_27_cos__3over2__pi,axiom,
    cos(times_times(real1,inverse_divide(real1,number_number_of(real1,bit1(bit1(pls))),number_number_of(real1,bit0(bit1(pls)))),pi)) = zero_zero(real1) ).

tff(fact_28_sin__2npi,axiom,
    ! [N: nat] : ( sin(times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),real(nat,N)),pi)) = zero_zero(real1) ) ).

tff(fact_29_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_30_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_31_pi__neq__zero,axiom,
    pi != zero_zero(real1) ).

tff(fact_32_fact__lemma,axiom,
    ! [N: nat] : ( times_times(real1,real(nat,N),number_number_of(real1,bit0(bit0(bit1(pls))))) = real(nat,times_times(nat,number_number_of(nat,bit0(bit0(bit1(pls)))),N)) ) ).

tff(fact_33_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X: A,W: int] :
          ( ( number_number_of(A,W) = X )
        <=> ( X = number_number_of(A,W) ) ) ) ).

tff(fact_34_cos__two__neq__zero,axiom,
    cos(number_number_of(real1,bit0(bit1(pls)))) != zero_zero(real1) ).

tff(fact_35_pi__half__neq__zero,axiom,
    inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls)))) != zero_zero(real1) ).

tff(fact_36_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W1: int,V: int] : ( number_number_of(A,times_times(int,V,W1)) = times_times(A,number_number_of(A,V),number_number_of(A,W1)) ) ) ).

tff(fact_37_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_38_divide__eq__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [W: int,C1: A,B1: A] :
          ( ( inverse_divide(A,B1,C1) = number_number_of(A,W) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( B1 = times_times(A,number_number_of(A,W),C1) ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_39_eq__divide__eq__number__of,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number(A) )
     => ! [C1: A,B1: A,W: int] :
          ( ( number_number_of(A,W) = inverse_divide(A,B1,C1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( times_times(A,number_number_of(A,W),C1) = B1 ) )
            & ( ( C1 = zero_zero(A) )
             => ( number_number_of(A,W) = zero_zero(A) ) ) ) ) ) ).

tff(fact_40_divide__Numeral0,axiom,
    ! [A: $tType] :
      ( ( field_inverse_zero(A)
        & number_ring(A) )
     => ! [X1: A] : ( inverse_divide(A,X1,number_number_of(A,pls)) = zero_zero(A) ) ) ).

tff(fact_41_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_42_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_43_divide__Numeral1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [X1: A] : ( inverse_divide(A,X1,number_number_of(A,bit1(pls))) = X1 ) ) ).

tff(fact_44_divide__numeral__1,axiom,
    ! [A: $tType] :
      ( ( field(A)
        & number_ring(A) )
     => ! [A1: A] : ( inverse_divide(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_45_Complex__eq__0,axiom,
    ! [B1: real1,A2: real1] :
      ( ( complex1(A2,B1) = zero_zero(complex) )
    <=> ( ( A2 = zero_zero(real1) )
        & ( B1 = zero_zero(real1) ) ) ) ).

tff(fact_46_Complex__eq__number__of,axiom,
    ! [W: int,B1: real1,A2: real1] :
      ( ( complex1(A2,B1) = number_number_of(complex,W) )
    <=> ( ( A2 = number_number_of(real1,W) )
        & ( B1 = zero_zero(real1) ) ) ) ).

tff(fact_47_real__of__nat__mult,axiom,
    ! [N: nat,M1: nat] : ( real(nat,times_times(nat,M1,N)) = times_times(real1,real(nat,M1),real(nat,N)) ) ).

tff(fact_48_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [C: A,B: A,A1: A] : ( times_times(A,A1,inverse_divide(A,B,C)) = inverse_divide(A,times_times(A,A1,B),C) ) ) ).

tff(fact_49_divide__zero,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] : ( inverse_divide(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_50_divide__zero__left,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A] : ( inverse_divide(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_51_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A2: A] :
          ( ( times_times(A,A2,B1) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_52_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_53_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_54_real__of__nat__inject,axiom,
    ! [M: nat,Na: nat] :
      ( ( real(nat,Na) = real(nat,M) )
    <=> ( Na = M ) ) ).

tff(fact_55_complex_Oinject,axiom,
    ! [Real22: real1,Real12: real1,Real21: real1,Real11: real1] :
      ( ( complex1(Real11,Real21) = complex1(Real12,Real22) )
    <=> ( ( Real11 = Real12 )
        & ( Real21 = Real22 ) ) ) ).

tff(fact_56_real__of__nat__zero__iff,axiom,
    ! [Na: nat] :
      ( ( real(nat,Na) = zero_zero(real1) )
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_57_real__of__nat__zero,axiom,
    real(nat,zero_zero(nat)) = zero_zero(real1) ).

tff(fact_58_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_59_times__numeral__code_I5_J,axiom,
    ! [W1: int,V: int] : ( times_times(int,number_number_of(int,V),number_number_of(int,W1)) = number_number_of(int,times_times(int,V,W1)) ) ).

tff(fact_60_real__mult__right__cancel,axiom,
    ! [B1: real1,A2: real1,C1: real1] :
      ( ( C1 != zero_zero(real1) )
     => ( ( times_times(real1,A2,C1) = times_times(real1,B1,C1) )
      <=> ( A2 = B1 ) ) ) ).

tff(fact_61_real__mult__left__cancel,axiom,
    ! [B1: real1,A2: real1,C1: real1] :
      ( ( C1 != zero_zero(real1) )
     => ( ( times_times(real1,C1,A2) = times_times(real1,C1,B1) )
      <=> ( A2 = B1 ) ) ) ).

tff(fact_62_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B != zero_zero(A) )
           => ( times_times(A,A1,B) != zero_zero(A) ) ) ) ) ).

tff(fact_63_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B: A,A1: A] :
          ( ( times_times(A,A1,B) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B = zero_zero(A) ) ) ) ) ).

tff(fact_64_times__divide__times__eq,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [W1: A,Z1: A,Y1: A,X1: A] : ( times_times(A,inverse_divide(A,X1,Y1),inverse_divide(A,Z1,W1)) = inverse_divide(A,times_times(A,X1,Z1),times_times(A,Y1,W1)) ) ) ).

tff(fact_65_complex__zero__def,axiom,
    zero_zero(complex) = complex1(zero_zero(real1),zero_zero(real1)) ).

tff(fact_66_eq__divide__eq,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( A2 = inverse_divide(A,B1,C1) )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( times_times(A,A2,C1) = B1 ) )
            & ( ( C1 = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_67_divide__eq__eq,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [A2: A,C1: A,B1: A] :
          ( ( inverse_divide(A,B1,C1) = A2 )
        <=> ( ( ( C1 != zero_zero(A) )
             => ( B1 = times_times(A,A2,C1) ) )
            & ( ( C1 = zero_zero(A) )
             => ( A2 = zero_zero(A) ) ) ) ) ) ).

tff(fact_68_nonzero__eq__divide__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ( C1 != zero_zero(A) )
         => ( ( A2 = inverse_divide(A,B1,C1) )
          <=> ( times_times(A,A2,C1) = B1 ) ) ) ) ).

tff(fact_69_nonzero__divide__eq__eq,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A2: A,B1: A,C1: A] :
          ( ( C1 != zero_zero(A) )
         => ( ( inverse_divide(A,B1,C1) = A2 )
          <=> ( B1 = times_times(A,A2,C1) ) ) ) ) ).

tff(fact_70_mult__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [B: A,A1: A,C: A] :
          ( ( C != zero_zero(A) )
         => ( inverse_divide(A,times_times(A,A1,C),times_times(A,B,C)) = inverse_divide(A,A1,B) ) ) ) ).

tff(fact_71_mult__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( field_inverse_zero(A)
     => ! [B: A,A1: A,C: A] :
          ( ( C != zero_zero(A) )
         => ( inverse_divide(A,times_times(A,C,A1),times_times(A,C,B)) = inverse_divide(A,A1,B) ) ) ) ).

tff(fact_72_frac__eq__eq,axiom,
    ! [A: $tType] :
      ( field(A)
     => ! [W: A,X: A,Z: A,Y: A] :
          ( ( Y != zero_zero(A) )
         => ( ( Z != zero_zero(A) )
           => ( ( inverse_divide(A,X,Y) = inverse_divide(A,W,Z) )
            <=> ( times_times(A,X,Z) = times_times(A,W,Y) ) ) ) ) ) ).

tff(fact_73_divide__eq__imp,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [A1: A,B: A,C: A] :
          ( ( C != zero_zero(A) )
         => ( ( B = times_times(A,A1,C) )
           => ( inverse_divide(A,B,C) = A1 ) ) ) ) ).

tff(fact_74_eq__divide__imp,axiom,
    ! [A: $tType] :
      ( division_ring(A)
     => ! [B: A,A1: A,C: A] :
          ( ( C != zero_zero(A) )
         => ( ( times_times(A,A1,C) = B )
           => ( A1 = inverse_divide(A,B,C) ) ) ) ) ).

tff(fact_75_complex_Osize_I1_J,axiom,
    ! [Real2: real1,Real1: real1] : ( complex_size(complex1(Real1,Real2)) = zero_zero(nat) ) ).

tff(fact_76_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_77_complex_Osize_I2_J,axiom,
    ! [Real2: real1,Real1: real1] : ( size_size(complex,complex1(Real1,Real2)) = zero_zero(nat) ) ).

tff(fact_78_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_79_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_80_mult__cancel2,axiom,
    ! [Na: nat,K1: nat,M: nat] :
      ( ( times_times(nat,M,K1) = times_times(nat,Na,K1) )
    <=> ( ( M = Na )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_81_mult__cancel1,axiom,
    ! [Na: nat,M: nat,K1: nat] :
      ( ( times_times(nat,K1,M) = times_times(nat,K1,Na) )
    <=> ( ( M = Na )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_82_mult__0,axiom,
    ! [N: nat] : ( times_times(nat,zero_zero(nat),N) = zero_zero(nat) ) ).

tff(fact_83_mult__0__right,axiom,
    ! [M1: nat] : ( times_times(nat,M1,zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_84_mult__is__0,axiom,
    ! [Na: nat,M: nat] :
      ( ( times_times(nat,M,Na) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_85_nat__mult__commute,axiom,
    ! [N: nat,M1: nat] : ( times_times(nat,M1,N) = times_times(nat,N,M1) ) ).

tff(fact_86_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M1: nat] : ( times_times(nat,times_times(nat,M1,N),K) = times_times(nat,M1,times_times(nat,N,K)) ) ).

tff(fact_87_cos__pi__eq__zero,axiom,
    ! [M1: nat] : ( cos(inverse_divide(real1,times_times(real1,pi,real(nat,suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),M1)))),number_number_of(real1,bit0(bit1(pls))))) = zero_zero(real1) ) ).

tff(fact_88_cos__2npi,axiom,
    ! [N: nat] : ( cos(times_times(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),real(nat,N)),pi)) = one_one(real1) ) ).

tff(fact_89_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_90_divide__self__if,axiom,
    ! [A: $tType] :
      ( divisi14063676e_zero(A)
     => ! [A1: A] :
          ( ( ( A1 = zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = zero_zero(A) ) )
          & ( ( A1 != zero_zero(A) )
           => ( inverse_divide(A,A1,A1) = one_one(A) ) ) ) ) ).

tff(fact_91_mult__eq__1__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( times_times(nat,M,Na) = suc(zero_zero(nat)) )
    <=> ( ( M = suc(zero_zero(nat)) )
        & ( Na = suc(zero_zero(nat)) ) ) ) ).

tff(fact_92_cos__zero,axiom,
    cos(zero_zero(real1)) = one_one(real1) ).

tff(fact_93_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_94_real__of__nat__one,axiom,
    real(nat,suc(zero_zero(nat))) = one_one(real1) ).

tff(fact_95_cos__two__pi,axiom,
    cos(times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi)) = one_one(real1) ).

tff(fact_96_sin__pi__half,axiom,
    sin(inverse_divide(real1,pi,number_number_of(real1,bit0(bit1(pls))))) = one_one(real1) ).

%----Arities (33)
tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(real1) ).

tff(arity_RealDef_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(real1) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real1) ).

tff(arity_RealDef_Oreal___Fields_Odivision__ring,axiom,
    division_ring(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real1) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real1) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real1) ).

tff(arity_RealDef_Oreal___Fields_Ofield,axiom,
    field(real1) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real1) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring__inverse__zero,axiom,
    divisi14063676e_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield__inverse__zero,axiom,
    field_inverse_zero(complex) ).

tff(arity_Complex_Ocomplex___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(complex) ).

tff(arity_Complex_Ocomplex___Fields_Odivision__ring,axiom,
    division_ring(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__semiring,axiom,
    number_semiring(complex) ).

tff(arity_Complex_Ocomplex___Rings_Omult__zero,axiom,
    mult_zero(complex) ).

tff(arity_Complex_Ocomplex___Int_Oring__char__0,axiom,
    ring_char_0(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber__ring,axiom,
    number_ring(complex) ).

tff(arity_Complex_Ocomplex___Fields_Ofield,axiom,
    field(complex) ).

tff(arity_Complex_Ocomplex___Int_Onumber,axiom,
    number(complex) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    complex1(cos(inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,n))),sin(inverse_divide(real1,times_times(real1,number_number_of(real1,bit0(bit1(pls))),pi),real(nat,n)))) != zero_zero(complex) ).

%------------------------------------------------------------------------------
