%------------------------------------------------------------------------------
% File     : SWV597_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 133
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_133 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  173 (  74 unt;  34 typ;   0 def)
%            Number of atoms       :  271 (  67 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  151 (  19   ~;   4   |;  10   &)
%                                         (  34 <=>;  84  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   3 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   11 (   8   >;   3   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   12 (  12 usr;   5 con; 0-3 aty)
%            Number of variables   :  213 ( 192   !;   0   ?; 213   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:48
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

%----Explicit typings (30)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semiring__strict,type,
    linord20386208strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__comm__semiring__strict,type,
    linord893533164strict: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Transcendental_Opi,type,
    pi: real ).

tff(sy_c_Transcendental_Osin,type,
    sin: real > real ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_x,type,
    x: real ).

%----Relevant facts (97)
tff(fact_0_pi1,axiom,
    ord_less(real,pi,x) ).

tff(fact_1__C0_C,axiom,
    ord_less(real,zero_zero(real),x) ).

tff(fact_2__096sin_A_Ix_A_N_Api_J_A_126_061_A0_096,axiom,
    sin(minus_minus(real,x,pi)) != zero_zero(real) ).

tff(fact_3_calculation_I1_J,axiom,
    ( ord_less(real,zero_zero(real),x)
   => ( ord_less(real,x,pi)
     => ( sin(x) != zero_zero(real) ) ) ) ).

tff(fact_4_pi,axiom,
    ord_less(real,x,times_times(real,number_number_of(real,bit0(bit1(pls))),pi)) ).

tff(fact_5__0960_A_060_Ax_A_N_Api_096,axiom,
    ord_less(real,zero_zero(real),minus_minus(real,x,pi)) ).

tff(fact_6_sin__zero,axiom,
    sin(zero_zero(real)) = zero_zero(real) ).

tff(fact_7__096x_A_N_Api_A_060_Api_096,axiom,
    ord_less(real,minus_minus(real,x,pi),pi) ).

tff(fact_8_sin__pi,axiom,
    sin(pi) = zero_zero(real) ).

tff(fact_9_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_10_sin__gt__zero__pi,axiom,
    ! [X: real] :
      ( ord_less(real,zero_zero(real),X)
     => ( ord_less(real,X,pi)
       => ord_less(real,zero_zero(real),sin(X)) ) ) ).

tff(fact_11_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,zero_zero(A),A1) = zero_zero(A) ) ) ).

tff(fact_12_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( times_times(A,A1,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_13_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B2: A,A2: A] :
          ( ( times_times(A,A2,B2) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B2 = zero_zero(A) ) ) ) ) ).

tff(fact_14_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,A1) = zero_zero(A) ) ) ).

tff(fact_15_sin__two__pi,axiom,
    sin(times_times(real,number_number_of(real,bit0(bit1(pls))),pi)) = zero_zero(real) ).

tff(fact_16_pi__less__4,axiom,
    ord_less(real,pi,number_number_of(real,bit0(bit0(bit1(pls))))) ).

tff(fact_17_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C: A,B1: A,A1: A] : ( times_times(A,times_times(A,A1,B1),C) = times_times(A,A1,times_times(A,B1,C)) ) ) ).

tff(fact_18_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y1: A,X: A] :
          ( ( X != Y1 )
         => ( ~ ord_less(A,X,Y1)
           => ord_less(A,Y1,X) ) ) ) ).

tff(fact_19_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B2: A,A2: A] :
          ( ( minus_minus(A,A2,B2) = minus_minus(A,C1,D) )
         => ( ( A2 = B2 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_20_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B2: A,A2: A] :
          ( ( minus_minus(A,A2,B2) = minus_minus(A,C1,D) )
         => ( ord_less(A,A2,B2)
          <=> ord_less(A,C1,D) ) ) ) ).

tff(fact_21_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
        <=> ord_less(A,minus_minus(A,A2,B2),zero_zero(A)) ) ) ).

tff(fact_22_mult__strict__left__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C: A,A1: A,B1: A] :
          ( ord_less(A,B1,A1)
         => ( ord_less(A,C,zero_zero(A))
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B1)) ) ) ) ).

tff(fact_23_mult__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [C: A,A1: A,B1: A] :
          ( ord_less(A,B1,A1)
         => ( ord_less(A,C,zero_zero(A))
           => ord_less(A,times_times(A,A1,C),times_times(A,B1,C)) ) ) ) ).

tff(fact_24_comm__mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord893533164strict(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B1)) ) ) ) ).

tff(fact_25_mult__strict__left__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,C,A1),times_times(A,C,B1)) ) ) ) ).

tff(fact_26_mult__strict__right__mono,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(A,zero_zero(A),C)
           => ord_less(A,times_times(A,A1,C),times_times(A,B1,C)) ) ) ) ).

tff(fact_27_mult__neg__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,zero_zero(A),times_times(A,A1,B1)) ) ) ) ).

tff(fact_28_mult__neg__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,zero_zero(A),B1)
           => ord_less(A,times_times(A,A1,B1),zero_zero(A)) ) ) ) ).

tff(fact_29_mult__less__cancel__left__neg,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,C1,zero_zero(A))
         => ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
          <=> ord_less(A,B2,A2) ) ) ) ).

tff(fact_30_zero__less__mult__pos2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [A1: A,B1: A] :
          ( ord_less(A,zero_zero(A),times_times(A,B1,A1))
         => ( ord_less(A,zero_zero(A),A1)
           => ord_less(A,zero_zero(A),B1) ) ) ) ).

tff(fact_31_zero__less__mult__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,zero_zero(A),times_times(A,A1,B1))
         => ( ord_less(A,zero_zero(A),A1)
           => ord_less(A,zero_zero(A),B1) ) ) ) ).

tff(fact_32_mult__pos__neg2,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,times_times(A,B1,A1),zero_zero(A)) ) ) ) ).

tff(fact_33_mult__pos__neg,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B1,zero_zero(A))
           => ord_less(A,times_times(A,A1,B1),zero_zero(A)) ) ) ) ).

tff(fact_34_mult__pos__pos,axiom,
    ! [A: $tType] :
      ( linord20386208strict(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B1)
           => ord_less(A,zero_zero(A),times_times(A,A1,B1)) ) ) ) ).

tff(fact_35_mult__less__cancel__left__pos,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,zero_zero(A),C1)
         => ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
          <=> ord_less(A,A2,B2) ) ) ) ).

tff(fact_36_mult__less__cancel__left__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,times_times(A,C1,A2),times_times(A,C1,B2))
        <=> ( ( ord_less(A,zero_zero(A),C1)
              & ord_less(A,A2,B2) )
            | ( ord_less(A,C1,zero_zero(A))
              & ord_less(A,B2,A2) ) ) ) ) ).

tff(fact_37_mult__less__cancel__right__disj,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [B2: A,C1: A,A2: A] :
          ( ord_less(A,times_times(A,A2,C1),times_times(A,B2,C1))
        <=> ( ( ord_less(A,zero_zero(A),C1)
              & ord_less(A,A2,B2) )
            | ( ord_less(A,C1,zero_zero(A))
              & ord_less(A,B2,A2) ) ) ) ) ).

tff(fact_38_not__square__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_ring(A)
     => ! [A1: A] : ~ ord_less(A,times_times(A,A1,A1),zero_zero(A)) ) ).

tff(fact_39_pi__gt__zero,axiom,
    ord_less(real,zero_zero(real),pi) ).

tff(fact_40_pi__not__less__zero,axiom,
    ~ ord_less(real,pi,zero_zero(real)) ).

tff(fact_41_sin__gt__zero,axiom,
    ! [X: real] :
      ( ord_less(real,zero_zero(real),X)
     => ( ord_less(real,X,number_number_of(real,bit0(bit1(pls))))
       => ord_less(real,zero_zero(real),sin(X)) ) ) ).

tff(fact_42_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] :
          ( ( minus_minus(A,A2,B2) = zero_zero(A) )
        <=> ( A2 = B2 ) ) ) ).

tff(fact_43_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A2: A] :
          ( ( A2 = B2 )
        <=> ( minus_minus(A,A2,B2) = zero_zero(A) ) ) ) ).

tff(fact_44_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( minus_minus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_45_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B1: A,A1: A] :
          ( ( times_times(A,A1,B1) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_46_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B1: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B1 != zero_zero(A) )
           => ( times_times(A,A1,B1) != zero_zero(A) ) ) ) ) ).

tff(fact_47_pi__neq__zero,axiom,
    pi != zero_zero(real) ).

tff(fact_48_less__special_I1_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int] :
          ( ord_less(A,zero_zero(A),number_number_of(A,Y))
        <=> ord_less(int,pls,Y) ) ) ).

tff(fact_49_less__special_I3_J,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),zero_zero(A))
        <=> ord_less(int,Xa,pls) ) ) ).

tff(fact_50_not__real__square__gt__zero,axiom,
    ! [Xa: real] :
      ( ~ ord_less(real,zero_zero(real),times_times(real,Xa,Xa))
    <=> ( Xa = zero_zero(real) ) ) ).

tff(fact_51_right__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [C: B,B1: B,V: int] : ( times_times(B,number_number_of(B,V),minus_minus(B,B1,C)) = minus_minus(B,times_times(B,number_number_of(B,V),B1),times_times(B,number_number_of(B,V),C)) ) ) ).

tff(fact_52_left__diff__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & ring(B) )
     => ! [V: int,B1: B,A1: B] : ( times_times(B,minus_minus(B,A1,B1),number_number_of(B,V)) = minus_minus(B,times_times(B,A1,number_number_of(B,V)),times_times(B,B1,number_number_of(B,V))) ) ) ).

tff(fact_53_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_54_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_55_diff__bin__simps_I3_J,axiom,
    ! [L1: int] : ( minus_minus(int,pls,bit0(L1)) = bit0(minus_minus(int,pls,L1)) ) ).

tff(fact_56_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y: int,Xa: int] :
          ( ( number_number_of(A,Xa) = number_number_of(A,Y) )
        <=> ( Xa = Y ) ) ) ).

tff(fact_57_rel__simps_I51_J,axiom,
    ! [L: int,K3: int] :
      ( ( bit1(K3) = bit1(L) )
    <=> ( K3 = L ) ) ).

tff(fact_58_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_59_rel__simps_I48_J,axiom,
    ! [L: int,K3: int] :
      ( ( bit0(K3) = bit0(L) )
    <=> ( K3 = L ) ) ).

tff(fact_60_mult__Bit0,axiom,
    ! [L1: int,K: int] : ( times_times(int,bit0(K),L1) = bit0(times_times(int,K,L1)) ) ).

tff(fact_61_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( times_times(A,number_number_of(A,V),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V,W)),Z) ) ) ).

tff(fact_62_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( times_times(A,number_number_of(A,V),number_number_of(A,W)) = number_number_of(A,times_times(int,V,W)) ) ) ).

tff(fact_63_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_64_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_65_rel__simps_I50_J,axiom,
    ! [L1: int,K: int] : ( bit1(K) != bit0(L1) ) ).

tff(fact_66_rel__simps_I49_J,axiom,
    ! [L1: int,K: int] : ( bit0(K) != bit1(L1) ) ).

tff(fact_67_rel__simps_I44_J,axiom,
    ! [K3: int] :
      ( ( bit0(K3) = pls )
    <=> ( K3 = pls ) ) ).

tff(fact_68_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_69_rel__simps_I17_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit1(K3),bit1(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_70_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_71_rel__simps_I14_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit0(K3),bit0(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_72_diff__bin__simps_I7_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit0(K),bit0(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_73_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y: int,Xa: int] :
          ( ord_less(A,number_number_of(A,Xa),number_number_of(A,Y))
        <=> ord_less(int,Xa,Y) ) ) ).

tff(fact_74_rel__simps_I12_J,axiom,
    ! [K3: int] :
      ( ord_less(int,bit1(K3),pls)
    <=> ord_less(int,K3,pls) ) ).

tff(fact_75_rel__simps_I16_J,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,bit1(K3),bit0(L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_76_rel__simps_I10_J,axiom,
    ! [K3: int] :
      ( ord_less(int,bit0(K3),pls)
    <=> ord_less(int,K3,pls) ) ).

tff(fact_77_rel__simps_I4_J,axiom,
    ! [K3: int] :
      ( ord_less(int,pls,bit0(K3))
    <=> ord_less(int,pls,K3) ) ).

tff(fact_78_diff__bin__simps_I10_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit1(L1)) = bit0(minus_minus(int,K,L1)) ) ).

tff(fact_79_diff__bin__simps_I9_J,axiom,
    ! [L1: int,K: int] : ( minus_minus(int,bit1(K),bit0(L1)) = bit1(minus_minus(int,K,L1)) ) ).

tff(fact_80_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_81_bin__less__0__simps_I1_J,axiom,
    ~ ord_less(int,pls,zero_zero(int)) ).

tff(fact_82_less__bin__lemma,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,K3,L)
    <=> ord_less(int,minus_minus(int,K3,L),zero_zero(int)) ) ).

tff(fact_83_int__distrib_I4_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( times_times(int,W,minus_minus(int,Z1,Z2)) = minus_minus(int,times_times(int,W,Z1),times_times(int,W,Z2)) ) ).

tff(fact_84_bin__less__0__simps_I3_J,axiom,
    ! [W1: int] :
      ( ord_less(int,bit0(W1),zero_zero(int))
    <=> ord_less(int,W1,zero_zero(int)) ) ).

tff(fact_85_bin__less__0__simps_I4_J,axiom,
    ! [W1: int] :
      ( ord_less(int,bit1(W1),zero_zero(int))
    <=> ord_less(int,W1,zero_zero(int)) ) ).

tff(fact_86_less__int__code_I13_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit0(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_87_less__int__code_I16_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit1(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_88_less__number__of__int__code,axiom,
    ! [L: int,K3: int] :
      ( ord_less(int,number_number_of(int,K3),number_number_of(int,L))
    <=> ord_less(int,K3,L) ) ).

tff(fact_89_int__distrib_I3_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( times_times(int,minus_minus(int,Z1,Z2),W) = minus_minus(int,times_times(int,Z1,W),times_times(int,Z2,W)) ) ).

tff(fact_90_zmult__zless__mono2,axiom,
    ! [K: int,J: int,I: int] :
      ( ord_less(int,I,J)
     => ( ord_less(int,zero_zero(int),K)
       => ord_less(int,times_times(int,K,I),times_times(int,K,J)) ) ) ).

tff(fact_91_pos2,axiom,
    ord_less(nat,zero_zero(nat),number_number_of(nat,bit0(bit1(pls)))) ).

tff(fact_92_less__int__code_I15_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_93_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [Xa: A,W1: int] :
          ( ( number_number_of(A,W1) = Xa )
        <=> ( Xa = number_number_of(A,W1) ) ) ) ).

tff(fact_94_diff__bin__simps_I1_J,axiom,
    ! [K: int] : ( minus_minus(int,K,pls) = K ) ).

tff(fact_95_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_96_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,times_times(int,V,W)) = times_times(A,number_number_of(A,V),number_number_of(A,W)) ) ) ).

%----Arities (39)
tff(arity_Int_Oint___Rings_Olinordered__comm__semiring__strict,axiom,
    linord893533164strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(int) ).

tff(arity_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(int) ).

tff(arity_Int_Oint___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Groups_Ogroup__add,axiom,
    group_add(int) ).

tff(arity_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Rings_Oring,axiom,
    ring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__comm__semiring__strict,axiom,
    linord893533164strict(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__comm__semiring__strict,axiom,
    linord893533164strict(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(real) ).

tff(arity_RealDef_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__ring,axiom,
    linordered_ring(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Groups_Ogroup__add,axiom,
    group_add(real) ).

tff(arity_RealDef_Oreal___Rings_Omult__zero,axiom,
    mult_zero(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Rings_Oring,axiom,
    ring(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    sin(x) != zero_zero(real) ).

%------------------------------------------------------------------------------
