%------------------------------------------------------------------------------
% File     : SWV593_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 123
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_123 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  157 (  40 unt;  34 typ;   0 def)
%            Number of atoms       :  269 (  62 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  168 (  22   ~;   6   |;   3   &)
%                                         (  27 <=>; 110  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   4 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   18 (  12   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   19 (  18 usr;   0 prp; 1-3 aty)
%            Number of functors    :   14 (  14 usr;   3 con; 0-4 aty)
%            Number of variables   :  222 ( 197   !;   1   ?; 222   :)
%                                         (  24  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:37
%------------------------------------------------------------------------------
%----Should-be-implicit typings (3)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_SEQ_Obanach,type,
    banach: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__field,type,
    real_normed_field: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__vector,type,
    real_normed_vector: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add__abs,type,
    ordere142940540dd_abs: 
      !>[A: $tType] : $o ).

tff(sy_cl_RealVector_Oreal__normed__algebra__1,type,
    real_n2089651433ebra_1: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Log_Olog,type,
    log: ( real * real ) > real ).

tff(sy_c_Log_Opowr,type,
    powr: ( real * real ) > real ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Transcendental_Ocos,type,
    cos: real > real ).

tff(sy_c_Transcendental_Oexp,type,
    exp: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Transcendental_Osin,type,
    sin: real > real ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_x,type,
    x: real ).

%----Relevant facts (98)
tff(fact_0__C0_C,axiom,
    ord_less(real,zero_zero(real),x) ).

tff(fact_1_cos__zero,axiom,
    cos(zero_zero(real)) = one_one(real) ).

tff(fact_2_sin__zero,axiom,
    sin(zero_zero(real)) = zero_zero(real) ).

tff(fact_3_cos__one__sin__zero,axiom,
    ! [X: real] :
      ( ( cos(X) = one_one(real) )
     => ( sin(X) = zero_zero(real) ) ) ).

tff(fact_4_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_5_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_6_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [Xa: A] :
          ( ( one_one(A) = Xa )
        <=> ( Xa = one_one(A) ) ) ) ).

tff(fact_7_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_8_sin__zero__abs__cos__one,axiom,
    ! [X: real] :
      ( ( sin(X) = zero_zero(real) )
     => ( abs_abs(real,cos(X)) = one_one(real) ) ) ).

tff(fact_9_log__one,axiom,
    ! [A1: real] : ( log(A1,one_one(real)) = zero_zero(real) ) ).

tff(fact_10_exp__zero,axiom,
    ! [A: $tType] :
      ( ( real_normed_field(A)
        & banach(A) )
     => ( exp(A,zero_zero(A)) = one_one(A) ) ) ).

tff(fact_11_exp__less__cancel__iff,axiom,
    ! [Y1: real,Xa: real] :
      ( ord_less(real,exp(real,Xa),exp(real,Y1))
    <=> ord_less(real,Xa,Y1) ) ).

tff(fact_12_exp__less__mono,axiom,
    ! [Y: real,X: real] :
      ( ord_less(real,X,Y)
     => ord_less(real,exp(real,X),exp(real,Y)) ) ).

tff(fact_13_abs__idempotent,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] : ( abs_abs(A,abs_abs(A,A1)) = abs_abs(A,A1) ) ) ).

tff(fact_14_abs__exp__cancel,axiom,
    ! [X: real] : ( abs_abs(real,exp(real,X)) = exp(real,X) ) ).

tff(fact_15_abs__eq__0,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A2: A] :
          ( ( abs_abs(A,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_16_abs__zero,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ( abs_abs(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_17_abs__one,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ( abs_abs(A,one_one(A)) = one_one(A) ) ) ).

tff(fact_18_exp__eq__one__iff,axiom,
    ! [Xa: real] :
      ( ( exp(real,Xa) = one_one(real) )
    <=> ( Xa = zero_zero(real) ) ) ).

tff(fact_19_zero__less__abs__iff,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),abs_abs(A,A2))
        <=> ( A2 != zero_zero(A) ) ) ) ).

tff(fact_20_exp__less__one__iff,axiom,
    ! [Xa: real] :
      ( ord_less(real,exp(real,Xa),one_one(real))
    <=> ord_less(real,Xa,zero_zero(real)) ) ).

tff(fact_21_one__less__exp__iff,axiom,
    ! [Xa: real] :
      ( ord_less(real,one_one(real),exp(real,Xa))
    <=> ord_less(real,zero_zero(real),Xa) ) ).

tff(fact_22_not__exp__less__zero,axiom,
    ! [X: real] : ~ ord_less(real,exp(real,X),zero_zero(real)) ).

tff(fact_23_abs__not__less__zero,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] : ~ ord_less(A,abs_abs(A,A1),zero_zero(A)) ) ).

tff(fact_24_exp__gt__zero,axiom,
    ! [X: real] : ord_less(real,zero_zero(real),exp(real,X)) ).

tff(fact_25_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_26_abs__of__pos,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( abs_abs(A,A1) = A1 ) ) ) ).

tff(fact_27_exp__less__cancel,axiom,
    ! [Y: real,X: real] :
      ( ord_less(real,exp(real,X),exp(real,Y))
     => ord_less(real,X,Y) ) ).

tff(fact_28_exp__gt__one,axiom,
    ! [X: real] :
      ( ord_less(real,zero_zero(real),X)
     => ord_less(real,one_one(real),exp(real,X)) ) ).

tff(fact_29_exp__not__eq__zero,axiom,
    ! [A: $tType] :
      ( ( real_normed_field(A)
        & banach(A) )
     => ! [X: A] : ( exp(A,X) != zero_zero(A) ) ) ).

tff(fact_30_log__less__cancel__iff,axiom,
    ! [Y1: real,Xa: real,A2: real] :
      ( ord_less(real,one_one(real),A2)
     => ( ord_less(real,zero_zero(real),Xa)
       => ( ord_less(real,zero_zero(real),Y1)
         => ( ord_less(real,log(A2,Xa),log(A2,Y1))
          <=> ord_less(real,Xa,Y1) ) ) ) ) ).

tff(fact_31_log__eq__one,axiom,
    ! [A1: real] :
      ( ord_less(real,zero_zero(real),A1)
     => ( ( A1 != one_one(real) )
       => ( log(A1,A1) = one_one(real) ) ) ) ).

tff(fact_32_zero__less__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less(A,zero_zero(A),one_one(A)) ) ).

tff(fact_33_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less(A,one_one(A),zero_zero(A)) ) ).

tff(fact_34_exp__total,axiom,
    ! [Y: real] :
      ( ord_less(real,zero_zero(real),Y)
     => ? [X2: real] : ( exp(real,X2) = Y ) ) ).

tff(fact_35_powr__log__cancel,axiom,
    ! [X: real,A1: real] :
      ( ord_less(real,zero_zero(real),A1)
     => ( ( A1 != one_one(real) )
       => ( ord_less(real,zero_zero(real),X)
         => ( powr(A1,log(A1,X)) = X ) ) ) ) ).

tff(fact_36_log__powr__cancel,axiom,
    ! [Y: real,A1: real] :
      ( ord_less(real,zero_zero(real),A1)
     => ( ( A1 != one_one(real) )
       => ( log(A1,powr(A1,Y)) = Y ) ) ) ).

tff(fact_37_log__le__cancel__iff,axiom,
    ! [Y1: real,Xa: real,A2: real] :
      ( ord_less(real,one_one(real),A2)
     => ( ord_less(real,zero_zero(real),Xa)
       => ( ord_less(real,zero_zero(real),Y1)
         => ( ord_less_eq(real,log(A2,Xa),log(A2,Y1))
          <=> ord_less_eq(real,Xa,Y1) ) ) ) ) ).

tff(fact_38_powr__one__gt__zero__iff,axiom,
    ! [Xa: real] :
      ( ( powr(Xa,one_one(real)) = Xa )
    <=> ord_less(real,zero_zero(real),Xa) ) ).

tff(fact_39_sgn__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( sgn_sgn(A,A1) = one_one(A) ) ) ) ).

tff(fact_40_sgn__1__pos,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ( sgn_sgn(A,A2) = one_one(A) )
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_41_abs__sin__le__one,axiom,
    ! [X: real] : ord_less_eq(real,abs_abs(real,sin(X)),one_one(real)) ).

tff(fact_42_abs__cos__le__one,axiom,
    ! [X: real] : ord_less_eq(real,abs_abs(real,cos(X)),one_one(real)) ).

tff(fact_43_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( sgn_sgn(A,sgn_sgn(A,A1)) = sgn_sgn(A,A1) ) ) ).

tff(fact_44_exp__inj__iff,axiom,
    ! [Y1: real,Xa: real] :
      ( ( exp(real,Xa) = exp(real,Y1) )
    <=> ( Xa = Y1 ) ) ).

tff(fact_45_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_46_exp__le__cancel__iff,axiom,
    ! [Y1: real,Xa: real] :
      ( ord_less_eq(real,exp(real,Xa),exp(real,Y1))
    <=> ord_less_eq(real,Xa,Y1) ) ).

tff(fact_47_powr__one__eq__one,axiom,
    ! [A1: real] : ( powr(one_one(real),A1) = one_one(real) ) ).

tff(fact_48_abs__le__zero__iff,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A2: A] :
          ( ord_less_eq(A,abs_abs(A,A2),zero_zero(A))
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_49_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,sgn_sgn(A,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_50_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_51_powr__zero__eq__one,axiom,
    ! [X: real] : ( powr(X,zero_zero(real)) = one_one(real) ) ).

tff(fact_52_one__le__exp__iff,axiom,
    ! [Xa: real] :
      ( ord_less_eq(real,one_one(real),exp(real,Xa))
    <=> ord_less_eq(real,zero_zero(real),Xa) ) ).

tff(fact_53_exp__le__one__iff,axiom,
    ! [Xa: real] :
      ( ord_less_eq(real,exp(real,Xa),one_one(real))
    <=> ord_less_eq(real,Xa,zero_zero(real)) ) ).

tff(fact_54_powr__ge__pzero,axiom,
    ! [Y: real,X: real] : ord_less_eq(real,zero_zero(real),powr(X,Y)) ).

tff(fact_55_powr__powr__swap,axiom,
    ! [B1: real,A1: real,X: real] : ( powr(powr(X,A1),B1) = powr(powr(X,B1),A1) ) ).

tff(fact_56_powr__mono,axiom,
    ! [X: real,B1: real,A1: real] :
      ( ord_less_eq(real,A1,B1)
     => ( ord_less_eq(real,one_one(real),X)
       => ord_less_eq(real,powr(X,A1),powr(X,B1)) ) ) ).

tff(fact_57_powr__mono2,axiom,
    ! [Y: real,X: real,A1: real] :
      ( ord_less_eq(real,zero_zero(real),A1)
     => ( ord_less(real,zero_zero(real),X)
       => ( ord_less_eq(real,X,Y)
         => ord_less_eq(real,powr(X,A1),powr(Y,A1)) ) ) ) ).

tff(fact_58_powr__le__cancel__iff,axiom,
    ! [B2: real,A2: real,Xa: real] :
      ( ord_less(real,one_one(real),Xa)
     => ( ord_less_eq(real,powr(Xa,A2),powr(Xa,B2))
      <=> ord_less_eq(real,A2,B2) ) ) ).

tff(fact_59_ge__one__powr__ge__zero,axiom,
    ! [A1: real,X: real] :
      ( ord_less_eq(real,one_one(real),X)
     => ( ord_less_eq(real,zero_zero(real),A1)
       => ord_less_eq(real,one_one(real),powr(X,A1)) ) ) ).

tff(fact_60_exp__ge__zero,axiom,
    ! [X: real] : ord_less_eq(real,zero_zero(real),exp(real,X)) ).

tff(fact_61_not__exp__le__zero,axiom,
    ! [X: real] : ~ ord_less_eq(real,exp(real,X),zero_zero(real)) ).

tff(fact_62_abs__le__D1,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [B1: A,A1: A] :
          ( ord_less_eq(A,abs_abs(A,A1),B1)
         => ord_less_eq(A,A1,B1) ) ) ).

tff(fact_63_abs__ge__self,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] : ord_less_eq(A,A1,abs_abs(A,A1)) ) ).

tff(fact_64_powr__not__zero,axiom,
    ! [A1: real,X: real] : ( powr(X,A1) != zero_zero(real) ) ).

tff(fact_65_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ( sgn_sgn(A,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_66_not__one__le__zero,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ~ ord_less_eq(A,one_one(A),zero_zero(A)) ) ).

tff(fact_67_zero__le__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ord_less_eq(A,zero_zero(A),one_one(A)) ) ).

tff(fact_68_abs__of__nonneg,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] :
          ( ord_less_eq(A,zero_zero(A),A1)
         => ( abs_abs(A,A1) = A1 ) ) ) ).

tff(fact_69_abs__ge__zero,axiom,
    ! [A: $tType] :
      ( ordere142940540dd_abs(A)
     => ! [A1: A] : ord_less_eq(A,zero_zero(A),abs_abs(A,A1)) ) ).

tff(fact_70_powr__less__mono2__neg,axiom,
    ! [Y: real,X: real,A1: real] :
      ( ord_less(real,A1,zero_zero(real))
     => ( ord_less(real,zero_zero(real),X)
       => ( ord_less(real,X,Y)
         => ord_less(real,powr(Y,A1),powr(X,A1)) ) ) ) ).

tff(fact_71_powr__less__mono2,axiom,
    ! [Y: real,X: real,A1: real] :
      ( ord_less(real,zero_zero(real),A1)
     => ( ord_less(real,zero_zero(real),X)
       => ( ord_less(real,X,Y)
         => ord_less(real,powr(X,A1),powr(Y,A1)) ) ) ) ).

tff(fact_72_powr__gt__zero,axiom,
    ! [A1: real,X: real] : ord_less(real,zero_zero(real),powr(X,A1)) ).

tff(fact_73_powr__less__cancel,axiom,
    ! [B1: real,A1: real,X: real] :
      ( ord_less(real,powr(X,A1),powr(X,B1))
     => ( ord_less(real,one_one(real),X)
       => ord_less(real,A1,B1) ) ) ).

tff(fact_74_powr__less__mono,axiom,
    ! [X: real,B1: real,A1: real] :
      ( ord_less(real,A1,B1)
     => ( ord_less(real,one_one(real),X)
       => ord_less(real,powr(X,A1),powr(X,B1)) ) ) ).

tff(fact_75_powr__less__cancel__iff,axiom,
    ! [B2: real,A2: real,Xa: real] :
      ( ord_less(real,one_one(real),Xa)
     => ( ord_less(real,powr(Xa,A2),powr(Xa,B2))
      <=> ord_less(real,A2,B2) ) ) ).

tff(fact_76_cos__le__one,axiom,
    ! [X: real] : ord_less_eq(real,cos(X),one_one(real)) ).

tff(fact_77_sin__le__one,axiom,
    ! [X: real] : ord_less_eq(real,sin(X),one_one(real)) ).

tff(fact_78_sgn__one,axiom,
    ! [A: $tType] :
      ( real_n2089651433ebra_1(A)
     => ( sgn_sgn(A,one_one(A)) = one_one(A) ) ) ).

tff(fact_79_sgn__zero,axiom,
    ! [A: $tType] :
      ( real_normed_vector(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_80_real__sgn__pos,axiom,
    ! [X: real] :
      ( ord_less(real,zero_zero(real),X)
     => ( sgn_sgn(real,X) = one_one(real) ) ) ).

tff(fact_81_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_82_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X1: A] : ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_83_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_84_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,Xa: A] :
          ( ( Xa = Y1 )
        <=> ( ord_less_eq(A,Xa,Y1)
            & ord_less_eq(A,Y1,Xa) ) ) ) ).

tff(fact_85_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_86_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_87_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Xa: A,Y1: A] :
          ( ord_less_eq(A,Y1,Xa)
         => ( ord_less_eq(A,Xa,Y1)
          <=> ( Xa = Y1 ) ) ) ) ).

tff(fact_88_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ( A1 = B1 )
         => ( ord_less_eq(A,B1,C)
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_89_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B1: A,A1: A] :
          ( ord_less_eq(A,A1,B1)
         => ( ( B1 = C )
           => ord_less_eq(A,A1,C) ) ) ) ).

tff(fact_90_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_91_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less_eq(A,X,Z) ) ) ) ).

tff(fact_92_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [Xa: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,Xa),aa(A,B,G,Xa)) ) ) ).

tff(fact_93_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_94_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_95_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,Xa: A] :
          ( ( Xa != Y1 )
        <=> ( ord_less(A,Xa,Y1)
            | ord_less(A,Y1,Xa) ) ) ) ).

tff(fact_96_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,Xa: A] :
          ( ~ ord_less(A,Xa,Y1)
        <=> ( ord_less(A,Y1,Xa)
            | ( Xa = Y1 ) ) ) ) ).

tff(fact_97_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

%----Arities (22)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__algebra__1,axiom,
    real_n2089651433ebra_1(real) ).

tff(arity_RealDef_Oreal___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__vector,axiom,
    real_normed_vector(real) ).

tff(arity_RealDef_Oreal___RealVector_Oreal__normed__field,axiom,
    real_normed_field(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__semidom,axiom,
    linordered_semidom(real) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Orderings_Opreorder,axiom,
    preorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Olinorder,axiom,
    linorder(real) ).

tff(arity_RealDef_Oreal___Orderings_Oorder,axiom,
    order(real) ).

tff(arity_RealDef_Oreal___Orderings_Oord,axiom,
    ord(real) ).

tff(arity_RealDef_Oreal___Groups_Osgn__if,axiom,
    sgn_if(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___SEQ_Obanach,axiom,
    banach(real) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ( ( sin(x) != zero_zero(real) )
    | ( cos(x) != one_one(real) ) ) ).

%------------------------------------------------------------------------------
