%------------------------------------------------------------------------------
% File     : SWV589_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 96
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_96 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  154 (  67 unt;  34 typ;   0 def)
%            Number of atoms       :  187 ( 127 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   73 (   6   ~;   3   |;   7   &)
%                                         (  16 <=>;  41  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    8 (   3 avg)
%            Maximal term depth    :   12 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   14 (  10   >;   4   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-2 aty)
%            Number of functors    :   20 (  20 usr;   5 con; 0-5 aty)
%            Number of variables   :  243 ( 213   !;   0   ?; 243   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:18
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (29)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : fun(A,fun(A,fun(A,bool))) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_f,type,
    f: fun(nat,a) ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (98)
tff(fact_0_Sum4,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [X1: fun(nat,B)] : ( aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),X1),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),number_number_of(nat,bit0(bit0(bit1(pls)))))) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(nat,B,X1,zero_zero(nat))),aa(nat,B,X1,one_one(nat)))),aa(nat,B,X1,number_number_of(nat,bit0(bit1(pls)))))),aa(nat,B,X1,number_number_of(nat,bit1(bit1(pls))))) ) ) ).

tff(fact_1_nat__1__add__1,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),one_one(nat)),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_2_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_3_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(pls)),W)) ) ) ).

tff(fact_4_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),one_one(A)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),bit1(pls))) ) ) ).

tff(fact_5_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_6_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_7_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_8_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_9_right__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [C1: B,B2: B,V: int] : ( aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V)),aa(B,B,aa(B,fun(B,B),plus_plus(B),B2),C1)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V)),B2)),aa(B,B,aa(B,fun(B,B),times_times(B),number_number_of(B,V)),C1)) ) ) ).

tff(fact_10_left__distrib__number__of,axiom,
    ! [B: $tType] :
      ( ( number(B)
        & semiring(B) )
     => ! [V: int,B2: B,A2: B] : ( aa(B,B,aa(B,fun(B,B),times_times(B),aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),B2)),number_number_of(B,V)) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),A2),number_number_of(B,V))),aa(B,B,aa(B,fun(B,B),times_times(B),B2),number_number_of(B,V))) ) ) ).

tff(fact_11_nat__mult__2__right,axiom,
    ! [Z: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Z),number_number_of(nat,bit0(bit1(pls)))) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_12_nat__mult__2,axiom,
    ! [Z: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),Z) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Z),Z) ) ).

tff(fact_13_eq__number__of,axiom,
    ! [B: $tType] :
      ( ( number_ring(B)
        & ring_char_0(B) )
     => ! [Y1: int,X1: int] :
          ( ( number_number_of(B,X1) = number_number_of(B,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_14_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_mult__Pls,axiom,
    ! [W: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),pls),W) = pls ) ).

tff(fact_16_mult__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),bit0(K)),L) = bit0(aa(int,int,aa(int,fun(int,int),times_times(int),K),L)) ) ).

tff(fact_17_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_18_double__eq__0__iff,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A3: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A3),A3) = zero_zero(B) )
        <=> ( A3 = zero_zero(B) ) ) ) ).

tff(fact_19_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,V)),aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,W)),Z)) = aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),times_times(int),V),W))),Z) ) ) ).

tff(fact_20_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),times_times(int),V),W)) ) ) ).

tff(fact_21_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_22_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_23_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_24_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_25_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_26_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_27_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_28_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit0(L)) = bit0(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_29_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,W)),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W))),Z) ) ) ).

tff(fact_30_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ) ).

tff(fact_31_mult__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),bit1(K)),L) = aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(aa(int,int,aa(int,fun(int,int),times_times(int),K),L))),L) ) ).

tff(fact_32_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(K)),bit0(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_33_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit1(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_34_odd__nonzero,axiom,
    ! [Z: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),Z)),Z) != zero_zero(int) ) ).

tff(fact_35_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_36_Bit1__def,axiom,
    ! [K: int] : ( bit1(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),K)),K) ) ).

tff(fact_37_int__distrib_I2_J,axiom,
    ! [Z2: int,Z1: int,W: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),W),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),times_times(int),W),Z1)),aa(int,int,aa(int,fun(int,int),times_times(int),W),Z2)) ) ).

tff(fact_38_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),number_number_of(int,V)),number_number_of(int,W)) = number_number_of(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ).

tff(fact_39_int__distrib_I1_J,axiom,
    ! [W: int,Z2: int,Z1: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),Z1),Z2)),W) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),times_times(int),Z1),W)),aa(int,int,aa(int,fun(int,int),times_times(int),Z2),W)) ) ).

tff(fact_40_add__Pls__right,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),K),pls) = K ) ).

tff(fact_41_add__Pls,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),pls),K) = K ) ).

tff(fact_42_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),K),K) ) ).

tff(fact_43_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_44_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_45_number__of__reorient,axiom,
    ! [B: $tType] :
      ( number(B)
     => ! [X1: B,W1: int] :
          ( ( number_number_of(B,W1) = X1 )
        <=> ( X1 = number_number_of(B,W1) ) ) ) ).

tff(fact_46_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),times_times(int),V),W)) = aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_47_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_48_sum__squares__eq__zero__iff,axiom,
    ! [B: $tType] :
      ( linord581940658strict(B)
     => ! [Y1: B,X1: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(B,B,aa(B,fun(B,B),times_times(B),X1),X1)),aa(B,B,aa(B,fun(B,B),times_times(B),Y1),Y1)) = zero_zero(B) )
        <=> ( ( X1 = zero_zero(B) )
            & ( Y1 = zero_zero(B) ) ) ) ) ).

tff(fact_49_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_50_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_51_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,pls)),A2) = A2 ) ) ).

tff(fact_52_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),number_number_of(A,pls)) = A2 ) ) ).

tff(fact_53_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_54_nat__number__of__Bit0,axiom,
    ! [W: int] : ( number_number_of(nat,bit0(W)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),number_number_of(nat,W)),number_number_of(nat,W)) ) ).

tff(fact_55_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit0(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_56_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit1(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_57_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,bit1(pls))),A2) = A2 ) ) ).

tff(fact_58_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A2),number_number_of(A,bit1(pls))) = A2 ) ) ).

tff(fact_59_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_60_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

tff(fact_61_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_62_double__number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A))),number_number_of(A,W)) = number_number_of(A,bit0(W)) ) ) ).

tff(fact_63_semiring__mult__2,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_64_mult__2,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),number_number_of(A,bit0(bit1(pls)))),Z) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_65_semiring__mult__2__right,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [Z: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_66_mult__2__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Z),number_number_of(A,bit0(bit1(pls)))) = aa(A,A,aa(A,fun(A,A),plus_plus(A),Z),Z) ) ) ).

tff(fact_67_semiring__one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_68_setsum__0,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(B)
     => ! [A1: fun(C,bool)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combk(B,C,zero_zero(B))),A1) = zero_zero(B) ) ) ).

tff(fact_69_sumr__group,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [Na: nat,K1: nat,Fa: fun(nat,B)] : ( aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),combb(fun(nat,bool),B,nat,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),Fa),combs(nat,nat,fun(nat,bool),combb(nat,fun(nat,fun(nat,bool)),nat,ord_atLeastLessThan(nat),aa(nat,fun(nat,nat),combc(nat,nat,nat,times_times(nat)),K1)),aa(nat,fun(nat,nat),combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),aa(nat,fun(nat,nat),combc(nat,nat,nat,times_times(nat)),K1))),K1)))),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),Na)) = aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),Fa),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Na),K1))) ) ) ).

tff(fact_70_sumr__offset3,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [K1: nat,Na: nat,Fa: fun(nat,B)] : ( aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),Fa),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Na),K1))) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),combb(nat,B,nat,Fa,aa(nat,fun(nat,nat),combc(nat,nat,nat,plus_plus(nat)),K1))),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),Na))),aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),Fa),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),K1))) ) ) ).

tff(fact_71_nat__mult__eq__1__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),Na) = one_one(nat) )
    <=> ( ( M1 = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_72_nat__1__eq__mult__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( one_one(nat) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),Na) )
    <=> ( ( M1 = one_one(nat) )
        & ( Na = one_one(nat) ) ) ) ).

tff(fact_73_mult__cancel2,axiom,
    ! [Na: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),Na),K1) )
    <=> ( ( M1 = Na )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_74_mult__cancel1,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),Na) )
    <=> ( ( M1 = Na )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_75_mult__is__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),Na) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        | ( Na = zero_zero(nat) ) ) ) ).

tff(fact_76_mult__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_77_nat__add__left__cancel,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_78_nat__add__right__cancel,axiom,
    ! [Na: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Na),K1) )
    <=> ( M1 = Na ) ) ).

tff(fact_79_add__is__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),Na) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_80_mult__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_81_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_82_times__numeral__code_I5_J,axiom,
    ! [W: int,V: int] : ( aa(int,int,aa(int,fun(int,int),times_times(int),number_number_of(int,V)),number_number_of(int,W)) = number_number_of(int,aa(int,int,aa(int,fun(int,int),times_times(int),V),W)) ) ).

tff(fact_83_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M) ) ).

tff(fact_84_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Z)) ) ).

tff(fact_85_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) ) ).

tff(fact_86_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),M) ) ).

tff(fact_87_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_88_setsum__commute,axiom,
    ! [C: $tType,B: $tType,D: $tType] :
      ( comm_monoid_add(B)
     => ! [A1: fun(C,bool),B1: fun(D,bool),Fa: fun(C,fun(D,B))] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(D,bool),fun(C,B),combc(C,fun(D,bool),B,combb(fun(D,B),fun(fun(D,bool),B),C,big_co1399186613setsum(D,B),Fa)),B1)),A1) = aa(fun(D,bool),B,aa(fun(D,B),fun(fun(D,bool),B),big_co1399186613setsum(D,B),aa(fun(C,bool),fun(D,B),combc(D,fun(C,bool),B,combb(fun(C,B),fun(fun(C,bool),B),D,big_co1399186613setsum(C,B),combc(C,D,B,Fa))),A1)),B1) ) ) ).

tff(fact_89_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N) = N ) ).

tff(fact_90_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_91_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_92_add__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_93_add__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_94_nat__mult__1,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),one_one(nat)),N) = N ) ).

tff(fact_95_nat__mult__1__right,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),one_one(nat)) = N ) ).

tff(fact_96_setsum__right__distrib,axiom,
    ! [B: $tType,C: $tType] :
      ( semiring_0(B)
     => ! [A1: fun(C,bool),Fa: fun(C,B),R1: B] : ( aa(B,B,aa(B,fun(B,B),times_times(B),R1),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),Fa),A1)) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combb(B,B,C,aa(B,fun(B,B),times_times(B),R1),Fa)),A1) ) ) ).

tff(fact_97_setsum__left__distrib,axiom,
    ! [B: $tType,C: $tType] :
      ( semiring_0(B)
     => ! [R1: B,A1: fun(C,bool),Fa: fun(C,B)] : ( aa(B,B,aa(B,fun(B,B),times_times(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),Fa),A1)),R1) = aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(B,fun(C,B),combc(C,B,B,combb(B,fun(B,B),C,times_times(B),Fa)),R1)),A1) ) ) ).

%----Arities (14)
tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Osemiring__0,axiom,
    semiring_0(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Rings_Osemiring,axiom,
    semiring(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(fun(nat,bool),a,aa(fun(nat,a),fun(fun(nat,bool),a),big_co1399186613setsum(nat,a),f),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))),n))) = aa(a,a,aa(a,fun(a,a),plus_plus(a),aa(fun(nat,bool),a,aa(fun(nat,a),fun(fun(nat,bool),a),big_co1399186613setsum(nat,a),combb(nat,a,nat,f,aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))))),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),n))),aa(fun(nat,bool),a,aa(fun(nat,a),fun(fun(nat,bool),a),big_co1399186613setsum(nat,a),combb(nat,a,nat,f,aa(nat,fun(nat,nat),combc(nat,nat,nat,combb(nat,fun(nat,nat),nat,plus_plus(nat),aa(nat,fun(nat,nat),times_times(nat),number_number_of(nat,bit0(bit1(pls)))))),one_one(nat)))),aa(nat,fun(nat,bool),aa(nat,fun(nat,fun(nat,bool)),ord_atLeastLessThan(nat),zero_zero(nat)),n))) ).

%----Type variables (1)
tff(tfree_0,hypothesis,
    comm_monoid_add(a) ).

%------------------------------------------------------------------------------
