%------------------------------------------------------------------------------
% File     : SWV585_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 79
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_79 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  158 (  47 unt;  31 typ;   0 def)
%            Number of atoms       :  238 (  79 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  139 (  28   ~;   2   |;   7   &)
%                                         (  28 <=>;  74  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   19 (  12   >;   7   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   14 (  14 usr;   5 con; 0-4 aty)
%            Number of variables   :  247 ( 228   !;   1   ?; 247   :)
%                                         (  18  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (26)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Lattices_Oab__semigroup__idem__mult,type,
    ab_sem1668676832m_mult: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Oiszero,type,
    iszero: 
      !>[A: $tType] : ( A > $o ) ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( ( A * nat ) > A ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_x,type,
    x: nat ).

%----Relevant facts (97)
tff(fact_0_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,suc(N)) ).

tff(fact_1_Suc__less__eq,axiom,
    ! [Na: nat,M: nat] :
      ( ord_less(nat,suc(M),suc(Na))
    <=> ord_less(nat,M,Na) ) ).

tff(fact_2_Suc__mono,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ord_less(nat,suc(M1),suc(N)) ) ).

tff(fact_3_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_4_rel__simps_I38_J,axiom,
    ! [L: int] :
      ( ( pls = bit0(L) )
    <=> ( pls = L ) ) ).

tff(fact_5_rel__simps_I44_J,axiom,
    ! [K: int] :
      ( ( bit0(K) = pls )
    <=> ( K = pls ) ) ).

tff(fact_6_rel__simps_I49_J,axiom,
    ! [L1: int,K3: int] : ( bit0(K3) != bit1(L1) ) ).

tff(fact_7_rel__simps_I50_J,axiom,
    ! [L1: int,K3: int] : ( bit1(K3) != bit0(L1) ) ).

tff(fact_8_rel__simps_I39_J,axiom,
    ! [L1: int] : ( pls != bit1(L1) ) ).

tff(fact_9_rel__simps_I46_J,axiom,
    ! [K3: int] : ( bit1(K3) != pls ) ).

tff(fact_10_arith__simps_I32_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V2: int] : ( times_times(A,number_number_of(A,V2),number_number_of(A,W)) = number_number_of(A,times_times(int,V2,W)) ) ) ).

tff(fact_11_mult__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V2: int] : ( times_times(A,number_number_of(A,V2),times_times(A,number_number_of(A,W),Z)) = times_times(A,number_number_of(A,times_times(int,V2,W)),Z) ) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X2: int] :
          ( ( number_number_of(A,X2) = number_number_of(A,Y1) )
        <=> ( X2 = Y1 ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L: int,K: int] :
      ( ( bit1(K) = bit1(L) )
    <=> ( K = L ) ) ).

tff(fact_14_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_15_rel__simps_I48_J,axiom,
    ! [L: int,K: int] :
      ( ( bit0(K) = bit0(L) )
    <=> ( K = L ) ) ).

tff(fact_16_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X2: int] :
          ( ord_less(A,number_number_of(A,X2),number_number_of(A,Y1))
        <=> ord_less(int,X2,Y1) ) ) ).

tff(fact_17_mult__Pls,axiom,
    ! [W: int] : ( times_times(int,pls,W) = pls ) ).

tff(fact_18_mult__Bit0,axiom,
    ! [L1: int,K3: int] : ( times_times(int,bit0(K3),L1) = bit0(times_times(int,K3,L1)) ) ).

tff(fact_19_times__numeral__code_I5_J,axiom,
    ! [W: int,V2: int] : ( times_times(int,number_number_of(int,V2),number_number_of(int,W)) = number_number_of(int,times_times(int,V2,W)) ) ).

tff(fact_20_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X2: A,W1: int] :
          ( ( number_number_of(A,W1) = X2 )
        <=> ( X2 = number_number_of(A,W1) ) ) ) ).

tff(fact_21_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_22_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_23_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_24_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M: nat] :
      ( ( ord_less(nat,M,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M)) )
     => ( ( ( M = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M)) )
       => ( ( ord_less(nat,Na,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M)) ) ) ) ).

tff(fact_25_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_26_less__not__refl2,axiom,
    ! [M1: nat,N: nat] :
      ( ord_less(nat,N,M1)
     => ( M1 != N ) ) ).

tff(fact_27_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_28_linorder__neqE__nat,axiom,
    ! [Y: nat,X1: nat] :
      ( ( X1 != Y )
     => ( ~ ord_less(nat,X1,Y)
       => ord_less(nat,Y,X1) ) ) ).

tff(fact_29_nat__neq__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( M != Na )
    <=> ( ord_less(nat,M,Na)
        | ord_less(nat,Na,M) ) ) ).

tff(fact_30_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_31_nat__mult__assoc,axiom,
    ! [K3: nat,N: nat,M1: nat] : ( times_times(nat,times_times(nat,M1,N),K3) = times_times(nat,M1,times_times(nat,N,K3)) ) ).

tff(fact_32_nat__mult__commute,axiom,
    ! [N: nat,M1: nat] : ( times_times(nat,M1,N) = times_times(nat,N,M1) ) ).

tff(fact_33_number__of__mult,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V2: int] : ( number_number_of(A,times_times(int,V2,W)) = times_times(A,number_number_of(A,V2),number_number_of(A,W)) ) ) ).

tff(fact_34_Suc__less__SucD,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(N))
     => ord_less(nat,M1,N) ) ).

tff(fact_35_Suc__lessD,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,suc(M1),N)
     => ord_less(nat,M1,N) ) ).

tff(fact_36_less__SucE,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N))
     => ( ~ ord_less(nat,M1,N)
       => ( M1 = N ) ) ) ).

tff(fact_37_less__trans__Suc,axiom,
    ! [K3: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ( ord_less(nat,J1,K3)
       => ord_less(nat,suc(I1),K3) ) ) ).

tff(fact_38_Suc__lessI,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ( ( suc(M1) != N )
       => ord_less(nat,suc(M1),N) ) ) ).

tff(fact_39_less__SucI,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ord_less(nat,M1,suc(N)) ) ).

tff(fact_40_less__antisym,axiom,
    ! [M1: nat,N: nat] :
      ( ~ ord_less(nat,N,M1)
     => ( ord_less(nat,N,suc(M1))
       => ( M1 = N ) ) ) ).

tff(fact_41_not__less__less__Suc__eq,axiom,
    ! [M: nat,Na: nat] :
      ( ~ ord_less(nat,Na,M)
     => ( ord_less(nat,Na,suc(M))
      <=> ( Na = M ) ) ) ).

tff(fact_42_less__Suc__eq,axiom,
    ! [Na: nat,M: nat] :
      ( ord_less(nat,M,suc(Na))
    <=> ( ord_less(nat,M,Na)
        | ( M = Na ) ) ) ).

tff(fact_43_not__less__eq,axiom,
    ! [Na: nat,M: nat] :
      ( ~ ord_less(nat,M,Na)
    <=> ord_less(nat,Na,suc(M)) ) ).

tff(fact_44_Suc__mult__cancel1,axiom,
    ! [Na: nat,M: nat,K: nat] :
      ( ( times_times(nat,suc(K),M) = times_times(nat,suc(K),Na) )
    <=> ( M = Na ) ) ).

tff(fact_45_Suc__mult__less__cancel1,axiom,
    ! [Na: nat,M: nat,K: nat] :
      ( ord_less(nat,times_times(nat,suc(K),M),times_times(nat,suc(K),Na))
    <=> ord_less(nat,M,Na) ) ).

tff(fact_46_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,number_number_of(A,bit1(pls)),A1) = A1 ) ) ).

tff(fact_47_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( times_times(A,A1,number_number_of(A,bit1(pls))) = A1 ) ) ).

tff(fact_48_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N2: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N1: nat] : ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,suc(N1)))
         => ( ord_less(nat,Na,N2)
           => ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,N2)) ) ) ) ).

tff(fact_49_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N1: nat] : ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,suc(N1)))
         => ( ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,M))
          <=> ord_less(nat,Na,M) ) ) ) ).

tff(fact_50_mult__left__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,times_times(A,A1,B)) = times_times(A,A1,B) ) ) ).

tff(fact_51_Suc__lessE,axiom,
    ! [K3: nat,I1: nat] :
      ( ord_less(nat,suc(I1),K3)
     => ~ ! [J: nat] :
            ( ord_less(nat,I1,J)
           => ( K3 != suc(J) ) ) ) ).

tff(fact_52_lessE,axiom,
    ! [K3: nat,I1: nat] :
      ( ord_less(nat,I1,K3)
     => ( ( K3 != suc(I1) )
       => ~ ! [J: nat] :
              ( ord_less(nat,I1,J)
             => ( K3 != suc(J) ) ) ) ) ).

tff(fact_53_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [I: A,Na: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(Na),I) = semiri532925092at_aux(A,Inc,Na,aa(A,A,Inc,I)) ) ) ).

tff(fact_54_not__iszero__Numeral1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ~ iszero(A,number_number_of(A,bit1(pls))) ) ).

tff(fact_55_comm__semiring__1__class_Onormalizing__semiring__rules_I37_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),N))) = times_times(A,X1,times_times(A,power_power(A,X1,N),power_power(A,X1,N))) ) ) ).

tff(fact_56_rel__simps_I17_J,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,bit1(K),bit1(L))
    <=> ord_less(int,K,L) ) ).

tff(fact_57_rel__simps_I2_J,axiom,
    ~ ord_less(int,pls,pls) ).

tff(fact_58_rel__simps_I14_J,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,bit0(K),bit0(L))
    <=> ord_less(int,K,L) ) ).

tff(fact_59_rel__simps_I12_J,axiom,
    ! [K: int] :
      ( ord_less(int,bit1(K),pls)
    <=> ord_less(int,K,pls) ) ).

tff(fact_60_rel__simps_I16_J,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,bit1(K),bit0(L))
    <=> ord_less(int,K,L) ) ).

tff(fact_61_rel__simps_I4_J,axiom,
    ! [K: int] :
      ( ord_less(int,pls,bit0(K))
    <=> ord_less(int,pls,K) ) ).

tff(fact_62_rel__simps_I10_J,axiom,
    ! [K: int] :
      ( ord_less(int,bit0(K),pls)
    <=> ord_less(int,K,pls) ) ).

tff(fact_63_iszero__number__of__Bit0,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [W1: int] :
          ( iszero(A,number_number_of(A,bit0(W1)))
        <=> iszero(A,number_number_of(A,W1)) ) ) ).

tff(fact_64_less__nat__number__of,axiom,
    ! [V1: int,V: int] :
      ( ord_less(nat,number_number_of(nat,V),number_number_of(nat,V1))
    <=> ( ( ord_less(int,V,V1)
         => ord_less(int,pls,V1) )
        & ord_less(int,V,V1) ) ) ).

tff(fact_65_power2__eq__square__number__of,axiom,
    ! [B1: $tType] :
      ( ( monoid_mult(B1)
        & number(B1) )
     => ! [W: int] : ( power_power(B1,number_number_of(B1,W),number_number_of(nat,bit0(bit1(pls)))) = times_times(B1,number_number_of(B1,W),number_number_of(B1,W)) ) ) ).

tff(fact_66_number__of__is__id,axiom,
    ! [K3: int] : ( number_number_of(int,K3) = K3 ) ).

tff(fact_67_less__number__of__int__code,axiom,
    ! [L: int,K: int] :
      ( ord_less(int,number_number_of(int,K),number_number_of(int,L))
    <=> ord_less(int,K,L) ) ).

tff(fact_68_comm__semiring__1__class_Onormalizing__semiring__rules_I30_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,Y: A,X1: A] : ( power_power(A,times_times(A,X1,Y),Q) = times_times(A,power_power(A,X1,Q),power_power(A,Y,Q)) ) ) ).

tff(fact_69_comm__semiring__1__class_Onormalizing__semiring__rules_I31_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,P: nat,X1: A] : ( power_power(A,power_power(A,X1,P),Q) = power_power(A,X1,times_times(nat,P,Q)) ) ) ).

tff(fact_70_zpower__zpower,axiom,
    ! [Z: nat,Y: nat,X1: int] : ( power_power(int,power_power(int,X1,Y),Z) = power_power(int,X1,times_times(nat,Y,Z)) ) ).

tff(fact_71_less__int__code_I16_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit1(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_72_less__int__code_I13_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit0(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_73_comm__semiring__1__class_Onormalizing__semiring__rules_I35_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( power_power(A,X1,suc(Q)) = times_times(A,X1,power_power(A,X1,Q)) ) ) ).

tff(fact_74_comm__semiring__1__class_Onormalizing__semiring__rules_I27_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( times_times(A,X1,power_power(A,X1,Q)) = power_power(A,X1,suc(Q)) ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I28_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Q: nat,X1: A] : ( times_times(A,power_power(A,X1,Q),X1) = power_power(A,X1,suc(Q)) ) ) ).

tff(fact_76_less__int__code_I15_J,axiom,
    ! [K2: int,K1: int] :
      ( ord_less(int,bit1(K1),bit0(K2))
    <=> ord_less(int,K1,K2) ) ).

tff(fact_77_power3__eq__cube,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit1(bit1(pls)))) = times_times(A,times_times(A,A1,A1),A1) ) ) ).

tff(fact_78_times_Oidem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [A1: A] : ( times_times(A,A1,A1) = A1 ) ) ).

tff(fact_79_mult__idem,axiom,
    ! [A: $tType] :
      ( ab_sem1668676832m_mult(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = X1 ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B: A,A1: A] : ( times_times(A,A1,B) = times_times(A,B,A1) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,Lx,Ry)) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( times_times(A,Lx,times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),Ry) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,Lx,times_times(A,Ly,Rx)) ) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),Rx) = times_times(A,times_times(A,Lx,Rx),Ly) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Lx,times_times(A,Ly,times_times(A,Rx,Ry))) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,Rx,times_times(A,times_times(A,Lx,Ly),Ry)) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( times_times(A,times_times(A,Lx,Ly),times_times(A,Rx,Ry)) = times_times(A,times_times(A,Lx,Rx),times_times(A,Ly,Ry)) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I29_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [X1: A] : ( times_times(A,X1,X1) = power_power(A,X1,number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_89_power2__eq__square,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [A1: A] : ( power_power(A,A1,number_number_of(nat,bit0(bit1(pls)))) = times_times(A,A1,A1) ) ) ).

tff(fact_90_iszero__number__of__Bit1,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [W: int] : ~ iszero(A,number_number_of(A,bit1(W))) ) ).

tff(fact_91_iszero__Numeral0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => iszero(A,number_number_of(A,pls)) ) ).

tff(fact_92_power__even__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls)))) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I36_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [N: nat,X1: A] : ( power_power(A,X1,times_times(nat,number_number_of(nat,bit0(bit1(pls))),N)) = times_times(A,power_power(A,X1,N),power_power(A,X1,N)) ) ) ).

tff(fact_94_power__odd__eq,axiom,
    ! [A: $tType] :
      ( monoid_mult(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),N))) = times_times(A,A1,power_power(A,power_power(A,A1,N),number_number_of(nat,bit0(bit1(pls))))) ) ) ).

tff(fact_95_power__Suc,axiom,
    ! [A: $tType] :
      ( power(A)
     => ! [N: nat,A1: A] : ( power_power(A,A1,suc(N)) = times_times(A,A1,power_power(A,A1,N)) ) ) ).

tff(fact_96_four__x__squared,axiom,
    ! [X1: real] : ( times_times(real,number_number_of(real,bit0(bit0(bit1(pls)))),power_power(real,X1,number_number_of(nat,bit0(bit1(pls))))) = power_power(real,times_times(real,number_number_of(real,bit0(bit1(pls))),X1),number_number_of(nat,bit0(bit1(pls)))) ) ).

%----Arities (25)
tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Power_Opower,axiom,
    power(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__mult,axiom,
    monoid_mult(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Power_Opower,axiom,
    power(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_RealDef_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__mult,axiom,
    monoid_mult(real) ).

tff(arity_RealDef_Oreal___Rings_Osemiring__1,axiom,
    semiring_1(real) ).

tff(arity_RealDef_Oreal___Orderings_Oorder,axiom,
    order(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Power_Opower,axiom,
    power(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    ord_less(nat,x,times_times(nat,number_number_of(nat,bit0(bit1(pls))),n)) ).

tff(conj_1,hypothesis,
    ! [X: nat] :
      ( ord_less(nat,X,n)
     => ( x != suc(times_times(nat,number_number_of(nat,bit0(bit1(pls))),X)) ) ) ).

tff(conj_2,conjecture,
    ? [X: nat] :
      ( ord_less(nat,X,n)
      & ( x = times_times(nat,number_number_of(nat,bit0(bit1(pls))),X) ) ) ).

%------------------------------------------------------------------------------
