%------------------------------------------------------------------------------
% File     : SWV581_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 66
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_66 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  149 (  28 unt;  29 typ;   0 def)
%            Number of atoms       :  289 (  61 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  194 (  25   ~;   7   |;   4   &)
%                                         (  27 <=>; 131  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   18 (  10   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   13 (  13 usr;   6 con; 0-4 aty)
%            Number of variables   :  321 ( 302   !;   0   ?; 321   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:14:13
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (25)
tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > A ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_SetInterval_Oord__class_OgreaterThanLessThan,type,
    ord_gr676655987ssThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_f,type,
    f: fun(nat,a) ).

tff(sy_v_g,type,
    g: fun(nat,a) ).

tff(sy_v_m,type,
    m: nat ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (100)
tff(fact_0_less,axiom,
    ord_less(nat,m,n) ).

tff(fact_1_g,axiom,
    ! [I: nat] :
      ( ord_less(nat,m,I)
     => ( ord_less(nat,I,n)
       => ( aa(nat,a,g,I) = aa(nat,a,f,I) ) ) ) ).

tff(fact_2_setsum__add__nat__ivl__singleton,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [Fa: fun(nat,B),Na: nat,Ma: nat] :
          ( ord_less(nat,Ma,Na)
         => ( plus_plus(B,aa(nat,B,Fa,Ma),big_co1399186613setsum(nat,B,Fa,ord_gr676655987ssThan(nat,Ma,Na))) = big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,Ma,Na)) ) ) ) ).

tff(fact_3_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C: B,B1: B,A1: B] :
          ( ( plus_plus(B,A1,B1) = plus_plus(B,A1,C) )
        <=> ( B1 = C ) ) ) ).

tff(fact_4_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C: B,A1: B,B1: B] :
          ( ( plus_plus(B,B1,A1) = plus_plus(B,C,A1) )
        <=> ( B1 = C ) ) ) ).

tff(fact_5_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A2: A] : ( plus_plus(A,A2,C1) = plus_plus(A,C1,A2) ) ) ).

tff(fact_6_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C1: A,A2: A] : ( plus_plus(A,A2,plus_plus(A,C1,D1)) = plus_plus(A,C1,plus_plus(A,A2,D1)) ) ) ).

tff(fact_7_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C1: A,A2: A] : ( plus_plus(A,A2,plus_plus(A,C1,D1)) = plus_plus(A,plus_plus(A,A2,C1),D1) ) ) ).

tff(fact_8_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B2),C1) = plus_plus(A,A2,plus_plus(A,B2,C1)) ) ) ).

tff(fact_9_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B2),C1) = plus_plus(A,A2,plus_plus(A,B2,C1)) ) ) ).

tff(fact_10_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B2),C1) = plus_plus(A,plus_plus(A,A2,C1),B2) ) ) ).

tff(fact_11_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D1: A,C1: A,B2: A,A2: A] : ( plus_plus(A,plus_plus(A,A2,B2),plus_plus(A,C1,D1)) = plus_plus(A,plus_plus(A,A2,C1),plus_plus(A,B2,D1)) ) ) ).

tff(fact_12_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_13_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( plus_plus(A,A2,B2) = plus_plus(A,A2,C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_14_add__less__cancel__left,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B1: B,A1: B,C: B] :
          ( ord_less(B,plus_plus(B,C,A1),plus_plus(B,C,B1))
        <=> ord_less(B,A1,B1) ) ) ).

tff(fact_15_add__less__cancel__right,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B1: B,C: B,A1: B] :
          ( ord_less(B,plus_plus(B,A1,C),plus_plus(B,B1,C))
        <=> ord_less(B,A1,B1) ) ) ).

tff(fact_16_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B2))
         => ord_less(A,A2,B2) ) ) ).

tff(fact_17_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B2: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B2,C1))
         => ord_less(A,A2,B2) ) ) ).

tff(fact_18_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D1: A,C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ord_less(A,C1,D1)
           => ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B2,D1)) ) ) ) ).

tff(fact_19_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B2)) ) ) ).

tff(fact_20_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B2,C1)) ) ) ).

tff(fact_21_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ( plus_plus(A,B2,A2) = plus_plus(A,C1,A2) )
         => ( B2 = C1 ) ) ) ).

tff(fact_22_nat__add__left__cancel__less,axiom,
    ! [Na: nat,Ma: nat,K1: nat] :
      ( ord_less(nat,plus_plus(nat,K1,Ma),plus_plus(nat,K1,Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_23_atLeastLessThan__inj_I2_J,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [D: B,C: B,B1: B,A1: B] :
          ( ( ord_atLeastLessThan(B,A1,B1) = ord_atLeastLessThan(B,C,D) )
         => ( ord_less(B,A1,B1)
           => ( ord_less(B,C,D)
             => ( B1 = D ) ) ) ) ) ).

tff(fact_24_atLeastLessThan__inj_I1_J,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [D: B,C: B,B1: B,A1: B] :
          ( ( ord_atLeastLessThan(B,A1,B1) = ord_atLeastLessThan(B,C,D) )
         => ( ord_less(B,A1,B1)
           => ( ord_less(B,C,D)
             => ( A1 = C ) ) ) ) ) ).

tff(fact_25_atLeastLessThan__eq__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [D: B,C: B,B1: B,A1: B] :
          ( ord_less(B,A1,B1)
         => ( ord_less(B,C,D)
           => ( ( ord_atLeastLessThan(B,A1,B1) = ord_atLeastLessThan(B,C,D) )
            <=> ( ( A1 = C )
                & ( B1 = D ) ) ) ) ) ) ).

tff(fact_26_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_27_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_28_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_29_nat__neq__iff,axiom,
    ! [Na: nat,Ma: nat] :
      ( ( Ma != Na )
    <=> ( ord_less(nat,Ma,Na)
        | ord_less(nat,Na,Ma) ) ) ).

tff(fact_30_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_31_nat__add__left__cancel,axiom,
    ! [Na: nat,Ma: nat,K1: nat] :
      ( ( plus_plus(nat,K1,Ma) = plus_plus(nat,K1,Na) )
    <=> ( Ma = Na ) ) ).

tff(fact_32_nat__add__right__cancel,axiom,
    ! [Na: nat,K1: nat,Ma: nat] :
      ( ( plus_plus(nat,Ma,K1) = plus_plus(nat,Na,K1) )
    <=> ( Ma = Na ) ) ).

tff(fact_33_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_34_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_35_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_36_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,Ma: nat] :
      ( ( ord_less(nat,Ma,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
     => ( ( ( Ma = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
       => ( ( ord_less(nat,Na,Ma)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),Ma)) ) ) ) ).

tff(fact_37_add__lessD1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K)
     => ord_less(nat,I,K) ) ).

tff(fact_38_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K: nat] :
      ( ord_less(nat,K,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_39_add__less__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K,L)
       => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,L)) ) ) ).

tff(fact_40_add__less__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,K)) ) ).

tff(fact_41_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_42_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M)) ) ).

tff(fact_43_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_44_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_45_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_46_termination__basic__simps_I2_J,axiom,
    ! [Y: nat,Z: nat,X: nat] :
      ( ord_less(nat,X,Z)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_47_termination__basic__simps_I1_J,axiom,
    ! [Z: nat,Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_48_setsum__head__upt__Suc,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [Fa: fun(nat,B),Na: nat,Ma: nat] :
          ( ord_less(nat,Ma,Na)
         => ( big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,Ma,Na)) = plus_plus(B,aa(nat,B,Fa,Ma),big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,suc(Ma),Na))) ) ) ) ).

tff(fact_49_setsum__add__nat__ivl,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [Fa: fun(nat,B),P: nat,Na: nat,Ma: nat] :
          ( ord_less_eq(nat,Ma,Na)
         => ( ord_less_eq(nat,Na,P)
           => ( plus_plus(B,big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,Ma,Na)),big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,Na,P))) = big_co1399186613setsum(nat,B,Fa,ord_atLeastLessThan(nat,Ma,P)) ) ) ) ) ).

tff(fact_50_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_51_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_52_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_53_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_54_add__le__cancel__left,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B1: B,A1: B,C: B] :
          ( ord_less_eq(B,plus_plus(B,C,A1),plus_plus(B,C,B1))
        <=> ord_less_eq(B,A1,B1) ) ) ).

tff(fact_55_add__le__cancel__right,axiom,
    ! [B: $tType] :
      ( ordere236663937imp_le(B)
     => ! [B1: B,C: B,A1: B] :
          ( ord_less_eq(B,plus_plus(B,A1,C),plus_plus(B,B1,C))
        <=> ord_less_eq(B,A1,B1) ) ) ).

tff(fact_56_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,suc(N)) ).

tff(fact_57_Suc__less__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(nat,suc(Ma),suc(Na))
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_58_Suc__mono,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,suc(M),suc(N)) ) ).

tff(fact_59_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_60_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,suc(N)) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_61_Suc__le__mono,axiom,
    ! [Ma: nat,Na: nat] :
      ( ord_less_eq(nat,suc(Na),suc(Ma))
    <=> ord_less_eq(nat,Na,Ma) ) ).

tff(fact_62_nat__add__left__cancel__le,axiom,
    ! [Na: nat,Ma: nat,K1: nat] :
      ( ord_less_eq(nat,plus_plus(nat,K1,Ma),plus_plus(nat,K1,Na))
    <=> ord_less_eq(nat,Ma,Na) ) ).

tff(fact_63_linorder__not__less,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ~ ord_less(B,X1,Y1)
        <=> ord_less_eq(B,Y1,X1) ) ) ).

tff(fact_64_linorder__not__le,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ~ ord_less_eq(B,X1,Y1)
        <=> ord_less(B,Y1,X1) ) ) ).

tff(fact_65_linorder__le__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less(A,Y,X) ) ) ).

tff(fact_66_less__eq__Suc__le,axiom,
    ! [Ma: nat,Na: nat] :
      ( ord_less(nat,Na,Ma)
    <=> ord_less_eq(nat,suc(Na),Ma) ) ).

tff(fact_67_order__less__le,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y1: B,X1: B] :
          ( ord_less(B,X1,Y1)
        <=> ( ord_less_eq(B,X1,Y1)
            & ( X1 != Y1 ) ) ) ) ).

tff(fact_68_less__le__not__le,axiom,
    ! [B: $tType] :
      ( preorder(B)
     => ! [Y1: B,X1: B] :
          ( ord_less(B,X1,Y1)
        <=> ( ord_less_eq(B,X1,Y1)
            & ~ ord_less_eq(B,Y1,X1) ) ) ) ).

tff(fact_69_order__le__less,axiom,
    ! [B: $tType] :
      ( order(B)
     => ! [Y1: B,X1: B] :
          ( ord_less_eq(B,X1,Y1)
        <=> ( ord_less(B,X1,Y1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_70_less__Suc__eq__le,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less(nat,Ma,suc(Na))
    <=> ord_less_eq(nat,Ma,Na) ) ).

tff(fact_71_Suc__le__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less_eq(nat,suc(Ma),Na)
    <=> ord_less(nat,Ma,Na) ) ).

tff(fact_72_leI,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_73_not__leE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ~ ord_less_eq(A,Y,X)
         => ord_less(A,X,Y) ) ) ).

tff(fact_74_linorder__antisym__conv1,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ~ ord_less(B,X1,Y1)
         => ( ord_less_eq(B,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_75_order__neq__le__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ( A2 != B2 )
         => ( ord_less_eq(A,A2,B2)
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_76_leD,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y: A] :
          ( ord_less_eq(A,Y,X)
         => ~ ord_less(A,X,Y) ) ) ).

tff(fact_77_order__less__imp__le,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_78_termination__basic__simps_I5_J,axiom,
    ! [Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less_eq(nat,X,Y) ) ).

tff(fact_79_le__imp__less__Suc,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ord_less(nat,M,suc(N)) ) ).

tff(fact_80_termination__basic__simps_I3_J,axiom,
    ! [Z: nat,Y: nat,X: nat] :
      ( ord_less_eq(nat,X,Y)
     => ord_less_eq(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_81_termination__basic__simps_I4_J,axiom,
    ! [Y: nat,Z: nat,X: nat] :
      ( ord_less_eq(nat,X,Z)
     => ord_less_eq(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_82_Suc__leI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less_eq(nat,suc(M),N) ) ).

tff(fact_83_linorder__antisym__conv2,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [Y1: B,X1: B] :
          ( ord_less_eq(B,X1,Y1)
         => ( ~ ord_less(B,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_84_order__le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less(A,X,Y)
            | ( X = Y ) ) ) ) ).

tff(fact_85_le__less__Suc__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less_eq(nat,Ma,Na)
     => ( ord_less(nat,Na,suc(Ma))
      <=> ( Na = Ma ) ) ) ).

tff(fact_86_order__le__neq__trans,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [B2: A,A2: A] :
          ( ord_less_eq(A,A2,B2)
         => ( ( A2 != B2 )
           => ord_less(A,A2,B2) ) ) ) ).

tff(fact_87_order__less__le__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less_eq(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_88_order__le__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_89_Suc__le__lessD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,suc(M),N)
     => ord_less(nat,M,N) ) ).

tff(fact_90_atLeastLessThan__subset__iff,axiom,
    ! [B: $tType] :
      ( linorder(B)
     => ! [D: B,C: B,B1: B,A1: B] :
          ( ord_less_eq(fun(B,bool),ord_atLeastLessThan(B,A1,B1),ord_atLeastLessThan(B,C,D))
         => ( ord_less_eq(B,B1,A1)
            | ( ord_less_eq(B,C,A1)
              & ord_less_eq(B,B1,D) ) ) ) ) ).

tff(fact_91_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_92_Suc__leD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,suc(M),N)
     => ord_less_eq(nat,M,N) ) ).

tff(fact_93_le__SucE,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,suc(N))
     => ( ~ ord_less_eq(nat,M,N)
       => ( M = suc(N) ) ) ) ).

tff(fact_94_le__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ( ord_less_eq(nat,N,M)
       => ( M = N ) ) ) ).

tff(fact_95_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_96_le__SucI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
     => ord_less_eq(nat,M,suc(N)) ) ).

tff(fact_97_eq__imp__le,axiom,
    ! [N: nat,M: nat] :
      ( ( M = N )
     => ord_less_eq(nat,M,N) ) ).

tff(fact_98_le__Suc__eq,axiom,
    ! [Na: nat,Ma: nat] :
      ( ord_less_eq(nat,Ma,suc(Na))
    <=> ( ord_less_eq(nat,Ma,Na)
        | ( Ma = suc(Na) ) ) ) ).

tff(fact_99_nat__le__linear,axiom,
    ! [N: nat,M: nat] :
      ( ord_less_eq(nat,M,N)
      | ord_less_eq(nat,N,M) ) ).

%----Class relationships (1)
tff(clar_Groups_Ocomm__monoid__add__Groups_Oab__semigroup__add,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ab_semigroup_add(A) ) ).

%----Arities (15)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    plus_plus(a,aa(nat,a,f,m),big_co1399186613setsum(nat,a,g,ord_gr676655987ssThan(nat,m,n))) = big_co1399186613setsum(nat,a,f,ord_atLeastLessThan(nat,m,n)) ).

%----Type variables (1)
tff(tfree_0,hypothesis,
    comm_monoid_add(a) ).

%------------------------------------------------------------------------------
