%------------------------------------------------------------------------------
% File     : SWV577_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Software Verification
% Problem  : Fast Fourier Transform line 44
% Version  : Especial.
% English  : Formalization of a functional implementation of the FFT algorithm
%            over the complex numbers, and its inverse. Both are shown
%            equivalent to the usual definitions of these operations through
%            Vandermonde matrices. They are also shown to be inverse to each
%            other, more precisely, that composition of the inverse and the
%            transformation yield the identity up to a scalar.

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : fft_44 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  215 ( 108 unt;  46 typ;   0 def)
%            Number of atoms       :  246 ( 123 equ)
%            Maximal formula atoms :    4 (   1 avg)
%            Number of connectives :   85 (   8   ~;   0   |;   2   &)
%                                         (  16 <=>;  59  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   3 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :   22 (  16   >;   6   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-3 aty)
%            Number of functors    :   22 (  22 usr;   4 con; 0-5 aty)
%            Number of variables   :  252 ( 215   !;   0   ?; 252   :)
%                                         (  37  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:13:57
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_t_a,type,
    a: $tType ).

tff(ty_tc_Code__Numeral_Ocode__numeral,type,
    code_code_numeral: $tType ).

tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Quickcheck__Narrowing_Ocode__int,type,
    quickcheck_code_int: $tType ).

tff(ty_tc_RealDef_Oreal,type,
    real: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Big__Operators_Ocomm__monoid__add__class_Osetsum,type,
    big_co1399186613setsum: 
      !>[B: $tType,A: $tType] : fun(fun(B,A),fun(fun(B,bool),A)) ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Code__Numeral_Ocode__numeral_Ocode__numeral__size,type,
    code_c271388182l_size: code_code_numeral > nat ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_Int_OBit0,type,
    bit0: int > int ).

tff(sy_c_Int_OBit1,type,
    bit1: int > int ).

tff(sy_c_Int_OPls,type,
    pls: int ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Int_Osucc,type,
    succ: int > int ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_SetInterval_Oord__class_OatLeastLessThan,type,
    ord_atLeastLessThan: 
      !>[A: $tType] : ( ( A * A ) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_x,type,
    x: fun(nat,a) ).

%----Relevant facts (96)
tff(fact_0_one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_1_add__special_I2_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(pls)),W)) ) ) ).

tff(fact_2_add__special_I3_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),one_one(A)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),bit1(pls))) ) ) ).

tff(fact_3_nat__numeral__1__eq__1,axiom,
    number_number_of(nat,bit1(pls)) = one_one(nat) ).

tff(fact_4_numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_5_nat__number__of__Pls,axiom,
    number_number_of(nat,pls) = zero_zero(nat) ).

tff(fact_6_number__of__Pls,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_7_semiring__one__add__one__is__two,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),one_one(A)) = number_number_of(A,bit0(bit1(pls))) ) ) ).

tff(fact_8_setsum__0,axiom,
    ! [C: $tType,B: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combk(B,C,zero_zero(B))),A3) = zero_zero(B) ) ) ).

tff(fact_9_Bit0__Pls,axiom,
    bit0(pls) = pls ).

tff(fact_10_rel__simps_I38_J,axiom,
    ! [L1: int] :
      ( ( pls = bit0(L1) )
    <=> ( pls = L1 ) ) ).

tff(fact_11_rel__simps_I44_J,axiom,
    ! [K1: int] :
      ( ( bit0(K1) = pls )
    <=> ( K1 = pls ) ) ).

tff(fact_12_eq__number__of,axiom,
    ! [B: $tType] :
      ( ( number_ring(B)
        & ring_char_0(B) )
     => ! [Y1: int,Xa: int] :
          ( ( number_number_of(B,Xa) = number_number_of(B,Y1) )
        <=> ( Xa = Y1 ) ) ) ).

tff(fact_13_rel__simps_I51_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit1(K1) = bit1(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_14_rel__simps_I48_J,axiom,
    ! [L1: int,K1: int] :
      ( ( bit0(K1) = bit0(L1) )
    <=> ( K1 = L1 ) ) ).

tff(fact_15_double__eq__0__iff,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),A2) = zero_zero(B) )
        <=> ( A2 = zero_zero(B) ) ) ) ).

tff(fact_16_rel__simps_I46_J,axiom,
    ! [K: int] : ( bit1(K) != pls ) ).

tff(fact_17_rel__simps_I39_J,axiom,
    ! [L: int] : ( pls != bit1(L) ) ).

tff(fact_18_rel__simps_I50_J,axiom,
    ! [L: int,K: int] : ( bit1(K) != bit0(L) ) ).

tff(fact_19_rel__simps_I49_J,axiom,
    ! [L: int,K: int] : ( bit0(K) != bit1(L) ) ).

tff(fact_20_add__Bit0__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit0(L)) = bit0(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_21_add__number__of__left,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [Z: A,W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,W)),Z)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W))),Z) ) ) ).

tff(fact_22_add__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) = number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ) ).

tff(fact_23_add__Bit1__Bit0,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(K)),bit0(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_24_add__Bit0__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit0(K)),bit1(L)) = bit1(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),L)) ) ).

tff(fact_25_nat__1__add__1,axiom,
    aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),one_one(nat)),one_one(nat)) = number_number_of(nat,bit0(bit1(pls))) ).

tff(fact_26_odd__nonzero,axiom,
    ! [Z: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),Z)),Z) != zero_zero(int) ) ).

tff(fact_27_zero__is__num__zero,axiom,
    zero_zero(int) = number_number_of(int,pls) ).

tff(fact_28_Bit1__def,axiom,
    ! [K: int] : ( bit1(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),aa(int,int,aa(int,fun(int,int),plus_plus(int),one_one(int)),K)),K) ) ).

tff(fact_29_plus__numeral__code_I9_J,axiom,
    ! [W: int,V: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),number_number_of(int,V)),number_number_of(int,W)) = number_number_of(int,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) ) ).

tff(fact_30_add__Pls__right,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),K),pls) = K ) ).

tff(fact_31_add__Pls,axiom,
    ! [K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),pls),K) = K ) ).

tff(fact_32_Bit0__def,axiom,
    ! [K: int] : ( bit0(K) = aa(int,int,aa(int,fun(int,int),plus_plus(int),K),K) ) ).

tff(fact_33_Pls__def,axiom,
    pls = zero_zero(int) ).

tff(fact_34_one__is__num__one,axiom,
    one_one(int) = number_number_of(int,bit1(pls)) ).

tff(fact_35_nat__number__of__Bit0,axiom,
    ! [W: int] : ( number_number_of(nat,bit0(W)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),number_number_of(nat,W)),number_number_of(nat,W)) ) ).

tff(fact_36_number__of__reorient,axiom,
    ! [B: $tType] :
      ( number(B)
     => ! [Xa: B,W1: int] :
          ( ( number_number_of(B,W1) = Xa )
        <=> ( Xa = number_number_of(B,W1) ) ) ) ).

tff(fact_37_setsum__commute,axiom,
    ! [C: $tType,B: $tType,D1: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),B3: fun(D1,bool),F: fun(C,fun(D1,B))] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),aa(fun(D1,bool),fun(C,B),combc(C,fun(D1,bool),B,combb(fun(D1,B),fun(fun(D1,bool),B),C,big_co1399186613setsum(D1,B),F)),B3)),A3) = aa(fun(D1,bool),B,aa(fun(D1,B),fun(fun(D1,bool),B),big_co1399186613setsum(D1,B),aa(fun(C,bool),fun(D1,B),combc(D1,fun(C,bool),B,combb(fun(C,B),fun(fun(C,bool),B),D1,big_co1399186613setsum(C,B),combc(C,D1,B,F))),A3)),B3) ) ) ).

tff(fact_38_number__of__add,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int,V: int] : ( number_number_of(A,aa(int,int,aa(int,fun(int,int),plus_plus(int),V),W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,V)),number_number_of(A,W)) ) ) ).

tff(fact_39_setsum__addf,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(B)
     => ! [A3: fun(C,bool),G: fun(C,B),F: fun(C,B)] : ( aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),combs(C,B,B,combb(B,fun(B,B),C,plus_plus(B),F),G)),A3) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),F),A3)),aa(fun(C,bool),B,aa(fun(C,B),fun(fun(C,bool),B),big_co1399186613setsum(C,B),G),A3)) ) ) ).

tff(fact_40_semiring__numeral__0__eq__0,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,pls) = zero_zero(A) ) ) ).

tff(fact_41_semiring__norm_I112_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( zero_zero(A) = number_number_of(A,pls) ) ) ).

tff(fact_42_add__numeral__0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),number_number_of(A,pls)),A1) = A1 ) ) ).

tff(fact_43_add__numeral__0__right,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),number_number_of(A,pls)) = A1 ) ) ).

tff(fact_44_semiring__norm_I113_J,axiom,
    zero_zero(nat) = number_number_of(nat,pls) ).

tff(fact_45_number__of__Bit0,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit0(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_46_number__of__Bit1,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [W: int] : ( number_number_of(A,bit1(W)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),one_one(A)),number_number_of(A,W))),number_number_of(A,W)) ) ) ).

tff(fact_47_semiring__numeral__1__eq__1,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ( number_number_of(A,bit1(pls)) = one_one(A) ) ) ).

tff(fact_48_semiring__norm_I110_J,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ( one_one(A) = number_number_of(A,bit1(pls)) ) ) ).

tff(fact_49_Numeral1__eq1__nat,axiom,
    one_one(nat) = number_number_of(nat,bit1(pls)) ).

tff(fact_50_double__zero__sym,axiom,
    ! [B: $tType] :
      ( linord219039673up_add(B)
     => ! [A2: B] :
          ( ( zero_zero(B) = aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),A2) )
        <=> ( A2 = zero_zero(B) ) ) ) ).

tff(fact_51_sumr__offset3,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [K1: nat,N1: nat,F: fun(nat,B)] : ( aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),F),ord_atLeastLessThan(nat,zero_zero(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K1))) = aa(B,B,aa(B,fun(B,B),plus_plus(B),aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),combb(nat,B,nat,F,aa(nat,fun(nat,nat),combc(nat,nat,nat,plus_plus(nat)),K1))),ord_atLeastLessThan(nat,zero_zero(nat),N1))),aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),F),ord_atLeastLessThan(nat,zero_zero(nat),K1))) ) ) ).

tff(fact_52_setsum__shift__bounds__nat__ivl,axiom,
    ! [B: $tType] :
      ( comm_monoid_add(B)
     => ! [N1: nat,K1: nat,M1: nat,F: fun(nat,B)] : ( aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),F),ord_atLeastLessThan(nat,aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K1))) = aa(fun(nat,bool),B,aa(fun(nat,B),fun(fun(nat,bool),B),big_co1399186613setsum(nat,B),combb(nat,B,nat,F,aa(nat,fun(nat,nat),combc(nat,nat,nat,plus_plus(nat)),K1))),ord_atLeastLessThan(nat,M1,N1)) ) ) ).

tff(fact_53_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_54_sumr__offset4,axiom,
    ! [K1: nat,N2: nat,F1: fun(nat,real)] : ( aa(fun(nat,bool),real,aa(fun(nat,real),fun(fun(nat,bool),real),big_co1399186613setsum(nat,real),F1),ord_atLeastLessThan(nat,zero_zero(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N2),K1))) = aa(real,real,aa(real,fun(real,real),plus_plus(real),aa(fun(nat,bool),real,aa(fun(nat,real),fun(fun(nat,bool),real),big_co1399186613setsum(nat,real),combb(nat,real,nat,F1,aa(nat,fun(nat,nat),combc(nat,nat,nat,plus_plus(nat)),K1))),ord_atLeastLessThan(nat,zero_zero(nat),N2))),aa(fun(nat,bool),real,aa(fun(nat,real),fun(fun(nat,bool),real),big_co1399186613setsum(nat,real),F1),ord_atLeastLessThan(nat,zero_zero(nat),K1))) ) ).

tff(fact_55_add__right__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,A2: B,B1: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),B1),A2) = aa(B,B,aa(B,fun(B,B),plus_plus(B),C2),A2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_56_add__left__cancel,axiom,
    ! [B: $tType] :
      ( cancel_semigroup_add(B)
     => ! [C2: B,B1: B,A2: B] :
          ( ( aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),B1) = aa(B,B,aa(B,fun(B,B),plus_plus(B),A2),C2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_57_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_58_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_59_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

tff(fact_60_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M) ) ).

tff(fact_61_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),Z)) ) ).

tff(fact_62_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) ) ).

tff(fact_63_zero__reorient,axiom,
    ! [B: $tType] :
      ( zero(B)
     => ! [Xa: B] :
          ( ( zero_zero(B) = Xa )
        <=> ( Xa = zero_zero(B) ) ) ) ).

tff(fact_64_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_65_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_66_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_67_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_68_one__reorient,axiom,
    ! [B: $tType] :
      ( one(B)
     => ! [Xa: B] :
          ( ( one_one(B) = Xa )
        <=> ( Xa = one_one(B) ) ) ) ).

tff(fact_69_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N) = N ) ).

tff(fact_70_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_71_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_72_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_73_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_74_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_75_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_76_setsum__0_H,axiom,
    ! [B: $tType,C: $tType] :
      ( comm_monoid_add(C)
     => ! [F: fun(B,C),A3: fun(B,bool)] :
          ( ! [X: B] :
              ( member(B,X,A3)
             => ( aa(B,C,F,X) = zero_zero(C) ) )
         => ( aa(fun(B,bool),C,aa(fun(B,C),fun(fun(B,bool),C),big_co1399186613setsum(B,C),F),A3) = zero_zero(C) ) ) ) ).

tff(fact_77_one__code__numeral__code,axiom,
    one_one(code_code_numeral) = number_number_of(code_code_numeral,bit1(pls)) ).

tff(fact_78_one__code__int__code,axiom,
    one_one(quickcheck_code_int) = number_number_of(quickcheck_code_int,bit1(pls)) ).

tff(fact_79_zero__code__numeral__code,axiom,
    zero_zero(code_code_numeral) = number_number_of(code_code_numeral,pls) ).

tff(fact_80_zero__code__int__code,axiom,
    zero_zero(quickcheck_code_int) = number_number_of(quickcheck_code_int,pls) ).

tff(fact_81_code__numeral_Osize_I1_J,axiom,
    code_c271388182l_size(zero_zero(code_code_numeral)) = zero_zero(nat) ).

tff(fact_82_zero__neq__one,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( zero_zero(A) != one_one(A) ) ) ).

tff(fact_83_one__neq__zero,axiom,
    ! [A: $tType] :
      ( zero_neq_one(A)
     => ( one_one(A) != zero_zero(A) ) ) ).

tff(fact_84_code__numeral_Osize_I3_J,axiom,
    size_size(code_code_numeral,zero_zero(code_code_numeral)) = zero_zero(nat) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),D)) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),B2) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_89_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),D) ) ) ).

tff(fact_90_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),D)) ) ) ).

tff(fact_91_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) ) ) ).

tff(fact_92_add__0__iff,axiom,
    ! [B: $tType] :
      ( semiri456707255roduct(B)
     => ! [A2: B,B1: B] :
          ( ( B1 = aa(B,B,aa(B,fun(B,B),plus_plus(B),B1),A2) )
        <=> ( A2 = zero_zero(B) ) ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_94_add__Bit1__Bit1,axiom,
    ! [L: int,K: int] : ( aa(int,int,aa(int,fun(int,int),plus_plus(int),bit1(K)),bit1(L)) = bit0(aa(int,int,aa(int,fun(int,int),plus_plus(int),K),succ(L))) ) ).

tff(fact_95_add__2__eq__Suc,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),number_number_of(nat,bit0(bit1(pls)))),N) = suc(suc(N)) ) ).

%----Class relationships (3)
tff(clar_Groups_Ocomm__monoid__add__Groups_Oab__semigroup__add,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ab_semigroup_add(A) ) ).

tff(clar_Groups_Ocomm__monoid__add__Groups_Omonoid__add,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => monoid_add(A) ) ).

tff(clar_Groups_Ocomm__monoid__add__Groups_Ozero,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => zero(A) ) ).

%----Arities (62)
tff(arity_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(int) ).

tff(arity_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(int) ).

tff(arity_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(int) ).

tff(arity_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(int) ).

tff(arity_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one(int) ).

tff(arity_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Int_Oint___Groups_Oone,axiom,
    one(int) ).

tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_RealDef_Oreal___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(real) ).

tff(arity_RealDef_Oreal___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(real) ).

tff(arity_RealDef_Oreal___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(real) ).

tff(arity_RealDef_Oreal___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__semiring,axiom,
    number_semiring(real) ).

tff(arity_RealDef_Oreal___Rings_Ozero__neq__one,axiom,
    zero_neq_one(real) ).

tff(arity_RealDef_Oreal___Groups_Omonoid__add,axiom,
    monoid_add(real) ).

tff(arity_RealDef_Oreal___Int_Oring__char__0,axiom,
    ring_char_0(real) ).

tff(arity_RealDef_Oreal___Int_Onumber__ring,axiom,
    number_ring(real) ).

tff(arity_RealDef_Oreal___Groups_Ozero,axiom,
    zero(real) ).

tff(arity_RealDef_Oreal___Int_Onumber,axiom,
    number(real) ).

tff(arity_RealDef_Oreal___Groups_Oone,axiom,
    one(real) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Rings_Ozero__neq__one,axiom,
    zero_neq_one(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Omonoid__add,axiom,
    monoid_add(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Ozero,axiom,
    zero(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Int_Onumber,axiom,
    number(code_code_numeral) ).

tff(arity_Code__Numeral_Ocode__numeral___Groups_Oone,axiom,
    one(code_code_numeral) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Rings_Ozero__neq__one,axiom,
    zero_neq_one(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Omonoid__add,axiom,
    monoid_add(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Ozero,axiom,
    zero(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Int_Onumber,axiom,
    number(quickcheck_code_int) ).

tff(arity_Quickcheck__Narrowing_Ocode__int___Groups_Oone,axiom,
    one(quickcheck_code_int) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    aa(fun(nat,bool),a,aa(fun(nat,a),fun(fun(nat,bool),a),big_co1399186613setsum(nat,a),x),ord_atLeastLessThan(nat,zero_zero(nat),number_number_of(nat,bit0(bit0(bit1(pls)))))) = aa(a,a,aa(a,fun(a,a),plus_plus(a),aa(a,a,aa(a,fun(a,a),plus_plus(a),aa(a,a,aa(a,fun(a,a),plus_plus(a),aa(nat,a,x,zero_zero(nat))),aa(nat,a,x,one_one(nat)))),aa(nat,a,x,number_number_of(nat,bit0(bit1(pls)))))),aa(nat,a,x,number_number_of(nat,bit1(bit1(pls))))) ).

%----Type variables (1)
tff(tfree_0,hypothesis,
    comm_monoid_add(a) ).

%------------------------------------------------------------------------------
